/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.component.URLPanel;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdevimpl.library.LibraryArb;

public class LibraryEditPanel
extends JPanel {
    protected static URL defDir = URLFactory.newDirURL((String)Ide.getWorkDirectory());
    protected JScrollPane rightScroll = new JScrollPane();
    protected JTree pathsTree = new JTree();
    protected GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected JLabel lblLibList = new JLabel();
    protected JComboBox fldLibLists = new JComboBox();
    protected JTextField txtLibLists = new JTextField();
    protected JCheckBox cbDeployedByDefault = new JCheckBox();
    protected JButton addBtn = new JButton();
    protected JButton urlBtn = new JButton();
    protected JButton removeBtn = new JButton();
    protected JPanel addPanel = new JPanel();
    protected GridLayout addLayout = new GridLayout();
    protected JButton dnBtn = new JButton();
    protected JButton upBtn = new JButton();
    protected JPanel posPanel = new JPanel();
    protected GridLayout posLayout = new GridLayout();
    protected JTextField fldName = new JTextField();
    protected JLabel lblName = new JLabel();
    protected Library currentLib;
    protected DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
    protected DefaultTreeModel pathsModel = new DefaultTreeModel(this.root);
    protected DefaultMutableTreeNode clsNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)LibraryArb.getString(10)));
    protected DefaultMutableTreeNode srcNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)LibraryArb.getString(11)));
    protected DefaultMutableTreeNode docNode = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)LibraryArb.getString(12)));
    protected PathsRenderer pathsTreeRenderer = new PathsRenderer();
    private CopyToggleAction localCopyPathAction;
    private static final String REMOVE_CONFIRMATION_KEY = "oracle.jdevimpl.library.LibraryEditPanel.removePath";

    public LibraryEditPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedcreatelibrary_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LibraryEditPanel(JLibrary lib) {
        this();
        this.setLibrary(lib);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idededitlibrarydefinition_html");
    }

    private void jbInit() throws Exception {
        this.root.add(this.clsNode);
        this.root.add(this.srcNode);
        this.root.add(this.docNode);
        this.setLayout(this.gridBagLayout2);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.lblName.setHorizontalAlignment(0);
        this.pathsTree.setRootVisible(false);
        this.pathsTree.setShowsRootHandles(true);
        this.pathsTree.setModel(this.pathsModel);
        this.pathsTree.getSelectionModel().setSelectionMode(4);
        this.pathsTree.setCellRenderer(this.pathsTreeRenderer);
        this.pathsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LibraryEditPanel.this.updatePathsButtons(e);
            }
        });
        this.pathsTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                LibraryEditPanel.this.tryDelete(e);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.pathsTree);
        this.pathsTreeRenderer.setLeafIcon(null);
        this.addBtn.setEnabled(false);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryEditPanel.this.addEntry(e);
            }
        });
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryEditPanel.this.removeEntry(e);
            }
        });
        this.urlBtn.setEnabled(false);
        this.urlBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryEditPanel.this.addURL(e);
            }
        });
        this.addPanel.setLayout(this.addLayout);
        this.addPanel.setBorder(BorderFactory.createEmptyBorder());
        this.addLayout.setRows(1);
        this.addLayout.setHgap(2);
        this.upBtn.setMargin(new Insets(1, 1, 1, 1));
        this.upBtn.setIcon(ComponentArb.getIcon((int)0));
        this.upBtn.setEnabled(false);
        this.upBtn.setToolTipText(LibraryArb.getString(61));
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryEditPanel.this.moveUp(e);
            }
        });
        this.dnBtn.setMargin(new Insets(1, 1, 1, 1));
        this.dnBtn.setIcon(ComponentArb.getIcon((int)1));
        this.dnBtn.setEnabled(false);
        this.dnBtn.setToolTipText(LibraryArb.getString(60));
        this.dnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryEditPanel.this.moveDown(e);
            }
        });
        this.posPanel.setLayout(this.posLayout);
        this.posPanel.setBorder(BorderFactory.createEmptyBorder());
        this.posLayout.setColumns(1);
        this.posLayout.setRows(0);
        this.posLayout.setVgap(2);
        this.rightScroll.setViewportView(this.pathsTree);
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)LibraryArb.getString(68));
        ResourceUtils.resLabel((JLabel)this.lblLibList, (Component)this.fldLibLists, (String)LibraryArb.getString(70));
        ResourceUtils.resButton((AbstractButton)this.cbDeployedByDefault, (String)LibraryArb.getString(19));
        ResourceUtils.resButton((AbstractButton)this.addBtn, (String)LibraryArb.getString(58));
        ResourceUtils.resButton((AbstractButton)this.removeBtn, (String)LibraryArb.getString(56));
        ResourceUtils.resButton((AbstractButton)this.urlBtn, (String)ComponentArb.getString((int)13));
        this.posPanel.add((Component)this.upBtn, null);
        this.posPanel.add((Component)this.dnBtn, null);
        this.addPanel.add((Component)this.addBtn, null);
        this.addPanel.add((Component)this.urlBtn, null);
        this.addPanel.add((Component)this.removeBtn, null);
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 2), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 5), 0, 0));
        this.add((Component)this.cbDeployedByDefault, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), 0, 0));
        this.add((Component)this.rightScroll, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 5), 0, 0));
        this.add((Component)this.posPanel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.localCopyPathAction = new CopyToggleAction();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        MultiInputMap imap = MultiMapAdapter.getGlobalMap((KeyStrokeOptions)kso);
        InputMap inputMap = Ide.getIdeInputMap();
        imap.setParent(inputMap);
        this.setInputMap(1, (InputMap)imap);
        this.loadMyMap(imap, this.getActionMap(), kso);
    }

    private void loadMyMap(MultiInputMap myMap, ActionMap aMap, KeyStrokeOptions kso) {
        this.updateMyMapWithAction(kso, aMap, myMap, 77, this.localCopyPathAction);
        this.updateMyMapWithAction(kso, aMap, myMap, 18, this.localCopyPathAction);
    }

    private void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, MultiInputMap myMap, int cmdId, ToggleAction action) {
        List kList = this.getKeyStrokesFor(kso, cmdId);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = new Integer(cmdId);
            for (int i = 0; i < numKeys; ++i) {
                aMap.put(integer, (Action)action);
                myMap.put((KeyStrokes)kList.get(i), (Object)integer);
            }
        }
    }

    private List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        return kList;
    }

    public void setLibrary(Library source) {
        this.currentLib = source;
        this.updatePaths();
        boolean editable = true;
        if (this.currentLib != null) {
            editable = !this.currentLib.isLocked();
            this.fldName.setText(this.currentLib.getName());
            this.cbDeployedByDefault.setSelected(Boolean.TRUE.equals(((JLibrary)this.currentLib).getDeployedByDefault()));
        } else {
            this.fldName.setText("");
            this.cbDeployedByDefault.setSelected(false);
            editable = false;
        }
        this.lblName.setEnabled(editable);
        this.fldName.setEnabled(editable);
        this.fldName.setEditable(editable);
        this.lblLibList.setEnabled(editable);
        this.fldLibLists.setEnabled(editable);
        this.txtLibLists.setEnabled(false);
        this.txtLibLists.setEditable(false);
        this.cbDeployedByDefault.setEnabled(editable);
        this.pathsTreeRenderer.setEditable(editable);
        int count = this.pathsTree.getRowCount();
        while (--count >= 0) {
            this.pathsTree.expandRow(count);
        }
        TreePath path = this.pathsTree.getPathForRow(count);
        this.updatePathsButtons(new TreeSelectionEvent((Object)this.pathsTree, path, true, null, path));
    }

    public void setListsVisible(boolean visible) {
        if (visible) {
            this.remove(this.txtLibLists);
            this.add((Component)this.lblLibList, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
            this.add((Component)this.fldLibLists, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 5), 0, 0));
        } else {
            this.remove(this.fldLibLists);
            this.add((Component)this.lblLibList, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 2), 0, 0));
            this.add((Component)this.txtLibLists, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 0, 5), 0, 0));
        }
    }

    public LibraryList getLibraryList() {
        return (LibraryList)this.fldLibLists.getSelectedItem();
    }

    public void setLibraryList(LibraryList list) {
        this.fldLibLists.setSelectedItem(list);
        if (this.fldLibLists.getSelectedItem() == null && this.fldLibLists.getItemCount() > 0) {
            this.fldLibLists.setSelectedIndex(0);
        }
        this.txtLibLists.setText((list = (LibraryList)this.fldLibLists.getSelectedItem()) != null ? list.getShortLabel() : null);
        this.txtLibLists.setToolTipText(list != null ? list.getToolTipText() : null);
    }

    public void setLibraryLists(MutableLibraryList[] lists) {
        SortedComboBoxModel model = new SortedComboBoxModel();
        for (int i = 0; i < lists.length; ++i) {
            if (lists[i].isTransient()) continue;
            model.addElement((Object)lists[i]);
        }
        this.fldLibLists.setModel(model);
    }

    protected void updatePaths() {
        if (this.currentLib != null) {
            this.populatePath(this.srcNode, this.currentLib.getSourcePath());
            this.populatePath(this.clsNode, this.currentLib.getClassPath());
            this.populatePath(this.docNode, this.currentLib.getDocPath());
        } else {
            this.srcNode.removeAllChildren();
            this.clsNode.removeAllChildren();
            this.docNode.removeAllChildren();
            this.pathsModel.nodeStructureChanged(this.root);
        }
        this.selectNode(this.clsNode);
    }

    protected void populatePath(DefaultMutableTreeNode node, URLPath paths) {
        Iterator i;
        node.removeAllChildren();
        Iterator iterator = i = paths != null ? paths.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                URL url = (URL)i.next();
                PathNode child = new PathNode(url);
                child.setUserObject(url);
                node.add(child);
            }
        }
        this.pathsModel.nodeStructureChanged(node);
    }

    public String getLibraryName() {
        return this.fldName.getText();
    }

    public void setLibraryName(String name) {
        this.fldName.setText(name != null ? name : "");
    }

    public boolean isDeployByDefault() {
        return this.cbDeployedByDefault.isSelected();
    }

    public URLPath getClassPath() {
        return this.getPath(this.clsNode);
    }

    public URLPath getSourcePath() {
        return this.getPath(this.srcNode);
    }

    public URLPath getDocPath() {
        return this.getPath(this.docNode);
    }

    private URLPath getPath(DefaultMutableTreeNode node) {
        URLPath result = new URLPath();
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            result.add((URL)child.getUserObject());
        }
        return result;
    }

    protected void updatePathsButtons(TreeSelectionEvent e) {
        boolean editable;
        boolean bl = editable = e != null && !this.isLocked();
        if (editable) {
            DefaultMutableTreeNode node;
            TreePath[] paths = this.pathsTree.getSelectionPaths();
            DefaultMutableTreeNode defaultMutableTreeNode = node = paths != null && paths.length == 1 ? (DefaultMutableTreeNode)paths[0].getLastPathComponent() : null;
            if (node != null) {
                if (node == this.clsNode || node == this.srcNode || node == this.docNode) {
                    this.addBtn.setEnabled(true);
                    this.urlBtn.setEnabled(node == this.docNode);
                    this.removeBtn.setEnabled(false);
                    this.upBtn.setEnabled(false);
                    this.dnBtn.setEnabled(false);
                } else {
                    TreeNode parent = node.getParent();
                    int index = parent.getIndex(node);
                    this.addBtn.setEnabled(true);
                    this.urlBtn.setEnabled(parent == this.docNode);
                    this.removeBtn.setEnabled(true);
                    this.upBtn.setEnabled(index > 0);
                    this.dnBtn.setEnabled(index < parent.getChildCount() - 1);
                }
            } else {
                this.urlBtn.setEnabled(false);
                this.upBtn.setEnabled(false);
                this.dnBtn.setEnabled(false);
                boolean canDelete = paths != null;
                boolean siblings = paths != null;
                DefaultMutableTreeNode parent = null;
                if (canDelete) {
                    for (int i = 0; i < paths.length; ++i) {
                        DefaultMutableTreeNode obj = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                        if (obj == this.clsNode || obj == this.srcNode || obj == this.docNode) {
                            canDelete = false;
                            if (parent == null) {
                                parent = obj;
                            } else if (parent != obj) {
                                siblings = false;
                            }
                            if (canDelete || siblings) continue;
                            break;
                        }
                        obj = (DefaultMutableTreeNode)obj.getParent();
                        if (parent == null) {
                            parent = obj;
                        } else if (parent != obj) {
                            siblings = false;
                        }
                        if (!canDelete && !siblings) break;
                    }
                }
                this.addBtn.setEnabled(siblings);
                this.removeBtn.setEnabled(canDelete);
            }
            return;
        }
        this.addBtn.setEnabled(false);
        this.urlBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.upBtn.setEnabled(false);
        this.dnBtn.setEnabled(false);
    }

    protected boolean isLocked() {
        return this.currentLib == null || this.currentLib.isLocked();
    }

    private void addEntry(ActionEvent e) {
        URL[] dirs;
        int n;
        URLChooser chooser = DialogUtil.newURLChooser((URL)defDir);
        chooser.setSelectionMode(2);
        chooser.setSelectionScope(1);
        chooser.setShowJarsAsDirs(true);
        int result = chooser.showOpenDialog((Component)this, ComponentArb.getString((int)18));
        if (result == 0 && (n = (dirs = chooser.getSelectedURLs()).length) > 0) {
            DefaultMutableTreeNode node;
            TreePath sel = this.pathsTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = node = sel != null ? (DefaultMutableTreeNode)sel.getLastPathComponent() : null;
            if (node == null) {
                return;
            }
            if (node != this.clsNode && node != this.srcNode && node != this.docNode) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            URL dir = null;
            PathNode child = null;
            for (int i = 0; i < n; ++i) {
                dir = dirs[i];
                child = new PathNode(dir);
                this.pathsModel.insertNodeInto(child, node, node.getChildCount());
            }
            defDir = dir != null ? URLFileSystem.getParent((URL)dir) : null;
            this.selectNode(child);
            String libName = this.fldName.getText();
            String string = libName = libName != null ? libName.trim() : null;
            if (libName == null || libName.length() == 0) {
                this.fldName.setText(this.capitalize(dirs[0]));
            }
        }
    }

    private String capitalize(URL url) {
        int index;
        String name = URLFileSystem.getFileName((URL)url);
        if (!URLFileSystem.isDirectory((URL)url) && (index = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, index);
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private void addURL(ActionEvent e) {
        URL url;
        DefaultMutableTreeNode node;
        TreePath sel = this.pathsTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = node = sel != null ? (DefaultMutableTreeNode)sel.getLastPathComponent() : null;
        if (node == null) {
            return;
        }
        if (node != this.clsNode && node != this.srcNode && node != this.docNode) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if ((url = new URLPanel().promptForURL((Component)this)) != null) {
            PathNode child = new PathNode(url);
            this.pathsModel.insertNodeInto(child, node, node.getChildCount());
            this.selectNode(child);
        }
    }

    protected void selectNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        final TreePath path = new TreePath(node.getPath());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryEditPanel.this.pathsTree.setSelectionPath(path);
                LibraryEditPanel.this.pathsTree.scrollPathToVisible(path);
            }
        });
    }

    private void removeEntry(ActionEvent e) {
        DefaultMutableTreeNode node;
        TreePath[] sel = this.pathsTree.getSelectionPaths();
        if (sel == null || sel.length == 0 || this.isLocked()) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node = sel.length == 1 ? (DefaultMutableTreeNode)sel[0].getLastPathComponent() : null;
        if (node == this.clsNode || node == this.srcNode || node == this.docNode) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        int index = 0;
        for (int i = 0; i < sel.length; ++i) {
            node = (DefaultMutableTreeNode)sel[i].getLastPathComponent();
            parent = (DefaultMutableTreeNode)node.getParent();
            if (i == 0 && !this.confirmRemove()) {
                return;
            }
            index = parent.getIndex(node);
            this.pathsModel.removeNodeFromParent(node);
        }
        int count = parent.getChildCount();
        node = count == 0 ? parent : (DefaultMutableTreeNode)parent.getChildAt(count > index ? index : --index);
        this.selectNode(node);
    }

    private boolean confirmRemove() {
        MessageDialogPersistence persistence = MessageDialog.getPersistence();
        Boolean alreadyConfirmed = persistence.getConfirmed(REMOVE_CONFIRMATION_KEY);
        if (alreadyConfirmed != null) {
            return true;
        }
        return MessageDialog.optionalConfirm((String)REMOVE_CONFIRMATION_KEY, (Component)this, (String)LibraryArb.getString(82), (String)LibraryArb.getString(83), null);
    }

    private void moveUp(ActionEvent e) {
        DefaultMutableTreeNode node;
        TreePath sel = this.pathsTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = node = sel != null ? (DefaultMutableTreeNode)sel.getLastPathComponent() : null;
        if (node == null || node == this.clsNode || node == this.srcNode || node == this.docNode) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int index = parent.getIndex(node);
        if (index > 0) {
            this.pathsModel.removeNodeFromParent(node);
            this.pathsModel.insertNodeInto(node, parent, --index);
            this.selectNode(node);
        }
    }

    private void moveDown(ActionEvent e) {
        DefaultMutableTreeNode node;
        TreePath sel = this.pathsTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = node = sel != null ? (DefaultMutableTreeNode)sel.getLastPathComponent() : null;
        if (node == null || node == this.clsNode || node == this.srcNode || node == this.docNode) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int index = parent.getIndex(node);
        if (index < parent.getChildCount() - 1) {
            this.pathsModel.removeNodeFromParent(node);
            this.pathsModel.insertNodeInto(node, parent, ++index);
            this.selectNode(node);
        }
    }

    private void tryDelete(KeyEvent e) {
        if (e.getKeyChar() == '\u007f') {
            this.removeEntry(null);
            e.consume();
        }
    }

    private class CopyToggleAction
    extends ToggleAction {
        public CopyToggleAction() {
            super("copyPathAction", null);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] selPaths = LibraryEditPanel.this.pathsTree.getSelectionPaths();
            StringBuilder sb = new StringBuilder();
            if (selPaths != null) {
                for (TreePath treePath : selPaths) {
                    Object userObj;
                    Object pathObj = treePath.getLastPathComponent();
                    if (pathObj instanceof PathNode) {
                        sb.append(((PathNode)pathObj).toString() + "\n");
                        continue;
                    }
                    if (!(pathObj instanceof DefaultMutableTreeNode) || (userObj = ((DefaultMutableTreeNode)pathObj).getUserObject()) == null || !(userObj instanceof String)) continue;
                    sb.append((String)userObj + "\n");
                }
            }
            if (sb.length() > 0) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard systemClipboard = toolkit.getSystemClipboard();
                ClipboardStack.pushCurrentClipboard();
                systemClipboard.setContents(new StringSelection(sb.toString()), null);
            }
        }
    }

    private final class PathsRenderer
    extends DefaultTreeCellRenderer {
        private boolean _editable = true;

        private PathsRenderer() {
        }

        public void setEditable(boolean editable) {
            this._editable = editable;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            label.setEnabled(this._editable);
            label.setIcon(null);
            label.setDisabledIcon(null);
            if (value == LibraryEditPanel.this.clsNode) {
                label.setIcon(ModelArb.getIcon((int)31));
                label.setDisabledIcon(ModelArb.getIcon((int)31));
            } else if (value == LibraryEditPanel.this.srcNode) {
                label.setIcon(ModelArb.getIcon((int)31));
                label.setDisabledIcon(ModelArb.getIcon((int)31));
            } else if (value == LibraryEditPanel.this.docNode) {
                label.setIcon(ModelArb.getIcon((int)31));
                label.setDisabledIcon(ModelArb.getIcon((int)31));
            } else if (value != null) {
                label.setToolTipText(value.toString());
            }
            if (value instanceof PathNode && ((PathNode)value).isInvalid()) {
                label.setForeground(Color.RED);
            }
            return label;
        }
    }

    private static final class PathNode
    extends DefaultMutableTreeNode {
        private boolean _invalid;

        PathNode(URL url) {
            super(url);
        }

        public synchronized boolean isInvalid() {
            return this._invalid;
        }

        public synchronized boolean verify() {
            this._invalid = false;
            try {
                URLFileSystem.getPlatformPathName((URL)((URL)this.getUserObject()));
            }
            catch (Exception e) {
                this._invalid = true;
            }
            return this._invalid;
        }

        @Override
        public synchronized String toString() {
            try {
                String str = URLFileSystem.getPlatformPathName((URL)((URL)this.getUserObject()));
                this._invalid = false;
                return str;
            }
            catch (Exception e) {
                this._invalid = true;
                return this.getUserObject().toString();
            }
        }
    }
}

