/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.SimpleGlobMatcher;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;

public final class LibrariesHook
extends ExtensionHook {
    public static final ElementName ELEMENT = LibrariesHook.e("libraries");
    private static String LIBRARY = "Library";
    private static String LIBRARYNAME = "LibraryName";
    private static String LIBRARYDEPLOYED = "LibraryDeployed";
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-libraries";
    private ElementVisitor _libraryHandler = new LibraryHandler();
    private ElementVisitor _aliasHandler = new AliasHandler();
    private final List _aliases = new ArrayList();
    private final List _libraries = new ArrayList();

    public Collection getAliases() {
        return this._aliases;
    }

    public Collection getLibraries() {
        return this._libraries;
    }

    private static final ElementName e(String name) {
        return new ElementName(NS, name);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(LibrariesHook.e("library"), this._libraryHandler);
        context.registerChildVisitor(LibrariesHook.e("alias"), this._aliasHandler);
    }

    public final class LibraryAlias {
        private final String _from;
        private final String _to;

        private LibraryAlias(String from, String to) {
            this._from = from;
            this._to = to;
        }

        public String getFrom() {
            return this._from;
        }

        public String getTo() {
            return this._to;
        }
    }

    public final class LibraryInfo {
        private final String _name;
        private final URLPath _classPath;
        private final URLPath _sourcePath;
        private final URLPath _docPath;
        private final Boolean _deployed;

        private LibraryInfo(String name, URLPath classPath, URLPath sourcePath, URLPath docPath, Boolean isDeployed) {
            this._name = name;
            this._classPath = classPath;
            this._sourcePath = sourcePath;
            this._docPath = docPath;
            this._deployed = isDeployed;
        }

        public String getName() {
            return this._name;
        }

        public URLPath getClassPath() {
            return this._classPath;
        }

        public URLPath getDocPath() {
            return this._docPath;
        }

        public URLPath getSourcePath() {
            return this._sourcePath;
        }

        public Boolean isDeployed() {
            return this._deployed;
        }
    }

    private class LibraryHandler
    extends ElementVisitor {
        private LibraryHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("classpath"), (ElementVisitor)new ClassPathHandler());
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SrcPathHandler());
            context.getScopeData().put(LIBRARYNAME, context.getAttributeValue("name"));
            context.getScopeData().put(LIBRARYDEPLOYED, context.getAttributeValue("deployed"));
            context.getScopeData().put(LIBRARY, new LibraryObject());
        }

        public void end(ElementEndContext context) {
            String name = (String)context.getScopeData().get(LIBRARYNAME);
            LibraryObject library = this.getLibrary((ElementContext)context);
            String deployed = (String)context.getScopeData().get(LIBRARYDEPLOYED);
            boolean isDeployed = deployed != null && deployed.equalsIgnoreCase("true");
            LibrariesHook.this._libraries.add(new LibraryInfo(name, library._classPath, library._srcPath, library._docPath, isDeployed ? Boolean.TRUE : Boolean.FALSE));
        }

        private LibraryObject getLibrary(ElementContext context) {
            return (LibraryObject)context.getScopeData().get(LIBRARY);
        }

        private void addURLPath(ElementEndContext context, URLPath path) {
            int end;
            String text = context.getText();
            if (text == null || (text = text.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Element must not be empty");
                return;
            }
            int start = 0;
            while ((end = text.indexOf(44, start)) >= 0) {
                this.addURLPath(text.substring(start, end).trim(), context, path);
                start = end + 1;
            }
            this.addURLPath(text.substring(start).trim(), context, path);
        }

        private void addURLPath(String text, ElementEndContext context, URLPath path) {
            if (text == null || text.length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Element must not be empty");
                return;
            }
            if ((text = text.replace('\\', '/')).indexOf(59) >= 0) {
                this.log((ElementContext)context, Level.WARNING, "Use of path separator is no longer supported");
            }
            if (text.startsWith("http") || text.startsWith("https")) {
                path.add(URLFactory.newURL((String)text));
            } else {
                int posOfWildcard = -1;
                int posOfSeparator = -1;
                for (int i = text.length() - 1; i >= 0; --i) {
                    char c = text.charAt(i);
                    if (c == '*') {
                        posOfWildcard = i;
                    }
                    if (c != '/') continue;
                    posOfSeparator = i;
                    break;
                }
                if (posOfWildcard >= 0) {
                    VirtualFileSystem vfs;
                    URI[] entries;
                    if (posOfSeparator >= posOfWildcard) {
                        this.log((ElementContext)context, Level.SEVERE, "Wilcards cannot be used in the path of a library entry.");
                    }
                    this.log((ElementContext)context, Level.FINE, "Expanding wildcard path entry: " + text);
                    String pathText = text.substring(0, posOfSeparator);
                    String filterText = text.substring(posOfSeparator + 1);
                    URI parent = LibrariesHook.this.resolvePath((ElementContext)context, pathText);
                    if (parent != null && (entries = (vfs = VirtualFileSystem.getVirtualFileSystem()).list(parent)) != null) {
                        SimpleGlobMatcher matcher = new SimpleGlobMatcher(filterText);
                        for (URI entry : entries) {
                            String fileName = vfs.getFileName(entry);
                            if (!matcher.matches(fileName)) continue;
                            this.processPathElement(entry, text, context, path);
                        }
                    }
                } else {
                    URI uri = LibrariesHook.this.resolvePath((ElementContext)context, text);
                    this.processPathElement(uri, text, context, path);
                }
            }
        }

        private void processPathElement(URI uri, String text, ElementEndContext context, URLPath path) {
            String[] archiveExtensions = new String[]{".jar", ".war", ".ear", ".zip"};
            if (Arrays.asList(archiveExtensions).contains(VirtualFileSystem.getVirtualFileSystem().getSuffix(uri).toLowerCase())) {
                uri = URIFactory.newJarURI((URI)uri, (String)"");
            } else {
                String resultString = uri.toString();
                int bangSlash = resultString.indexOf("!/");
                if (bangSlash > 0) {
                    String jarUri = resultString.substring(0, bangSlash);
                    String entryUri = resultString.substring(bangSlash + 2);
                    uri = URIFactory.newJarURI((URI)URIFactory.newURI((String)jarUri), (String)entryUri);
                }
            }
            try {
                String urlPath;
                URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                if (text.length() > 0 && '/' == text.charAt(text.length() - 1) && "file".equals(url.getProtocol()) && (urlPath = url.getPath()).length() > 0 && urlPath.charAt(urlPath.length() - 1) != '/') {
                    url = URLFactory.newDirURL((String)(urlPath + '/'));
                }
                path.add(url);
            }
            catch (MalformedURLException mue) {
                this.log((ElementContext)context, Level.SEVERE, "Malformed URL: " + uri);
            }
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            private SrcPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibraryHandler.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._srcPath);
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibraryHandler.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._docPath);
            }
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            private ClassPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibraryHandler.this.addURLPath(context, ((LibraryHandler)LibraryHandler.this).getLibrary((ElementContext)context)._classPath);
            }
        }

        class LibraryObject {
            URLPath _classPath = new URLPath();
            URLPath _srcPath = new URLPath();
            URLPath _docPath = new URLPath();

            LibraryObject() {
            }
        }
    }

    private class AliasHandler
    extends ElementVisitor {
        private AliasHandler() {
        }

        public void start(ElementStartContext context) {
            String from = context.getAttributeValue("from");
            String to = context.getAttributeValue("to");
            LibrariesHook.this._aliases.add(new LibraryAlias(from, to));
        }
    }
}

