/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.ide.config.EnvironOptions;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;

final class CompilerPreferencesPage
extends DefaultTraversablePanel {
    private final JCheckBox _saveBeforeCompiling = new JCheckBox();
    private final JCheckBox _clearLogBeforeCompiling = new JCheckBox();
    private final JCheckBox _showCompileProgress = new JCheckBox();
    private final JCheckBox _cleanProjectBeforeRebuild = new JCheckBox();

    public CompilerPreferencesPage() {
        this.jbInit();
    }

    private void jbInit() {
        ResourceUtils.resButton((AbstractButton)this._saveBeforeCompiling, (String)EnvironOptionsArb.getString((int)13));
        ResourceUtils.resButton((AbstractButton)this._clearLogBeforeCompiling, (String)EnvironOptionsArb.getString((int)14));
        ResourceUtils.resButton((AbstractButton)this._showCompileProgress, (String)EnvironOptionsArb.getString((int)16));
        ResourceUtils.resButton((AbstractButton)this._cleanProjectBeforeRebuild, (String)EnvironOptionsArb.getString((int)35));
        this.setLayout(new GridBagLayout());
        this.add(this._saveBeforeCompiling, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._clearLogBeforeCompiling, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._showCompileProgress, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._cleanProjectBeforeRebuild, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        this.setHelpID("f1_com_preferences_html");
        EnvironOptions envOpts = EnvironOptions.getInstance((PropertyStorage)tc.getPropertyStorage());
        this.load(envOpts);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        EnvironOptions envOpts = EnvironOptions.getInstance((PropertyStorage)tc.getPropertyStorage());
        this.commit(envOpts);
    }

    private void load(EnvironOptions options) {
        this._saveBeforeCompiling.setSelected(options.getSaveBeforeCompile());
        this._clearLogBeforeCompiling.setSelected(options.getClearCompilerLogBeforeCompile());
        this._showCompileProgress.setSelected(options.getShowCompileProgress());
        this._cleanProjectBeforeRebuild.setSelected(options.getCleanProjectBeforeRebuild());
    }

    private void commit(EnvironOptions options) {
        options.setSaveBeforeCompile(this._saveBeforeCompiling.isSelected());
        options.setClearCompilerLogBeforeCompile(this._clearLogBeforeCompiling.isSelected());
        options.setShowCompileProgress(this._showCompileProgress.isSelected());
        options.setCleanProjectBeforeRebuild(this._cleanProjectBeforeRebuild.isSelected());
    }
}

