/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.LibraryReference;

public class JProjectLibraries
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.jdevimpl.config.JProjectLibraries";
    public static final String JDK_NAME = "jdkReference";
    public static final String LIBRARIES = "libraryReferences";
    public static final String LIB_LIST = "internalDefinitions";
    public static final String EXPORTS = "exportedReferences";

    public JProjectLibraries(HashStructure hash) {
        super(hash);
    }

    public static JProjectLibraries getInstance(PropertyStorage prj) {
        boolean wasClean = prj != null && prj == Ide.getDefaultProject() ? !((Project)prj).isDirty() : false;
        HashStructure hash = JProjectLibraries.findOrCreate((PropertyStorage)prj, (String)DATA_KEY);
        JProjectLibraries settings = new JProjectLibraries(hash);
        if (wasClean && ((Project)prj).isDirty()) {
            try {
                ((Project)prj).save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return settings;
    }

    public JDK getJDK() {
        LibraryReference ref;
        JDK jdk = null;
        HashStructure struct = this._hash.getHashStructure(JDK_NAME);
        LibraryReference libraryReference = ref = struct != null ? new LibraryReference(struct) : null;
        if (ref != null && ref.isJDK()) {
            JProjectLibraryList list = this.getProjectLibraryList();
            JDK jDK = jdk = list != null ? list.findJDK(ref.getID()) : null;
            if (jdk == null) {
                jdk = (JDK)ref.getLibrary();
            }
        }
        return jdk != null ? jdk : JLibraryManager.getDefaultJDK();
    }

    public void setJDK(final JDK jdk) {
        if (jdk == null || jdk == JLibraryManager.getDefaultJDK()) {
            this._hash.remove(JDK_NAME);
        } else {
            this._hash.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    HashStructure struct = JProjectLibraries.this._hash.getOrCreateHashStructure(JProjectLibraries.JDK_NAME);
                    LibraryReference ref = new LibraryReference(struct);
                    ref.setLibrary(jdk);
                }
            });
        }
    }

    public VersionNumber getJdkVersionNumber() {
        JDK jdk = this.getJDK();
        return jdk != null ? jdk.getJavaVersion() : null;
    }

    public String[] getLibraryList() {
        JLibrary[] libs = this.getLibraries();
        String[] ids = new String[libs != null ? libs.length : 0];
        for (int i = 0; i < ids.length; ++i) {
            Object id = libs[i].getID();
            if (id == null) {
                id = libs[i].getName();
            }
            ids[i] = id != null ? id.toString() : "";
        }
        return ids;
    }

    public JLibrary[] getLibraries() {
        ListStructure libs = this._hash.getListStructure(LIBRARIES);
        List list = this.getLibraries(libs);
        return list.toArray(new JLibrary[list.size()]);
    }

    public boolean hasLibrary(Object id) {
        ListStructure libs;
        List list;
        JLibrary lib = this.resolveLibrary(id);
        return lib != null && (list = this.getLibraries(libs = this._hash.getOrCreateListStructure(LIBRARIES))).contains(lib);
    }

    public void setLibraries(JLibrary[] newLibs) {
        if (newLibs == null) {
            this._hash.remove(LIBRARIES);
        } else {
            ListStructure libs = this._hash.getOrCreateListStructure(LIBRARIES);
            this.setLibraries(libs, newLibs);
        }
    }

    public JLibrary[] getExports() {
        ListStructure exports = this._hash.getListStructure(EXPORTS);
        List list = this.getLibraries(exports);
        return list.toArray(new JLibrary[list.size()]);
    }

    public boolean hasExport(Object id) {
        ListStructure libs;
        List list;
        JLibrary lib = this.resolveLibrary(id);
        return lib != null && (list = this.getLibraries(libs = this._hash.getOrCreateListStructure(EXPORTS))).contains(lib);
    }

    public void setExports(JLibrary[] exports) {
        if (exports == null) {
            this._hash.remove(EXPORTS);
        } else {
            ListStructure ls = this._hash.getOrCreateListStructure(EXPORTS);
            this.setLibraries(ls, exports);
        }
    }

    public JProjectLibraryList getProjectLibraryList() {
        return JProjectLibraryList.getInstance(this._hash.getOrCreateHashStructure(LIB_LIST));
    }

    public void setProjectLibraryList(JProjectLibraryList newList) {
        if (newList == null) {
            this._hash.remove(LIB_LIST);
        } else {
            JProjectLibraryList oldList = this.getProjectLibraryList();
            newList.copyTo(oldList);
        }
    }

    public boolean addLibrary(Object id) {
        return this.addLibrary(id, true);
    }

    public boolean addLibrary(Object id, boolean export) {
        ListStructure libs;
        List list;
        JLibrary lib = this.resolveLibrary(id);
        if (lib != null && !(list = this.getLibraries(libs = this._hash.getOrCreateListStructure(LIBRARIES))).contains(lib)) {
            list.add(lib);
            this.setLibraries(libs, list.toArray(new JLibrary[list.size()]));
            if (export && !(list = this.getLibraries(libs = this._hash.getOrCreateListStructure(EXPORTS))).contains(lib)) {
                list.add(lib);
                this.setLibraries(libs, list.toArray(new JLibrary[list.size()]));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLibrary(Object id) {
        JLibrary lib = this.resolveLibrary(id);
        if (lib != null) {
            List list;
            ListStructure libs = this._hash.getListStructure(LIBRARIES);
            List list2 = list = libs != null ? this.getLibraries(libs) : null;
            if (list != null && list.contains(lib)) {
                List exports;
                list.remove(lib);
                this.setLibraries(libs, list.toArray(new JLibrary[list.size()]));
                ListStructure exportedLibs = this._hash.getListStructure(EXPORTS);
                List list3 = exports = exportedLibs != null ? this.getLibraries(exportedLibs) : null;
                if (exports != null && exports.contains(lib)) {
                    exports.remove(lib);
                    this.setExports(exports.toArray(new JLibrary[exports.size()]));
                }
                return true;
            }
        } else {
            ListStructure testStruct = this._hash.getListStructure(LIBRARIES);
            if (testStruct == null) {
                return true;
            }
            Object object = testStruct.iteratorLock();
            synchronized (object) {
                Iterator i = testStruct.iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    UnresolvedLibrary unresolvedLib = new UnresolvedLibrary((HashStructure)obj);
                    Object unresolvedId = unresolvedLib.getID();
                    if (!(unresolvedId instanceof String) || !((String)unresolvedId).equals(id)) continue;
                    i.remove();
                    return true;
                }
            }
        }
        return false;
    }

    public JLibrary resolveLibrary(Object id) {
        JLibrary lib;
        JProjectLibraryList list = this.getProjectLibraryList();
        JLibrary jLibrary = lib = list != null ? list.findLibrary(id) : null;
        if (lib == null) {
            lib = JLibraryManager.findLibrary(id);
        }
        return lib;
    }

    public JDK resolveJDK(Object id) {
        JDK jdk;
        JProjectLibraryList list = this.getProjectLibraryList();
        JDK jDK = jdk = list != null ? list.findJDK(id) : null;
        if (jdk == null) {
            jdk = JLibraryManager.findJDK(id);
        }
        return jdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getLibraries(ListStructure libs) {
        ArrayList<JLibrary> result = new ArrayList<JLibrary>();
        if (libs == null) {
            return result;
        }
        JProjectLibraryList list = this.getProjectLibraryList();
        Object object = libs.iteratorLock();
        synchronized (object) {
            for (HashStructure struct : libs) {
                JLibrary lib;
                LibraryReference ref = new LibraryReference(struct);
                Object id = ref.getID();
                JLibrary jLibrary = lib = list != null ? list.findLibrary(id) : null;
                if (lib == null && (lib = (JLibrary)ref.getLibrary()) == null) {
                    lib = new UnresolvedLibrary(HashStructure.newInstance());
                    ((JLibraryAdapter)lib).setID(id);
                    if (id instanceof URL) {
                        ((JLibraryAdapter)lib).setName(URLFileSystem.getPlatformPathName((URL)((URL)id)));
                    } else if (id != null) {
                        lib.setName(id.toString());
                    }
                }
                result.add(lib);
            }
        }
        return result;
    }

    private void setLibraries(ListStructure libs, JLibrary[] newLibs) {
        ArrayList<HashStructure> copy = new ArrayList<HashStructure>();
        for (int i = 0; i < newLibs.length; ++i) {
            HashStructure struct = HashStructure.newInstance();
            LibraryReference ref = new LibraryReference(struct);
            ref.setLibrary(newLibs[i]);
            copy.add(struct);
        }
        libs.mirror(copy);
    }

    static class UnresolvedLibrary
    extends JLibraryAdapter {
        UnresolvedLibrary(HashStructure hash) {
            super(hash);
        }

        @Override
        public Object getID() {
            Object id = super.getID();
            return id != null ? id : "";
        }
    }
}

