/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryAdapter;
import oracle.jdeveloper.resource.LibraryArb;

public class JLibraryAdapter
extends LibraryAdapter
implements JLibrary {
    private transient Icon icon;

    public JLibraryAdapter(HashStructure hash) {
        super(hash);
    }

    @Override
    public boolean equivalent(Library lib) {
        JLibrary jlib;
        JLibrary jLibrary = jlib = lib instanceof JLibrary ? (JLibrary)lib : null;
        if (!super.equivalent(lib)) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jlib.getDeployedByDefault(), (Object)this.getDeployedByDefault());
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JLibrary) {
            JLibrary jlib = (JLibrary)lib;
            Boolean deployed = jlib.getDeployedByDefault();
            super.initFromLibrary(jlib);
            if (ModelUtil.areDifferent((Object)deployed, (Object)this.getDeployedByDefault())) {
                this.setDeployedByDefault(deployed);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (!this.isLocked()) {
            return LibraryArb.getIcon(6);
        }
        if (URLFileSystem.isDirectory((URL)this.getClassPath().getFirstEntry())) {
            return LibraryArb.getIcon(8);
        }
        return LibraryArb.getIcon(7);
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this._hash.getBoolean("deployedByDefault", false) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setDeployedByDefault(Boolean deploy) {
        if (deploy == null) {
            this._hash.remove("deployedByDefault");
        } else {
            this._hash.putBoolean("deployedByDefault", deploy.booleanValue());
        }
    }

    @Override
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }
}

