/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.JdkIntrospector;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.resource.ControlsArb;

public final class JDKUtil {
    private static final String SUN_HOST = "java.sun.com";
    private static final String BASE_1_2_PATH = "/products/jdk/1.2/docs/api/";
    private static final URL BASE_1_2_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/products/jdk/1.2/docs/api/", null, null);
    private static final String BASE_1_3_PATH = "/j2se/1.3/docs/api/";
    private static final URL BASE_1_3_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/j2se/1.3/docs/api/", null, null);
    private static final String BASE_1_4_PATH = "/j2se/1.4/docs/api/";
    private static final URL BASE_1_4_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/j2se/1.4/docs/api/", null, null);
    private static final String BASE_1_5_PATH = "/j2se/1.5/docs/api/";
    private static final URL BASE_1_5_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/j2se/1.5/docs/api/", null, null);
    private static final String BASE_1_6_PATH = "/javase/6/docs/api/";
    private static final URL BASE_1_6_URL = URLFactory.newURL((String)"http", null, (String)"java.sun.com", (int)-1, (String)"/javase/6/docs/api/", null, null);
    private static final String CFG_FILE = "jvm.cfg";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initJDK(JDK jdk, URL javaExe) {
        String version = null;
        String clsPath = null;
        String home = null;
        BufferedReader in = null;
        InputStreamReader err = null;
        if (jdk != null && new JDKExeFilter().accept(javaExe)) {
            try {
                URL dir = URLFileSystem.getParent((URL)javaExe);
                URL exec = JDKUtil.getJavaExecutableNoConsole(dir);
                URL classpath = JdkIntrospector.class.getProtectionDomain().getCodeSource().getLocation();
                URLPath cPath = new URLPath(classpath);
                String cName = JdkIntrospector.class.getName();
                if (!JDKUtil._pathValid(exec, cPath, cName)) {
                    boolean bl = false;
                    return bl;
                }
                String[] args = new String[]{URLFileSystem.getPlatformPathName((URL)exec), "-classpath", cPath.toString(), cName};
                Process proc = Runtime.getRuntime().exec(args);
                in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                err = new InputStreamReader(proc.getErrorStream());
                while (true) {
                    if (err.ready()) {
                        char[] buf = new char[256];
                        int count = err.read(buf);
                        if (count <= 0) continue;
                    }
                    String line = in.readLine();
                    if (line == null) break;
                    if (line.equals(".")) {
                        break;
                    }
                    int idx = line.indexOf(9);
                    if (idx == -1) {
                        break;
                    }
                    String prop = line.substring(0, idx);
                    String val = line.substring(idx + 1);
                    if ("java.version".equals(prop)) {
                        version = val;
                        continue;
                    }
                    if ("java.home".equals(prop)) {
                        home = val;
                        continue;
                    }
                    if (!"sun.boot.class.path".equals(prop)) continue;
                    clsPath = val;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        if (version != null && clsPath != null && home != null) {
            JDKUtil.initJDK(jdk, javaExe, version, clsPath, home);
            return true;
        }
        return false;
    }

    public static void initJDK(JDK jdk, URL exe, String version, String clsPath, String home) {
        VersionNumber ver = new VersionNumber(version);
        jdk.setJavaVersion(ver);
        jdk.setJavaExecutable(exe);
        jdk.setClassPath(URLPath.newURLPathFromString((String)clsPath));
        URL homeURL = URLFactory.newDirURL((String)home);
        URL parent = URLFileSystem.getParent((URL)homeURL);
        URL jreURL = URLFactory.newDirURL((URL)parent, (String)"jre");
        if (!URLFileSystem.exists((URL)jreURL)) {
            parent = homeURL;
        }
        URLPath srcPath = new URLPath();
        URL srcURL = JDKUtil._getSrcURL(parent);
        if (srcURL != null) {
            srcPath.add(srcURL);
        }
        jdk.setSourcePath(srcPath);
        URLPath docPath = new URLPath();
        if (ver.isBefore(new VersionNumber("1.3"), false)) {
            docPath.add(BASE_1_2_URL);
        } else if (ver.isBefore(new VersionNumber("1.4"), false)) {
            docPath.add(BASE_1_3_URL);
        } else if (ver.isBefore(new VersionNumber("1.5"), false)) {
            docPath.add(BASE_1_4_URL);
        } else if (ver.isBefore(new VersionNumber("1.6"), false)) {
            docPath.add(BASE_1_5_URL);
        } else {
            docPath.add(BASE_1_6_URL);
        }
        jdk.setDocPath(docPath);
        if (homeURL != null) {
            URL sdkDir = URLFileSystem.getParent((URL)homeURL);
            URL binDir = URLFactory.newDirURL((URL)sdkDir, (String)"bin");
            if (!URLFileSystem.exists((URL)binDir)) {
                binDir = URLFactory.newDirURL((URL)homeURL, (String)"bin");
            }
            jdk.setSDKBinDir(binDir);
        }
    }

    private static boolean _pathValid(URL exec, URLPath cPath, String cName) {
        return URLFileSystem.exists((URL)exec) && URLFileSystem.isRegularFile((URL)exec) && cPath.toQualifiedURL(cName.replace('.', '/') + ".class") != null;
    }

    private static URL _getSrcURL(URL parent) {
        String[] archiveName = new String[]{"src.jar", "src.zip"};
        String[] subDirs = new String[]{"src/", ""};
        for (int i = 0; i < archiveName.length; ++i) {
            URL archive = URLFactory.newURL((URL)parent, (String)archiveName[i]);
            if (!URLFileSystem.exists((URL)archive)) continue;
            for (int j = 0; j < subDirs.length; ++j) {
                URL dir = URLFactory.newJarURL((URL)archive, (String)subDirs[j]);
                if (!URLFileSystem.exists((URL)URLFactory.newURL((URL)dir, (String)"java/lang/Object.java"))) continue;
                return dir;
            }
        }
        return null;
    }

    private static URL _checkLocation(URL dir) {
        if (dir == null) {
            return null;
        }
        URL cfg = URLFactory.newURL((URL)dir, (String)CFG_FILE);
        return cfg != null && URLFileSystem.exists((URL)cfg) ? cfg : null;
    }

    private static URL _findJvmCfg(URL baseURL) {
        URL cfg = JDKUtil._checkLocation(baseURL);
        if (cfg != null) {
            return cfg;
        }
        String arch = System.getProperty("os.arch");
        if ("x86".equals(arch)) {
            arch = "i386";
        }
        if ((cfg = JDKUtil._checkLocation(URLFactory.newDirURL((URL)baseURL, (String)arch))) != null) {
            return cfg;
        }
        return JDKUtil._checkChildren(baseURL);
    }

    private static URL _checkChildren(URL baseURL) {
        URL[] children = URLFileSystem.list((URL)baseURL, (URLFilter)new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isDirectory((URL)url);
            }
        });
        if (children != null) {
            for (int i = children.length - 1; i >= 0; --i) {
                URL cfg = JDKUtil._checkLocation(children[i]);
                if (cfg != null) {
                    return cfg;
                }
                cfg = JDKUtil._checkChildren(children[i]);
                if (cfg == null) continue;
                return cfg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getVMChoices(URL SDKBinURL, boolean addOjvm) {
        URL cfg;
        URL parent = URLFileSystem.getParent((URL)SDKBinURL);
        URL homeURL = URLFactory.newDirURL((URL)parent, (String)"jre");
        if (!URLFileSystem.exists((URL)homeURL)) {
            homeURL = parent;
        }
        ArrayList<String> vmList = new ArrayList<String>();
        URL libURL = URLFactory.newURL((URL)homeURL, (String)"lib/");
        if (libURL == null) {
            libURL = homeURL;
        }
        if ((cfg = JDKUtil._findJvmCfg(libURL)) != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(cfg.openStream()));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                    }
                    if (line.startsWith("#")) continue;
                    String vmName = null;
                    String attribute = null;
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.hasMoreTokens()) {
                        vmName = st.nextToken();
                        if (st.hasMoreTokens()) {
                            attribute = st.nextToken();
                        }
                    }
                    if (vmName == null || attribute != null && !attribute.equalsIgnoreCase("KNOWN") && !attribute.equalsIgnoreCase("IF_SERVER_CLASS") && !attribute.equalsIgnoreCase("ALIASED_TO")) continue;
                    if (vmName.startsWith("-")) {
                        vmName = vmName.substring(1);
                    }
                    vmList.add(vmName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {}
                }
            }
        } else {
            URL[] contents;
            URL binURL = URLFactory.newDirURL((URL)homeURL, (String)"bin");
            if (URLFileSystem.exists((URL)binURL) && (contents = URLFileSystem.list((URL)binURL, (URLFilter)new URLFilter(){

                public boolean accept(URL url) {
                    return URLFileSystem.isDirectory((URL)url) && URLFileSystem.exists((URL)URLFactory.newURL((URL)url, (String)"jvm.dll"));
                }
            })) != null) {
                for (int i = 0; i < contents.length; ++i) {
                    String vmName = URLFileSystem.getFileName((URL)contents[i]);
                    vmList.add(vmName);
                }
                int idx = vmList.indexOf("classic");
                if (idx != -1) {
                    Object o = vmList.remove(idx);
                    vmList.add(0, (String)o);
                }
            }
        }
        return vmList.toArray(new String[vmList.size()]);
    }

    static URL getJavaExecutableNoConsole(URL dir) {
        String[] possibleJava = new String[]{"javaw.exe", "javaw", "java.exe", "java"};
        int length = possibleJava.length;
        for (int i = 0; i < length; ++i) {
            URL javaURL = URLFactory.newURL((URL)dir, (String)possibleJava[i]);
            if (!URLFileSystem.exists((URL)javaURL)) continue;
            return javaURL;
        }
        return null;
    }

    static String getJavaExecutableNoConsolePath(URL dir) {
        URL url = JDKUtil.getJavaExecutableNoConsole(dir);
        return url != null ? URLFileSystem.getPlatformPathName((URL)url) : "java";
    }

    public static class JDKExeFilter
    implements URLFilter {
        public boolean accept(URL url) {
            String fName;
            boolean result = false;
            if (url != null && "file".equals(url.getProtocol()) && URLFileSystem.isRegularFile((URL)url) && (fName = URLFileSystem.getFileName((URL)url)) != null) {
                result = (fName = fName.toLowerCase()).equals("java") || fName.equals("java.exe");
            }
            return result;
        }

        public boolean equals(Object o) {
            return o instanceof JDKExeFilter;
        }

        public String toString() {
            return ControlsArb.getString(53);
        }
    }
}

