/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.marshal.AttributeMarker;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.resource.LibraryArb;

public final class AddinLibrary
extends AbstractLibrary
implements JLibrary {
    private final String _name;
    private final URLPath _clsPath;
    private final URLPath _srcPath;
    private final URLPath _docPath;
    private final Boolean _deployed;

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed) {
        this._name = name;
        this._clsPath = new URLPath(clsPath);
        this._srcPath = new URLPath(srcPath);
        this._docPath = new URLPath(docPath);
        this._deployed = deployed != null ? deployed : Boolean.FALSE;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public URLPath getClassPath() {
        return new URLPath(this._clsPath);
    }

    @Override
    public URLPath getSourcePath() {
        return new URLPath(this._srcPath);
    }

    @Override
    public URLPath getDocPath() {
        return new URLPath(this._docPath);
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this._deployed;
    }

    @Override
    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        return LibraryArb.getIcon(5);
    }

    @Override
    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    @Override
    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    @Override
    public void setDeployedByDefault(Boolean deployed) {
        this.immutable();
    }

    @Override
    public void markDirty(boolean dirty) {
        this.immutable();
    }

    @Override
    public void setClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    public void setDefaultClassPath(URLPath clsPath) {
        this.immutable();
    }

    @Override
    public void setDefaultDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    public void setDefaultSourcePath(URLPath srcPath) {
        this.immutable();
    }

    @Override
    public void setDocPath(URLPath docPath) {
        this.immutable();
    }

    @Override
    public void setLocked(boolean isLocked) {
        this.immutable();
    }

    @Override
    public void setName(String name) {
        this.immutable();
    }

    @Override
    public void setSourcePath(URLPath srcPath) {
        this.immutable();
    }

    private void immutable() {
        throw new UnsupportedOperationException("AddinLibrary instances are immutable.");
    }
}

