/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportCreatePanel;
import oracle.dbtools.raptor.report.ui.ReportUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class ReportNewPanel
extends JPanel {
    private ReportCreatePanel _newReport;
    private String _dbName;
    private String _path;

    public ReportNewPanel() {
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this._newReport = new ReportCreatePanel();
        this.add((Component)this._newReport, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(6, 6, 6, 6), 0, 0));
        this._newReport.getTestReportButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportNewPanel.this.displayTestReportDialog(1);
            }
        });
        this._newReport.getLargeEditorTestReportButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportNewPanel.this.displayTestReportDialog(2);
            }
        });
    }

    private void displayTestReportDialog(int n) {
        String string = null;
        String string2 = string = n == 1 ? this._newReport.getSql() : this._newReport.getSqlFromLargeEditor();
        if (string == null || string.isEmpty()) {
            MessageDialog.error((Component)this, (Object)ReportArb.getString("TEST_REPORT_ERROR_SQL_MISSING"), (String)ReportArb.getString("TEST_REPORT_ERROR_TITLE"), null);
        } else {
            this.showTest(this.getModel(string), this._dbName);
        }
    }

    public void showTest(DisplayModel displayModel, String string) {
        if (string == null) {
            string = ReportUtils.getNewConnection();
        }
        try {
            Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (string != null && Connections.getInstance().isConnectionOpen(string)) {
            displayModel.setConnName(string);
            DisplayPanel displayPanel = new DisplayPanel(displayModel);
            displayPanel.promptForBindsOnNextRun(true);
            displayPanel.refresh(true);
            Dimension dimension = new Dimension(400, 400);
            try {
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)displayPanel, null, (String)ReportArb.getString("TEST_REPORT_TITLE"), (int)16);
                jEWTDialog.setPreferredSize(dimension);
                jEWTDialog.setSize(dimension);
                jEWTDialog.setLocation(300, 20);
                jEWTDialog.runDialog();
            }
            catch (Exception exception) {
                // empty catch block
            }
            displayPanel.close();
        }
    }

    public DisplayModel getModel() {
        return this.getModel(null);
    }

    private DisplayModel getModel(String string) {
        DisplayModel displayModel = new DisplayModel(this._newReport.getName(), this._newReport.getDescription(), "true", null);
        displayModel.setStyle(this._newReport.getStyle());
        displayModel.setPath(this._path);
        String string2 = null;
        string2 = string == null ? this._newReport.getSql().replaceAll("\r\n", "\n") : string.replaceAll("\r\n", "\n");
        Query query = new Query();
        query.setSql(string2);
        ArrayList<Query> arrayList = new ArrayList<Query>();
        arrayList.add(query);
        displayModel.setQueries(arrayList);
        IDisplayDetail iDisplayDetail = null;
        try {
            iDisplayDetail = DisplayRegistry.getDetailPanel((String)this._newReport.getStyle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iDisplayDetail != null) {
            displayModel.setExtValues(iDisplayDetail.getValues());
        }
        return displayModel;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public ReportCreatePanel getCreateReportPanel() {
        return this._newReport;
    }

    public String getMasterReportName() {
        return this._newReport.getName();
    }

    public String getSQL() {
        return this._newReport.getSql();
    }
}

