/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import oracle.dbtools.raptor.report.pdf.PDFConstants;

public class Ruler
extends JComponent {
    public static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 35;
    public int orientation;
    public boolean isMetric;
    private int increment;
    private int units;

    public Ruler(int n, boolean bl) {
        this.orientation = n;
        this.isMetric = bl;
        this.setIncrementAndUnits();
    }

    public void setIsMetric(boolean bl) {
        this.isMetric = bl;
        this.setIncrementAndUnits();
        this.repaint();
    }

    private void setIncrementAndUnits() {
        if (this.isMetric) {
            this.increment = this.units = (int)((double)INCH / 2.54);
        } else {
            this.units = INCH;
            this.increment = this.units / 2;
        }
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPreferredHeight(int n) {
        this.setPreferredSize(new Dimension(35, n));
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, 35));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(PDFConstants.RULER_COLOR);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        if (this.orientation == 0) {
            n2 = rectangle.x / this.increment * this.increment;
            n = ((rectangle.x + rectangle.width) / this.increment + 1) * this.increment;
        } else {
            n2 = rectangle.y / this.increment * this.increment;
            n = ((rectangle.y + rectangle.height) / this.increment + 1) * this.increment;
        }
        if (n2 == 0) {
            string = Integer.toString(0) + (this.isMetric ? " cm" : " in");
            n3 = 10;
            if (this.orientation == 0) {
                graphics.drawLine(0, 34, 0, 35 - n3 - 1);
                graphics.drawString(string, 2, 21);
            } else {
                graphics.drawLine(34, 0, 35 - n3 - 1, 0);
                graphics.drawString(string, 9, 10);
            }
            string = null;
            n2 = this.increment;
        }
        for (int i = n2; i < n; i += this.increment) {
            if (i % this.units == 0) {
                n3 = 10;
                string = Integer.toString(i / this.units);
            } else {
                n3 = 7;
                string = null;
            }
            if (n3 == 0) continue;
            if (this.orientation == 0) {
                graphics.drawLine(i, 34, i, 35 - n3 - 1);
                if (string == null) continue;
                graphics.drawString(string, i - 3, 21);
                continue;
            }
            graphics.drawLine(34, i, 35 - n3 - 1, i);
            if (string == null) continue;
            graphics.drawString(string, 9, i + 3);
        }
    }
}

