/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.ide.util.ResourceUtils;

public class PDFSecurityPanel
implements IPDFOptions,
ItemListener {
    private static final long serialVersionUID = 1L;
    private PDFFormatOptions _pdfFormat = null;
    private JPasswordField _openPassword = null;
    private JPasswordField _permissionPassword = null;
    private JCheckBox _securityAllowed = null;
    private JCheckBox _openPasswordRequired = null;
    private JCheckBox _permissionsAllowed = null;
    private JCheckBox _printingAllowed = null;
    private JCheckBox _copyingAllowed = null;
    private JCheckBox _updatingAllowed = null;
    private JCheckBox _ADCopyingAllowed = null;
    private JRadioButton _encryptAll = null;
    private JRadioButton _encryptAllExceptMetadata = null;
    private JTextPane _permissionInstructions = null;
    private String _errorMessage = null;
    private int _row = 0;

    public PDFSecurityPanel() {
        this.init();
    }

    private void init() {
        this._securityAllowed = new JCheckBox();
        this._permissionsAllowed = new JCheckBox();
        this._openPasswordRequired = new JCheckBox();
        this._printingAllowed = new JCheckBox();
        this._copyingAllowed = new JCheckBox();
        this._updatingAllowed = new JCheckBox();
        this._ADCopyingAllowed = new JCheckBox();
        this._permissionInstructions = new JTextPane();
        this._encryptAll = new JRadioButton();
        this._encryptAllExceptMetadata = new JRadioButton();
        this._securityAllowed.addItemListener(this);
        this._openPasswordRequired.addItemListener(this);
        this._permissionsAllowed.addItemListener(this);
        this._copyingAllowed.addItemListener(this);
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._openPassword, (String)PDFArb.getString("OPEN_PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._permissionPassword, (String)PDFArb.getString("PERMISSION_PASSWORD"));
        ResourceUtils.resButton((AbstractButton)this._securityAllowed, (String)PDFArb.getString("SECURITY_ALLOWED"));
        ResourceUtils.resButton((AbstractButton)this._permissionsAllowed, (String)PDFArb.getString("PERMISSION_TITLE"));
        ResourceUtils.resButton((AbstractButton)this._openPasswordRequired, (String)PDFArb.getString("OPEN_PASSWORD_REQUIRED"));
        ResourceUtils.resButton((AbstractButton)this._printingAllowed, (String)PDFArb.getString("ALLOW_PRINTING"));
        ResourceUtils.resButton((AbstractButton)this._copyingAllowed, (String)PDFArb.getString("ALLOW_COPYING"));
        ResourceUtils.resButton((AbstractButton)this._updatingAllowed, (String)PDFArb.getString("ALLOW_UPDATING"));
        ResourceUtils.resButton((AbstractButton)this._ADCopyingAllowed, (String)PDFArb.getString("ALLOW_AD_COPYING"));
        ResourceUtils.resButton((AbstractButton)this._encryptAll, (String)PDFArb.getString("ENCRYPT_ALL"));
        ResourceUtils.resButton((AbstractButton)this._encryptAllExceptMetadata, (String)PDFArb.getString("ENCRYPT_ALL_EXCEPT_METADATA"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel.add((Component)this._securityAllowed, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(1, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel2.add((Component)this._openPasswordRequired, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 25, 0, 6), 0, 0));
        jPanel2.add((Component)this._openPassword, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 0, 6), 150, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(2, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this._row = 0;
        String string = PDFArb.getString("PERMISSION_INSTRUCTION");
        this._permissionInstructions.setText(string);
        this._permissionInstructions.setEditable(false);
        this._permissionInstructions.setOpaque(false);
        this._permissionInstructions.setRequestFocusEnabled(false);
        this._permissionInstructions.setFocusable(false);
        jPanel3.add((Component)this._permissionInstructions, new GridBagConstraints(0, this._row, 2, 1, 0.0, 0.0, 23, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(1, 0, 0, 6), 0, 0));
        jPanel4.add((Component)this._permissionPassword, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 23, 2, new Insets(1, 0, 0, 6), 150, 0));
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 6), 0, 0));
        jPanel3.add((Component)this._printingAllowed, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(10, 25, 0, 6), 0, 0));
        jPanel3.add((Component)this._copyingAllowed, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 25, 0, 6), 0, 0));
        jPanel3.add((Component)this._updatingAllowed, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 25, 0, 6), 0, 0));
        jPanel3.add((Component)this._ADCopyingAllowed, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 25, 6, 6), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._permissionsAllowed, (Component)jPanel3);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this._row = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._encryptAll);
        buttonGroup.add(this._encryptAllExceptMetadata);
        jPanel5.add((Component)this._encryptAll, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 10, 0, 6), 0, 0));
        jPanel5.add((Component)this._encryptAllExceptMetadata, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 10, 8, 6), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(1, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel5, (String)PDFArb.getString("ENCRYPTION_TITLE"));
        this._row = 0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)jPanel, new GridBagConstraints(0, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel6.add((Component)jPanel2, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 0, 0, 8), 0, 0));
        jPanel6.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 0, 0, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add((Component)titledPane, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 0, 0, 8), 0, 0));
        jPanel6.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 0, 0, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add((Component)jPanel5, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 2, new Insets(10, 0, 0, 8), 0, 0));
        jPanel6.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel6;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        this._openPassword = new JPasswordField(this._pdfFormat.getOpenPassword());
        this._permissionPassword = new JPasswordField(this._pdfFormat.getPermissionPassword());
        this._securityAllowed.setSelected(this._pdfFormat.isSecurityAllowed());
        this._permissionsAllowed.setSelected(this._pdfFormat.isPermissionsAllowed());
        this._openPasswordRequired.setSelected(this._pdfFormat.isOpenPasswordRequired());
        this._printingAllowed.setSelected(this._pdfFormat.isPrintingAllowed());
        this._copyingAllowed.setSelected(this._pdfFormat.isCopyingAllowed());
        this._updatingAllowed.setSelected(this._pdfFormat.isUpdatingAllowed());
        this._ADCopyingAllowed.setSelected(this._pdfFormat.isAccessibleDevicesCopyingAllowed());
        PDFFormatOptions.ENCRYPTION_LEVEL eNCRYPTION_LEVEL = this._pdfFormat.getEncryptionLevel();
        switch (eNCRYPTION_LEVEL) {
            case EXCLUDE_METADATA: {
                this._encryptAllExceptMetadata.setSelected(true);
                break;
            }
            default: {
                this._encryptAll.setSelected(true);
            }
        }
        this.enableDisablePermissions(this._securityAllowed.isSelected(), true);
        this.enableDisableOpenPassword(this._securityAllowed.isSelected(), true);
        this.enableDisableEncryption(this._securityAllowed.isSelected());
        if (this._copyingAllowed.isSelected()) {
            this.enableDisableAccessibilityCopying(this._copyingAllowed.isSelected());
        }
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            this._pdfFormat.setOpenPassword(String.valueOf(this._openPassword.getPassword()));
            this._pdfFormat.setPermissionPassword(String.valueOf(this._permissionPassword.getPassword()));
            this._pdfFormat.setSecurityAllowed(this._securityAllowed.isSelected());
            this._pdfFormat.setOpenPasswordRequired(this._openPasswordRequired.isSelected());
            this._pdfFormat.setPermissionsAllowed(this._permissionsAllowed.isSelected());
            this._pdfFormat.setPrintingAllowed(this._printingAllowed.isSelected());
            this._pdfFormat.setCopyingAllowed(this._copyingAllowed.isSelected());
            this._pdfFormat.setUpdatingAllowed(this._updatingAllowed.isSelected());
            this._pdfFormat.setAccessibleDevicesCopyingAllowed(this._ADCopyingAllowed.isSelected());
            PDFFormatOptions.ENCRYPTION_LEVEL eNCRYPTION_LEVEL = null;
            eNCRYPTION_LEVEL = this._encryptAllExceptMetadata.isSelected() ? PDFFormatOptions.ENCRYPTION_LEVEL.EXCLUDE_METADATA : PDFFormatOptions.ENCRYPTION_LEVEL.ENTIRE_CONTENT;
            this._pdfFormat.setEncryptionLevel(eNCRYPTION_LEVEL);
        }
        return this._pdfFormat;
    }

    public boolean validatePassword() {
        if (!this._securityAllowed.isSelected()) {
            return true;
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._openPasswordRequired.isSelected() && ((string = String.valueOf(this._openPassword.getPassword())) == null || string.isEmpty())) {
            stringBuffer.append(PDFArb.getString("OPEN_PASSWORD_MISSING"));
            this._openPassword.requestFocus();
        }
        if (this._permissionsAllowed.isSelected() && ((string = String.valueOf(this._permissionPassword.getPassword())) == null || string.isEmpty())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            } else {
                this._permissionPassword.requestFocus();
            }
            stringBuffer.append(PDFArb.getString("PERMISSION_PASSWORD_MISSING"));
        }
        if (stringBuffer.length() > 0) {
            this._errorMessage = stringBuffer.toString();
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this._securityAllowed) {
            this.enableDisablePermissions(this._securityAllowed.isSelected(), true);
            this.enableDisableOpenPassword(this._securityAllowed.isSelected(), true);
            this.enableDisableEncryption(this._securityAllowed.isSelected());
        } else if (itemSelectable == this._openPasswordRequired) {
            this.enableDisableOpenPassword(this._openPasswordRequired.isSelected(), false);
        } else if (itemSelectable == this._permissionsAllowed) {
            this.enableDisablePermissions(this._permissionsAllowed.isSelected(), false);
        } else if (itemSelectable == this._copyingAllowed) {
            this.enableDisableAccessibilityCopying(this._copyingAllowed.isSelected());
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    private void enableDisablePermissions(boolean bl, boolean bl2) {
        if (bl2) {
            this._permissionsAllowed.setEnabled(bl);
            if (bl) {
                bl = this._permissionsAllowed.isSelected();
            }
        }
        this._permissionPassword.setEnabled(bl);
        this._printingAllowed.setEnabled(bl);
        this._copyingAllowed.setEnabled(bl);
        this._updatingAllowed.setEnabled(bl);
        this._ADCopyingAllowed.setEnabled(bl);
        this._permissionInstructions.setEnabled(bl);
    }

    private void enableDisableOpenPassword(boolean bl, boolean bl2) {
        if (bl2) {
            this._openPasswordRequired.setEnabled(bl);
            if (bl) {
                bl = this._openPasswordRequired.isSelected();
            }
        }
        this._openPassword.setEnabled(bl);
        if (this._openPasswordRequired.isEnabled()) {
            if (this._openPasswordRequired.isSelected()) {
                if (this._permissionsAllowed.isSelected()) {
                    if (this._permissionsAllowed.isEnabled()) {
                        this._permissionsAllowed.setEnabled(false);
                    }
                } else {
                    this._permissionsAllowed.setSelected(true);
                    this.enableDisablePermissions(true, false);
                    this._permissionsAllowed.setEnabled(false);
                }
            } else if (!this._permissionsAllowed.isEnabled()) {
                this._permissionsAllowed.setEnabled(true);
            }
        }
    }

    private void enableDisableEncryption(boolean bl) {
        this._encryptAll.setEnabled(bl);
        this._encryptAllExceptMetadata.setEnabled(bl);
    }

    private void enableDisableAccessibilityCopying(boolean bl) {
        if (bl) {
            if (!this._ADCopyingAllowed.isSelected()) {
                this._ADCopyingAllowed.setSelected(true);
            }
            this._ADCopyingAllowed.setEnabled(false);
        } else {
            this._ADCopyingAllowed.setSelected(false);
            this._ADCopyingAllowed.setEnabled(true);
        }
    }
}

