/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.dbtools.raptor.report.pdf.PDFUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;

public class PDFDateTimeDialog {
    private JEWTDialog _dlg = null;
    private JList _dateTimeFormatList;
    private JScrollPane _dateTimeScrollPane;
    private JCheckBox _autoUpdateDate = null;
    private String _title;

    public PDFDateTimeDialog(boolean bl) {
        this.initComponents(bl);
    }

    private void initComponents(boolean bl) {
        this._title = PDFArb.getString("INSERT_DATE");
        this._dateTimeFormatList = new JList();
        String[] stringArray = PDFUtils.getDateTimeFormatted();
        this._dateTimeFormatList = new JList<String>(stringArray);
        this._dateTimeFormatList.setSelectedIndex(0);
        this._dateTimeFormatList.setSelectionMode(0);
        this._dateTimeFormatList.setVisibleRowCount(stringArray.length);
        this._dateTimeScrollPane = new JScrollPane(this._dateTimeFormatList);
        this._autoUpdateDate = new JCheckBox();
        this._autoUpdateDate.setSelected(bl);
    }

    private JPanel getPanel() {
        JTextPane jTextPane = new JTextPane();
        String string = PDFArb.getString("AVAILABLE_FORMATS");
        jTextPane.setText(string);
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        ResourceUtils.resButton((AbstractButton)this._autoUpdateDate, (String)PDFArb.getString("AUTO_UPDATE_DATE"));
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jTextPane, new GridBagConstraints(n2, n, 2, 2, 0.0, 0.0, 23, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._dateTimeScrollPane, new GridBagConstraints(n2, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 6, 6, 0), 0, 0));
        jPanel.add((Component)this._autoUpdateDate, new GridBagConstraints(n2, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 6, 6, 0), 0, 0));
        return jPanel;
    }

    public String getDateTimeValue() {
        String string = null;
        if (this._dateTimeFormatList != null) {
            String string2 = PDFConstants.DATE_TIME_PATTERN_LIST[this._dateTimeFormatList.getSelectedIndex()];
            Calendar calendar = Calendar.getInstance();
            if ((string2.equals("HH:mm") || string2.equals("HH:mm:ss")) && calendar.get(11) < 12) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                string = simpleDateFormat.format(calendar.getTime());
            } else {
                string = (String)this._dateTimeFormatList.getSelectedValue();
            }
        }
        return string;
    }

    public String getDateTimePattern() {
        String string = null;
        if (this._dateTimeFormatList != null) {
            string = PDFConstants.DATE_TIME_PATTERN_LIST[this._dateTimeFormatList.getSelectedIndex()];
        }
        return string;
    }

    public int getDateTimeFormatIndex() {
        int n = 0;
        if (this._dateTimeFormatList != null) {
            n = this._dateTimeFormatList.getSelectedIndex();
        }
        return n;
    }

    public boolean _isAutoUpdateDate() {
        if (this._autoUpdateDate != null) {
            return this._autoUpdateDate.isSelected();
        }
        return false;
    }

    public boolean runDialog() {
        JPanel jPanel = this.getPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_editheaderfooter_html");
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)this._title, (int)7);
        this._dlg.setModal(true);
        this._dlg.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dlg);
        boolean bl = this._dlg.runDialog();
        if (!bl) {
            // empty if block
        }
        return bl;
    }
}

