/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.util.Resource;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;

public class RootNode
extends DefaultContainer {
    private static RootNode INSTANCE;
    private FolderNode _userReports;
    private FolderNode _sharedReports;
    ReportXMLUtil xmlUtil = new ReportXMLUtil();
    private Attributes m_attributes = new ElementAttributes();
    XLIFFHelper xliff = new XLIFFHelper();
    public static final String ROOTNODE_NAME;
    public static final String USER_DEFINED_REPORTS_NODE_NAME;
    public static final String SHARED_REPORTS_NODE_NAME;
    private Logger logger = Logger.getLogger(Messages.getString("RootNode.4"));
    private boolean _init = false;

    public static synchronized RootNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RootNode();
        }
        return INSTANCE;
    }

    private RootNode() {
        this.setURL(URLFactory.newURL((String)"sqldev.reports", (String)ROOTNODE_NAME));
    }

    public FolderNode getUserDefined() {
        return this._userReports;
    }

    public FolderNode getSharedDefined() {
        return this._sharedReports;
    }

    public String getShortLabel() {
        return ROOTNODE_NAME;
    }

    public Icon getIcon() {
        return ReportAddin.rootIcon;
    }

    protected void openImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RootNode.this.initialize();
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("Report Tree Opener");
        thread.start();
    }

    public void open(String string) {
        this.initialize();
        Map map = null;
        DisplayModel displayModel = DisplayModelCache.getDisplayModel((String)string);
        displayModel.setQueriesBindMap(map);
        ReportNavigatorContextMenu.getInstance().openReport(displayModel, true, (String)null);
    }

    public void initialize() {
        if (!this._init) {
            InputStreamReader inputStreamReader;
            Object object;
            InputStream inputStream;
            Object object2 = new Folder(Messages.getString("RootNode.5"), Messages.getString("RootNode.6"));
            Iterator<String> iterator = URLFactory.newURL((URL)this.getURL(), (String)"Data Dictionary Reports");
            FolderNode object32 = new FolderNode((URL)((Object)iterator), (Folder)object2);
            object32.setEditable(false);
            this._children.add(object32);
            object2 = new Folder(USER_DEFINED_REPORTS_NODE_NAME, USER_DEFINED_REPORTS_NODE_NAME);
            iterator = URLFactory.newURL((URL)this.getURL(), (String)USER_DEFINED_REPORTS_NODE_NAME);
            this._userReports = new FolderNode((URL)((Object)iterator), (Folder)object2);
            this._children.add(this._userReports);
            object2 = this;
            try {
                this.addPackage("oracle.dbtools.raptor.report.reports");
            }
            catch (Exception exception) {
                this.logger.severe(Messages.getString("RootNode.10") + exception.getMessage() + "\n*****");
            }
            try {
                iterator = new File(ReportAddin.USER_REPORT_FILE);
                String string = "UTF-8";
                inputStream = new FileInputStream((File)((Object)iterator));
                object = new BufferedInputStream(inputStream);
                inputStreamReader = new InputStreamReader((InputStream)object, string);
                this.xmlUtil.parseXML(this._userReports, inputStreamReader, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                this.logger.severe(Messages.getString("RootNode.14") + USER_DEFINED_REPORTS_NODE_NAME);
            }
            try {
                if (ReportAddin.getRegisterReport().size() > 0) {
                    iterator = new Folder(SHARED_REPORTS_NODE_NAME, SHARED_REPORTS_NODE_NAME);
                    URL uRL = new URL(this.getURL().toString() + "/" + SHARED_REPORTS_NODE_NAME);
                    this._sharedReports = new FolderNode(uRL, (Folder)((Object)iterator));
                    this._sharedReports.setEditable(false);
                    this.add((Element)this._sharedReports);
                    UpdateMessage.fireChildAdded((Subject)object2, (Element)this._sharedReports);
                }
                for (URL uRL : ReportAddin.getRegisterReport()) {
                    try {
                        inputStream = uRL.openStream();
                        object = "UTF-8";
                        inputStreamReader = new InputStreamReader(inputStream, (String)object);
                        this.xmlUtil.parseXML(this._sharedReports, inputStreamReader, false);
                    }
                    catch (Exception exception) {
                        if (uRL.toURI().toString().indexOf("www.oracle.com") == -1) {
                            this.logger.severe(Messages.getString("RootNode.17") + uRL.toString());
                            continue;
                        }
                        this.logger.info(Messages.getString("RootNode.17") + uRL.toString());
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(Messages.getString("RootNode.18") + SHARED_REPORTS_NODE_NAME);
            }
            for (String string : ReportAddin.getRegisterReportPackages()) {
                try {
                    this.addPackage(string);
                    UpdateMessage.fireStructureChanged((Subject)object2);
                }
                catch (Exception exception) {
                    this.logger.severe(Messages.getString("RootNode.19") + string);
                }
            }
            UpdateMessage.fireStructureChanged((Subject)object2);
            this.markDirty(false);
            this._init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackage(String string) throws Exception {
        URL[] uRLArray = Resource.getPath((String)(string = string.replaceAll("\\.", "\\/")));
        if (uRLArray != null) {
            for (URL uRL : uRLArray) {
                URL[] uRLArray2;
                for (URL uRL2 : uRLArray2 = URLFileSystem.list((URL)uRL, (URLFilenameFilter)new URLFilenameFilter(){

                    public boolean accept(URL uRL, String string) {
                        return string.endsWith(".xml");
                    }
                })) {
                    InputStreamReader inputStreamReader = null;
                    try {
                        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL2);
                        String string2 = "UTF-8";
                        inputStreamReader = new InputStreamReader(inputStream, string2);
                        String string3 = null;
                        if (uRL2.toString().contains(".jar!")) {
                            string3 = uRL2.toString().substring(uRL2.toString().lastIndexOf(".jar!") + 5);
                            this.xliff.setBaseDocName(string3);
                        } else {
                            string3 = uRL2.toString().substring(uRL2.toString().lastIndexOf("classes") + 7);
                            this.xliff.setBaseDocName(string3);
                        }
                        this.xmlUtil.parseXML(this, inputStreamReader, false, string, this.xliff);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    finally {
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }

    static {
        ROOTNODE_NAME = Messages.getString("RootNode.1");
        USER_DEFINED_REPORTS_NODE_NAME = Messages.getString("RootNode.2");
        SHARED_REPORTS_NODE_NAME = Messages.getString("RootNode.3");
    }
}

