/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.log.LogManager;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportXMLUtil {
    private static ArrayList<URL> _urls = new ArrayList();
    Boolean _import = false;
    XLIFFHelper xliff = new XLIFFHelper();
    private DOMParser _parser;

    private DOMParser getParser() {
        if (this._parser == null) {
            this._parser = new DOMParser();
        } else {
            this._parser.reset();
        }
        return this._parser;
    }

    public void parseXML(DefaultContainer defaultContainer, InputStreamReader inputStreamReader, boolean bl, String string) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        this.processNode(defaultContainer, (Node)xMLDocument, bl);
    }

    public void parseXML(DefaultContainer defaultContainer, InputStreamReader inputStreamReader, boolean bl) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        this.processNode(defaultContainer, (Node)xMLDocument, bl);
    }

    private void processNode(DefaultContainer defaultContainer, Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(defaultContainer, nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("report")) {
                this.processReport(defaultContainer, nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("reports")) {
                this.processNode(defaultContainer, nodeList.item(i), bl);
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("displays")) continue;
            this.processNodeV2(defaultContainer, nodeList.item(i), bl);
        }
    }

    private void processNodeV2(DefaultContainer defaultContainer, Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("folder")) {
                try {
                    this.processFolderV2(defaultContainer, nodeList.item(i), bl);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
                }
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("display")) continue;
            try {
                this.processReportV2(defaultContainer, nodeList.item(i), bl);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
            }
        }
    }

    private DefaultContainer findOrCreateFolders(DefaultContainer defaultContainer, String string, boolean bl) {
        URL uRL;
        String[] stringArray = string.split("/");
        String string2 = defaultContainer.getURL().toString();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "/" + stringArray[i];
            try {
                uRL = new URL(string2);
                for (URL object2 : _urls) {
                    if (!object2.equals(uRL)) continue;
                    uRL = object2;
                }
                if (!_urls.contains(uRL)) {
                    _urls.add(uRL);
                }
                arrayList.add(uRL);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
            }
        }
        Object object = defaultContainer;
        uRL = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                uRL = (DefaultContainer)NodeFactory.findOrCreateUsingDefault((URL)((URL)arrayList.get(i)), FolderNode.class);
                if (uRL instanceof FolderNode && ((FolderNode)((Object)uRL)).getFolder() == null) {
                    String instantiationException = ((URL)arrayList.get(i)).toString().substring(((URL)arrayList.get(i)).toString().lastIndexOf("/") + 1);
                    ((FolderNode)((Object)uRL)).setFolder(new Folder(instantiationException, ""));
                    ((FolderNode)((Object)uRL)).setTemp(true);
                    ((FolderNode)((Object)uRL)).setEditable(bl);
                }
                if (!object.containsChild((Element)uRL)) {
                    object.add((Element)uRL);
                }
                object.markDirty(false);
                object = uRL;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
        }
        return object;
    }

    private void processFolder(DefaultContainer defaultContainer, Node node, boolean bl) {
        Object object;
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        FolderNode folderNode = (FolderNode)this.findOrCreateFolders(defaultContainer, string, bl);
        if (folderNode.isTemp()) {
            object = new Folder(node, this.xliff);
            folderNode.setFolder((Folder)object);
            folderNode.setTemp(false);
            if (folderNode.getURL().toString().indexOf(Messages.getString("RootNode.2")) > 0) {
                folderNode.setEditable(true);
            } else {
                folderNode.setEditable(false);
            }
        } else if (this._import.booleanValue()) {
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.3"), folderNode.getShortLabel()));
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            if (object.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(folderNode, object.item(i), bl);
                continue;
            }
            if (object.item(i).getNodeName().equalsIgnoreCase("report")) {
                this.processReport(folderNode, object.item(i), bl);
                continue;
            }
            if (!object.item(i).getNodeName().equalsIgnoreCase("description") && object.item(i).getNodeName().equalsIgnoreCase("name")) continue;
        }
    }

    private void processFolderV2(DefaultContainer defaultContainer, Node node, boolean bl) throws MalformedURLException {
        Object object;
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        FolderNode folderNode = (FolderNode)this.findOrCreateFolders(defaultContainer, string, bl);
        if (folderNode.isTemp()) {
            object = new Folder(node, this.xliff);
            folderNode.setFolder((Folder)object);
            folderNode.setTemp(false);
            if (folderNode.getURL().toString().indexOf(Messages.getString("RootNode.2")) > 0) {
                folderNode.setEditable(true);
            } else {
                folderNode.setEditable(false);
            }
        } else if (this._import.booleanValue()) {
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.4"), folderNode.getShortLabel()));
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            if (object.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolderV2(folderNode, object.item(i), bl);
                continue;
            }
            if (object.item(i).getNodeName().equalsIgnoreCase("display")) {
                this.processReportV2(folderNode, object.item(i), bl);
                continue;
            }
            if (!object.item(i).getNodeName().equalsIgnoreCase("description") && object.item(i).getNodeName().equalsIgnoreCase("name")) continue;
        }
    }

    private void processReportV2(DefaultContainer defaultContainer, Node node, boolean bl) throws MalformedURLException {
        Object object;
        DisplayModel displayModel = DisplayModel.getDisplayModel((Node)node, (XLIFFHelper)this.xliff, null);
        URL uRL = new URL(defaultContainer.getURL().toString() + "/" + displayModel.getName());
        displayModel.setPath(uRL.getPath());
        Iterator iterator = defaultContainer.getChildren();
        while (iterator.hasNext()) {
            DefaultContainer defaultContainer2;
            object = iterator.next();
            URL uRL2 = null;
            if (object instanceof ReportNode) {
                defaultContainer2 = (ReportNode)object;
                uRL2 = defaultContainer2.getURL();
                if (!uRL2.getPath().equals(uRL.getPath()) || !this._import.booleanValue()) continue;
                LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.0"), defaultContainer2.getShortLabel()));
                return;
            }
            defaultContainer2 = (FolderNode)object;
            uRL2 = defaultContainer2.getURL();
            if (!uRL2.getPath().equals(uRL.getPath()) || !this._import.booleanValue()) continue;
            LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.1"), defaultContainer2.getShortLabel()));
            return;
        }
        object = new ReportNode(uRL, displayModel);
        ((ReportNode)object).setEditable(bl);
        defaultContainer.add((Element)object);
        defaultContainer.markDirty(false);
    }

    private void processReport(DefaultContainer defaultContainer, Node node, boolean bl) {
        DisplayModel displayModel = DisplayModel.getDisplayModel((Node)node, null, null);
        try {
            ReportNode reportNode;
            URL uRL = new URL(defaultContainer.getURL().toString() + "/" + displayModel.getName());
            Iterator iterator = defaultContainer.getChildren();
            while (iterator.hasNext()) {
                reportNode = (ReportNode)iterator.next();
                URL uRL2 = reportNode.getURL();
                if (!uRL2.getPath().equals(uRL.getPath()) || !this._import.booleanValue()) continue;
                LogManager.getIdeLogWindow().log((Object)MessageFormat.format(Messages.getString("ReportXMLUtil.2"), reportNode.getShortLabel()));
                return;
            }
            reportNode = new ReportNode(uRL, displayModel);
            reportNode.setEditable(bl);
            defaultContainer.add((Element)reportNode);
            defaultContainer.markDirty(false);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
        }
    }

    public void setImport(Boolean bl) {
        this._import = bl;
    }

    public void parseXML(DefaultContainer defaultContainer, InputStreamReader inputStreamReader, boolean bl, String string, XLIFFHelper xLIFFHelper) {
        this.xliff = xLIFFHelper;
        this.parseXML(defaultContainer, inputStreamReader, bl, string);
    }
}

