/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.report.addin.RepNav;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorWindow;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class ReportNavigatorManager
extends DefaultNavigatorManager {
    private static final String REPORT_NAVIGATOR_WINDOW_ID = "ReportNavigatorWindow";
    private static final String RPT_NAV_CMD = "ReportNavigator.SHOW_NAVIGATOR";
    private static final String REPORTLABEL = "Reports";
    private static final String PACKAGEDTITLENAME = "Database Reports";
    private static final int RPT_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"ReportNavigator.SHOW_NAVIGATOR");
    private static final String ACCEL_FILE = "/oracle/dbtools/raptor/report/navigatorV2/accelerators.xml";

    public ReportNavigatorManager() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), ACCEL_FILE);
    }

    private static String getNavigatorLabel() {
        return RaptorExtensionConstants.isStandAlone() ? REPORTLABEL : PACKAGEDTITLENAME;
    }

    protected IdeAction createShowNavigatorAction() {
        String string = RepNav.getString(RaptorExtensionConstants.isStandAlone() ? "TITLE_NAME" : "PACKAGED_TITLE_NAME");
        return IdeAction.get((int)RPT_NAV_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)string), (Icon)ReportAddin.navIcon, null, (boolean)true);
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)RootNode.getInstance(), true, RaptorExtensionConstants.isStandAlone() ? 1 : 0);
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new ReportNavigatorWindow(context, viewId.getId());
    }

    protected String getDefaultName() {
        return ReportNavigatorManager.getNavigatorLabel();
    }

    protected String getViewCategory() {
        return REPORT_NAVIGATOR_WINDOW_ID;
    }

    public void initialize() {
        super.initialize();
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_ADDINS);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        if (navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith((Dockable)navigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        return dockingParam;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_databasereports_html");
    }
}

