/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.addin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.actions.SaveGridAsReport;
import oracle.dbtools.raptor.report.addin.ReportEditor;
import oracle.dbtools.raptor.report.addin.ReportEditorAddin;
import oracle.dbtools.raptor.report.addin.ReportPrintFactory;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorManager;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.report.net.ReportURLFileSystemHelper;
import oracle.dbtools.raptor.report.net.ReportUrlStreamHandlerFactory;
import oracle.dbtools.util.Resource;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.print.PrintManager;
import oracle.javatools.dialogs.MessageDialog;

public class ReportAddin
implements Addin,
Controller {
    public static final String USER_REPORT_FILE = Resource.raptorUser.getAbsolutePath() + File.separator + "UserReports.xml";
    public static final int OPEN_REPORT = Ide.findOrCreateCmdID((String)"openReport");
    public static final Icon rootIcon = RaptorImage.getIcon((String)"reportroot.png");
    public static final Icon folderIcon = RaptorImage.getIcon((String)"folder_with_report.png");
    public static final Icon reportIcon = RaptorImage.getIcon((String)"report1.png");
    public static final Icon reportChartIcon = RaptorImage.getIcon((String)"sqlreportchart.png");
    public static final Icon reportCodeIcon = RaptorImage.getIcon((String)"sqlreportcode.png");
    public static final Icon reportDbmsIcon = RaptorImage.getIcon((String)"sqlreportdbmsoutput.png");
    public static final Icon reportGaugeIcon = RaptorImage.getIcon((String)"sqlreportgauge.png");
    public static final Icon reportScriptIcon = RaptorImage.getIcon((String)"sqlreportscript.png");
    public static final Icon reportTableIcon = RaptorImage.getIcon((String)"sqlreporttable.png");
    public static final String menuIcon = "report2.png";
    public static final Icon navIcon = RaptorImage.getIcon((String)"report2.png");
    public static final Icon editorIcon = RaptorImage.getIcon((String)"report1.png");
    private static ArrayList<String> _registeredReportPackages = new ArrayList();
    private static ArrayList<URL> _registeredReports = new ArrayList();
    private static HashMap<String, String> menuReports = new HashMap();
    private ActionListener _openReport = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            string = (String)menuReports.get(actionEvent.getActionCommand());
            RootNode.getInstance().open(string);
        }
    };

    public static synchronized void registerReport(URL uRL) {
        _registeredReports.add(uRL);
    }

    public static synchronized void registerReport(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                Logger.getLogger(ReportAddin.class.getClass().getName()).log(Level.WARNING, malformedURLException2.getStackTrace()[0].toString(), malformedURLException2);
            }
        }
        if (uRL != null) {
            _registeredReports.add(uRL);
        } else {
            System.err.println(Messages.getString("ReportAddin.9") + string);
        }
    }

    public static synchronized void unregisterReport(URL uRL) {
        _registeredReports.remove(uRL);
    }

    public static synchronized ArrayList<URL> getRegisterReport() {
        return _registeredReports;
    }

    public static synchronized void registerReportPackage(String string) {
        _registeredReportPackages.add(string);
    }

    public static synchronized void unregisterReportPackage(String string) {
        _registeredReportPackages.remove(string);
    }

    public static synchronized ArrayList<String> getRegisterReportPackages() {
        return _registeredReportPackages;
    }

    public ReportAddin() {
        String string = System.getProperty("raptor.shared.reports");
        if (string != null) {
            for (String string2 : string.split("[:;]")) {
                ReportAddin.registerReport(string2);
            }
        }
        for (String string3 : DBConfig.getInstance().getExtensions("REPORT")) {
            ReportAddin.registerReport(string3);
        }
    }

    public void initialize() {
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new ReportUrlStreamHandlerFactory());
        URLFileSystem.registerHelper((String)"sqldev.reports", (URLFileSystemHelper)new ReportURLFileSystemHelper());
        if (Ide.getIdeArgs().getCreateUI()) {
            ReportNavigatorManager reportNavigatorManager = new ReportNavigatorManager();
            reportNavigatorManager.addContextMenuListener(new ReportNavigatorContextMenu(), null);
            reportNavigatorManager.initialize();
            EditorManager.getEditorManager().registerDynamic((EditorAddin)new ReportEditorAddin());
            PrintManager.getPrintManager().registerDocumentPrintFactory(ReportEditor.class, ReportPrintFactory.class);
            this.addMenuItem(Messages.getString("ReportAddin.13"), "a7db0062-0114-1000-821d-c0a8010a29c4");
            ResultSetTable.addGridContextMenu((GridContextMenuItem)SaveGridAsReport.getInstance());
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public static boolean isUserDefinedReport(URL uRL) {
        String string = uRL.toString();
        return string.startsWith(RootNode.getInstance().getURL().toString()) && (string = string.substring(RootNode.getInstance().getURL().toString().length() + 1, string.length())).startsWith(RootNode.USER_DEFINED_REPORTS_NODE_NAME);
    }

    public static void showOracleOnlyReportMessage(Component component) {
        MessageDialog.information((Component)component, (Object)Messages.getString("ReportAddin.15"), (String)Messages.getString("ReportAddin.16"), (String)Messages.getString("ReportAddin.17"));
    }

    public void addMenuItem(String string, String string2) {
        String string3 = StringUtils.stripMnemonic((String)string);
        IdeAction ideAction = IdeAction.get((int)OPEN_REPORT, null, (String)string3, (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ResourceBundle)RaptorImage.getInstance(), null, null, (boolean)true);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        jMenuItem.addActionListener(this._openReport);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
        menuReports.put(string3, string2);
    }
}

