/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.pjava12;

import ice.debug.Debug;
import ice.util.io.IOKit;
import ice.util.security.pjava12.JarCache_pjava12;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;

final class URLClassLoader_pjava12
extends SecureClassLoader {
    private URL codebase;
    private URL[] urls;

    private void $init$() {
        this.codebase = null;
        this.urls = null;
    }

    URLClassLoader_pjava12(URL[] urls, ClassLoader parent) {
        super(parent);
        this.$init$();
        this.urls = urls;
        this.codebase = urls[0];
        int i = 1;
        while (i < urls.length) {
            JarCache_pjava12.getInstance().addJarFile(urls[i]);
            ++i;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                Class<?> clazz = this.findSystemClass(name);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                c = this.do_loadClass(name);
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private Class do_loadClass(String className) {
        String resourceName = className.replace('.', '/') + ".class";
        URL originUrl = this.urls.length > 1 ? this.urls[1] : this.codebase;
        Certificate[] certs = null;
        CodeSource origin = new CodeSource(originUrl, certs);
        return (Class)AccessController.doPrivileged(new 1(this, resourceName, className, origin));
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = super.getPermissions(codesource);
        this.addSourceAllowances(pc, codesource.getLocation());
        return pc;
    }

    private void addSourceAllowances(PermissionCollection pc, URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String urlPath = url.getFile();
            String systemPath = '/' == File.separatorChar ? urlPath : urlPath.replace('/', File.separatorChar);
            boolean directory = urlPath.endsWith("/");
            String allowedPath = directory ? systemPath + '-' : systemPath;
            pc.add(new FilePermission(allowedPath, "read"));
        } else {
            String host = url.getHost();
            if (host == null || host.length() == 0) {
                host = "localhost";
            }
            pc.add(new SocketPermission(host, "connect, accept"));
        }
    }

    private byte[] getResourceAsByteArray(String name) {
        byte[] data;
        block7: {
            data = null;
            if (this.urls.length > 1) {
                String fullName = "jar:" + this.urls[1] + "!/" + name;
                data = JarCache_pjava12.getInstance().getResource(fullName);
            }
            if (data == null && this.codebase != null) {
                try {
                    URL u = new URL(this.codebase, name);
                    InputStream is = this.getInputStream(u);
                    if (is == null) break block7;
                    try {
                        data = IOKit.readAll(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block7;
                    Debug.ex(ex);
                }
            }
        }
        return data;
    }

    public URL getResource(String name) {
        URL u = URLClassLoader_pjava12.getSystemResource(name);
        if (u != null) {
            return u;
        }
        if (this.urls.length > 1) {
            try {
                URL uRL = u = new URL("jar://" + this.urls[1].toString() + "!/" + name);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.codebase != null) {
            try {
                u = new URL(this.codebase, name);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return u;
    }

    public InputStream getResourceAsStream(String name) {
        URL u;
        byte[] data;
        InputStream s = URLClassLoader_pjava12.getSystemResourceAsStream(name);
        if (s != null) {
            return s;
        }
        if (this.urls.length > 1 && (data = this.getResourceAsByteArray(name)) != null) {
            s = new ByteArrayInputStream(data);
        }
        if (s == null && this.codebase != null && (u = this.getResource(name)) != null) {
            s = this.getInputStream(u);
        }
        return s;
    }

    private InputStream getInputStream(URL url) {
        URLConnection uc;
        try {
            uc = url.openConnection();
        }
        catch (IOException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            InputStream inputStream = null;
            return inputStream;
        }
        return (InputStream)AccessController.doPrivileged(new 2(this, uc));
    }

    private InputStream do_getInputStream(URLConnection uc) {
        InputStream is;
        try {
            HttpURLConnection hc;
            int code;
            is = uc.getInputStream();
            if (uc instanceof HttpURLConnection && (code = (hc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
                is = null;
            }
        }
        catch (IOException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            is = null;
        }
        return is;
    }

    static InputStream mav$do_getInputStream(URLClassLoader_pjava12 uRLClassLoader_pjava12, URLConnection uRLConnection) {
        return uRLClassLoader_pjava12.do_getInputStream(uRLConnection);
    }

    static byte[] mav$getResourceAsByteArray(URLClassLoader_pjava12 uRLClassLoader_pjava12, String string) {
        return uRLClassLoader_pjava12.getResourceAsByteArray(string);
    }

    static Class mav$defineClass(URLClassLoader_pjava12 uRLClassLoader_pjava12, String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        return uRLClassLoader_pjava12.defineClass(string, byArray, n, n2, codeSource);
    }

    final class 1
    implements PrivilegedAction {
        private final /* synthetic */ String v$resourceName;
        private final /* synthetic */ String v$className;
        private final /* synthetic */ CodeSource v$origin;
        final /* synthetic */ URLClassLoader_pjava12 this$0;

        public Object run() {
            byte[] data = URLClassLoader_pjava12.mav$getResourceAsByteArray(this.this$0, this.v$resourceName);
            if (data != null) {
                return URLClassLoader_pjava12.mav$defineClass(this.this$0, this.v$className, data, 0, data.length, this.v$origin);
            }
            return null;
        }

        public 1(URLClassLoader_pjava12 uRLClassLoader_pjava12, String string, String string2, CodeSource codeSource) {
            this.v$origin = codeSource;
            this.v$className = string2;
            this.v$resourceName = string;
            this.this$0 = uRLClassLoader_pjava12;
        }
    }

    final class 2
    implements PrivilegedAction {
        private final /* synthetic */ URLConnection v$uc;
        final /* synthetic */ URLClassLoader_pjava12 this$0;

        public Object run() {
            return URLClassLoader_pjava12.mav$do_getInputStream(this.this$0, this.v$uc);
        }

        public 2(URLClassLoader_pjava12 uRLClassLoader_pjava12, URLConnection uRLConnection) {
            this.v$uc = uRLConnection;
            this.this$0 = uRLClassLoader_pjava12;
        }
    }
}

