/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.pjava12;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class JarCache_pjava12 {
    private static JarCache_pjava12 jarCache = new JarCache_pjava12();
    private Hashtable loadedJarFiles;
    private Hashtable resources;

    static JarCache_pjava12 getInstance() {
        return jarCache;
    }

    private void $init$() {
        this.loadedJarFiles = new Hashtable();
        this.resources = new Hashtable();
    }

    synchronized void clear() {
        this.loadedJarFiles.clear();
        this.resources.clear();
    }

    synchronized void addJarFile(URL jarURL) {
        BufferedInputStream jarStream;
        if (this.loadedJarFiles.get(jarURL) != null) {
            return;
        }
        try {
            URLConnection uc = jarURL.openConnection();
            InputStream is = uc.getInputStream();
            jarStream = new BufferedInputStream(is);
        }
        catch (Exception e) {
            return;
        }
        ZipInputStream zis = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                zis = new ZipInputStream(jarStream);
                ZipEntry ent = null;
                while ((ent = zis.getNextEntry()) != null) {
                    int len;
                    String name = ent.getName();
                    String fullName = "jar:" + jarURL.toString() + "!/" + name;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((len = zis.read(buffer)) >= 0) {
                        baos.write(buffer, 0, len);
                    }
                    byte[] buf = baos.toByteArray();
                    this.resources.put(fullName, buf);
                }
                this.loadedJarFiles.put(jarURL, jarURL);
            }
            catch (IOException e) {
            }
            finally {
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    synchronized byte[] getResource(URL url) {
        byte[] data = (byte[])this.resources.get(url.toString());
        return data;
    }

    synchronized byte[] getResource(String fullName) {
        byte[] data = (byte[])this.resources.get(fullName);
        return data;
    }

    JarCache_pjava12() {
        this.$init$();
    }
}

