/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.security.BoxedCode;
import java.net.URL;

public abstract class SecurityKit {
    private static final SecurityKit instance = SecurityKit.netInstance();

    private static SecurityKit netInstance() {
        SecurityKit x = null;
        String className = Defs.sysProperty("ice.util.security.SecurityKit");
        if (className != null && (x = (SecurityKit)Defs.newClassInstance(className)) == null && Debug.trace) {
            Debug.trace("FAILED TO LOAD REQUESTED SecurityKit: " + className);
        }
        if (x == null) {
            String[] list = new String[]{"ice.util.security.jdk12.SecurityKit_jdk12", "ice.util.security.pjava12.SecurityKit_pjava12", "ice.util.security.jdk11.SecurityKit_jdk11"};
            int i = 0;
            while (i != list.length) {
                className = list[i];
                x = (SecurityKit)Defs.newClassInstance(className);
                if (x != null) break;
                ++i;
            }
        }
        if (Debug.trace) {
            Debug.trace(x != null ? className : "FAILED!");
        }
        return x;
    }

    public static void installDefaultSecurityManager() {
        block4: {
            instance.installDefaultSecurityManagerImpl();
            if (Debug.trace) {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (Debug.trace) {
                        Debug.trace(sm == null ? "null" : sm.getClass().getName());
                    }
                }
                catch (SecurityException ex) {
                    if (!Debug.ex) break block4;
                    Debug.ex(ex);
                }
            }
        }
    }

    public static ClassLoader newURLClassLoader(URL[] urls) {
        return instance.newURLClassLoaderImpl(urls);
    }

    public static Object doPrivileged(BoxedCode privilegedCode) {
        return instance.doPrivilegedImpl(privilegedCode);
    }

    public static Object doUntrusted(BoxedCode untrustedCode) {
        return instance.doUntrustedImpl(untrustedCode);
    }

    public static boolean usesJava2Security() {
        return instance.usesJava2SecurityImpl();
    }

    public static boolean is_working_doUntrusted() {
        return instance.is_working_doUntrustedImpl();
    }

    protected abstract void installDefaultSecurityManagerImpl();

    protected abstract ClassLoader newURLClassLoaderImpl(URL[] var1);

    protected abstract Object doPrivilegedImpl(BoxedCode var1);

    protected abstract Object doUntrustedImpl(BoxedCode var1);

    protected boolean usesJava2SecurityImpl() {
        return true;
    }

    protected boolean is_working_doUntrustedImpl() {
        return true;
    }
}

