/*
 * Decompiled with CFR 0.152.
 */
package ice.util.io;

import ice.util.Defs;
import java.io.IOException;
import java.io.InputStream;

public class LazyCachedInputStream
extends InputStream {
    private static final int INITIAL_CACHE_SIZE_DEFAULT = 4096;
    private static final int READ_BUFFER_SIZE_DEFAULT = 4096;
    private static final String READ_BUFFER_SIZE_KEY = "ice.net.readBufferSize";
    private byte[] cachedBytes;
    private boolean closed;
    private InputStream inputStream;
    private int position;
    private byte[] readBuffer;

    private void $init$() {
        this.position = -1;
        this.readBuffer = new byte[Defs.sysPropertyInt(READ_BUFFER_SIZE_KEY, 4096)];
    }

    public LazyCachedInputStream(InputStream inputStream) throws IllegalArgumentException {
        this(inputStream, 4096);
    }

    public LazyCachedInputStream(InputStream inputStream, int initialCacheSize) throws IllegalArgumentException {
        this.$init$();
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        if (initialCacheSize < 0) {
            throw new IllegalArgumentException("initialCacheSize < 0");
        }
        this.inputStream = inputStream;
        this.cachedBytes = new byte[initialCacheSize];
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        int _available = this.position + 1;
        if (this.inputStream != null) {
            _available += this.inputStream.available();
        }
        return _available;
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.inputStream != null) {
                    InputStream _inputStream = this.inputStream;
                    this.inputStream = null;
                    _inputStream.close();
                }
            }
            finally {
                this.cachedBytes = null;
                this.position = -1;
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        return this.read(this.position + 1);
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(this.position + 1, bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.read(this.position + 1, bytes, offset, length);
    }

    public int read(int position) throws IndexOutOfBoundsException, IOException {
        if (this.closed) {
            throw new IOException("read error: stream is closed");
        }
        if (position < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position > this.position) {
            if (this.readUpTo(position) == -1 || position > this.position) {
                return -1;
            }
            return this.toUnsignedByte(this.cachedBytes[position]);
        }
        return this.toUnsignedByte(this.cachedBytes[position]);
    }

    public int read(int position, byte[] bytes) throws IllegalArgumentException, IndexOutOfBoundsException, IOException {
        return this.read(position, bytes, 0, bytes.length);
    }

    public int read(int position, byte[] bytes, int offset, int length) throws IllegalArgumentException, IndexOutOfBoundsException, IOException {
        if (this.closed) {
            throw new IOException("read error: stream is closed");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (position < 0 || offset < 0 || offset > bytes.length || length < 0 || offset + length > bytes.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if (position + length - 1 > this.position && this.readUpTo(position + length - 1) == -1 && position > this.position) {
            return -1;
        }
        int _bytesRead = Math.min(length, this.position - position + 1);
        System.arraycopy(this.cachedBytes, position, bytes, offset, _bytesRead);
        return _bytesRead;
    }

    private void ensureCapacity(int minimumCapacity) {
        int _oldCapacity = this.cachedBytes.length;
        if (minimumCapacity > _oldCapacity) {
            byte[] _oldCachedBytes = this.cachedBytes;
            this.cachedBytes = new byte[Math.max(_oldCapacity * 3 / 2 + 1, minimumCapacity)];
            System.arraycopy(_oldCachedBytes, 0, this.cachedBytes, 0, this.position + 1);
        }
    }

    private int readUpTo(int position) throws IOException {
        if (this.inputStream == null) {
            return -1;
        }
        int _totalBytesRead = 0;
        if (this.position != position) {
            int _bytesRead = this.inputStream.read(this.readBuffer, 0, this.readBuffer.length);
            if (_bytesRead == -1) {
                InputStream _inputStream = this.inputStream;
                this.inputStream = null;
                _inputStream.close();
                return -1;
            }
            if (_bytesRead != 0) {
                this.ensureCapacity(this.position + 1 + _bytesRead);
                System.arraycopy(this.readBuffer, 0, this.cachedBytes, this.position + 1, _bytesRead);
                this.position += _bytesRead;
                _totalBytesRead += _bytesRead;
            }
            while (position > this.position) {
                _bytesRead = this.inputStream.read(this.readBuffer, 0, this.readBuffer.length);
                if (_bytesRead == -1) {
                    InputStream _inputStream = this.inputStream;
                    this.inputStream = null;
                    _inputStream.close();
                    return _totalBytesRead;
                }
                if (_bytesRead == 0) continue;
                this.ensureCapacity(this.position + 1 + _bytesRead);
                System.arraycopy(this.readBuffer, 0, this.cachedBytes, this.position + 1, _bytesRead);
                this.position += _bytesRead;
                _totalBytesRead += _bytesRead;
            }
        }
        return _totalBytesRead;
    }

    private int toUnsignedByte(byte signedByte) {
        return signedByte >= 0 ? signedByte : 256 + signedByte;
    }
}

