/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.AbstractVersion;
import ice.util.Defs;
import java.util.StringTokenizer;

public class JavaVersion
extends AbstractVersion {
    public static final int MAJOR_PART = 0;
    public static final int MINOR_PART = 1;
    public static final int BUILD_PART_ONE = 2;
    public static final int BUILD_PART_TWO = 3;
    public static final int VERSION_FULL_LENGTH = 4;
    public static final int MAJOR_MINOR_LENGTH = 2;
    public static boolean IS_MAC_OS = Defs.property("mrj.version") != null;
    private static JavaVersion vmVersion = new JavaVersion(JavaVersion.tokenizeVersion(Defs.sysProperty("java.version", "1.1.8")));

    private JavaVersion(int[] versionParts) {
        super(versionParts);
    }

    public static JavaVersion getVMVersion() {
        return vmVersion;
    }

    public static JavaVersion getVersion(String versionString) {
        return new JavaVersion(JavaVersion.tokenizeVersion(versionString));
    }

    public static JavaVersion getVersionFromHex(String versionString) {
        return new JavaVersion(JavaVersion.tokenizeHexVersion(versionString));
    }

    public static boolean isV12orGreater() {
        return JavaVersion.isV1XorGreater(2);
    }

    public static boolean isV13orGreater() {
        return JavaVersion.isV1XorGreater(3);
    }

    public static boolean isV14orGreater() {
        return JavaVersion.isV1XorGreater(4);
    }

    public static boolean isV15orGreater() {
        return JavaVersion.isV1XorGreater(5);
    }

    private static boolean isV1XorGreater(int minorVersion) {
        if (JavaVersion.vmVersion._versionParts[0] > 1) {
            return true;
        }
        return JavaVersion.vmVersion._versionParts[0] >= 1 && JavaVersion.vmVersion._versionParts[1] >= minorVersion;
    }

    private static int[] tokenizeVersion(String aVersionString) {
        int[] returnVal = new int[4];
        String token = null;
        StringTokenizer st = new StringTokenizer(aVersionString, ".");
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            returnVal[0] = Integer.parseInt(JavaVersion.getNumeric(token));
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            returnVal[1] = Integer.parseInt(JavaVersion.getNumeric(token));
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            int spos = token.indexOf("_");
            if (spos > -1) {
                returnVal[2] = Integer.parseInt(JavaVersion.getNumeric(token.substring(0, spos)));
                returnVal[3] = Integer.parseInt(JavaVersion.getNumeric(token.substring(spos + 1)));
            } else {
                returnVal[2] = Integer.parseInt(JavaVersion.getNumeric(token));
            }
        }
        return returnVal;
    }

    private static String getNumeric(String aToken) {
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        while (idx < aToken.length()) {
            char c = aToken.charAt(idx);
            if (c >= '0' && c <= '9') {
                sb.append(c);
            }
            ++idx;
        }
        return sb.toString();
    }

    private static int[] tokenizeHexVersion(String aVersionString) {
        int[] returnVal = new int[4];
        String token = null;
        StringTokenizer st = new StringTokenizer(aVersionString, "-");
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            returnVal[0] = Integer.parseInt(token.substring(0, 3), 16);
            returnVal[1] = Integer.parseInt(token.substring(3), 16);
        }
        if (!st.hasMoreTokens()) {
            throw new NumberFormatException("Illegal Version format");
        }
        token = st.nextToken();
        returnVal[2] = Integer.parseInt(token, 16);
        if (!st.hasMoreTokens()) {
            throw new NumberFormatException("Illegal Version format");
        }
        token = st.nextToken();
        returnVal[3] = Integer.parseInt(token, 16);
        return returnVal;
    }

    public String toString() {
        return this._versionParts[0] + "." + this._versionParts[1] + "." + this._versionParts[2] + "_" + this._versionParts[3];
    }
}

