/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.security.SecurityKit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class JVMCapabilities {
    private static final int CAPABILITY_UNKNOWN = 0;
    private static final int CAPABILITY_PRESENT = 1;
    private static final int CAPABILITY_ABSENT = 2;
    private static int scrollbarsFlag = 0;
    private static int mousewheelFlag = 0;
    private static int jmfFlag = 0;
    private static int swingFlag = 0;
    private static int jarFlag = 0;
    private static int md5Flag = 0;
    static String jvmVersion = null;
    static int majorVersion = -1;
    static int minorVersion = -1;
    static int microVersion = -1;

    public static String getVersionString() {
        if (jvmVersion == null) {
            JVMCapabilities.readVersionJVM();
        }
        return jvmVersion;
    }

    public static int getMajorVersion() {
        if (majorVersion == -1) {
            JVMCapabilities.readVersionJVM();
        }
        return majorVersion;
    }

    public static int getMinorVersion() {
        if (minorVersion == -1) {
            JVMCapabilities.readVersionJVM();
        }
        return minorVersion;
    }

    public static int getMicroVersion() {
        if (microVersion == -1) {
            JVMCapabilities.readVersionJVM();
        }
        return microVersion;
    }

    public static boolean isScrollbarsPresent() {
        int flag = scrollbarsFlag;
        if (flag == 0) {
            scrollbarsFlag = flag = JVMCapabilities.testClassPresence("java.awt.Scrollbar");
        }
        return flag == 1;
    }

    public static boolean isMouseWheelPresent() {
        int flag = mousewheelFlag;
        if (flag == 0) {
            mousewheelFlag = flag = JVMCapabilities.testClassPresence("java.awt.event.MouseWheelEvent");
        }
        return flag == 1;
    }

    public static boolean isJMFPresent() {
        int flag = jmfFlag;
        if (flag == 0) {
            jmfFlag = flag = JVMCapabilities.testClassPresence("javax.media.Player");
        }
        return flag == 1;
    }

    public static boolean isSwingPresent() {
        int flag = swingFlag;
        if (flag == 0) {
            swingFlag = flag = JVMCapabilities.testClassPresence("javax.swing.JComponent");
        }
        return flag == 1;
    }

    public static boolean isJarHandlerPresent() {
        int flag = jarFlag;
        if (flag == 0) {
            flag = 2;
            try {
                new URL("jar://test");
                flag = 1;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            jarFlag = flag;
        }
        return flag == 1;
    }

    public static boolean isMD5Present() {
        int flag = md5Flag;
        if (flag == 0) {
            flag = 2;
            Class testClass = Defs.getClass("java.security.MessageDigest");
            if (testClass != null) {
                try {
                    Class[] signature = new Class[]{"".getClass()};
                    Method m = Defs.getMethod(testClass, "getInstance", signature);
                    if (m != null) {
                        Object[] parameters = new Object[]{"MD5"};
                        m.invoke(null, parameters);
                        flag = 1;
                    }
                }
                catch (IllegalAccessException ex) {
                }
                catch (InvocationTargetException ex) {
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
            }
            md5Flag = flag;
        }
        return flag == 1;
    }

    private static int testClassPresence(String className) {
        return Defs.getClass(className) != null ? 1 : 2;
    }

    public static void installDefaultSecurityManager() {
        SecurityKit.installDefaultSecurityManager();
    }

    private static void readVersionJVM() {
        long test;
        String version;
        jvmVersion = version = Defs.sysProperty("java.version");
        int major = 1;
        int minor = 1;
        int micro = 0;
        int L = version.length();
        int majorEnd = version.indexOf(46);
        if (majorEnd < 0) {
            majorEnd = L;
        }
        if ((test = CharKit.parseInt(version, 0, majorEnd)) >= 0L) {
            major = (int)test;
            if (majorEnd != L) {
                int minorEnd = version.indexOf(46, majorEnd + 1);
                if (minorEnd < 0) {
                    minorEnd = L;
                }
                if ((test = CharKit.parseInt(version, majorEnd + 1, minorEnd)) >= 0L) {
                    minor = (int)test;
                    if (minorEnd != L && (test = CharKit.parseInt(version, minorEnd + 1, L)) >= 0L) {
                        micro = (int)test;
                    }
                }
            }
        }
        majorVersion = major;
        minorVersion = minor;
        microVersion = micro;
    }
}

