/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.debug.Debug;
import java.io.IOException;

public class ICEException
extends IOException {
    public static final int MOD_UNKNOWN = 0;
    public static final int MOD_BROWSER = 1;
    public static final int MOD_HTTP = 2;
    public static final int MOD_ICESECURE = 3;
    public static final int MOD_EMAIL = 4;
    public static final int MOD_PIM = 5;
    public static final int PHASE_UNKNOWN = 0;
    public static final int PHASE_INIT = 1;
    public static final int PHASE_CONNECT = 2;
    public static final int PHASE_LOAD = 3;
    public static final int PHASE_RENDER = 4;
    public static final int PHASE_AUTENTICATION = 5;
    public static final int PHASE_COMPLETED = 6;
    public static final int PROBLEM_UNKNOWN = 0;
    public static final int PROBLEM_UNHANDLED_EXCEPTION = 1;
    public static final int PROBLEM_MEMORY = 2;
    public static final int PROBLEM_UNKNOWNPROTOCOL = 3;
    public static final int PROBLEM_UNKNOWN_HOST = 4;
    public static final int PROBLEM_TIMEOUT = 5;
    public static final int PROBLEM_CONNECTION_CLOSED = 6;
    public static final int PROBLEM_NO_ROUTE = 7;
    public static final int PROBLEM_CLASSLOAD_FAILED = 8;
    public static final int PROBLEM_AUTH_FAILED = 9;
    public static final int PROBLEM_CERT_INVALID = 10;
    public static final int PROBLEM_CERT_WRONG_HOST = 11;
    public static final int PROBLEM_CERT_NOT_YET_VALID = 12;
    public static final int PROBLEM_CERT_EXIPRED = 13;
    public static final int PROBLEM_HTTP_DOCUMENT_NOT_FOUND = 14;
    public static final int PROBLEM_HTTP_FORBIDDEN = 15;
    public static final int PROBLEM_COULD_NOT_CONNECT = 16;
    public static final int PROBLEM_XSLT_TRANSFORM_FAILED = 17;
    public static final int PROBLEM_FILE_CACHE_PATH_INVALID = 18;
    public int module;
    public int phase;
    public int problem;

    ICEException() {
        this.$init$();
    }

    public ICEException(int module, int phase, int problem) {
        this.$init$();
        this.module = module;
        this.phase = phase;
        this.problem = problem;
    }

    public static String moduleName(int moduleId) {
        switch (moduleId) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "browser";
            }
            case 2: {
                return "http";
            }
            case 3: {
                return "ICESecure";
            }
            case 4: {
                return "email";
            }
            case 5: {
                return "PIM";
            }
        }
        Debug.bug();
        return null;
    }

    public static String phaseName(int phaseId) {
        switch (phaseId) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Initialization";
            }
            case 2: {
                return "Connection";
            }
            case 3: {
                return "Loading";
            }
            case 4: {
                return "Rendering";
            }
            case 5: {
                return "Autentification";
            }
            case 6: {
                return "Completed";
            }
        }
        Debug.bug();
        return null;
    }

    public static String problemName(int problemId) {
        switch (problemId) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Unhandled exception";
            }
            case 2: {
                return "Insufficient memory";
            }
            case 3: {
                return "Unknown protocol";
            }
            case 4: {
                return "Unknown host";
            }
            case 5: {
                return "Timeout";
            }
            case 6: {
                return "Connection cloased";
            }
            case 7: {
                return "No route to host";
            }
            case 8: {
                return "Classloading failed";
            }
            case 9: {
                return "Authentication failed";
            }
            case 10: {
                return "Certificate is invalid";
            }
            case 11: {
                return "Certificate is not issued for this host";
            }
            case 12: {
                return "Certificate is not yet valid";
            }
            case 13: {
                return "Certificate is expired";
            }
            case 14: {
                return "Document was not found on the server";
            }
            case 15: {
                return "Forbidden: Server refused to serve the document";
            }
            case 16: {
                return "Could not connect to server";
            }
            case 17: {
                return "XSLT transformation failed";
            }
            case 18: {
                return "Path given to File Cache was invalid";
            }
        }
        Debug.bug();
        return null;
    }

    private void $init$() {
        this.module = 0;
        this.phase = 0;
        this.problem = 0;
    }

    public String toString() {
        return "Failure in " + ICEException.moduleName(this.module) + " during " + ICEException.phaseName(this.phase) + " phase : " + ICEException.problemName(this.problem);
    }
}

