/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.DynamicObject;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.util.alg.ThreadVar;

public abstract class Scripter {
    private static final ThreadVar FRAME_KEY = ThreadVar.create();

    public abstract String scripterName();

    public abstract void init(StormBase var1);

    public abstract void dispose();

    public abstract Object eval(Viewport var1, String var2, String var3, int var4);

    public Object evalCodeLocation(Viewport view, String codeLocation) {
        int code_start = codeLocation.indexOf(58) + 1;
        String code = codeLocation.substring(code_start);
        code = Scripter.decodeWhitespace(code);
        return this.eval(view, code, "script-as-url", 0);
    }

    public abstract boolean evalEventHandler(Viewport var1, DynamicObject var2, Object var3, DynamicObject var4);

    public abstract boolean evalCallback(Viewport var1, Object var2, Object[] var3);

    public abstract Object _unwrap(Object var1);

    public abstract void suspend();

    public abstract void resume();

    public final Object enterExecutionFrame(Viewport contextViewport) {
        FrameData data = new FrameData(null);
        data.view = contextViewport;
        FrameData old = (FrameData)FRAME_KEY.push(data);
        if (old != null) {
            data.nestingLevel = old.nestingLevel + 1;
        }
        return old;
    }

    public final void exitExecutionFrame(Object parentExecution) {
        FRAME_KEY.restore(parentExecution);
    }

    protected Viewport contextViewport() {
        return Scripter.contextViewportImpl();
    }

    static Viewport contextViewportImpl() {
        FrameData data = (FrameData)FRAME_KEY.get();
        return data == null ? null : data.view;
    }

    public static int executionNestingLevel() {
        FrameData data = (FrameData)FRAME_KEY.get();
        return data == null ? 0 : data.nestingLevel;
    }

    private static String decodeWhitespace(String loc) {
        int length = loc.length();
        StringBuffer b = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            if (i < length - 2 && loc.charAt(i) == '%' && loc.charAt(i + 1) == '2' && loc.charAt(i + 2) == '0') {
                b.append(' ');
                i += 3;
                continue;
            }
            b.append(loc.charAt(i));
            ++i;
        }
        return b.length() > 0 ? b.toString() : loc;
    }

    private static class FrameData {
        Viewport view;
        int nestingLevel;

        private FrameData() {
        }

        FrameData(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

