/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.mozilla.javascript.Context;
import ice.scripters.js.TheScripter;
import ice.storm.CallbackAdapter;
import ice.storm.ScripterCallback;
import ice.storm.Viewport;
import ice.util.Emulation;
import ice.util.security.SecurityKit;

final class CustomContext
extends Context {
    private TheScripter scripter;
    private boolean ieEmulation;
    private boolean onAwtThread;
    private long maxScriptExecTime;
    long startTime;

    CustomContext(TheScripter scripter) {
        ScripterCallback c;
        this.scripter = scripter;
        String emulation = Emulation.getEmulationMode();
        this.ieEmulation = Emulation.getEmulationMode().startsWith("ie");
        this.setOptimizationLevel(-1);
        this.setWrapFactory(scripter.wrapFactory);
        this.setErrorReporter(scripter);
        this.setInstructionObserverThreshold(10000);
        this.onAwtThread = scripter.storm.isEventThread();
        if (this.onAwtThread && (c = scripter.storm.getScripterCallback()) != null) {
            this.maxScriptExecTime = c.getMaxScriptRunningTime();
            if (this.maxScriptExecTime != 0L) {
                this.startTime = System.currentTimeMillis();
                this.postAwtDispatchCheck();
            }
        }
    }

    private void postAwtDispatchCheck() {
        this.scripter.storm.runOnEventThreadLater(new 1(), 0L);
    }

    void prepareForExec() {
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                if (!this.ieEmulation) break;
                return true;
            }
            case 2: {
                if (!this.ieEmulation) break;
                return true;
            }
            case 3: {
                if (!this.ieEmulation) break;
                return true;
            }
        }
        return super.hasFeature(featureIndex);
    }

    protected void observeInstructionCount(int instructionCount) {
        if (Thread.interrupted() || this.scripter.suspended) {
            throw new TheScripter.Interruptor();
        }
        if (this.onAwtThread && this.maxScriptExecTime != 0L) {
            long time = System.currentTimeMillis();
            if (this.startTime == (long)-1) {
                this.startTime = time;
                this.postAwtDispatchCheck();
            } else if (time - this.startTime > this.maxScriptExecTime) {
                Viewport view;
                ScripterCallback c = this.scripter.storm.getScripterCallback();
                Object shouldStop = SecurityKit.doPrivileged(CallbackAdapter.box_interruptLongRunningScript(c, view = this.scripter.contextViewport(), time - this.startTime));
                if (shouldStop == Boolean.TRUE) {
                    throw new TheScripter.Interruptor();
                }
                this.startTime = System.currentTimeMillis();
            }
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            CustomContext.this.startTime = -1;
        }
    }
}

