/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.pilots.html4.ThePilot;
import ice.ri.swing.BrowserWindow;
import ice.ri.swing.Resources;
import ice.storm.ContentLoader;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

final class StatusBar
extends JPanel
implements PropertyChangeListener {
    StatusLabel label;
    JLabel sslIndicator;
    Resources res;
    private String strConnecting;
    private String strStopped;
    private String strError;
    private String strTitle;
    private String strImages;
    private String strDone;
    private String strSeconds;
    private String topLevelViewportId;
    private boolean isTopLevelViewportEvent;
    private String locationURL;
    private int lastImages;
    private boolean imagesDecreasing;
    private boolean contentLoaded;
    private boolean imagesLoaded;
    private boolean contentRendered;
    private boolean allDone;
    private boolean showRenderTimes;
    private long startTime;

    private void $init$() {
        this.isTopLevelViewportEvent = false;
        this.locationURL = "";
        this.lastImages = 0;
        this.imagesDecreasing = false;
        this.contentLoaded = false;
        this.imagesLoaded = false;
        this.contentRendered = false;
        this.allDone = false;
        this.showRenderTimes = false;
    }

    public StatusBar(BrowserWindow window) {
        super(new BorderLayout());
        this.$init$();
        this.res = window.res;
        this.cacheText();
        this.topLevelViewportId = window.mainview.getId();
        this.showRenderTimes = window.displayRenderTimes();
        Border border = BorderFactory.createEtchedBorder();
        this.sslIndicator = new JLabel();
        this.sslIndicator.setIcon(this.res.imageIcon(this.getToolkit(), "lock.gif"));
        this.sslIndicator.setToolTipText(this.res.str("statusbar.sslindicator.tooltip"));
        this.sslIndicator.setBorder(border);
        this.sslIndicator.setVisible(false);
        this.label = new StatusLabel();
        this.label.setBorder(border);
        this.label.setHorizontalAlignment(2);
        this.add((Component)this.sslIndicator, "West");
        this.add((Component)this.label, "Center");
        window.mainview.addPropertyChangeListener(this);
    }

    void onMouseEvent(MouseEvent event, HTMLAnchorElement anchor) {
        String type = event.getType();
        if ("mouseover".equals(type) || "mouseout".equals(type)) {
            if (anchor == null) {
                this.setStatusText(" ");
            } else {
                this.setStatusText(" " + anchor.getHref());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        Viewport viewport = (Viewport)ev.getSource();
        String viewportId = viewport.getId();
        boolean isHTML4Pilot = viewport.getPilot() instanceof ThePilot;
        this.isTopLevelViewportEvent = viewportId.equals(this.topLevelViewportId);
        String name = ev.getPropertyName();
        String newValue = ev.getNewValue() instanceof String ? (String)ev.getNewValue() : "";
        if (name.equals("contentLoading")) {
            if (newValue.equals("request")) {
                if (this.isTopLevelViewportEvent) {
                    this.setStatusText(this.strConnecting + "...");
                    this.allDone = false;
                    this.resetStatus();
                }
            } else if (newValue.equals("end")) {
                if (this.isTopLevelViewportEvent) {
                    this.contentLoaded = true;
                    this.checkStatus(isHTML4Pilot);
                }
            } else if (newValue.equals("stop")) {
                if (this.isTopLevelViewportEvent) {
                    this.setStatusText(this.strStopped);
                    this.allDone = true;
                }
            } else if (newValue.equals("error")) {
                ContentLoader cl = (ContentLoader)ev.getOldValue();
                if (cl != null) {
                    this.setStatusText(this.strError + ": " + cl.getException().toString());
                } else {
                    this.setStatusText(this.strError);
                }
                if (this.isTopLevelViewportEvent) {
                    this.allDone = true;
                }
            }
        } else if (!name.equals("contentLoadingProgress")) {
            if (name.equals("title")) {
                if (newValue.length() > 0) {
                    this.setStatusText(this.strTitle + " " + this.locationURL + "...");
                }
            } else if (name.equals("outstandingImages")) {
                if (this.isTopLevelViewportEvent && newValue != null) {
                    int images = Integer.valueOf(newValue);
                    if (images < 0) {
                        images = 0;
                    }
                    if (images < this.lastImages) {
                        this.imagesDecreasing = true;
                    }
                    if (this.imagesDecreasing && !this.allDone) {
                        this.setStatusText("(" + images + " " + this.strImages + ") " + this.strTitle + " " + this.locationURL + "...");
                    }
                    this.lastImages = images;
                    if (images == 0) {
                        this.imagesLoaded = true;
                        this.checkStatus(isHTML4Pilot);
                    }
                }
            } else if (name.equals("contentRendering")) {
                if (newValue.equals("finished") && this.isTopLevelViewportEvent) {
                    this.contentRendered = true;
                    this.checkStatus(isHTML4Pilot);
                }
            } else if (name.equals("location")) {
                this.locationURL = newValue;
                if (this.locationURL.startsWith("https:")) {
                    this.setSSLIndicatorVisible(true);
                } else {
                    this.setSSLIndicatorVisible(false);
                }
            } else if (name.equals("statusLine")) {
                this.setStatusText(newValue);
            }
        }
    }

    private void setSSLIndicatorVisible(boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.sslIndicator.setVisible(visible);
        } else {
            1 doWorkRunnable = new 1(this, visible);
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    private void resetStatus() {
        this.contentLoaded = false;
        this.contentRendered = false;
        this.imagesLoaded = false;
        this.imagesDecreasing = false;
        this.lastImages = 0;
        if (this.showRenderTimes) {
            this.startTime = System.currentTimeMillis();
        }
    }

    private void checkStatus(boolean isHTML4Pilot) {
        if (this.allDone) {
            return;
        }
        if (isHTML4Pilot && this.contentLoaded && this.contentRendered && this.imagesLoaded) {
            this.allDone = true;
        } else if (!isHTML4Pilot && this.contentLoaded) {
            this.allDone = true;
        }
        if (this.allDone) {
            String statusLineTxt = this.strDone;
            if (this.showRenderTimes) {
                long endTime = System.currentTimeMillis();
                float elapsedTime = (endTime - this.startTime) / (long)100;
                statusLineTxt = statusLineTxt + " (" + elapsedTime / 10.0f + " " + this.strSeconds + ")";
            }
            this.setStatusText(statusLineTxt);
        }
    }

    private void cacheText() {
        this.strConnecting = this.res.str("statusbar.progress.connecting");
        this.strStopped = this.res.str("statusbar.progress.stopped");
        this.strError = this.res.str("statusbar.progress.error");
        this.strTitle = this.res.str("statusbar.progress.title");
        this.strImages = this.res.str("statusbar.progress.images");
        this.strDone = this.res.str("statusbar.progress.done");
        this.strSeconds = this.res.str("statusbar.progress.seconds");
    }

    void setStatusText(String text) {
        String msg = text;
        if (SwingUtilities.isEventDispatchThread()) {
            this.label.setText(" " + msg);
            this.label.setCaretPosition(0);
        } else {
            2 doWorkRunnable = new 2(this, msg);
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$visible;
        final /* synthetic */ StatusBar this$0;

        public void run() {
            this.this$0.sslIndicator.setVisible(this.v$visible);
        }

        public 1(StatusBar statusBar, boolean bl) {
            this.v$visible = bl;
            this.this$0 = statusBar;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ StatusBar this$0;

        public void run() {
            this.this$0.label.setText(" " + this.v$msg);
            this.this$0.label.setCaretPosition(0);
        }

        public 2(StatusBar statusBar, String string) {
            this.v$msg = string;
            this.this$0 = statusBar;
        }
    }

    class StatusLabel
    extends JTextField {
        public StatusLabel() {
            this.setEditable(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

