/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.debug.Debug;
import ice.pilots.html4.DOM;
import ice.pilots.html4.TransformerFactory;
import ice.ri.swing.AboutDialog;
import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.SplashWindow;
import ice.ri.swing.WindowManager;
import ice.storm.StormBase;
import ice.util.Defs;
import ice.util.security.SecurityKit;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public final class Main {
    private static PropertiesManager pm;
    private static String startPage;
    public static WindowManager wm;

    static void run(Resources res, String homeString, String language, String region) {
        Main.setDynamicLayoutReflectively();
        Properties sysProps = System.getProperties();
        pm = new PropertiesManager(sysProps, res, homeString, language, region);
        String[] proxyKeys = new String[]{"http.proxyHost", "http.proxyPort", "ftpProxySet", "ftpProxyHost", "ftpProxyPort", "gopherProxySet", "gopherProxyHost", "gopherProxyPort", "http.nonProxyHosts"};
        int i = 0;
        while (i < proxyKeys.length) {
            String proxyString = pm.getString(proxyKeys[i], null);
            if (proxyString != null) {
                sysProps.put(proxyKeys[i], proxyString);
                Defs.setSystemProperty(proxyKeys[i], proxyString);
            }
            ++i;
        }
        if (Defs.sysProperty("ice.browser.emulation", null) == null) {
            String emulMode = pm.getString("application.emulation");
            sysProps.setProperty("ice.browser.emulation", emulMode);
            Defs.setSystemProperty("ice.browser.emulation", emulMode);
        }
        if (Defs.sysPropertyBoolean("ice.pilots.html4.viewXmlAsTree", true)) {
            Defs.setSystemProperty("ice.pilots.html4.viewXmlAsTree", "true");
        }
        System.setProperties(sysProps);
        if (pm.getBoolean("security.on", false)) {
            SecurityKit.installDefaultSecurityManager();
        }
        wm = new WindowManager(pm);
        Main.setupLookAndFeel(res);
        if (Defs.booleanProperty("ice.pilots.html4.swing.heavy", false)) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }
        Main.setup_dom2(Main.wm.storm);
        Main.setup_xslt(Main.wm.storm);
        String firstPage = pm.getString("home.location");
        if (startPage != null) {
            firstPage = startPage;
        }
        wm.newWindow(firstPage);
        if (pm.getBoolean("application.alwaysShowImageSplashWindow", false) || "EXPIRY_DATE_TEXT".equals("EXPIRY_DATE_TEXT")) {
            1 doSwingWork = new 1();
            SwingUtilities.invokeLater(doSwingWork);
        } else {
            2 doSwingWork = new 2();
            SwingUtilities.invokeLater(doSwingWork);
        }
    }

    private static void setupLookAndFeel(Resources res) {
        String className = pm.getLookAndFeel("application.lookandfeel", null);
        if (className != null) {
            try {
                UIManager.setLookAndFeel(className);
                return;
            }
            catch (Exception e) {
                Debug.ex(e);
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            Debug.ex(e);
        }
    }

    private static void setup_dom2(StormBase storm) {
        block6: {
            try {
                Class<?> c = Class.forName("ice.dom.DOMImplementationImpl");
                DOM d = (DOM)c.newInstance();
                DOM.setInstance(storm, d);
            }
            catch (ClassNotFoundException cnfe) {
                if (Debug.trace) {
                    Debug.trace("dom2 " + cnfe);
                }
            }
            catch (InstantiationException ie) {
                if (Debug.trace) {
                    Debug.trace("dom2 " + ie);
                }
            }
            catch (IllegalAccessException iae) {
                if (!Debug.trace) break block6;
                Debug.trace("dom2 " + iae);
            }
        }
    }

    private static void setup_xslt(StormBase storm) {
        block6: {
            Class cl = Defs.getClass("ice.xslt.XalanTransformerFactory");
            if (cl != null) {
                try {
                    TransformerFactory f = (TransformerFactory)cl.newInstance();
                    DOM.setTransformFactory(storm, f);
                    if (Debug.trace) {
                        Debug.trace("XSLT is ready");
                    }
                }
                catch (IllegalAccessException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                }
                catch (InstantiationException ex) {
                    if (!Debug.ex) break block6;
                    Debug.ex(ex);
                }
            }
        }
    }

    public static void main(String[] argv) {
        boolean broken_usage = false;
        String language = null;
        String region = null;
        String homeString = null;
        int i = 0;
        while (i < argv.length) {
            if (i == argv.length - 1) {
                broken_usage = true;
                break;
            }
            String arg = argv[i];
            if (arg.equals("-startpage")) {
                startPage = argv[++i].trim();
            } else if (arg.equals("-language")) {
                language = argv[++i].trim();
            } else if (arg.equals("-region")) {
                region = argv[++i].trim();
            } else if (arg.equals("-home")) {
                homeString = argv[++i].trim();
            } else {
                broken_usage = true;
                break;
            }
            ++i;
        }
        Resources res = new Resources();
        if (language != null) {
            Locale l = new Locale(language, region != null ? region : "");
            Locale.setDefault(l);
            res.setLocale(l);
        }
        if (broken_usage) {
            System.out.println(res.str("application.usage"));
            System.exit(1);
        }
        Main.run(res, homeString, language, region);
    }

    public static WindowManager getWindowManager() {
        return wm;
    }

    private static void setDynamicLayoutReflectively() {
        Toolkit defToolkit = Toolkit.getDefaultToolkit();
        Class<?> toolkit = defToolkit.getClass();
        try {
            Class[] methodArgs = new Class[]{Boolean.TYPE};
            Method m = toolkit.getMethod("setDynamicLayout", methodArgs);
            Object[] args = new Object[]{Boolean.TRUE};
            m.invoke((Object)defToolkit, args);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException ia) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
    }

    static final class 1
    implements Runnable {
        public void run() {
            new SplashWindow(wm).setVisible(true);
        }
    }

    static final class 2
    implements Runnable {
        public void run() {
            new AboutDialog(wm, "startmessage.body", true, 0, 4).setVisible(true);
        }
    }
}

