/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

final class AboutDialog
extends JDialog
implements ActionListener,
WindowListener {
    private boolean timebombActive;
    private WindowManager windowManager;
    private JButton ok;
    private JButton cancel;
    private Timer timer;
    private int whichTimer;
    private static final int WAIT_TIME = 3000;
    private static final String IMAGE = "icelogo.png";
    public static final int NO_BUTTONS = 0;
    public static final int CANCEL = 1;
    public static final int OK = 2;
    public static final int OK_CANCEL = 3;
    public static final int NO_TIMER = 0;
    public static final int DISAPPEAR = 4;

    public AboutDialog(WindowManager windowManager, String messageKey, boolean isModal, int buttons, int whichTimer) {
        super((Frame)windowManager.getProperties().res.getBaseFrame(), isModal);
        int c1;
        this.windowManager = windowManager;
        this.whichTimer = whichTimer;
        if (!"EXPIRY_DATE_TEXT".equals("EXPIRY_DATE_TEXT")) {
            this.timebombActive = true;
            buttons = 2;
            whichTimer = 0;
        }
        PropertiesManager properties = windowManager.getProperties();
        Resources res = properties.res;
        this.setTitle(res.str("startmessage.title"));
        this.setResizable(false);
        JPanel panelImage = new JPanel();
        ImageIcon icon = res.imageIcon(this.getToolkit(), IMAGE);
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder());
        panelImage.add(iconLabel);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.add(Box.createVerticalStrut(10));
        panel1.add(panelImage);
        panel1.add(Box.createVerticalStrut(30));
        JLabel label = new JLabel(res.str("application.version", properties.versionName));
        label.setAlignmentX(0.5f);
        panel1.add(label);
        if (this.timebombActive) {
            StringBuffer timebombMsg = new StringBuffer("This trial expires: ");
            timebombMsg.append("EXPIRY_DATE_TEXT");
            JLabel expiresLabel = new JLabel(timebombMsg.toString());
            expiresLabel.setAlignmentX(0.5f);
            panel1.add(Box.createVerticalStrut(10));
            panel1.add(expiresLabel);
            try {
                Date expireTime = new SimpleDateFormat("yyyyMMdd").parse("988668001910L");
                Date currentTime = new Date();
                long daysLeft = (expireTime.getTime() - currentTime.getTime()) / 86400000L;
                long restHours = (expireTime.getTime() - currentTime.getTime()) % 86400000L / 3600000L;
                if (restHours > (long)12) {
                    ++daysLeft;
                }
                timebombMsg = new StringBuffer("(There are ");
                timebombMsg.append(daysLeft);
                timebombMsg.append(" days remaining)");
                JLabel tbLabel = new JLabel(timebombMsg.toString());
                tbLabel.setAlignmentX(0.5f);
                panel1.add(Box.createVerticalStrut(10));
                panel1.add(tbLabel);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        String text = res.str(messageKey);
        int c2 = 0;
        while ((c1 = text.indexOf("\n", c2)) > -1) {
            panel1.add(Box.createVerticalStrut(10));
            label = new JLabel(text.substring(c2, c1));
            label.setAlignmentX(0.5f);
            panel1.add(label);
            c2 = c1 + 1;
        }
        panel1.add(Box.createVerticalStrut(10));
        label = new JLabel(text.substring(c2, text.length()));
        label.setAlignmentX(0.5f);
        panel1.add(label);
        JPanel pane = new JPanel();
        pane.setBorder(new EmptyBorder(5, 15, 5, 15));
        pane.setLayout(new BorderLayout());
        pane.add(panel1);
        if (buttons > 0) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            if ((buttons & 2) > 0) {
                this.ok = new JButton(res.strButtonOk());
                this.ok.addActionListener(this);
                if (whichTimer > 0) {
                    this.ok.setEnabled(false);
                }
                panel2.add(this.ok);
            }
            if ((buttons & 1) > 0) {
                this.cancel = new JButton(res.strButtonCancel());
                this.cancel.addActionListener(this);
                panel2.add(this.cancel);
            }
            pane.add((Component)panel2, "South");
        }
        this.setContentPane(pane);
        this.pack();
        this.setLocationRelativeTo(res.getBaseFrame());
        if (whichTimer > 0) {
            this.timer = new Timer(3000, this);
            this.timer.start();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.timer) {
            this.timer.stop();
            if (this.whichTimer == 2) {
                this.ok.setEnabled(true);
            } else if (this.whichTimer == 4) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (ev.getSource() == this.cancel) {
            this.setVisible(false);
            this.dispose();
            this.windowManager.quit();
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void windowClosing(WindowEvent ev) {
        if (this.ok.isEnabled()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }
}

