/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print.jdk11;

import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.PrintUtilities;
import ice.ri.common.print.awt.PageSetupDialog;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Vector;

public class PrintHelper11
implements PrintHelper {
    private Viewport mainViewport;
    private boolean isFrameset;
    private int zoom;
    private StormPageFormat stormPageFormat;

    public PrintHelper11(Viewport viewport, StormPageFormat stormpageformat) {
        this.stormPageFormat = stormpageformat;
        this.mainViewport = viewport;
        this.zoom = viewport.getZoom();
        this.isFrameset = PrintUtilities.isFrameset(this.mainViewport);
    }

    public void print(Frame parent) {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(parent, "ICEBrowser", null);
        if (printJob != null) {
            Dimension printSize = printJob.getPageDimension();
            this.stormPageFormat.setOrientation(printSize);
            this.stormPageFormat.setPageSize(new PointUnit(printSize.getSize().width), new PointUnit(printSize.getSize().height));
            if (!this.isFrameset || this.stormPageFormat.getFramePrintFormat() == 3) {
                StormPrinter printer = this.mainViewport.getPilot().createPrinter();
                if (printer != null) {
                    PageSetupDialog.refreshPageDecoration(this.mainViewport, this.stormPageFormat);
                    PrintUtilities.adjustScale(this.stormPageFormat, printer.getDimension().width);
                    printer.setStormPageFormat(this.stormPageFormat);
                    this.printPages(printer, printJob);
                    printer.dispose();
                }
            } else if (this.isFrameset && this.stormPageFormat.getFramePrintFormat() == 1) {
                Vector viewports = new Vector(4, 2);
                this.mainViewport.getViewAndAllChildren(viewports);
                int size = viewports.size();
                int j = 1;
                while (j < size) {
                    Viewport tmpViewport = (Viewport)viewports.elementAt(j);
                    StormPrinter printer = tmpViewport.getPilot().createPrinter();
                    if (printer != null) {
                        PrintUtilities.adjustScale(this.stormPageFormat, printer.getDimension().width);
                        PageSetupDialog.refreshPageDecoration(tmpViewport, this.stormPageFormat);
                        printer.setStormPageFormat(this.stormPageFormat);
                        this.printPages(printer, printJob);
                        printer.dispose();
                    }
                    ++j;
                }
                viewports.removeAllElements();
            }
            printJob.end();
            int aZoom = this.zoom - 1;
            this.mainViewport.setZoom(aZoom > 0 ? aZoom : this.zoom + 1);
            this.mainViewport.setZoom(this.zoom);
        }
    }

    private void printPages(StormPrinter stormPrinter, PrintJob printJob) {
        int pageCount = stormPrinter.getPageCount();
        int i = 0;
        while (i < pageCount) {
            Graphics g = printJob.getGraphics();
            stormPrinter.printPage(g, i);
            g.dispose();
            ++i;
        }
    }
}

