/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print.awt;

import ice.pilots.html4.DDocument;
import ice.pilots.text.ThePilot;
import ice.ri.common.dialog.awt.AbstractSettingsDialog;
import ice.ri.common.dialog.awt.AbstractSettingsDialogPanel;
import ice.ri.common.dialog.awt.DecimalTextField;
import ice.ri.common.dialog.awt.DefaultSettingsDialog;
import ice.ri.common.dialog.awt.ListSettingsDialog;
import ice.ri.common.dialog.awt.TitledBorderPanel;
import ice.ri.common.dialog.awt.WholeNumberTextField;
import ice.ri.common.print.PrintUtilities;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.storm.print.AbstractPageDecoration;
import ice.storm.print.PageNumberPageDecoration;
import ice.storm.print.StormPageFormat;
import ice.storm.print.StringPageDecoration;
import ice.util.unit.InchUnit;
import ice.util.unit.MmUnit;
import ice.util.unit.PointUnit;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PageSetupDialog
implements WindowListener {
    public static final int LIST_LAYOUT = 1;
    public static final int BUTTON_LAYOUT = 2;
    private static StormPageFormat stormPageFormat;
    private TitledBorderPanel marginPanel;
    private AbstractSettingsDialog settingsDialog;
    private DecimalTextField leftMarginTextField;
    private DecimalTextField topMarginTextField;
    private DecimalTextField rightMarginTextField;
    private DecimalTextField bottomMarginTextField;
    private static String[][] units;
    private static String[] decorationList;
    private int defaultUnit;
    private Vector viewports;
    private Viewport mainViewport;
    private Viewport currentViewPort;

    private void $init$() {
        this.defaultUnit = 0;
    }

    public PageSetupDialog(Frame parent, Viewport viewport, StormPageFormat stormPageFormat) {
        this(parent, viewport, stormPageFormat, 2);
    }

    public PageSetupDialog(Frame parent, Viewport viewport, StormPageFormat stormPageFormat, int view) {
        this.$init$();
        PageSetupDialog.stormPageFormat = (StormPageFormat)stormPageFormat.clone();
        this.mainViewport = viewport;
        this.viewports = new Vector(4, 2);
        this.mainViewport.getViewAndAllChildren(this.viewports);
        this.currentViewPort = this.mainViewport;
        this.settingsDialog = view == 1 ? new ListSettingsDialog(parent, "Page Setup") : new DefaultSettingsDialog(parent, "Page Setup");
        this.settingsDialog.add(new PageSettingsPanel(this.settingsDialog));
        this.settingsDialog.add(new AdvancedPageSettingsPanel(this.settingsDialog));
        this.settingsDialog.setButtonDisplay(2);
        this.settingsDialog.addWindowListener(this);
    }

    public StormPageFormat showDialog() {
        this.settingsDialog.setVisible(true);
        return stormPageFormat;
    }

    private static String getDocumentTitle(Viewport viewport) {
        Pilot tmp = viewport.getPilot();
        if (tmp instanceof ice.pilots.html4.ThePilot) {
            ice.pilots.html4.ThePilot pilot = (ice.pilots.html4.ThePilot)tmp;
            DDocument doc = pilot.getDDocument();
            return doc.getTitle();
        }
        if (tmp instanceof ThePilot) {
            return "Text Pilot";
        }
        if (tmp instanceof ice.pilots.image.ThePilot) {
            return "Image Pilot";
        }
        return "";
    }

    public static void refreshPageDecoration(Viewport viewport, StormPageFormat stormPageFormat) {
        Vector decorations = stormPageFormat.getDecoration();
        int j = 0;
        while (j < decorations.size()) {
            Object tmp = decorations.elementAt(j);
            if (tmp instanceof AbstractPageDecoration) {
                AbstractPageDecoration decoration = (AbstractPageDecoration)decorations.elementAt(j);
                if (decoration.getName() == decorationList[1]) {
                    decorations.setElementAt(new StringPageDecoration("Title", PageSetupDialog.getDocumentTitle(viewport), decoration.getVerticalAlignment(), decoration.getHorizontalAlignment()), j);
                } else if (decoration.getName() == decorationList[2]) {
                    decorations.setElementAt(new StringPageDecoration("URL", viewport.getLocation(), decoration.getVerticalAlignment(), decoration.getHorizontalAlignment()), j);
                } else if (decoration.getName() == decorationList[3]) {
                    SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss a");
                    String s = formatter.format((Object)new Date());
                    decorations.setElementAt(new StringPageDecoration("Date/Time", s, decoration.getVerticalAlignment(), decoration.getHorizontalAlignment()), j);
                }
            }
            ++j;
        }
    }

    private void updateMarginUnits() {
        if (this.marginPanel != null) {
            this.marginPanel.setTitle("Margins (" + units[this.defaultUnit][1] + ")");
        }
        if (this.defaultUnit == 0) {
            PointUnit unit = new PointUnit();
            unit.setPoints(stormPageFormat.getMargin(2));
            this.leftMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(1));
            this.topMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(4));
            this.rightMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(3));
            this.bottomMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
        } else if (this.defaultUnit == 1) {
            MmUnit unit = new MmUnit();
            unit.setPoints(stormPageFormat.getMargin(2));
            this.leftMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(1));
            this.topMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(4));
            this.rightMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(3));
            this.bottomMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
        } else if (this.defaultUnit == 2) {
            InchUnit unit = new InchUnit();
            unit.setPoints(stormPageFormat.getMargin(2));
            this.leftMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(1));
            this.topMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(4));
            this.rightMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
            unit.setPoints(stormPageFormat.getMargin(3));
            this.bottomMarginTextField.setText((double)Math.round(unit.getUnits() * 100.0) / 100.0 + "");
        }
    }

    private void buildChoice(Choice choice, String[] items) {
        int i = 0;
        while (i < items.length) {
            choice.addItem(items[i]);
            ++i;
        }
    }

    public void windowClosing(WindowEvent e) {
        this.settingsDialog.setVisible(false);
        this.settingsDialog.dispose();
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    static {
        units = new String[][]{{"points", "Points"}, {"mm", "Millimeters"}, {"inch", "Inches"}};
        decorationList = new String[]{"Blank", "Title", "URL", "Date/Time", "Page # of #"};
    }

    static StormPageFormat ra$stormPageFormat() {
        return stormPageFormat;
    }

    static Viewport ra$currentViewPort(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.currentViewPort;
    }

    static String maS$getDocumentTitle(Viewport viewport) {
        return PageSetupDialog.getDocumentTitle(viewport);
    }

    static Viewport ra$mainViewport(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.mainViewport;
    }

    static int ra$defaultUnit(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.defaultUnit;
    }

    static DecimalTextField ra$leftMarginTextField(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.leftMarginTextField;
    }

    static DecimalTextField ra$rightMarginTextField(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.rightMarginTextField;
    }

    static DecimalTextField ra$topMarginTextField(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.topMarginTextField;
    }

    static DecimalTextField ra$bottomMarginTextField(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.bottomMarginTextField;
    }

    static String[] ra$decorationList() {
        return decorationList;
    }

    static void wa$defaultUnit(PageSetupDialog pageSetupDialog, int n) {
        pageSetupDialog.defaultUnit = n;
    }

    static void mav$updateMarginUnits(PageSetupDialog pageSetupDialog) {
        pageSetupDialog.updateMarginUnits();
    }

    static void mav$buildChoice(PageSetupDialog pageSetupDialog, Choice choice, String[] stringArray) {
        pageSetupDialog.buildChoice(choice, stringArray);
    }

    static void wa$leftMarginTextField(PageSetupDialog pageSetupDialog, DecimalTextField decimalTextField) {
        pageSetupDialog.leftMarginTextField = decimalTextField;
    }

    static void wa$topMarginTextField(PageSetupDialog pageSetupDialog, DecimalTextField decimalTextField) {
        pageSetupDialog.topMarginTextField = decimalTextField;
    }

    static void wa$rightMarginTextField(PageSetupDialog pageSetupDialog, DecimalTextField decimalTextField) {
        pageSetupDialog.rightMarginTextField = decimalTextField;
    }

    static void wa$bottomMarginTextField(PageSetupDialog pageSetupDialog, DecimalTextField decimalTextField) {
        pageSetupDialog.bottomMarginTextField = decimalTextField;
    }

    static void wa$marginPanel(PageSetupDialog pageSetupDialog, TitledBorderPanel titledBorderPanel) {
        pageSetupDialog.marginPanel = titledBorderPanel;
    }

    static TitledBorderPanel ra$marginPanel(PageSetupDialog pageSetupDialog) {
        return pageSetupDialog.marginPanel;
    }

    static String[][] ra$units() {
        return units;
    }

    public class PageSettingsPanel
    extends AbstractSettingsDialogPanel
    implements ActionListener,
    TextListener,
    ItemListener {
        private GridBagConstraints constraints;
        private Choice paperSizesComboBox;
        private Checkbox shrinkToFitCheckBox;
        private WholeNumberTextField scaleFactorTextField;
        private Checkbox portraitRadioButton;
        private Checkbox landscapeRadioButton;
        private Choice leftHeaderComboBox;
        private Choice middleHeaderComboBox;
        private Choice rightHeaderComboBox;
        private Choice leftFooterComboBox;
        private Choice middleFooterComboBox;
        private Choice rightFooterComboBox;
        private String[] fontList;
        private Choice fontComboBox;
        private String[] fontSizeList;
        private Choice fontSizeComboBox;

        private void $init$() {
            this.fontSizeList = new String[]{"4", "6", "8", "10", "12", "14"};
        }

        public PageSettingsPanel(AbstractSettingsDialog controlPanel) {
            super("Settings", controlPanel);
            this.$init$();
            this.setGui();
        }

        private void setGui() {
            GridBagLayout layout = new GridBagLayout();
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 2;
            this.constraints.weightx = 1.0;
            this.constraints.insets = new Insets(2, 10, 2, 6);
            this.setLayout(layout);
            Panel paperPanel = new Panel(new FlowLayout(0));
            Panel internalPanel = new Panel(new GridBagLayout());
            Label paperLabel = new Label("Paper size: ");
            this.paperSizesComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.paperSizesComboBox, StormPageFormat.PAPER_DISPLAY_NAMES);
            GridBagConstraints paperConstraints = new GridBagConstraints();
            paperConstraints.fill = 0;
            paperConstraints.weightx = 0.0;
            paperConstraints.anchor = 17;
            paperConstraints.insets = new Insets(1, 1, 1, 1);
            this.addGB(paperLabel, internalPanel, paperConstraints, 0, 0, 1, 1);
            this.addGB(this.paperSizesComboBox, internalPanel, paperConstraints, 1, 0, 1, 1);
            paperPanel.add(internalPanel);
            this.addGB(paperPanel, 0, 0, 3, 1);
            CheckboxGroup orientationGroup = new CheckboxGroup();
            this.portraitRadioButton = new Checkbox("Portrait", orientationGroup, false);
            this.landscapeRadioButton = new Checkbox("Landscape", orientationGroup, false);
            TitledBorderPanel orientationPanel = new TitledBorderPanel("Orientation", new FlowLayout(0));
            internalPanel = new Panel(new GridBagLayout());
            GridBagConstraints orientationConstraints = new GridBagConstraints();
            orientationConstraints.fill = 0;
            orientationConstraints.weightx = 0.0;
            orientationConstraints.insets = new Insets(1, 1, 1, 1);
            orientationConstraints.anchor = 17;
            this.addGB(this.portraitRadioButton, internalPanel, orientationConstraints, 0, 0, 1, 1);
            this.addGB(this.landscapeRadioButton, internalPanel, orientationConstraints, 0, 1, 1, 1);
            orientationPanel.add(internalPanel);
            this.addGB(orientationPanel, 0, 1, 1, 1);
            this.shrinkToFitCheckBox = new Checkbox("Shrink to Fit Paper Width");
            this.scaleFactorTextField = new WholeNumberTextField(100, 3, 3);
            Label scaleLabel = new Label("Scale: ");
            Label percentLabel = new Label(" %");
            Panel currentScalePanel = new Panel(new FlowLayout(0, 0, 0));
            currentScalePanel.add(scaleLabel);
            currentScalePanel.add(this.scaleFactorTextField);
            currentScalePanel.add(percentLabel);
            TitledBorderPanel scalePanel = new TitledBorderPanel("Scale", new FlowLayout(0));
            internalPanel = new Panel(new GridBagLayout());
            GridBagConstraints scaleConstraints = new GridBagConstraints();
            scaleConstraints.fill = 0;
            scaleConstraints.anchor = 17;
            scaleConstraints.weightx = 0.0;
            scaleConstraints.insets = new Insets(1, 1, 1, 1);
            this.addGB(currentScalePanel, internalPanel, scaleConstraints, 0, 0, 1, 1);
            this.addGB(this.shrinkToFitCheckBox, internalPanel, scaleConstraints, 0, 1, 1, 1);
            scalePanel.add(internalPanel);
            this.addGB(scalePanel, 2, 1, 1, 1);
            PageSetupDialog.wa$leftMarginTextField(PageSetupDialog.this, new DecimalTextField(0.0, 6, 6));
            PageSetupDialog.wa$topMarginTextField(PageSetupDialog.this, new DecimalTextField(0.0, 6, 6));
            PageSetupDialog.wa$rightMarginTextField(PageSetupDialog.this, new DecimalTextField(0.0, 6, 6));
            PageSetupDialog.wa$bottomMarginTextField(PageSetupDialog.this, new DecimalTextField(0.0, 6, 6));
            Label topMarginLabel = new Label("Top");
            Label leftMarginLabel = new Label("Left");
            Label rightMarginLabel = new Label("Right");
            Label bottomMarginLabel = new Label("Bottom", 0);
            PageSetupDialog.wa$marginPanel(PageSetupDialog.this, new TitledBorderPanel("Margins (Points)", new FlowLayout(0)));
            internalPanel = new Panel(new GridBagLayout());
            GridBagConstraints marginConstraints = new GridBagConstraints();
            marginConstraints.fill = 0;
            marginConstraints.weightx = 0.0;
            marginConstraints.insets = new Insets(1, 1, 1, 1);
            marginConstraints.anchor = 17;
            this.addGB(topMarginLabel, internalPanel, marginConstraints, 0, 0, 1, 1);
            this.addGB(PageSetupDialog.ra$topMarginTextField(PageSetupDialog.this), internalPanel, marginConstraints, 1, 0, 1, 1);
            this.addGB(new Label("       "), internalPanel, marginConstraints, 2, 0, 1, 1);
            this.addGB(bottomMarginLabel, internalPanel, marginConstraints, 3, 0, 1, 1);
            this.addGB(PageSetupDialog.ra$bottomMarginTextField(PageSetupDialog.this), internalPanel, marginConstraints, 4, 0, 1, 1);
            this.addGB(leftMarginLabel, internalPanel, marginConstraints, 0, 1, 1, 1);
            this.addGB(PageSetupDialog.ra$leftMarginTextField(PageSetupDialog.this), internalPanel, marginConstraints, 1, 1, 1, 1);
            this.addGB(new Label("       "), internalPanel, marginConstraints, 2, 1, 1, 1);
            this.addGB(rightMarginLabel, internalPanel, marginConstraints, 3, 1, 1, 1);
            this.addGB(PageSetupDialog.ra$rightMarginTextField(PageSetupDialog.this), internalPanel, marginConstraints, 4, 1, 1, 1);
            PageSetupDialog.ra$marginPanel(PageSetupDialog.this).add(internalPanel);
            this.addGB(PageSetupDialog.ra$marginPanel(PageSetupDialog.this), 0, 2, 3, 1);
            this.leftHeaderComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.leftHeaderComboBox, PageSetupDialog.ra$decorationList());
            this.middleHeaderComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.middleHeaderComboBox, PageSetupDialog.ra$decorationList());
            this.rightHeaderComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.rightHeaderComboBox, PageSetupDialog.ra$decorationList());
            this.leftFooterComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.leftFooterComboBox, PageSetupDialog.ra$decorationList());
            this.middleFooterComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.middleFooterComboBox, PageSetupDialog.ra$decorationList());
            this.rightFooterComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.rightFooterComboBox, PageSetupDialog.ra$decorationList());
            this.fontList = Toolkit.getDefaultToolkit().getFontList();
            this.fontComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.fontComboBox, this.fontList);
            this.fontSizeComboBox = new Choice();
            PageSetupDialog.mav$buildChoice(PageSetupDialog.this, this.fontSizeComboBox, this.fontSizeList);
            TitledBorderPanel decorationPanel = new TitledBorderPanel("Header & Footers", new FlowLayout(0));
            internalPanel = new Panel(new GridBagLayout());
            GridBagConstraints decorationConstraints = new GridBagConstraints();
            decorationConstraints.fill = 0;
            decorationConstraints.weightx = 0.0;
            decorationConstraints.insets = new Insets(1, 1, 1, 1);
            decorationConstraints.anchor = 17;
            decorationConstraints.anchor = 10;
            this.addGB(new Label("Left:"), internalPanel, decorationConstraints, 1, 0, 1, 1);
            this.addGB(new Label("  "), internalPanel, decorationConstraints, 2, 0, 1, 1);
            this.addGB(new Label("Center:"), internalPanel, decorationConstraints, 3, 0, 1, 1);
            this.addGB(new Label("  "), internalPanel, decorationConstraints, 4, 0, 1, 1);
            this.addGB(new Label("Right:"), internalPanel, decorationConstraints, 5, 0, 1, 1);
            decorationConstraints.anchor = 17;
            this.addGB(new Label("Header"), internalPanel, decorationConstraints, 0, 1, 1, 1);
            this.addGB(this.leftHeaderComboBox, internalPanel, decorationConstraints, 1, 1, 1, 1);
            this.addGB(this.middleHeaderComboBox, internalPanel, decorationConstraints, 3, 1, 1, 1);
            this.addGB(this.rightHeaderComboBox, internalPanel, decorationConstraints, 5, 1, 1, 1);
            this.addGB(new Label("Footer"), internalPanel, decorationConstraints, 0, 2, 1, 1);
            this.addGB(this.leftFooterComboBox, internalPanel, decorationConstraints, 1, 2, 1, 1);
            this.addGB(this.middleFooterComboBox, internalPanel, decorationConstraints, 3, 2, 1, 1);
            this.addGB(this.rightFooterComboBox, internalPanel, decorationConstraints, 5, 2, 1, 1);
            this.addGB(new Label("Font"), internalPanel, decorationConstraints, 0, 4, 1, 1);
            this.addGB(this.fontComboBox, internalPanel, decorationConstraints, 1, 4, 3, 1);
            this.addGB(this.fontSizeComboBox, internalPanel, decorationConstraints, 3, 4, 1, 1);
            decorationPanel.add(internalPanel);
            this.addGB(decorationPanel, 0, 3, 3, 1);
            this.constraints.weighty = 1.0;
            this.addGB(new Panel(), 0, 4, 3, 1);
            this.getPreferenceElements();
            PageSetupDialog.ra$leftMarginTextField(PageSetupDialog.this).addTextListener(this);
            PageSetupDialog.ra$rightMarginTextField(PageSetupDialog.this).addTextListener(this);
            PageSetupDialog.ra$topMarginTextField(PageSetupDialog.this).addTextListener(this);
            PageSetupDialog.ra$bottomMarginTextField(PageSetupDialog.this).addTextListener(this);
            this.scaleFactorTextField.addTextListener(this);
            this.shrinkToFitCheckBox.addItemListener(this);
            this.paperSizesComboBox.addItemListener(this);
            this.portraitRadioButton.addItemListener(this);
            this.landscapeRadioButton.addItemListener(this);
            this.leftHeaderComboBox.addItemListener(this);
            this.middleHeaderComboBox.addItemListener(this);
            this.rightHeaderComboBox.addItemListener(this);
            this.leftFooterComboBox.addItemListener(this);
            this.middleFooterComboBox.addItemListener(this);
            this.rightFooterComboBox.addItemListener(this);
            this.fontComboBox.addItemListener(this);
            this.fontSizeComboBox.addItemListener(this);
        }

        private void getPreferenceElements() {
            int index = StormPageFormat.findPageSize(new Dimension((int)PageSetupDialog.ra$stormPageFormat().getPageWidth(), (int)PageSetupDialog.ra$stormPageFormat().getPageHeight()));
            this.paperSizesComboBox.select(index);
            if (PageSetupDialog.ra$stormPageFormat().isScaleToFitEnabled()) {
                this.scaleFactorTextField.setEnabled(false);
                this.shrinkToFitCheckBox.setState(true);
            }
            this.scaleFactorTextField.setValue((int)(PageSetupDialog.ra$stormPageFormat().getScale() * 100.0));
            if (PageSetupDialog.ra$stormPageFormat().getOrientation() == 1) {
                this.portraitRadioButton.setState(true);
            } else {
                this.landscapeRadioButton.setState(true);
            }
            PageSetupDialog.wa$defaultUnit(PageSetupDialog.this, PageSetupDialog.ra$stormPageFormat().getPageSetupDialogUnit());
            PageSetupDialog.mav$updateMarginUnits(PageSetupDialog.this);
            int i = 0;
            while (i < this.fontList.length) {
                if (this.fontList[i].equals(PageSetupDialog.ra$stormPageFormat().getHeaderFooterFont().getName())) {
                    this.fontComboBox.select(i);
                    break;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.fontSizeList.length) {
                if (this.fontSizeList[i2].equals(PageSetupDialog.ra$stormPageFormat().getHeaderFooterFont().getSize() + "")) {
                    this.fontSizeComboBox.select(i2);
                    break;
                }
                ++i2;
            }
            Enumeration decorations = PageSetupDialog.ra$stormPageFormat().getDecoration().elements();
            while (decorations.hasMoreElements()) {
                Object tmp = decorations.nextElement();
                if (!(tmp instanceof AbstractPageDecoration)) continue;
                AbstractPageDecoration decoration = (AbstractPageDecoration)tmp;
                if (decoration.getVerticalAlignment() == AbstractPageDecoration.TOP) {
                    if (decoration.getHorizontalAlignment() == AbstractPageDecoration.LEFT) {
                        this.leftHeaderComboBox.select(this.selectDecorationComboBoxIndex(decoration.getName()));
                        continue;
                    }
                    if (decoration.getHorizontalAlignment() == AbstractPageDecoration.CENTER) {
                        this.middleHeaderComboBox.select(this.selectDecorationComboBoxIndex(decoration.getName()));
                        continue;
                    }
                    if (decoration.getHorizontalAlignment() != AbstractPageDecoration.RIGHT) continue;
                    this.rightHeaderComboBox.select(this.selectDecorationComboBoxIndex(decoration.getName()));
                    continue;
                }
                if (decoration.getVerticalAlignment() != AbstractPageDecoration.BOTTOM) continue;
                if (decoration.getHorizontalAlignment() == AbstractPageDecoration.LEFT) {
                    this.leftFooterComboBox.select(this.selectDecorationComboBoxIndex(decoration.getName()));
                    continue;
                }
                if (decoration.getHorizontalAlignment() == AbstractPageDecoration.CENTER) {
                    this.middleFooterComboBox.select(this.selectDecorationComboBoxIndex(decoration.getName()));
                    continue;
                }
                if (decoration.getHorizontalAlignment() != AbstractPageDecoration.RIGHT) continue;
                this.rightFooterComboBox.select(this.selectDecorationComboBoxIndex(decoration.getName()));
            }
        }

        private int selectDecorationComboBoxIndex(String decorationName) {
            int index = 0;
            int i = 0;
            while (i < PageSetupDialog.ra$decorationList().length) {
                if (PageSetupDialog.ra$decorationList()[i].equalsIgnoreCase(decorationName)) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }

        private void setPreferenceElements() {
            PageSetupDialog.ra$stormPageFormat().setOrientation(1);
            int index = this.paperSizesComboBox.getSelectedIndex();
            PageSetupDialog.ra$stormPageFormat().setPageSize(index);
            if (this.landscapeRadioButton.getState()) {
                PageSetupDialog.ra$stormPageFormat().setOrientation(0);
            }
            if (this.shrinkToFitCheckBox.getState()) {
                PageSetupDialog.ra$stormPageFormat().setScaleToFitEnabled(true);
            } else {
                PageSetupDialog.ra$stormPageFormat().setScaleToFitEnabled(false);
                try {
                    double tmp = Double.valueOf(this.scaleFactorTextField.getText());
                    PageSetupDialog.ra$stormPageFormat().setScale(tmp / 100.0);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            try {
                if (PageSetupDialog.ra$defaultUnit(PageSetupDialog.this) == 0) {
                    double tmp = Double.valueOf(PageSetupDialog.ra$leftMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new PointUnit(tmp), 2);
                    tmp = Double.valueOf(PageSetupDialog.ra$rightMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new PointUnit(tmp), 4);
                    tmp = Double.valueOf(PageSetupDialog.ra$topMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new PointUnit(tmp), 1);
                    tmp = Double.valueOf(PageSetupDialog.ra$bottomMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new PointUnit(tmp), 3);
                } else if (PageSetupDialog.ra$defaultUnit(PageSetupDialog.this) == 1) {
                    double tmp = Double.valueOf(PageSetupDialog.ra$leftMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new MmUnit(tmp), 2);
                    tmp = Double.valueOf(PageSetupDialog.ra$rightMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new MmUnit(tmp), 4);
                    tmp = Double.valueOf(PageSetupDialog.ra$topMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new MmUnit(tmp), 1);
                    tmp = Double.valueOf(PageSetupDialog.ra$bottomMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new MmUnit(tmp), 3);
                } else if (PageSetupDialog.ra$defaultUnit(PageSetupDialog.this) == 2) {
                    double tmp = Double.valueOf(PageSetupDialog.ra$leftMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new InchUnit(tmp), 2);
                    tmp = Double.valueOf(PageSetupDialog.ra$rightMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new InchUnit(tmp), 4);
                    tmp = Double.valueOf(PageSetupDialog.ra$topMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new InchUnit(tmp), 1);
                    tmp = Double.valueOf(PageSetupDialog.ra$bottomMarginTextField(PageSetupDialog.this).getText());
                    PageSetupDialog.ra$stormPageFormat().setMargin(new InchUnit(tmp), 3);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            PageSetupDialog.ra$stormPageFormat().setHeaderFooterFont(new Font(this.fontList[this.fontComboBox.getSelectedIndex()], 0, Integer.parseInt(this.fontSizeList[this.fontSizeComboBox.getSelectedIndex()])));
            Vector decorations = PageSetupDialog.ra$stormPageFormat().getDecoration();
            int j = 0;
            while (j < decorations.size()) {
                Object tmp = decorations.elementAt(j);
                if (tmp instanceof AbstractPageDecoration) {
                    AbstractPageDecoration decoration = (AbstractPageDecoration)decorations.elementAt(j);
                    int i = 0;
                    while (i < PageSetupDialog.ra$decorationList().length) {
                        if (PageSetupDialog.ra$decorationList()[i].equalsIgnoreCase(decoration.getName())) {
                            decorations.removeElementAt(j);
                            --j;
                            break;
                        }
                        ++i;
                    }
                }
                ++j;
            }
            int selectedIndex = this.leftHeaderComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.TOP, AbstractPageDecoration.LEFT, selectedIndex);
            selectedIndex = this.middleHeaderComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.TOP, AbstractPageDecoration.CENTER, selectedIndex);
            selectedIndex = this.rightHeaderComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.TOP, AbstractPageDecoration.RIGHT, selectedIndex);
            selectedIndex = this.leftFooterComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.BOTTOM, AbstractPageDecoration.LEFT, selectedIndex);
            selectedIndex = this.middleFooterComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.BOTTOM, AbstractPageDecoration.CENTER, selectedIndex);
            selectedIndex = this.rightFooterComboBox.getSelectedIndex();
            this.addDecoration(AbstractPageDecoration.BOTTOM, AbstractPageDecoration.RIGHT, selectedIndex);
        }

        private void addDecoration(int vert, int hor, int index) {
            if (index == 1) {
                PageSetupDialog.ra$stormPageFormat().addDecoration(new StringPageDecoration("Title", PageSetupDialog.maS$getDocumentTitle(PageSetupDialog.ra$currentViewPort(PageSetupDialog.this)), vert, hor));
            } else if (index == 2) {
                PageSetupDialog.ra$stormPageFormat().addDecoration(new StringPageDecoration("URL", PageSetupDialog.ra$mainViewport(PageSetupDialog.this).getLocation(), vert, hor));
            } else if (index == 3) {
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss a");
                String s = formatter.format((Object)new Date());
                PageSetupDialog.ra$stormPageFormat().addDecoration(new StringPageDecoration("Date/Time", s, vert, hor));
            } else if (index == 4) {
                PageSetupDialog.ra$stormPageFormat().addDecoration(new PageNumberPageDecoration("Page # of #", vert, hor));
            }
        }

        public boolean save() {
            this.setPreferenceElements();
            this.setHasChanged(false);
            return false;
        }

        public boolean cancel() {
            this.getPreferenceElements();
            return false;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.shrinkToFitCheckBox) {
                if (this.shrinkToFitCheckBox.getState()) {
                    this.scaleFactorTextField.setEnabled(false);
                    this.setHasChanged(true);
                } else {
                    this.scaleFactorTextField.setEnabled(true);
                    this.setHasChanged(true);
                }
            }
            if (e.getSource() == this.portraitRadioButton) {
                if (PageSetupDialog.ra$stormPageFormat().getOrientation() != 1) {
                    this.setHasChanged(true);
                }
            } else if (e.getSource() == this.landscapeRadioButton) {
                if (PageSetupDialog.ra$stormPageFormat().getOrientation() != 0) {
                    this.setHasChanged(true);
                }
            } else {
                this.setHasChanged(true);
            }
        }

        public void textValueChanged(TextEvent te) {
            this.setHasChanged(true);
        }

        public void actionPerformed(ActionEvent e) {
        }

        private void addGB(Component component, Panel panel, GridBagConstraints constraints, int x, int y, int rowSpan, int colSpan) {
            constraints.gridx = x;
            constraints.gridy = y;
            constraints.gridwidth = rowSpan;
            constraints.gridheight = colSpan;
            panel.add(component, constraints);
        }

        private void addGB(Component component, int x, int y, int rowSpan, int colSpan) {
            this.constraints.gridx = x;
            this.constraints.gridy = y;
            this.constraints.gridwidth = rowSpan;
            this.constraints.gridheight = colSpan;
            this.add(component, this.constraints);
        }
    }

    public class AdvancedPageSettingsPanel
    extends AbstractSettingsDialogPanel
    implements ItemListener {
        private GridBagConstraints constraints;
        private Checkbox printBackgroundCheckBox;
        private Choice unitsComboBox;
        private Checkbox smartPagingOnCheckBox;
        private Checkbox seperateFramesRadioButton;
        private Checkbox selectedFramesRadioButton;

        public AdvancedPageSettingsPanel(AbstractSettingsDialog controlPanel) {
            super("Advanced Page Setup", controlPanel);
            this.setGui();
        }

        private void setGui() {
            GridBagLayout layout = new GridBagLayout();
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 2;
            this.constraints.weightx = 1.0;
            this.constraints.anchor = 17;
            this.constraints.insets = new Insets(2, 15, 2, 10);
            this.setLayout(layout);
            this.printBackgroundCheckBox = new Checkbox("Print Background (colors & images)");
            this.unitsComboBox = new Choice();
            int i = 0;
            while (i < PageSetupDialog.ra$units().length) {
                this.unitsComboBox.addItem(PageSetupDialog.ra$units()[i][1]);
                ++i;
            }
            TitledBorderPanel optionsPanel = new TitledBorderPanel("Options", new FlowLayout(0));
            Panel internalPanel = new Panel(new GridBagLayout());
            GridBagConstraints optionConstraints = new GridBagConstraints();
            optionConstraints.fill = 0;
            optionConstraints.weightx = 0.0;
            optionConstraints.insets = new Insets(1, 1, 1, 1);
            optionConstraints.anchor = 17;
            this.addGB(this.printBackgroundCheckBox, internalPanel, optionConstraints, 0, 0, 2, 1);
            this.addGB(new Label("Units:"), internalPanel, optionConstraints, 0, 1, 1, 1);
            this.addGB(this.unitsComboBox, internalPanel, optionConstraints, 1, 1, 1, 1);
            optionsPanel.add(internalPanel);
            this.addGB(optionsPanel, 0, 0, 1, 1);
            this.smartPagingOnCheckBox = new Checkbox("Use Smart Page Breaks");
            TitledBorderPanel pagingPanel = new TitledBorderPanel("HTML Paging", new FlowLayout(0));
            pagingPanel.add(this.smartPagingOnCheckBox);
            this.addGB(pagingPanel, 0, 2, 1, 1);
            CheckboxGroup framesGroup = new CheckboxGroup();
            this.seperateFramesRadioButton = new Checkbox("All frames individually", framesGroup, false);
            this.selectedFramesRadioButton = new Checkbox("As laid out on screen", framesGroup, false);
            TitledBorderPanel framesPanel = new TitledBorderPanel("Frames", new FlowLayout(0));
            internalPanel = new Panel(new GridBagLayout());
            GridBagConstraints framesConstraints = new GridBagConstraints();
            framesConstraints.fill = 0;
            framesConstraints.weightx = 0.0;
            framesConstraints.insets = new Insets(1, 1, 1, 1);
            framesConstraints.anchor = 17;
            this.addGB(this.selectedFramesRadioButton, internalPanel, framesConstraints, 0, 0, 1, 1);
            this.addGB(this.seperateFramesRadioButton, internalPanel, framesConstraints, 0, 1, 1, 1);
            framesPanel.add(internalPanel);
            this.addGB(framesPanel, 0, 3, 1, 1);
            this.constraints.weighty = 1.0;
            this.addGB(new Panel(), 0, 4, 1, 1);
            this.getPreferenceElements();
            this.unitsComboBox.addItemListener(this);
            this.printBackgroundCheckBox.addItemListener(this);
            this.unitsComboBox.addItemListener(this);
            this.smartPagingOnCheckBox.addItemListener(this);
            this.seperateFramesRadioButton.addItemListener(this);
            this.selectedFramesRadioButton.addItemListener(this);
        }

        public void getPreferenceElements() {
            if (PageSetupDialog.ra$stormPageFormat().isBackgroundVisible()) {
                this.printBackgroundCheckBox.setState(true);
            } else {
                this.printBackgroundCheckBox.setState(false);
            }
            this.unitsComboBox.select(PageSetupDialog.ra$stormPageFormat().getPageSetupDialogUnit());
            if (PageSetupDialog.ra$stormPageFormat().isHtmlSmartPagingEnabled()) {
                this.smartPagingOnCheckBox.setState(true);
            } else {
                this.smartPagingOnCheckBox.setState(false);
            }
            if (PrintUtilities.isFrameset(PageSetupDialog.ra$mainViewport(PageSetupDialog.this))) {
                this.seperateFramesRadioButton.setEnabled(true);
                this.selectedFramesRadioButton.setEnabled(true);
            } else {
                this.seperateFramesRadioButton.setEnabled(false);
                this.selectedFramesRadioButton.setEnabled(false);
            }
            if (PageSetupDialog.ra$stormPageFormat().getFramePrintFormat() == 3) {
                this.selectedFramesRadioButton.setState(true);
            } else if (PageSetupDialog.ra$stormPageFormat().getFramePrintFormat() == 1) {
                this.seperateFramesRadioButton.setState(true);
            }
        }

        public synchronized void setPreferenceElements() {
            if (this.printBackgroundCheckBox.getState()) {
                PageSetupDialog.ra$stormPageFormat().setBackgroundVisible(true);
            } else {
                PageSetupDialog.ra$stormPageFormat().setBackgroundVisible(false);
            }
            if (this.selectedFramesRadioButton.getState()) {
                PageSetupDialog.ra$stormPageFormat().setFramePrintFormat(3);
            } else {
                PageSetupDialog.ra$stormPageFormat().setFramePrintFormat(1);
            }
            PageSetupDialog.ra$stormPageFormat().setPageSetupDialogUnit(this.unitsComboBox.getSelectedIndex());
            if (this.smartPagingOnCheckBox.getState()) {
                PageSetupDialog.ra$stormPageFormat().setHtmlSmartPaging(true);
            } else {
                PageSetupDialog.ra$stormPageFormat().setHtmlSmartPaging(false);
            }
        }

        public boolean save() {
            this.setPreferenceElements();
            this.setHasChanged(false);
            return false;
        }

        public boolean cancel() {
            this.getPreferenceElements();
            return false;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.unitsComboBox) {
                int index = this.unitsComboBox.getSelectedIndex();
                PageSetupDialog.wa$defaultUnit(PageSetupDialog.this, index);
                PageSetupDialog.mav$updateMarginUnits(PageSetupDialog.this);
                this.setHasChanged(true);
            } else {
                this.setHasChanged(true);
            }
        }

        public void actionPerformed(ActionEvent e) {
        }

        private void addGB(Component component, Panel panel, GridBagConstraints constraints, int x, int y, int rowSpan, int colSpan) {
            constraints.gridx = x;
            constraints.gridy = y;
            constraints.gridwidth = rowSpan;
            constraints.gridheight = colSpan;
            panel.add(component, constraints);
        }

        private void addGB(Component component, int x, int y, int rowSpan, int colSpan) {
            this.constraints.gridx = x;
            this.constraints.gridy = y;
            this.constraints.gridwidth = rowSpan;
            this.constraints.gridheight = colSpan;
            this.add(component, this.constraints);
        }
    }
}

