/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePilot;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private Vector textLines;
    private ThePilot pilot;
    private int lineSpacing;
    private int linesPerPage;
    private FontMetrics fontMetrics;
    private int spaceWidth;
    Font fonts;

    private void $init$() {
        this.textLines = new Vector();
        this.pilot = null;
        this.lineSpacing = 0;
        this.fonts = new Font("Arial", 0, 10);
    }

    protected ThePrinter(ThePilot pilot) {
        this.$init$();
        this.pilot = pilot;
        this.getPageCount();
    }

    public int getPageCount() {
        if (this.pageFormat == null) {
            throw new NullPointerException();
        }
        if (this.pageFormat.hasImageableAreaChanged()) {
            this.fonts = ThePilot.getDefaultFont();
            if (this.fonts != null) {
                int fontSize = ThePilot.DEFAULT_FONT_SIZE;
                int zoomedSize = fontSize * (int)(this.pageFormat.getScale() * 256.0) >> 8;
                if (zoomedSize < 4) {
                    zoomedSize = 4;
                }
                this.fonts = new Font(this.fonts.getName(), this.fonts.getStyle(), zoomedSize);
            }
            this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fonts);
            this.lineSpacing = this.fontMetrics.getAscent();
            this.spaceWidth = this.fontMetrics.charWidth(' ');
            this.linesPerPage = (int)this.pageFormat.getImageableHeight() / this.lineSpacing;
            this.textLines = (Vector)this.pilot.getLines().clone();
            if (this.pageFormat.isTextWrappingEnabled()) {
                int lineCount = 0;
                Enumeration lines = this.textLines.elements();
                while (lines.hasMoreElements() && (int)Math.ceil((double)this.textLines.size() / (double)this.linesPerPage) < 2000) {
                    String currentLine = (String)lines.nextElement();
                    int currentLineLength = this.fontMetrics.stringWidth(currentLine);
                    if ((double)currentLineLength > this.pageFormat.getImageableWidth()) {
                        this.lineWrapper(this.textLines, currentLine, lineCount);
                    }
                    ++lineCount;
                }
            }
            this.numberOfPages = (int)Math.ceil((double)this.textLines.size() / (double)this.linesPerPage);
            this.currentPageIndex = -1;
            this.pageFormat.setImageableAreaChangedFlag(false);
        }
        return this.numberOfPages;
    }

    private void lineWrapper(Vector textLines, String currentLine, int lineCount) {
        StringTokenizer tokenizer = new StringTokenizer(currentLine, " ", true);
        int linePixelLength = 0;
        int lineCharLength = 0;
        int thisTokenPixelLength = 0;
        block0: while (tokenizer.hasMoreTokens()) {
            String thisToken = tokenizer.nextToken();
            if (thisToken.equals(" ")) {
                thisTokenPixelLength = this.spaceWidth;
                linePixelLength += thisTokenPixelLength;
                ++lineCharLength;
            } else {
                thisTokenPixelLength = this.fontMetrics.stringWidth(thisToken);
                linePixelLength += thisTokenPixelLength;
                lineCharLength += thisToken.length();
            }
            if (!((double)linePixelLength > this.pageFormat.getImageableWidth()) || !((double)(linePixelLength - thisTokenPixelLength) <= this.pageFormat.getImageableWidth())) continue;
            if ((double)thisTokenPixelLength <= this.pageFormat.getImageableWidth()) {
                String thisLine = currentLine.substring(0, lineCharLength - thisToken.length());
                String nextLine = currentLine.substring(lineCharLength - thisToken.length(), currentLine.length()).trim();
                textLines.setElementAt(thisLine, lineCount);
                textLines.insertElementAt(nextLine, lineCount + 1);
                continue;
            }
            int cursor = linePixelLength - thisTokenPixelLength;
            int i = 0;
            while (i < thisToken.length() - 1) {
                if ((double)(cursor += this.fontMetrics.stringWidth(thisToken.substring(i, i + 1))) > this.pageFormat.getImageableWidth()) {
                    String thisLine = thisToken.substring(0, i);
                    String nextLine = thisToken.substring(i, thisToken.length()).trim();
                    textLines.setElementAt(thisLine, lineCount);
                    if (lineCount + 1 < textLines.size()) {
                        textLines.setElementAt(nextLine + " " + textLines.elementAt(lineCount + 1), lineCount + 1);
                        continue block0;
                    }
                    textLines.addElement(nextLine);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public void printPage(Graphics g, int pageIndex) {
        if (pageIndex < 0) {
            pageIndex = 0;
        } else if (pageIndex > this.numberOfPages - 1) {
            pageIndex = this.numberOfPages - 1;
        }
        g.setColor(Color.black);
        g.setFont(this.fonts);
        Graphics gg = g.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        gg.translate(0, 0);
        gg.setClip(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        int verticalOffset = this.fontMetrics.getMaxAscent() - 3;
        int pageLineStart = this.linesPerPage * pageIndex;
        int pageLineEnd = pageLineStart + this.linesPerPage;
        int i = pageLineStart;
        while (i < this.textLines.size() && i < pageLineEnd) {
            String currentLine = (String)this.textLines.elementAt(i);
            gg.drawString(currentLine, 0, verticalOffset);
            verticalOffset += this.lineSpacing;
            ++i;
        }
        gg.dispose();
        Graphics gd = g.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        gd.translate(0, 0);
        gd.setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        Vector pageDecorations = this.pageFormat.getDecoration();
        int i2 = pageDecorations.size() - 1;
        while (i2 >= 0) {
            PageDecoration tmp = (PageDecoration)pageDecorations.elementAt(i2);
            tmp.paint(gd, pageIndex, this.numberOfPages, this.pageFormat);
            --i2;
        }
        gd.dispose();
    }

    public void print(Graphics g) {
        g.setColor(Color.black);
        g.setFont(ThePilot.getDefaultFont());
        int verticalOffset = this.lineSpacing;
        int i = 0;
        while (i < this.textLines.size()) {
            String currentLine = (String)this.textLines.elementAt(i);
            g.drawString(currentLine, 0, verticalOffset);
            verticalOffset += this.lineSpacing;
            ++i;
        }
    }

    public void setZoom(int zoom) {
        double pageFormatZoom = (double)Math.abs(zoom) / 256.0;
        this.pageFormat.setScale(pageFormatZoom);
        this.getPageCount();
    }

    public int getZoom() {
        return (int)(this.pageFormat.getScale() * 256.0);
    }

    public Dimension getDimension() {
        int width = (int)this.pageFormat.getImageableWidth();
        int height = this.lineSpacing * this.numberOfPages;
        return new Dimension(width, height);
    }

    public void dispose() {
    }
}

