/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePrinter;
import ice.pilots.text.VisualComponent;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class ThePilot
extends Pilot {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORMAL_CURSOR = new Cursor(0);
    private VisualComponent vis;
    private Vector lines;
    private int zoomFactor;
    private static Font defaultFont;
    public static int DEFAULT_FONT_SIZE;

    private void $init$() {
        this.vis = null;
        this.lines = null;
        this.zoomFactor = 256;
    }

    public static Font getDefaultFont() {
        Font f = defaultFont;
        if (f == null) {
            defaultFont = f = new Font("SansSarif", 0, DEFAULT_FONT_SIZE);
        }
        return f;
    }

    public static void setDefaultFont(Font f) {
        defaultFont = f;
    }

    public void init(String componentToolkitName) {
        super.init(componentToolkitName);
        String s = "ice.pilots.text." + componentToolkitName + ".TextArea";
        try {
            Object o = Class.forName(s).newInstance();
            this.vis = (VisualComponent)o;
            this.vis.setTheFont(ThePilot.getDefaultFont());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public Component createComponent() {
        return (Component)((Object)this.vis);
    }

    public Vector getLines() {
        return this.lines;
    }

    public void clear(String contentType) {
        this.vis.setTheText("");
    }

    public void parse(ContentLoader cl) throws IOException {
        try {
            this.setCursor(WAIT_CURSOR);
            this.lines = new Vector();
            this.firePropertyChange("location", null, cl.getLocation());
            this.firePropertyChange("title", null, cl.getLocation());
            StringBuffer sb = new StringBuffer();
            BufferedReader r = new BufferedReader(new InputStreamReader(cl.getInputStream()));
            String line = r.readLine();
            try {
                while (line != null) {
                    this.lines.addElement(line);
                    sb.append(line);
                    sb.append('\n');
                    line = r.readLine();
                }
            }
            catch (OutOfMemoryError e) {
                sb = null;
                throw new OutOfMemoryError();
            }
            r.close();
            this.vis.setTheText(sb.toString());
        }
        finally {
            this.setCursor(NORMAL_CURSOR);
        }
    }

    public void setZoom(int factor) {
        if (factor != this.zoomFactor) {
            this.zoomFactor = factor;
            Font font = defaultFont;
            if (font != null) {
                int fontSize = DEFAULT_FONT_SIZE;
                int zoomedSize = fontSize * factor >> 8;
                if (zoomedSize < 4) {
                    zoomedSize = 4;
                }
                if (fontSize != zoomedSize) {
                    this.vis.setTheFont(new Font(font.getName(), font.getStyle(), zoomedSize));
                }
                defaultFont = new Font(font.getName(), font.getStyle(), zoomedSize);
            }
        }
    }

    public void setFont(Font font) {
        int zoomedSize = font.getSize() * this.zoomFactor >> 8;
        if (zoomedSize < 4) {
            zoomedSize = 4;
        }
        if (!(font = new Font(font.getName(), font.getStyle(), zoomedSize)).equals(this.vis.getTheFont())) {
            this.vis.setTheFont(font);
        }
    }

    public StormPrinter createPrinter() {
        ThePrinter p = new ThePrinter(this);
        return p;
    }

    private void setCursor(Cursor theCursor) {
        if (this.vis != null) {
            this.vis.setTheCursor(theCursor);
        }
    }

    public ThePilot() {
        this.$init$();
    }

    static {
        DEFAULT_FONT_SIZE = 12;
    }
}

