/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.jmf;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;

public class ThePilot
extends Pilot
implements ControllerListener {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORMAL_CURSOR = new Cursor(0);
    protected Player player;
    protected Component visualComponent;
    protected Component controlComponent;
    protected Component progressBar;
    protected int controlPanelHeight;
    protected int videoWidth;
    protected int videoHeight;
    protected String mediaFile;
    protected boolean deallocateSync;
    protected Panel panel;

    static {
        ThePilot.testForJMF();
    }

    private static final void testForJMF() throws RuntimeException {
        String className = "javax.media.Manager";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Required class '" + className + "' not found. Required JMF library jars may not be on the classpath - JMF Pilot disabled.";
            Debug.trace(msg);
            throw new RuntimeException(msg);
        }
    }

    private void $init$() {
        this.player = null;
        this.visualComponent = null;
        this.controlComponent = null;
        this.progressBar = null;
        this.controlPanelHeight = 0;
        this.videoWidth = 0;
        this.videoHeight = 0;
        this.deallocateSync = false;
    }

    public Object getDynamicValueOnWindow(DynamicObject window, String name, DynEnv env) {
        if (name.equals("pilot")) {
            return this;
        }
        return super.getDynamicValueOnWindow(window, name, env);
    }

    public Component createComponent() {
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout());
        return this.panel;
    }

    public void parse(ContentLoader cl) {
        try {
            this.setCursor(WAIT_CURSOR);
            if (this.player != null) {
                this.dispose();
                this.player = null;
            }
            MediaLocator mrl = null;
            this.mediaFile = cl.getLocation();
            int i1 = this.mediaFile.indexOf("//localhost");
            if (i1 > 0) {
                int i2 = i1 + 11;
                this.mediaFile = this.mediaFile.substring(0, i1) + this.mediaFile.substring(i2);
            }
            this.firePropertyChange("location", null, this.mediaFile);
            this.firePropertyChange("title", null, "Buffering " + this.mediaFile);
            try {
                Manager.setHint((int)4, (Object)new Boolean(true));
                mrl = new MediaLocator(this.mediaFile);
                if (mrl == null) {
                    this.Fatal("Can't build URL for " + this.mediaFile);
                }
                try {
                    this.player = Manager.createPlayer((MediaLocator)mrl);
                }
                catch (NoPlayerException e) {
                    this.Fatal("Could not create player for " + mrl);
                }
                this.player.addControllerListener((ControllerListener)this);
            }
            catch (MalformedURLException e) {
                this.Fatal("Invalid media file URL!");
            }
            catch (IOException e) {
                this.Fatal("IO exception creating player for " + mrl);
            }
            if (this.player != null) {
                this.player.start();
            }
        }
        finally {
            this.setCursor(NORMAL_CURSOR);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.player != null) {
            this.deallocateSync = true;
            this.player.stop();
            this.player.deallocate();
            this.deallocateSync = false;
            this.player.close();
            this.controlComponent = null;
            this.visualComponent = null;
            this.progressBar = null;
        }
    }

    protected void Fatal(String s) {
        throw new Error(s);
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (this.player == null) {
            return;
        }
        if (event instanceof RealizeCompleteEvent) {
            if (this.progressBar != null) {
                this.panel.remove(this.progressBar);
                this.progressBar = null;
            }
            int width = 320;
            int height = 0;
            if (this.controlComponent == null && (this.controlComponent = this.player.getControlPanelComponent()) != null) {
                this.controlPanelHeight = this.controlComponent.getPreferredSize().height;
                this.panel.add(this.controlComponent, "South");
                height += this.controlPanelHeight;
            }
            if (this.visualComponent == null && (this.visualComponent = this.player.getVisualComponent()) != null) {
                this.panel.add(this.visualComponent, "Center");
                Dimension videoSize = this.visualComponent.getPreferredSize();
                this.videoWidth = videoSize.width;
                this.videoHeight = videoSize.height;
                width = this.videoWidth;
                height += this.videoHeight;
                this.visualComponent.setSize(this.videoWidth, this.videoHeight);
            }
            this.panel.setSize(width, height);
            if (this.controlComponent != null) {
                this.controlComponent.setBounds(0, this.videoHeight, width, this.controlPanelHeight);
                this.controlComponent.invalidate();
            }
            if (this.panel.getParent() != null) {
                this.panel.getParent().validate();
            }
            this.firePropertyChange("jmfEvent", this.mediaFile, "playerRealized");
        } else if (!(event instanceof PrefetchCompleteEvent)) {
            if (event instanceof StartEvent) {
                this.firePropertyChange("title", null, "Playing " + this.mediaFile);
            } else if (event instanceof CachingControlEvent) {
                CachingControlEvent e = (CachingControlEvent)event;
                CachingControl cc = e.getCachingControl();
                long progress = cc.getContentProgress();
                long len = cc.getContentLength();
                String s = "loading ";
                s = len == Long.MAX_VALUE || len == 0L ? s + "(" + progress + " bytes)" : (len == progress ? s + "done" : s + "(" + progress * (long)100 / len + "%)");
                this.firePropertyChange("statusLine", null, s);
            } else if (event instanceof EndOfMediaEvent) {
                this.firePropertyChange("jmfEvent", this.mediaFile, "endOfMedia");
            } else if (event instanceof ControllerErrorEvent) {
                this.player = null;
                this.Fatal(((ControllerErrorEvent)event).getMessage());
            } else if (event instanceof ControllerClosedEvent) {
                this.panel.removeAll();
            } else {
                try {
                    Class.forName("com.sun.media.SizeChangeEvent");
                    if (event instanceof SizeChangeEvent) {
                        SizeChangeEvent sce = (SizeChangeEvent)event;
                        int nooWidth = sce.getWidth();
                        int nooHeight = sce.getHeight();
                        if (nooWidth != this.videoWidth || nooHeight != this.videoHeight) {
                            this.videoWidth = nooWidth;
                            this.videoHeight = nooHeight;
                        }
                        this.panel.setSize(this.videoWidth, this.videoHeight + this.controlPanelHeight);
                        this.visualComponent.setBounds(0, 0, this.videoWidth, this.videoHeight);
                        if (this.controlComponent != null) {
                            this.controlComponent.setBounds(0, this.videoHeight, this.videoWidth, this.controlPanelHeight);
                            this.controlComponent.invalidate();
                        }
                        this.panel.validate();
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }

    public void playerStart() {
        this.player.start();
    }

    public void playerStop() {
        this.player.stop();
    }

    private void setCursor(Cursor theCursor) {
        if (this.panel != null) {
            this.panel.setCursor(theCursor);
        }
    }

    public ThePilot() {
        this.$init$();
    }
}

