/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

class FormInputButton
extends JButton
implements ObjectPainter,
Movable {
    private DocView docView;
    private Border _originalBorder;
    private boolean paintBordersOurselves;
    private DInputElement element;
    private ObjectBox box;
    private boolean borderDrawingEnabled;

    private void $init$() {
        this._originalBorder = this.getBorder();
        this.paintBordersOurselves = false;
        this.borderDrawingEnabled = true;
    }

    FormInputButton(DocView docView, DElement e, String type) {
        super(type);
        this.$init$();
        this.docView = docView;
        this.element = (DInputElement)e;
        String v = this.element.getValue();
        if (v != null) {
            this.setText(v);
        } else {
            this.setText(type);
            this.element.setValue(type);
        }
        this.checkAttributes();
        this.validateTree();
    }

    public void paintComponent(Graphics g) {
        if (this.isShowing()) {
            if (this.borderDrawingEnabled) {
                if (this.paintBordersOurselves) {
                    g.setColor(this.getBackground());
                    g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                    g.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, this.model.isArmed() ^ true);
                }
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
        } else {
            this.paintButtonOurselves(g);
        }
    }

    private void paintButtonOurselves(Graphics g) {
        try {
            String text = this.element.getValue();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int height = fontMetrics.getDescent();
            int width = fontMetrics.stringWidth(text);
            if (this.borderDrawingEnabled) {
                g.setColor(this.getBackground());
                g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                g.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, this.model.isArmed() ^ true);
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Color c = this.getForeground();
            if (!this.isEnabled()) {
                c = UIManager.getColor("Button.foreground");
            }
            g.setColor(c);
            g.drawString(text, (this.getWidth() + 1 - width) / 2, (this.getHeight() + 1) / 2 + height);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void checkAttributes() {
        this.setEnabled(this.element.getDisabled() ^ true);
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        String s = this.element.getValue();
        if (s != null && !s.equals(this.getText())) {
            this.updateFont();
            this.setText(s);
            this.box.invalidate();
            this.box.reqReflow();
        } else {
            this.checkAttributes();
        }
    }

    private void updateFont() {
        if (this.box != null) {
            String s = this.getText();
            Font f = this.box.getCSSAttribs().getTestedFont(s);
            if (!f.equals(this.getFont())) {
                this.setFont(f);
            }
        }
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        if (box != null) {
            CSSAttribs css = box.getCSSAttribs();
            Image image = (Image)css.getBackgroundImage();
            if (image != null) {
                ImageIcon ii = new ImageIcon(image);
                this.setIcon(ii);
            }
            this.setHorizontalTextPosition(0);
        }
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics g) {
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
        if (!aDrawBorder) {
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.borderDrawingEnabled = false;
        } else {
            if (!this.paintBordersOurselves) {
                this.setBorder(this._originalBorder);
                this.setContentAreaFilled(true);
            }
            this.borderDrawingEnabled = true;
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (bg.equals(UIManager.getColor("Button.background"))) {
            this.paintBordersOurselves = false;
            if (this.borderDrawingEnabled) {
                this.setBorder(this._originalBorder);
                this.setContentAreaFilled(true);
            }
        } else {
            this.paintBordersOurselves = true;
            this.setContentAreaFilled(false);
        }
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    public int getClientHeight() {
        Insets i = this.getInsets();
        return this.getFont().getSize() + i.top + i.bottom;
    }

    public int getClientWidth() {
        Border b = this.getBorder();
        Insets i = b.getBorderInsets(this);
        return this.getWidth() - i.left - i.right;
    }
}

