/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CharacterAttributes;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ScreenReaderStatusComponent;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.swing.AccessibleLinkIndex;
import ice.pilots.html4.swing.DocView;
import ice.util.encoding.CharIO;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class AccessibleHypertextPanel
extends AccessibleContext
implements AccessibleHypertext,
EventListener {
    protected DocView docView;
    protected ThePilot htmlPilot;
    protected AccessibleContext defaultContext;
    protected Html4DocumentAccess accessProvider;
    protected AccessibleLinkIndex linkIndex;
    protected ScreenReaderStatusComponent status;
    public static final int NONE = 0;
    public static final int NEXT = 1;
    public static final int PREVIOUS = 2;

    public AccessibleHypertextPanel(DocView docView, AccessibleContext defaultContext, ScreenReaderStatusComponent status) {
        this.docView = docView;
        this.defaultContext = defaultContext;
        this.status = status;
        this.init();
    }

    protected AccessibleContext getAccessibleContext() {
        return this.defaultContext;
    }

    private void init() {
        this.htmlPilot = this.docView.getPilot();
        this.accessProvider = new Html4DocumentAccess(this.htmlPilot);
        this.htmlPilot.addPersistentDOMEventListener("load", this, true);
        this.htmlPilot.addPersistentDOMEventListener("unload", this, true);
        this.htmlPilot.addPersistentDOMEventListener("keyup", this, true);
        this.htmlPilot.addPersistentDOMEventListener("focus", this, true);
        this.htmlPilot.addPersistentDOMEventListener("goto", this, true);
        this.handleLoad(null);
        DDocument ddoc = this.htmlPilot.getDDocument();
        this.setAccessibleName(ddoc.getTitle());
        this.setAccessibleDescription(ddoc.getTitle());
        this.setAccessibleParent(this.defaultContext.getAccessibleParent());
    }

    public AccessibleText getAccessibleText() {
        return this;
    }

    public AccessibleComponent getAccessibleComponent() {
        return this.defaultContext.getAccessibleComponent();
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TEXT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        return this.defaultContext.getAccessibleStateSet();
    }

    public int getAccessibleIndexInParent() {
        return -1;
    }

    public int getAccessibleChildrenCount() {
        return this.defaultContext.getAccessibleChildrenCount();
    }

    public Accessible getAccessibleChild(int accessibleIndex) {
        return this.defaultContext.getAccessibleChild(accessibleIndex);
    }

    public Locale getLocale() throws IllegalComponentStateException {
        Locale locale = null;
        String pilotEncoding = this.htmlPilot.getEncoding();
        if (pilotEncoding != null) {
            locale = CharIO.getEncodingLocale(pilotEncoding);
        }
        if (locale == null) {
            this.defaultContext.getLocale();
        }
        if (locale == null) {
            locale = this.docView.docPanel.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public int getLinkCount() {
        return this.linkIndex.getLinkCount();
    }

    public AccessibleHyperlink getLink(int linkIndex) {
        return this.linkIndex.getLink(linkIndex, this.docView);
    }

    public int getLinkIndex(int charIndex) {
        if (this.isBadIndex(charIndex)) {
            return -1;
        }
        DNode indexNode = this.accessProvider.getNodeByIndex(1, charIndex);
        if (indexNode == null) {
            return -1;
        }
        if (indexNode instanceof DAnchorElement) {
            return this.linkIndex.getIndexFromNode((DAnchorElement)indexNode);
        }
        DNode parent = indexNode.getParentDNode();
        if (parent instanceof DAnchorElement) {
            return this.linkIndex.getIndexFromNode((DAnchorElement)parent);
        }
        return -1;
    }

    public int getIndexAtPoint(Point p) {
        if (p == null) {
            return -1;
        }
        return this.accessProvider.getIndexAtPoint(p.x, p.y, this.docView.getScrollX(), this.docView.getScrollY());
    }

    public Rectangle getCharacterBounds(int i) {
        return new Rectangle();
    }

    public int getCharCount() {
        return this.accessProvider.getCount(1);
    }

    public int getCaretPosition() {
        return this.accessProvider.getCaretPosition(1);
    }

    public String getAtIndex(int part, int index) {
        return this.getText(part, index, 0);
    }

    public String getAfterIndex(int part, int index) {
        return this.getText(part, index, 1);
    }

    public String getBeforeIndex(int part, int index) {
        return this.getText(part, index, 2);
    }

    private String getText(int part, int index, int direction) {
        String text = null;
        int textType = this.mapJavaToICETextType(part);
        if (textType < 0) {
            return text;
        }
        this.accessProvider.positionToIndex(1, index);
        switch (direction) {
            case 0: {
                text = this.accessProvider.getCurrentText(textType);
                break;
            }
            case 2: {
                text = this.accessProvider.getPrevious(textType);
                break;
            }
            case 1: {
                text = this.accessProvider.getNext(textType);
                break;
            }
        }
        return text;
    }

    public AttributeSet getCharacterAttribute(int charIndex) {
        if (this.isBadIndex(charIndex)) {
            return null;
        }
        CharacterAttributes attributes = this.accessProvider.getCharAttributes(charIndex);
        if (attributes == null) {
            return null;
        }
        return this.getAttributeSet(attributes);
    }

    private AttributeSet getAttributeSet(CharacterAttributes cssAttributes) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        this.addAttributeSafely(set, CSS.Attribute.BACKGROUND_COLOR, CharacterAttributes.background_color);
        this.addAttributeSafely(set, CSS.Attribute.BACKGROUND_IMAGE, CharacterAttributes.background_image);
        this.addAttributeSafely(set, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_bottom_color);
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_bottom_style));
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_bottom_width));
        this.addAttributeSafely(set, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_left_color);
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_left_style));
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_left_width));
        this.addAttributeSafely(set, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_right_color);
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_right_style));
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_right_width));
        this.addAttributeSafely(set, CSS.Attribute.BORDER_COLOR, CharacterAttributes.border_top_color);
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM, new Integer(CharacterAttributes.border_top_style));
        set.addAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH, new Integer(CharacterAttributes.border_top_width));
        set.addAttribute(CSS.Attribute.FONT_FAMILY, new Integer(CharacterAttributes.font_family));
        set.addAttribute(CSS.Attribute.FONT_SIZE, new Integer(CharacterAttributes.font_size));
        set.addAttribute(CSS.Attribute.FONT_STYLE, new Integer(CharacterAttributes.font_style));
        set.addAttribute(CSS.Attribute.MARGIN_BOTTOM, new Integer(CharacterAttributes.margin_bottom));
        set.addAttribute(CSS.Attribute.MARGIN_LEFT, new Integer(CharacterAttributes.margin_left));
        set.addAttribute(CSS.Attribute.MARGIN_RIGHT, new Integer(CharacterAttributes.margin_right));
        set.addAttribute(CSS.Attribute.MARGIN_TOP, new Integer(CharacterAttributes.margin_top));
        set.addAttribute(CSS.Attribute.PADDING_BOTTOM, new Integer(CharacterAttributes.padding_bottom));
        set.addAttribute(CSS.Attribute.PADDING_LEFT, new Integer(CharacterAttributes.padding_left));
        set.addAttribute(CSS.Attribute.PADDING_RIGHT, new Integer(CharacterAttributes.padding_right));
        set.addAttribute(CSS.Attribute.PADDING_TOP, new Integer(CharacterAttributes.padding_top));
        set.addAttribute(CSS.Attribute.TEXT_ALIGN, new Integer(CharacterAttributes.text_align));
        set.addAttribute(CSS.Attribute.TEXT_DECORATION, new Byte(CharacterAttributes.text_decoration));
        set.addAttribute(CSS.Attribute.TEXT_INDENT, new Integer(CharacterAttributes.text_indent));
        set.addAttribute(CSS.Attribute.VERTICAL_ALIGN, new Integer(CharacterAttributes.vertical_align_type));
        this.addAttributeSafely(set, CSS.Attribute.COLOR, CharacterAttributes.color);
        set.addAttribute(CSS.Attribute.DISPLAY, new Integer(CharacterAttributes.display));
        this.addAttributeSafely(set, CSS.Attribute.COLOR, CharacterAttributes.outline_color);
        set.addAttribute(CSS.Attribute.HEIGHT, new Integer(CharacterAttributes.height));
        set.addAttribute(CSS.Attribute.LINE_HEIGHT, new Integer(CharacterAttributes.line_height));
        set.addAttribute(CSS.Attribute.LIST_STYLE_TYPE, new Byte(CharacterAttributes.listStyleType));
        return set;
    }

    private void addAttributeSafely(SimpleAttributeSet set, Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        set.addAttribute(key, value);
    }

    private boolean isBadIndex(int charIndex) {
        return charIndex < 0 || charIndex > this.getCharCount();
    }

    public int getSelectionStart() {
        return this.accessProvider.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.accessProvider.getSelectionEnd();
    }

    public String getSelectedText() {
        return this.accessProvider.getSelectedText();
    }

    public void handleEvent(Event event) {
        DOMEvent dEvent = (DOMEvent)event;
        DNode eventTarget = (DNode)event.getTarget();
        switch (dEvent.getTypeId()) {
            case 13: {
                if (eventTarget == null || eventTarget.getNameId() != 13) break;
                this.handleLoad(eventTarget);
                break;
            }
            case 14: {
                if (eventTarget == null || eventTarget.getNameId() != 13) break;
                this.handleUnLoad(eventTarget);
                break;
            }
            case 10: {
                DOMUIEvent uiEvent = (DOMUIEvent)event;
                this.handleKeyUp(uiEvent);
                break;
            }
            case 21: {
                if (eventTarget == null) break;
                this.handleFocus(eventTarget);
                break;
            }
            case 30: {
                if (eventTarget == null) break;
                this.handleGoto(eventTarget);
                break;
            }
        }
    }

    private void handleLoad(DNode eventTarget) {
        this.linkIndex = new AccessibleLinkIndex(this.accessProvider);
        this.linkIndex.processDoc(this.htmlPilot.getDDocument());
        this.firePropertyChange("AccessibleName", null, this.getAccessibleName());
        this.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
    }

    private void handleUnLoad(DNode eventTarget) {
        this.firePropertyChange("AccessibleName", this.getAccessibleName(), null);
        this.firePropertyChange("AccessibleText", Boolean.TRUE, Boolean.FALSE);
    }

    private void handleGoto(DNode eventTarget) {
        this.moveCaretToNode(eventTarget);
    }

    private void handleFocus(DNode eventTarget) {
        if (eventTarget != null) {
            this.moveCaretToNode(eventTarget);
            if (eventTarget instanceof DAnchorElement) {
                this.status.setScreenReaderStatus("LINK " + eventTarget.getInnerText());
            }
        }
    }

    private void moveCaretToNode(DNode node) {
        int charIndex = this.accessProvider.getIndexOfNode(node);
        this.updateCaretPosition(1, this.accessProvider.getCaretPosition(1), charIndex, 0);
    }

    private void handleKeyUp(DOMUIEvent uiEvent) {
        if (!this.docView.docPanel.hasFocus()) {
            return;
        }
        long keyCode = uiEvent.getKeyCode();
        if (keyCode == 0L) {
            return;
        }
        if (uiEvent.isShortcutKey()) {
            int wordPosition = this.accessProvider.getCaretPosition(2);
            int wordTotal = this.accessProvider.getCount(2);
            if (keyCode == (long)39 && wordPosition < wordTotal) {
                this.updateCaretPosition(2, wordPosition++, wordPosition, 1);
            }
            if (keyCode == (long)37 && wordPosition > 0) {
                this.updateCaretPosition(2, wordPosition--, wordPosition, 2);
            }
        } else {
            int charPosition = this.accessProvider.getCaretPosition(1);
            int charTotal = this.accessProvider.getCount(1);
            if (keyCode == (long)39 && charPosition < charTotal) {
                this.updateCaretPosition(1, charPosition++, charPosition, 1);
            }
            if (keyCode == (long)37 && charPosition > 0) {
                this.updateCaretPosition(1, charPosition--, charPosition, 2);
            }
        }
        int sentencePosition = this.accessProvider.getCaretPosition(3);
        int sentenceTotal = this.accessProvider.getCount(3);
        if (keyCode == (long)38 && sentencePosition > 0) {
            this.updateCaretPosition(3, sentencePosition--, sentencePosition, 2);
        }
        if (keyCode == (long)40 && sentencePosition < sentenceTotal) {
            this.updateCaretPosition(3, sentencePosition++, sentencePosition, 1);
        }
    }

    private void updateCaretPosition(int type, int oldIndex, int newIndex, int direction) {
        if (oldIndex != newIndex) {
            String item = null;
            if (direction == 1) {
                item = this.accessProvider.getNext(type);
            } else if (direction == 2) {
                item = this.accessProvider.getPrevious(type);
            } else {
                this.accessProvider.positionToIndex(type, newIndex);
                item = this.accessProvider.getCurrentText(type);
            }
            if (this.status != null && item != null) {
                this.status.setScreenReaderStatus(item);
            }
            this.firePropertyChange("AccessibleCaret", new Integer(oldIndex), new Integer(newIndex));
        }
    }

    public int mapJavaToICETextType(int accessibleTextType) {
        int textType = -1;
        switch (accessibleTextType) {
            case 1: {
                textType = 1;
                break;
            }
            case 2: {
                textType = 2;
                break;
            }
            case 3: {
                textType = 3;
                break;
            }
        }
        return textType;
    }
}

