/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.OutlinePainter;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableRowBox;
import ice.pilots.html4.TextBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class TableRowGroupBox
extends CSSBox {
    boolean rtlSet;
    CSSBox firstRow;
    CSSBox lastRow;
    private TableRowBox anonRow;
    int[] usedCols;
    int numUsedCols;
    int numRows;
    int realNumCols;

    private void $init$() {
        this.rtlSet = false;
    }

    void resetColInfo() {
        this.usedCols = new int[4];
        this.numUsedCols = 0;
    }

    void notifyChildrenGenerated() {
        if (!this.rtlSet) {
            return;
        }
        int max = 0;
        CSSBox b = this.firstRow;
        while (b != null) {
            TableRowBox trb = (TableRowBox)b;
            if (trb.numCols > max) {
                max = trb.numCols;
            }
            b = b.next;
        }
        CSSBox b2 = this.firstRow;
        while (b2 != null) {
            TableRowBox trb = (TableRowBox)b2;
            trb.reverseCells(max);
            b2 = b2.next;
        }
    }

    void adjustHeight() {
        CSSBox row = this.firstRow;
        int tot = 0;
        while (row != null) {
            tot += row.height;
            row = row.next;
        }
        row = this.firstRow;
        int dy = 0;
        while (row != null && tot > 0) {
            int tmp = row.height * this.height / tot;
            row.oy += dy;
            int extra = tmp - row.height;
            dy += extra;
            ((TableRowBox)row).adjustHeight(extra);
            row.height = tmp;
            row = row.next;
        }
    }

    TableRowGroupBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        super(e, css, cssLayout);
        this.$init$();
        this.resetColInfo();
    }

    void propagateVisibility(short b, boolean self) {
        boolean propagate;
        boolean bl = propagate = self ? this.setVisibility(b) : true;
        if (propagate) {
            CSSBox bb = this.firstRow;
            while (bb != null) {
                bb.propagateVisibility(b, true);
                bb = bb.next;
            }
        }
    }

    void dispose() {
        CSSBox b = this.firstRow;
        while (b != null) {
            CSSBox bn = b.next;
            b.dispose();
            b = bn;
        }
        this.lastRow = null;
        this.firstRow = null;
        this.anonRow = null;
        super.dispose();
        this.element = null;
    }

    CSSBox getFirstChild() {
        return this.firstRow;
    }

    void findAbsolutePosition(Point p) {
        p.y += this.oy;
        this.parentBox.findAbsolutePosition(p);
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        CSSBox fallback = null;
        int fallbackX = 0;
        int fallbackY = 0;
        CSSBox b = this.firstRow;
        while (b != null) {
            if (ey < b.oy) break;
            TableRowBox row = (TableRowBox)b;
            if ((row.numCellRows <= 1 || row.next == null) && ey < b.oy + b.height) {
                fallback = b.getBoxAt(ex, ey - b.oy, rv);
                if (fallback != b) {
                    return fallback;
                }
                fallbackX = rv.x;
                fallbackY = rv.y;
            }
            b = b.next;
        }
        CSSBox b2 = this.firstRow;
        while (b2 != null) {
            if (ey < b2.oy) break;
            TableRowBox row = (TableRowBox)b2;
            if (row.numCellRows > 1 && row.next != null) {
                CSSBox t = row.next;
                int i = row.numCellRows - 1;
                while (t.next != null && i > 1) {
                    if (ey < t.oy + t.height) break;
                    t = t.next;
                    --i;
                }
                if (ey < t.oy + t.height) {
                    CSSBox box = b2.getBoxAt(ex, ey - b2.oy, rv);
                    if (box != b2) {
                        return box;
                    }
                    if (fallback == null) {
                        fallback = b2;
                        fallbackX = rv.x;
                        fallbackY = rv.y;
                    }
                }
            }
            b2 = b2.next;
        }
        if (fallback != null) {
            rv.x = fallbackX;
            rv.y = fallbackY;
            return fallback;
        }
        rv.x = ex;
        rv.y = ey;
        return this;
    }

    DNode getDomNode() {
        return this.element;
    }

    void layout(int parentHeight) {
        int border_spacing_y = this.parentBox.css.border_spacing_y;
        CSSBox b = this.firstRow;
        if (this.css.background_image != null) {
            while (b != null) {
                if (b.css.background_image == null) {
                    b.css.background_image = this.css.background_image;
                    b.css.background_image_url = this.css.background_image_url;
                    b.css.background_params = this.css.background_params;
                    b.css.background_position_x = this.css.background_position_x;
                    b.css.background_position_y = this.css.background_position_y;
                }
                b = b.next;
            }
        }
        this.numRows = 0;
        b = this.firstRow;
        while (b != null) {
            b.height = 0;
            b.oy = 0;
            b = b.next;
            ++this.numRows;
        }
        TableRowBox row = (TableRowBox)this.firstRow;
        while (row != null) {
            row.layout(parentHeight);
            row = (TableRowBox)row.next;
        }
        row = (TableRowBox)this.firstRow;
        while (row != null) {
            TableCellBox cell = (TableCellBox)row.firstCell;
            while (cell != null) {
                if (cell.rowspan == 1 || row.next == null) {
                    cell.calcRowHeights(border_spacing_y);
                }
                cell = (TableCellBox)cell.next;
            }
            row = (TableRowBox)row.next;
        }
        row = (TableRowBox)this.firstRow;
        while (row != null) {
            TableCellBox cell = (TableCellBox)row.firstCell;
            while (cell != null) {
                if (cell.rowspan > 1 && row.next != null) {
                    cell.calcRowHeights(border_spacing_y);
                }
                cell = (TableCellBox)cell.next;
            }
            row = (TableRowBox)row.next;
        }
        row = (TableRowBox)this.firstRow;
        while (row != null) {
            TableCellBox cell = (TableCellBox)row.firstCell;
            while (cell != null) {
                cell.calcCellHeight(border_spacing_y);
                cell = (TableCellBox)cell.next;
            }
            row = (TableRowBox)row.next;
        }
        this.height = 0;
        b = this.firstRow;
        while (b != null) {
            b.oy = this.height;
            this.height += b.height + border_spacing_y;
            b = b.next;
        }
        if (this.height > 0) {
            this.height -= border_spacing_y;
        }
    }

    void paint(Graphics g) {
        Rectangle r = g.getClipBounds();
        TableBox tableBox = (TableBox)this.parentBox;
        OutlinePainter outlinePainter = this.cssLayout.outlinePainter;
        TableRowBox row = (TableRowBox)this.firstRow;
        while (row != null) {
            if (r.y + r.height < this.oy + row.oy) break;
            if (r.y < this.oy + row.oy + row.height) {
                outlinePainter.drawBox(g, row, 0, this.oy + row.oy);
            } else if (row.numCellRows > 1 && row.next != null) {
                CSSBox b = row.next;
                int i = row.numCellRows - 1;
                while (b.next != null && i > 1) {
                    b = b.next;
                    --i;
                }
                if (r.y < this.oy + b.oy + b.height) {
                    outlinePainter.translate(g, 0, this.oy + row.oy);
                    row.paint(g);
                    outlinePainter.translate(g, 0, -this.oy - row.oy);
                }
            }
            row = (TableRowBox)row.next;
        }
    }

    void setParentBox(CSSBox parentBox) {
        super.setParentBox(parentBox);
        CSSBox b = parentBox;
        while (b != null) {
            if (b instanceof TableBox) break;
            b = b.parentBox;
        }
        if (b != null && b.css.directionFlag == 1) {
            this.rtlSet = true;
        }
    }

    CSSBox addChild(CSSBox b) {
        if (b instanceof TableRowBox) {
            int i = 0;
            while (i < this.numUsedCols) {
                if (this.usedCols[i] > 0) {
                    int n = i;
                    this.usedCols[n] = this.usedCols[n] - 1;
                }
                ++i;
            }
            if (this.firstRow == null) {
                this.firstRow = this.lastRow = b;
                b.next = null;
            } else {
                this.lastRow.next = b;
                b.next = null;
                this.lastRow = b;
            }
            b.setParentBox(this);
            this.anonRow = null;
        } else {
            if (b instanceof TextBox && ((TextBox)b).isEmpty()) {
                return this;
            }
            TableRowBox r = this.anonRow;
            if (r == null) {
                CSSAttribs a = new CSSAttribs(this.cssLayout.sdata, this.css);
                a.display = 51;
                r = new TableRowBox(null, a, this.cssLayout);
                this.addChild(r);
                this.anonRow = r;
            }
            r.addChild(b);
        }
        return this;
    }

    int getCount(int aType, Point p) {
        int returnVal = 0;
        CSSBox box = this.firstRow;
        while (box != null) {
            returnVal += box.getCount(aType, p);
            box = box.next;
        }
        return returnVal;
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        CSSBox box = this.firstRow;
        while (box != null) {
            CSSBox returnVal = box.findChildByIndex_r(aType, aIndex, aPoint);
            if (returnVal != null) {
                return returnVal;
            }
            box = box.next;
        }
        return null;
    }

    public String toString() {
        return "tablerowgroup " + super.toString();
    }
}

