/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.SimpleSelector;

class Selector {
    byte pseudo;
    int weight;
    private SimpleSelector[] simpleSelectors;
    private int numSelectors;

    private void $init$() {
        this.pseudo = 0;
        this.weight = 0;
        this.simpleSelectors = new SimpleSelector[10];
        this.numSelectors = 0;
    }

    int getSelectorKey() {
        return this.simpleSelectors[this.numSelectors - 1].elementNameId;
    }

    String getUniversalClassKey() {
        return this.simpleSelectors[this.numSelectors - 1].getUniversalClassKey();
    }

    boolean isEmpty() {
        return this.numSelectors == 0;
    }

    void addSimpleSelector(SimpleSelector s) {
        this.pseudo = (byte)(this.pseudo | s.pseudo);
        int N = this.numSelectors;
        if (N == this.simpleSelectors.length) {
            SimpleSelector[] tmp = new SimpleSelector[N * 2 + 1];
            System.arraycopy(this.simpleSelectors, 0, tmp, 0, N);
            this.simpleSelectors = tmp;
        }
        this.simpleSelectors[N] = s;
        this.numSelectors = N + 1;
    }

    int computeWeight() {
        int i = 0;
        while (i != this.numSelectors) {
            SimpleSelector simple = this.simpleSelectors[i];
            this.weight += simple.computeWeight();
            ++i;
        }
        return this.weight;
    }

    boolean match(DElement e) {
        int i = this.numSelectors - 1;
        SimpleSelector ss = this.simpleSelectors[i];
        if (!ss.match(e)) {
            return false;
        }
        if (i == 0) {
            return true;
        }
        return this.matchSimpleSelector_r(e, i - 1);
    }

    private final boolean matchSimpleSelector_r(DElement e, int i) {
        SimpleSelector ss = this.simpleSelectors[i];
        int combinator = ss.combinator;
        if (combinator == 62) {
            DNode n = e.getParentDNode();
            if (!(n instanceof DElement)) {
                return false;
            }
            e = (DElement)n;
            if (!ss.match(e)) {
                return false;
            }
        } else if (combinator == 43) {
            DNode n = e.getPreviousDSibling();
            while (n != null && !(n instanceof DElement)) {
                n = n.getPreviousDSibling();
            }
            if (n == null) {
                return false;
            }
            e = (DElement)n;
            if (!ss.match(e)) {
                return false;
            }
        } else if (combinator == 32) {
            DNode n = e.getParentDNode();
            while (n != null) {
                if (!(n instanceof DElement)) {
                    return false;
                }
                if (ss.match((DElement)n)) {
                    if (i == 0) {
                        return true;
                    }
                    if (this.matchSimpleSelector_r((DElement)n, i - 1)) {
                        return true;
                    }
                }
                n = n.getParentDNode();
            }
            return false;
        }
        if (i == 0) {
            return true;
        }
        return this.matchSimpleSelector_r(e, i - 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.numSelectors) {
            sb.append(this.simpleSelectors[i]);
            ++i;
        }
        return sb.toString();
    }

    Selector() {
        this.$init$();
    }
}

