/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class OutlinePainter {
    private LineComputer outlineComputer;
    private Hashtable styles;
    private int transX;
    private int transY;

    private void $init$() {
        this.outlineComputer = new LineComputer();
        this.styles = new Hashtable();
        this.transX = 0;
        this.transY = 0;
    }

    void clear() {
        this.outlineComputer = new LineComputer();
        this.styles = new Hashtable();
        this.transY = 0;
        this.transX = 0;
    }

    boolean hasOutline() {
        return this.styles.isEmpty() ^ true;
    }

    void paint(Graphics g) {
        if (this.hasOutline()) {
            Enumeration s = this.styles.elements();
            while (s.hasMoreElements()) {
                StyleNode stl = (StyleNode)s.nextElement();
                Vector rects = stl.rectangles;
                Vector lines = this.computeOutline(rects);
                Vector polygons = new Polygons(lines).getPolygons();
                if (polygons == null) {
                    return;
                }
                Polygon p = null;
                g.setColor(stl.color);
                if (stl.color == null) {
                    g.setColor(Color.black);
                }
                int strokewidth = stl.width;
                int style = stl.style;
                int i = 0;
                while (i < polygons.size()) {
                    p = (Polygon)polygons.elementAt(i);
                    Vector polylines = new Polygons().getPolyLines(p);
                    Enumeration e = polylines.elements();
                    while (e.hasMoreElements()) {
                        MyLine line = (MyLine)e.nextElement();
                        int x1 = line.getP1().x;
                        int x2 = line.getP2().x;
                        int y1 = line.getP1().y;
                        int y2 = line.getP2().y;
                        int xdir = 1;
                        int ydir = 1;
                        strokewidth = stl.width;
                        style = stl.style;
                        if (strokewidth > 1) {
                            if (x1 == x2) {
                                if (p.contains(x1 + 1, (y1 + y2) / 2)) {
                                    xdir = -1;
                                }
                            } else if (p.contains((x1 + x2) / 2, y1 + 1)) {
                                ydir = -1;
                            }
                        }
                        if ((style = stl.style) == 168 | style == 148 | style == 149) {
                            int xadjust = 0;
                            int yadjust = 0;
                            if (xdir == -1) {
                                xadjust = -strokewidth;
                            }
                            if (ydir == -1) {
                                yadjust = -strokewidth;
                            }
                            strokewidth = stl.width;
                            CSSUtil.drawStyledLine(g, x1 + xadjust, y1 + yadjust, x2 + xadjust, y2 + yadjust, style, strokewidth);
                            continue;
                        }
                        if (stl.color == null) {
                            g.setColor(Color.black);
                        } else {
                            g.setColor(stl.color);
                        }
                        strokewidth = stl.width;
                        style = stl.style;
                        CSSUtil.drawStyledLine(g, x1, y1, x2, y2, style);
                        if (strokewidth <= 1) continue;
                        int k = 1;
                        while (k < strokewidth) {
                            if (x1 == x2) {
                                x1 += xdir;
                                x2 += xdir;
                                if (y1 < y2) {
                                    if (!p.contains(x1, y1 - 1)) {
                                        --y1;
                                    }
                                    if (!p.contains(x2, y2 + 1)) {
                                        ++y2;
                                    }
                                } else {
                                    if (!p.contains(x1, y1 + 1)) {
                                        ++y1;
                                    }
                                    if (!p.contains(x2, y2 - 1)) {
                                        --y2;
                                    }
                                }
                            } else {
                                y1 += ydir;
                                y2 += ydir;
                                if (x1 < x2) {
                                    if (!p.contains(x1 - 1, y1)) {
                                        --x1;
                                    }
                                    if (!p.contains(x2 + 1, y2)) {
                                        ++x2;
                                    }
                                } else {
                                    if (!p.contains(x1 + 1, y1)) {
                                        ++x1;
                                    }
                                    if (!p.contains(x2 - 1, y2)) {
                                        --x2;
                                    }
                                }
                            }
                            if (stl.color == null) {
                                g.setColor(Color.black);
                            } else {
                                g.setColor(stl.color);
                            }
                            style = stl.style;
                            CSSUtil.drawStyledLine(g, x1, y1, x2, y2, style);
                            ++k;
                        }
                    }
                    polylines = null;
                    ++i;
                }
                polygons = null;
            }
            this.styles.clear();
        }
        this.clear();
    }

    void addRectangle(CSSBox box, int x, int y, int w, int h) {
        if (box == null) {
            return;
        }
        CSSBox initiator = box.parentBox;
        while ((initiator.css.misc & 2) != 0 && initiator.css.outline_width == 0) {
            initiator = initiator.parentBox;
        }
        int strokewidth = initiator.css.outline_width;
        Color col = initiator.css.outline_color;
        if (col == null) {
            col = Color.black;
        }
        short style = initiator.css.outline_style;
        Rectangle r = new Rectangle(x, y, w, h);
        StyleNode stl = null;
        if (this.styles != null) {
            stl = (StyleNode)this.styles.get(initiator);
        }
        if (stl == null) {
            if (this.styles == null) {
                this.styles = new Hashtable();
            }
            stl = new StyleNode(initiator, style, col, strokewidth);
            this.styles.put(initiator, stl);
        }
        stl.addPointer(r);
        r.x += this.transX;
        r.y += this.transY;
    }

    Vector computeOutline(Vector rects) {
        Vector retval = null;
        if (this.hasOutline()) {
            retval = this.outlineComputer.computeLines(this.outlineComputer.digest(rects));
            rects.removeAllElements();
        }
        return retval;
    }

    void drawBox(Graphics g, CSSBox box, int dx, int dy) {
        this.translate(g, dx, dy);
        box.paint(g);
        this.translate(g, -dx, -dy);
    }

    void translate(Graphics g, int dx, int dy) {
        g.translate(dx, dy);
        this.transX += dx;
        this.transY += dy;
    }

    OutlinePainter() {
        this.$init$();
    }

    class MyLine {
        private Point P1;
        private Point P2;

        public MyLine() {
            this.P1 = null;
            this.P2 = null;
        }

        public MyLine(Point p1, Point p2) {
            this.P1 = p1;
            this.P2 = p2;
        }

        public MyLine(int x1, int y1, int x2, int y2) {
            this.P1 = new Point(x1, y1);
            this.P2 = new Point(x2, y2);
        }

        public Point getP1() {
            return this.P1;
        }

        public Point getP2() {
            return this.P2;
        }
    }

    class LineComputer {
        Vector lines;
        Vector outline;
        int xoffset;
        int yoffset;

        private void $init$() {
            this.lines = null;
            this.xoffset = 5;
            this.yoffset = 5;
        }

        public LineComputer() {
            this.$init$();
        }

        public LineComputer(Vector rects) {
            this.$init$();
            if (rects != null) {
                this.lines = this.digest(rects);
                this.outline = this.computeLines(this.lines);
            } else if (Debug.trace) {
                Debug.trace("WARNING: rectangle vector is null");
            }
        }

        Vector digest(Vector rects) {
            Rectangle r = null;
            Vector<MyLine> lineVec = new Vector<MyLine>();
            Enumeration e = rects.elements();
            while (e.hasMoreElements()) {
                r = (Rectangle)e.nextElement();
                lineVec.addElement(new MyLine(r.x, r.y, r.x + r.width, r.y));
                lineVec.addElement(new MyLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height));
                lineVec.addElement(new MyLine(r.x, r.y, r.x, r.y + r.height));
                lineVec.addElement(new MyLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height));
            }
            Enumeration e2 = lineVec.elements();
            while (e2.hasMoreElements()) {
                MyLine l = (MyLine)e2.nextElement();
            }
            return lineVec;
        }

        Vector computeLines(Vector lines) {
            this.outline = null;
            boolean moreAlignments = true;
            while (moreAlignments) {
                moreAlignments = false;
                Enumeration e = lines.elements();
                while (e.hasMoreElements()) {
                    MyLine line;
                    if (this.outline == null) {
                        this.outline = new Vector();
                        int i = 0;
                        while (i < 4) {
                            line = (MyLine)e.nextElement();
                            this.outline.addElement(line);
                            ++i;
                        }
                    }
                    if (!e.hasMoreElements()) break;
                    line = (MyLine)e.nextElement();
                    MyLine[] newLines = new MyLine[4];
                    boolean aligned = false;
                    Enumeration o = this.outline.elements();
                    while (o.hasMoreElements() && !aligned) {
                        MyLine outl = (MyLine)o.nextElement();
                        if (this.verticallyAligned(line, outl)) {
                            aligned = true;
                            this.outline.removeElement(outl);
                            newLines = this.cutVerticalLines(line, outl);
                            continue;
                        }
                        if (!this.horizontallyAligned(line, outl)) continue;
                        aligned = true;
                        this.outline.removeElement(outl);
                        newLines = this.cutHorizontalLines(line, outl);
                    }
                    if (!aligned) {
                        this.outline.insertElementAt(line, 0);
                        continue;
                    }
                    moreAlignments = true;
                    int k = 0;
                    while (k < newLines.length) {
                        if (newLines[k] != null) {
                            this.outline.insertElementAt(newLines[k], 0);
                        }
                        ++k;
                    }
                }
                if (!moreAlignments) continue;
                lines = this.outline;
                this.outline = new Vector();
            }
            return this.outline;
        }

        boolean verticallyAligned(MyLine a, MyLine b) {
            if (a.getP1().x == a.getP2().x && b.getP1().x == b.getP2().x && Math.abs(a.getP1().x - b.getP1().x) <= this.xoffset) {
                int Bmin;
                int Bmax;
                int Amax = a.getP2().y;
                int Amin = a.getP1().y;
                if (Amax < Amin) {
                    int temp = Amax;
                    Amax = Amin;
                    Amin = temp;
                }
                if ((Bmax = b.getP2().y) < (Bmin = b.getP1().y)) {
                    int temp = Bmax;
                    Bmax = Bmin;
                    Bmin = temp;
                }
                if (Amax - Amin <= this.xoffset | Bmax - Bmin <= this.xoffset) {
                    return false;
                }
                if ((Amin <= Bmin && Bmin <= Amax) | (Bmin < Amin && Amin <= Bmax)) {
                    return this.xoffset <= 0 || a.getP1().x == b.getP1().x || !(Bmin == Amax | Amin == Bmax);
                }
            }
            return false;
        }

        boolean horizontallyAligned(MyLine a, MyLine b) {
            if (a.getP1().y == a.getP2().y && b.getP1().y == b.getP2().y && Math.abs(a.getP1().y - b.getP1().y) <= this.yoffset) {
                int Bmin;
                int Bmax;
                int Amax = a.getP2().x;
                int Amin = a.getP1().x;
                if (Amax < Amin) {
                    int temp = Amax;
                    Amax = Amin;
                    Amin = temp;
                }
                if ((Bmax = b.getP2().x) < (Bmin = b.getP1().x)) {
                    int temp = Bmax;
                    Bmax = Bmin;
                    Bmin = temp;
                }
                if (Amax - Amin <= this.yoffset | Bmax - Bmin <= this.yoffset) {
                    return false;
                }
                if ((Amin <= Bmin && Bmin <= Amax) | (Bmin < Amin && Amin <= Bmax)) {
                    return this.yoffset <= 0 || a.getP1().y == b.getP1().y || !(Bmin == Amax | Amin == Bmax);
                }
            }
            return false;
        }

        MyLine[] cutVerticalLines(MyLine A, MyLine B) {
            MyLine[] nuLines = new MyLine[4];
            if (Math.abs(A.getP2().y - A.getP1().y) < Math.abs(B.getP2().y - B.getP1().y)) {
                MyLine temp = A;
                A = B;
                B = temp;
            }
            Point A1 = A.getP1();
            Point A2 = A.getP2();
            Point B1 = B.getP1();
            Point B2 = B.getP2();
            if (A1.y > A2.y) {
                Point temp = A1;
                A1 = A2;
                A2 = temp;
            }
            if (B1.y > B2.y) {
                Point temp = B1;
                B1 = B2;
                B2 = temp;
            }
            int Amin = A1.y;
            int Amax = A2.y;
            int Bmin = B1.y;
            int Bmax = B2.y;
            nuLines[0] = null;
            nuLines[1] = null;
            nuLines[2] = null;
            nuLines[3] = null;
            if (Amin <= Bmin && Bmin <= Amax) {
                if (Bmin == Amin) {
                    if (Bmax == Amax) {
                        if (this.xoffset > 0 && A1.x != B1.x) {
                            nuLines[0] = new MyLine(A1.x, A1.y, B1.x, B1.y);
                            nuLines[1] = new MyLine(A2.x, A2.y, B2.x, B2.y);
                        }
                    } else if (this.xoffset > 0 && A1.x != B1.x) {
                        nuLines[1] = new MyLine(A1.x, A1.y, B1.x, B1.y);
                        nuLines[2] = new MyLine(B2.x, B2.y, A2.x, B2.y);
                        nuLines[3] = new MyLine(A1.x, B2.y, A2.x, A2.y);
                    } else {
                        nuLines[0] = new MyLine(B2, A2);
                    }
                } else if (Bmin == Amax) {
                    if (this.xoffset <= 0 || A1.x == B1.x) {
                        nuLines[0] = new MyLine(A1, B2);
                    }
                } else if (this.xoffset > 0 && A1.x != B1.x) {
                    nuLines[0] = new MyLine(A1.x, A1.y, A1.x, B1.y);
                    nuLines[1] = new MyLine(B1.x, B1.y, A1.x, B1.y);
                    if (Amax > Bmax) {
                        nuLines[2] = new MyLine(B2.x, B2.y, A1.x, B2.y);
                        nuLines[3] = new MyLine(A1.x, B2.y, A2.x, A2.y);
                    } else {
                        nuLines[2] = new MyLine(A2.x, A2.y, B2.x, A2.y);
                        if (Amax != Bmax) {
                            nuLines[3] = new MyLine(B2.x, A2.y, B2.x, B2.y);
                        }
                    }
                } else {
                    nuLines[0] = new MyLine(A1, B1);
                    nuLines[1] = Amax == Bmax ? null : new MyLine(A2, B2);
                }
            } else if (Bmin < Amin && Amin <= Bmax) {
                if (Amin == Bmax) {
                    if (this.xoffset <= 0 || A1.x == B1.x) {
                        nuLines[0] = new MyLine(B1, A2);
                    }
                } else if (this.yoffset > 0 && A1.x != B1.x) {
                    nuLines[0] = new MyLine(B1.x, B1.y, B1.x, A1.y);
                    nuLines[1] = new MyLine(B1.x, A1.y, A1.x, A1.y);
                    nuLines[2] = new MyLine(B2.x, B2.y, A2.x, B2.y);
                    nuLines[3] = new MyLine(A2.x, B2.y, A2.x, A2.y);
                } else {
                    nuLines[0] = new MyLine(B1, A1);
                    nuLines[1] = new MyLine(B2, A2);
                }
            }
            return nuLines;
        }

        MyLine[] cutHorizontalLines(MyLine A, MyLine B) {
            MyLine[] nuLines = new MyLine[4];
            if (Math.abs(A.getP2().x - A.getP1().x) < Math.abs(B.getP2().x - B.getP1().x)) {
                MyLine temp = A;
                A = B;
                B = temp;
            }
            Point A1 = A.getP1();
            Point A2 = A.getP2();
            Point B1 = B.getP1();
            Point B2 = B.getP2();
            if (A1.x > A2.x) {
                Point temp = A1;
                A1 = A2;
                A2 = temp;
            }
            if (B1.x > B2.x) {
                Point temp = B1;
                B1 = B2;
                B2 = temp;
            }
            int Amin = A1.x;
            int Amax = A2.x;
            int Bmin = B1.x;
            int Bmax = B2.x;
            nuLines[3] = null;
            nuLines[2] = null;
            nuLines[1] = null;
            nuLines[0] = null;
            if (Amin <= Bmin && Bmin <= Amax) {
                if (Bmin == Amin) {
                    if (Bmax == Amax) {
                        if (this.yoffset > 0 && A1.y != B1.y) {
                            nuLines[0] = new MyLine(A1.x, A1.y, B1.x, B1.y);
                            nuLines[1] = new MyLine(A2.x, A2.y, B2.x, B2.y);
                        }
                    } else if (this.yoffset > 0 && A1.y != B1.y) {
                        nuLines[1] = new MyLine(A1.x, A1.y, B1.x, B1.y);
                        nuLines[2] = new MyLine(B2.x, B2.y, B2.x, A2.y);
                        nuLines[3] = new MyLine(B2.x, A2.y, A2.x, A2.y);
                    } else {
                        nuLines[0] = new MyLine(B2, A2);
                    }
                } else if (Bmin != Amax) {
                    if (this.yoffset > 0 && A1.y != B1.y) {
                        nuLines[0] = new MyLine(A1.x, A1.y, B1.x, A1.y);
                        nuLines[1] = new MyLine(B1.x, A1.y, B1.x, B1.y);
                        if (Amax > Bmax) {
                            nuLines[2] = new MyLine(B2.x, B2.y, B2.x, A2.y);
                            nuLines[3] = new MyLine(B2.x, A2.y, A2.x, A2.y);
                        } else {
                            nuLines[2] = new MyLine(A2.x, A2.y, A2.x, B2.y);
                            if (Bmax != Amax) {
                                nuLines[3] = new MyLine(A2.x, B2.y, B2.x, B2.y);
                            }
                        }
                    } else {
                        nuLines[0] = new MyLine(A1, B1);
                        nuLines[1] = Amax == Bmax ? null : new MyLine(A2, B2);
                    }
                } else if (Bmin == Amax && (this.yoffset <= 0 || A1.y == B1.y)) {
                    nuLines[0] = new MyLine(A1, B2);
                }
            } else if (Bmin < Amin && Amin <= Bmax) {
                if (Amin == Bmax) {
                    if (this.yoffset > 0 && A1.y != B1.y) {
                        nuLines[0] = A;
                        nuLines[1] = B;
                    } else {
                        nuLines[0] = new MyLine(B1, A2);
                    }
                } else if (this.yoffset > 0 && A1.y != B1.y) {
                    nuLines[0] = new MyLine(B1.x, B1.y, A1.x, B1.y);
                    nuLines[1] = new MyLine(A1.x, B1.y, A1.x, A1.y);
                    nuLines[2] = new MyLine(B2.x, B2.y, B2.x, A2.y);
                    nuLines[3] = new MyLine(B2.x, A2.y, A2.x, A2.y);
                } else {
                    nuLines[0] = new MyLine(B1, A1);
                    nuLines[1] = new MyLine(B2, A2);
                }
            }
            return nuLines;
        }
    }

    class Polygons {
        private Hashtable points;
        private Vector polys;

        public Polygons(Vector lines) {
            if (lines != null) {
                this.initializePoints(lines);
                this.buildPol(lines);
            }
        }

        public Polygons() {
        }

        public Vector getPolygons() {
            return this.polys;
        }

        private void buildPol(Vector lines) {
            this.polys = new Vector();
            Enumeration theLines = lines.elements();
            if (!theLines.hasMoreElements()) {
                return;
            }
            MyLine l = (MyLine)theLines.nextElement();
            while (theLines.hasMoreElements() && !this.points.isEmpty()) {
                boolean notUsed = true;
                while (notUsed && theLines.hasMoreElements()) {
                    new String();
                    new String();
                    String p1key = String.valueOf(l.getP1().x).concat(String.valueOf(l.getP1().y));
                    if (this.points.containsKey(p1key) && ((PointNode)this.points.get((Object)p1key)).endpoints[0].equals(l.getP2())) {
                        notUsed = false;
                        continue;
                    }
                    l = (MyLine)theLines.nextElement();
                }
                Point e1 = l.getP1();
                Point e2 = l.getP2();
                new String();
                new String();
                String e1key = String.valueOf(e1.x).concat(String.valueOf(e1.y));
                new String();
                new String();
                String e2key = String.valueOf(e2.x).concat(String.valueOf(e2.y));
                PointNode node = (PointNode)this.points.get(e2key);
                Polygon P = new Polygon();
                P.addPoint(e1.x, e1.y);
                this.points.remove(e1key);
                while (node != null) {
                    P.addPoint(e2.x, e2.y);
                    this.points.remove(e2key);
                    Point temp = e2;
                    e2 = !node.endpoints[0].equals(e1) ? node.endpoints[0] : node.endpoints[1];
                    e1 = temp;
                    new String();
                    new String();
                    e2key = String.valueOf(e2.x).concat(String.valueOf(e2.y));
                    node = (PointNode)this.points.get(e2key);
                }
                this.polys.addElement(P);
            }
        }

        private void initializePoints(Vector lines) {
            this.points = new Hashtable();
            Enumeration e = lines.elements();
            while (e.hasMoreElements()) {
                PointNode node;
                MyLine l = (MyLine)e.nextElement();
                Point p1 = l.getP1();
                Point p2 = l.getP2();
                new String();
                new String();
                String e1key = String.valueOf(p1.x).concat(String.valueOf(p1.y));
                if (this.points.containsKey(e1key)) {
                    node = (PointNode)this.points.get(e1key);
                    node.endpoints[1] = p2;
                } else {
                    node = new PointNode(e1key);
                    node.endpoints[0] = p2;
                    this.points.put(e1key, node);
                }
                new String();
                new String();
                String e2key = String.valueOf(p2.x).concat(String.valueOf(p2.y));
                node = null;
                if (this.points.containsKey(e2key)) {
                    node = (PointNode)this.points.get(e2key);
                    node.endpoints[1] = p1;
                    continue;
                }
                node = new PointNode(e2key);
                node.endpoints[0] = p1;
                this.points.put(e2key, node);
            }
        }

        Vector getPolyLines(Polygon p) {
            Vector<MyLine> polylines = new Vector<MyLine>();
            if (p.npoints >= 2) {
                MyLine l;
                int i = 1;
                while (i < p.npoints) {
                    l = new MyLine(p.xpoints[i - 1], p.ypoints[i - 1], p.xpoints[i], p.ypoints[i]);
                    polylines.addElement(l);
                    ++i;
                }
                l = new MyLine(p.xpoints[p.npoints - 1], p.ypoints[p.npoints - 1], p.xpoints[0], p.ypoints[0]);
                polylines.addElement(l);
            }
            return polylines;
        }

        class PointNode {
            String location;
            Point[] endpoints;

            public PointNode(String loc) {
                this.location = loc;
                this.endpoints = new Point[2];
            }
        }
    }

    class StyleNode {
        int style;
        Color color;
        int width;
        CSSBox initiator;
        Vector rectangles;

        public StyleNode(CSSBox init, int stl, Color col, int w) {
            this.initiator = init;
            this.style = stl;
            this.color = col;
            this.width = w;
            this.rectangles = new Vector();
        }

        public void addPointer(Rectangle r) {
            this.rectangles.addElement(r);
        }

        public boolean equals(StyleNode n) {
            return this.initiator.equals(n.initiator);
        }
    }
}

