/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.util.Stack;

class HtmlDOMFixer {
    private static final int TSET_LEAF = 0;
    private static final int TSET_SPAN = 1;
    private static final int TSET_BODY = 2;
    private static final int TSET_ADDRESS = 3;
    private static final int TSET_DIV = 4;
    private static final int TSET_A = 5;
    private static final int TSET_MAP = 6;
    private static final int TSET_OBJECT = 7;
    private static final int TSET_PRE = 8;
    private static final int TSET_DL = 9;
    private static final int TSET_UL = 10;
    private static final int TSET_FORM = 11;
    private static final int TSET_LABEL = 12;
    private static final int TSET_SELECT = 13;
    private static final int TSET_OPTGROUP = 14;
    private static final int TSET_OPTION = 15;
    private static final int TSET_FIELDSET = 16;
    private static final int TSET_BUTTON = 17;
    private static final int TSET_TABLE = 18;
    private static final int TSET_TBODY = 19;
    private static final int TSET_COLGROUP = 20;
    private static final int TSET_TR = 21;
    private static final int TSET_HEAD = 22;
    private static final int TSET_SCRIPT = 23;
    private static final int TSET_HTML = 24;
    private static final int TSET_FRAMESET = 25;
    private static final int TSET_DOCUMENT = 26;
    private static final int TSET_NOSCRIPT = 27;
    private static final int LAST_TSET = 27;
    private static final int NEED_END = 1;
    private static final int END_OPTIONAL = 2;
    private DDocument doc;
    private DMapElement latestMap;
    private DNode nodeToAdd;
    private boolean[] checked;
    private boolean check_required;
    private boolean head_exists;
    private boolean body_exists;
    private boolean html_exists;
    private boolean title_exists;
    DNode parentOfIllegalTitleNode;
    DNode hackTable;
    private DNode lastBreakNode;
    private boolean allowNoScript;
    private Stack isIndexElements;

    private void $init$() {
        this.check_required = true;
        this.head_exists = false;
        this.body_exists = false;
        this.html_exists = false;
        this.title_exists = false;
        this.allowNoScript = false;
    }

    HtmlDOMFixer(DDocument doc) {
        this.$init$();
        this.doc = doc;
    }

    void onClosingTR(DNode node) {
        DNode td = node.getLastDChild();
        if (td == null || td.getNameId() != 81) {
            return;
        }
        DNode n = td.getLastDChild();
        if (n == null || n.getNameId() != 92) {
            return;
        }
        DTextNode tn = (DTextNode)n;
        if (tn.text == null || tn.text.length != 1 || tn.text[0] != ' ') {
            return;
        }
        td.removeDChild(tn);
    }

    /*
     * Unable to fully structure code
     */
    boolean isFirstWhitespaceAllowed(DNode node) {
        if (node.getFirstChild() == null) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            t = node.getNameId();
            if (t == 64 || t == 26 || t == 81) {
                return false;
            }
            p = node.getParentDNode();
            if (p == null || p != null && p.getFirstChild() != node) break;
            node = p;
lbl9:
            // 2 sources

            ** while (node != null)
        }
lbl10:
        // 2 sources

        return true;
    }

    boolean tagsAreSynonymous(DElement element, int id) {
        boolean rtrn = false;
        switch (element.tagId) {
            case 31: {
                rtrn = id == 7 || id == 1;
                break;
            }
            case 7: {
                rtrn = id == 31 || id == 1;
                break;
            }
            case 1: {
                rtrn = id == 31 || id == 7;
                break;
            }
            case 3: {
                rtrn = id == 1;
                break;
            }
        }
        return rtrn;
    }

    boolean canCloseNodeWith(DNode node, int id) {
        int t = node.getNameId();
        switch (id) {
            case 58: 
            case 59: {
                return true;
            }
            case 60: {
                if (t != 45) break;
                return true;
            }
            case 81: {
                if (t != 71) break;
                return true;
            }
        }
        if (t >= 96) {
            return false;
        }
        return 1 != HtmlDOMFixer.getEndTagFlag(t);
    }

    DNode closeHackTable(boolean lastRow) {
        DNode tmp = this.hackTable;
        this.hackTable = null;
        return tmp;
    }

    boolean hasHackTable() {
        return this.hackTable != null;
    }

    void closeLastBreakNode() {
        if (this.lastBreakNode != null) {
            DNode nn = this.lastBreakNode;
            DNode pp = this.lastBreakNode.getParentDNode();
            while (nn != null && nn.getNameId() == 14) {
                DNode tmp = nn.getPreviousDSibling();
                pp.removeDChild(nn);
                nn = tmp;
            }
            this.lastBreakNode = null;
        }
    }

    DNode addChildNode(DNode parentNode, DNode node) {
        if (this.parentOfIllegalTitleNode != null) {
            return this.parentOfIllegalTitleNode;
        }
        this.nodeToAdd = node;
        int toFindId = node.getNameId();
        if (this.hackTable != null) {
            switch (toFindId) {
                case 16: 
                case 80: 
                case 81: 
                case 83: 
                case 85: 
                case 87: {
                    DNode tmp = this.hackTable;
                    this.hackTable = null;
                    return this.addChildNode(tmp, node);
                }
            }
            if (this.hackTable.getParentDNode() == parentNode && this.test_r(parentNode.getNameId(), toFindId)) {
                parentNode.insertBefore(node, this.hackTable);
                return node;
            }
        }
        if (this.lastBreakNode != null && parentNode == this.lastBreakNode.getParentDNode()) {
            this.lastBreakNode = null;
        }
        this.check_required = true;
        DNode n = this.do_fix_add(parentNode, node, toFindId);
        if (n == null) {
            this.check_required = false;
            n = this.do_fix_add(parentNode, node, toFindId);
            if (n == null) {
                int tmp = parentNode.getNameId();
                if (toFindId == 79 || tmp == 80) {
                    return this.addChildNode(parentNode.getParentDNode(), node);
                }
                if (tmp == 79 || tmp == 87 || tmp == 80) {
                    DNode t = parentNode;
                    while (t != null && t.getNameId() != 79) {
                        t = t.getParentDNode();
                    }
                    DNode pn = t.getParentDNode();
                    if (pn != null) {
                        pn.insertBefore(node, t);
                        switch (node.getNameId()) {
                            case 1: 
                            case 71: {
                                if (HtmlDOMFixer.get_child_index(node.getNameId()) == 0) break;
                                this.hackTable = t;
                                return node;
                            }
                        }
                    }
                }
            }
            if (n == null) {
                n = parentNode;
            }
        }
        return n;
    }

    void setAllowNoScript(boolean flag) {
        this.allowNoScript = flag;
    }

    void moveIsIndexElements() {
        if (this.isIndexElements != null) {
            DElement body = this.doc.getDBody();
            while (!this.isIndexElements.isEmpty()) {
                body.insertDChildBefore((DNode)this.isIndexElements.pop(), body.getFirstDChild());
            }
            this.isIndexElements.removeAllElements();
            this.isIndexElements = null;
        }
    }

    private DNode do_fix_add(DNode parentNode, DNode theChild, int toFindId) {
        int parentId = parentNode.getNameId();
        if (parentId >= 96 || toFindId >= 96) {
            parentNode.appendDChild(theChild);
            if (toFindId == 92) {
                return parentNode;
            }
            return theChild;
        }
        if (parentId == 93) {
            if (toFindId == 92) {
                return parentNode.appendDChild(theChild);
            }
            return this.do_fix_add(parentNode.getParentDNode(), theChild, toFindId);
        }
        if (toFindId == 46 && parentId == 1) {
            DNode tmp = parentNode.getFirstDChild();
            if (tmp != null && tmp.getNameId() == 92 && ((DTextNode)tmp).isEmpty()) {
                parentNode.removeDChild(tmp);
            }
            parentNode.appendDChild(theChild);
            return parentNode;
        }
        if (toFindId == 92 && parentId == 26) {
            DNode last;
            if (((DTextNode)theChild).isEmpty() && (last = parentNode.getLastDChild()) != null && last.getNameId() == 46) {
                return parentNode;
            }
        } else if (toFindId == 49) {
            boolean headContext = true;
            DNode par = parentNode;
            while (par.getNameId() != 43) {
                if (par.getNameId() == 13) {
                    headContext = false;
                    break;
                }
                par = par.getParentDNode();
            }
            if (headContext) {
                if (this.isIndexElements == null) {
                    this.isIndexElements = new Stack();
                }
                this.isIndexElements.addElement(theChild);
                return parentNode;
            }
        } else if (toFindId == 43) {
            if (this.html_exists) {
                return parentNode;
            }
            this.html_exists = true;
        } else if (toFindId == 13) {
            if (this.body_exists) {
                DElement old = this.doc.getDBody();
                if (theChild != null) {
                    if (old != null) {
                        old.copyAttrsFrom((DElement)theChild, false);
                        return parentNode;
                    }
                    this.doc.getDocumentDElement().appendDChild(theChild);
                    return theChild;
                }
                return null;
            }
            this.body_exists = true;
        }
        if (parentId == 43 && this.body_exists && toFindId == 14) {
            DElement body = parentNode.doc.getDBody();
            body.appendDChild(theChild);
            return theChild;
        }
        if (parentId == 59) {
            return this.allowNoScript ? parentNode.appendDChild(theChild) : parentNode;
        }
        if (parentId == 58 && toFindId != 33 && toFindId != 34 && !ThePilot.viewNoframes) {
            return parentNode;
        }
        int child_idx = HtmlDOMFixer.get_child_index(parentId);
        if (child_idx >= 0 && HtmlDOMFixer.checkHTML4Accept(child_idx, toFindId)) {
            return this.do_trivial_add(parentNode, theChild, toFindId, parentId);
        }
        if (toFindId == 92) {
            if (((DTextNode)theChild).isEmpty()) {
                return parentNode;
            }
        } else if (toFindId == 41) {
            if (this.head_exists) {
                return null;
            }
            this.head_exists = true;
        } else {
            DElement head;
            if (toFindId == 86 && this.title_exists) {
                this.parentOfIllegalTitleNode = parentNode;
                return this.parentOfIllegalTitleNode;
            }
            if (toFindId == 55) {
                this.latestMap = (DMapElement)theChild;
            } else if (toFindId == 6 && parentId != 55) {
                if (this.latestMap != null) {
                    this.latestMap.appendDChild(theChild);
                    return parentNode;
                }
            } else if (toFindId == 57 && this.head_exists && (head = this.doc.getHead()) != null) {
                head.appendDChild(theChild);
                return parentNode;
            }
        }
        this.checked = new boolean[96];
        DNode pn = parentNode;
        do {
            int test;
            if (parentId == 81 && toFindId == 87) {
                DElement tr = (DElement)pn.getParentDNode();
                if (tr.getSynthetic() && !pn.hasChildNodes()) {
                    tr.setSynthetic(false);
                    tr.copyAttrsFrom((DElement)theChild);
                    return pn;
                }
            } else {
                if (parentId == 60 && toFindId == 45) {
                    return pn;
                }
                if (parentId == 73 && toFindId == 26) {
                    return pn.appendDChild(theChild);
                }
                if (parentId == 43) {
                    if (this.body_exists && this.doc.getDBody() != null && this.test_r(13, toFindId)) {
                        return this.doc.getDBody().appendDChild(this.nodeToAdd);
                    }
                } else if (toFindId == 31 && parentId == 79) {
                    DElement tmp = this.doc.createElement(80);
                    tmp.setSynthetic(true);
                    pn.appendDChild(tmp);
                    DElement tmp2 = this.doc.createElement(87);
                    tmp2.setSynthetic(true);
                    tmp.appendDChild(tmp2);
                    tmp = tmp2;
                    tmp2 = this.doc.createElement(81);
                    tmp2.setSynthetic(true);
                    tmp.appendDChild(tmp2);
                    tmp = tmp2;
                    return tmp.appendDChild(theChild);
                }
            }
            if ((test = HtmlDOMFixer.get_child_index(parentId)) == 10) {
                if (toFindId == 64) {
                    pn.appendDChild(theChild);
                    return pn;
                }
                if (toFindId != 53 && !pn.hasChildNodes()) {
                    if (toFindId == 64) {
                        return pn.appendDChild(theChild);
                    }
                    DElement tmp = this.doc.createElement(53);
                    pn.appendDChild(tmp);
                    tmp.setSynthetic(true);
                    tmp.appendDChild(theChild);
                    return theChild;
                }
                if (theChild instanceof DTextNode) {
                    return this.do_fix_add(pn.getParentDNode(), theChild, toFindId);
                }
            } else {
                if (parentId == 7 && (toFindId == 64 || toFindId == 27 || toFindId == 25)) {
                    pn.appendDChild(theChild);
                    return theChild;
                }
                if (parentId == 1 && (toFindId == 64 || toFindId == 17 || toFindId == 26 || 35 <= toFindId && toFindId <= 40)) {
                    pn.appendDChild(theChild);
                    return theChild;
                }
                if (toFindId == 53 && parentId != 53 && parentId != 31) {
                    if (parentId == 64) {
                        DNode p_parent = pn.getParentDNode();
                        while (p_parent != null) {
                            if (p_parent.getNameId() == 53) {
                                p_parent.getParentDNode().appendDChild(theChild);
                                return theChild;
                            }
                            p_parent = p_parent.getParentDNode();
                        }
                    }
                    DNode tmpNode = pn;
                    while (tmpNode != null) {
                        DNode nextParent = tmpNode.getParentDNode();
                        if (nextParent != null) {
                            int nextParentId = nextParent.getNameId();
                            if (nextParentId == 1) {
                                DNode ancestor = nextParent.getParentDNode();
                                if (ancestor.getNameId() == 61) {
                                    ancestor.removeDChild(nextParent);
                                    this.nodeToAdd.appendDChild(nextParent);
                                    ancestor.appendDChild(this.nodeToAdd);
                                    return tmpNode;
                                }
                            } else if (nextParentId == 53) {
                                if (((DElement)nextParent).getSynthetic()) {
                                    ((DElement)nextParent).setSynthetic(false);
                                } else {
                                    nextParent.removeDChild(tmpNode);
                                    this.nodeToAdd.appendDChild(tmpNode);
                                    nextParent.getParentDNode().appendDChild(this.nodeToAdd);
                                }
                                return parentNode;
                            }
                            parentId = nextParentId;
                        }
                        tmpNode = nextParent;
                    }
                    if (parentId != 90) {
                        DElement tmp = this.doc.createElement(90);
                        tmp.setAttribute("style", "margin-left: 13px");
                        pn.appendDChild(tmp);
                        tmp.setSynthetic(true);
                        return tmp.appendDChild(theChild);
                    }
                } else if (toFindId == 53 && parentId == 53) {
                    pn = pn.getParentDNode();
                    pn.appendDChild(this.nodeToAdd);
                    return theChild;
                }
            }
            if (this.test_r(parentId, toFindId)) {
                if (this.nodeToAdd != null) {
                    pn.appendDChild(this.nodeToAdd);
                }
                if (HtmlDOMFixer.get_child_index(theChild.getNameId()) != 0) {
                    return theChild;
                }
                return theChild.getParentDNode();
            }
            if (pn == null) continue;
            int endFlag = HtmlDOMFixer.getEndTagFlag(parentId);
            if (endFlag == 1) {
                return null;
            }
            if (endFlag == 2 && this.check_required) {
                return null;
            }
            if (toFindId == 92) {
                return null;
            }
            if ((pn = pn.getParentDNode()) == null) continue;
            parentId = pn.getNameId();
        } while (pn != null);
        return null;
    }

    private DNode do_trivial_add(DNode parentNode, DNode theChild, int toFindId, int parentId) {
        if (toFindId == 41) {
            if (this.head_exists) {
                return parentNode.doc.getHead();
            }
            this.head_exists = true;
        } else if (toFindId == 86) {
            this.title_exists = true;
        } else if (toFindId == 14 && parentId == 81) {
            this.lastBreakNode = this.nodeToAdd;
        }
        parentNode.appendDChild(this.nodeToAdd);
        if (HtmlDOMFixer.get_child_index(theChild.getNameId()) != 0) {
            return theChild;
        }
        return theChild.getParentDNode();
    }

    private final boolean test_r(int idx, int toFindId) {
        int child_idx = HtmlDOMFixer.get_child_index(idx);
        if (child_idx == 0) {
            this.checked[idx] = true;
            return false;
        }
        if (HtmlDOMFixer.checkHTML4Accept(child_idx, toFindId)) {
            return true;
        }
        this.checked[idx] = true;
        int insertAttempts = HtmlDOMFixer.getSyntheticInsert(child_idx, -1);
        int i = 0;
        while (i != insertAttempts && this.nodeToAdd != null) {
            idx = HtmlDOMFixer.getSyntheticInsert(child_idx, i);
            if (!(this.checked[idx] || idx == 87 && this.check_required || !this.test_r(idx, toFindId))) {
                if (this.nodeToAdd == null) {
                    return true;
                }
                if (idx == 41) {
                    if (this.head_exists) {
                        DElement tmp = this.doc.getHead();
                        if (tmp != null) {
                            tmp.appendDChild(this.nodeToAdd);
                            this.nodeToAdd = null;
                        } else {
                            tmp = this.doc.createElement(idx);
                            this.doc.getDocumentDElement().appendDChild(tmp);
                            tmp.setSynthetic(true);
                            tmp.appendDChild(this.nodeToAdd);
                            this.nodeToAdd = null;
                        }
                        return true;
                    }
                    this.head_exists = true;
                } else if (idx == 13) {
                    if (this.body_exists) {
                        return false;
                    }
                    this.body_exists = true;
                } else if (idx == 43) {
                    if (this.html_exists) {
                        return false;
                    }
                    this.html_exists = true;
                }
                DElement e = this.doc.createElement(idx);
                e.setSynthetic(true);
                e.appendDChild(this.nodeToAdd);
                this.nodeToAdd = e;
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean checkHTML4Accept(int parentTagSet, int tag) {
        switch (parentTagSet) {
            case 0: {
                return tag == 93 || tag == 94;
            }
            case 1: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 27: 
                    case 29: 
                    case 31: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 53: 
                    case 55: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 29: 
                    case 31: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 60: 
                    case 64: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (tag) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 26: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 60: 
                    case 64: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                switch (tag) {
                    case 4: 
                    case 6: 
                    case 12: 
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 49: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 79: 
                    case 90: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 8: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 29: 
                    case 31: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 9: {
                switch (tag) {
                    case 22: 
                    case 28: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 10: {
                switch (tag) {
                    case 1: 
                    case 14: 
                    case 25: 
                    case 31: 
                    case 53: 
                    case 56: 
                    case 61: 
                    case 73: 
                    case 79: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 12: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 29: 
                    case 31: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 55: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 13: {
                switch (tag) {
                    case 62: 
                    case 63: 
                    case 70: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 14: {
                return tag == 63 || tag == 93 || tag == 94;
            }
            case 15: {
                return tag == 92 || tag == 93 || tag == 94;
            }
            case 16: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 17: {
                switch (tag) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 46: 
                    case 50: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 18: {
                switch (tag) {
                    case 16: 
                    case 20: 
                    case 21: 
                    case 70: 
                    case 80: 
                    case 83: 
                    case 85: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 19: {
                switch (tag) {
                    case 59: 
                    case 70: 
                    case 76: 
                    case 87: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 20: {
                return tag == 20 || tag == 93 || tag == 94;
            }
            case 21: {
                switch (tag) {
                    case 70: 
                    case 76: 
                    case 81: 
                    case 84: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 22: {
                switch (tag) {
                    case 8: 
                    case 49: 
                    case 54: 
                    case 57: 
                    case 60: 
                    case 70: 
                    case 76: 
                    case 86: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 23: {
                return tag == 92 || tag == 93 || tag == 94;
            }
            case 24: {
                switch (tag) {
                    case 13: 
                    case 34: 
                    case 41: 
                    case 58: 
                    case 70: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 25: {
                switch (tag) {
                    case 33: 
                    case 34: 
                    case 58: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 26: {
                return tag == 43 || tag == 93 || tag == 94;
            }
            case 27: {
                switch (tag) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
        }
        Defs.badArg();
        return false;
    }

    private static int getSyntheticInsert(int tag, int stage) {
        switch (tag) {
            case 9: {
                return stage < 0 ? 1 : 28;
            }
            case 18: {
                return stage < 0 ? 1 : 80;
            }
            case 19: {
                return stage < 0 ? 1 : 87;
            }
            case 24: {
                return stage < 0 ? 2 : (stage == 0 ? 13 : 41);
            }
            case 26: {
                return stage < 0 ? 1 : 43;
            }
            case 27: {
                return stage < 0 ? 1 : 13;
            }
        }
        return 0;
    }

    private static int get_child_index(int tagId) {
        switch (tagId) {
            case 0: {
                return 26;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 17;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 1;
            }
            case 19: {
                return 1;
            }
            case 20: {
                return 0;
            }
            case 21: {
                return 20;
            }
            case 22: {
                return 4;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 1;
            }
            case 25: {
                return 10;
            }
            case 26: {
                return 4;
            }
            case 27: {
                return 9;
            }
            case 28: {
                return 1;
            }
            case 29: {
                return 1;
            }
            case 30: {
                return 16;
            }
            case 31: {
                return 1;
            }
            case 32: {
                return 11;
            }
            case 33: {
                return 0;
            }
            case 34: {
                return 25;
            }
            case 35: {
                return 1;
            }
            case 36: {
                return 1;
            }
            case 37: {
                return 1;
            }
            case 38: {
                return 1;
            }
            case 39: {
                return 1;
            }
            case 40: {
                return 1;
            }
            case 41: {
                return 22;
            }
            case 42: {
                return 0;
            }
            case 43: {
                return 24;
            }
            case 44: {
                return 1;
            }
            case 45: {
                return 4;
            }
            case 46: {
                return 0;
            }
            case 47: {
                return 0;
            }
            case 48: {
                return 4;
            }
            case 49: {
                return 0;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 12;
            }
            case 52: {
                return 1;
            }
            case 53: {
                return 4;
            }
            case 54: {
                return 0;
            }
            case 55: {
                return 6;
            }
            case 56: {
                return 10;
            }
            case 57: {
                return 0;
            }
            case 58: {
                return 27;
            }
            case 59: {
                return 24;
            }
            case 60: {
                return 7;
            }
            case 61: {
                return 10;
            }
            case 62: {
                return 14;
            }
            case 63: {
                return 15;
            }
            case 64: {
                return 1;
            }
            case 65: {
                return 0;
            }
            case 66: {
                return 8;
            }
            case 67: {
                return 1;
            }
            case 68: {
                return 1;
            }
            case 69: {
                return 1;
            }
            case 70: {
                return 23;
            }
            case 71: {
                return 13;
            }
            case 72: {
                return 1;
            }
            case 73: {
                return 1;
            }
            case 74: {
                return 1;
            }
            case 75: {
                return 1;
            }
            case 76: {
                return 23;
            }
            case 77: {
                return 1;
            }
            case 78: {
                return 1;
            }
            case 79: {
                return 18;
            }
            case 80: {
                return 19;
            }
            case 81: {
                return 4;
            }
            case 82: {
                return 15;
            }
            case 83: {
                return 19;
            }
            case 84: {
                return 4;
            }
            case 85: {
                return 19;
            }
            case 86: {
                return 15;
            }
            case 87: {
                return 21;
            }
            case 88: {
                return 1;
            }
            case 89: {
                return 1;
            }
            case 90: {
                return 10;
            }
            case 91: {
                return 1;
            }
            case 92: {
                return 0;
            }
            case 93: {
                return 23;
            }
            case 94: {
                return 23;
            }
            case 95: {
                return 1;
            }
        }
        Defs.badArg();
        return 0;
    }

    private static int getEndTagFlag(int tagId) {
        switch (tagId) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 0;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 0;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 1;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 0;
            }
            case 21: {
                return 0;
            }
            case 22: {
                return 0;
            }
            case 23: {
                return 1;
            }
            case 24: {
                return 1;
            }
            case 25: {
                return 2;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 2;
            }
            case 28: {
                return 0;
            }
            case 29: {
                return 1;
            }
            case 30: {
                return 1;
            }
            case 31: {
                return 2;
            }
            case 32: {
                return 2;
            }
            case 33: {
                return 0;
            }
            case 34: {
                return 1;
            }
            case 35: {
                return 2;
            }
            case 36: {
                return 2;
            }
            case 37: {
                return 2;
            }
            case 38: {
                return 2;
            }
            case 39: {
                return 2;
            }
            case 40: {
                return 2;
            }
            case 41: {
                return 0;
            }
            case 42: {
                return 0;
            }
            case 43: {
                return 0;
            }
            case 44: {
                return 2;
            }
            case 45: {
                return 2;
            }
            case 46: {
                return 0;
            }
            case 47: {
                return 0;
            }
            case 48: {
                return 1;
            }
            case 49: {
                return 0;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 1;
            }
            case 52: {
                return 1;
            }
            case 53: {
                return 0;
            }
            case 54: {
                return 0;
            }
            case 55: {
                return 2;
            }
            case 56: {
                return 1;
            }
            case 57: {
                return 0;
            }
            case 58: {
                return 1;
            }
            case 59: {
                return 1;
            }
            case 60: {
                return 1;
            }
            case 61: {
                return 2;
            }
            case 62: {
                return 1;
            }
            case 63: {
                return 0;
            }
            case 64: {
                return 0;
            }
            case 65: {
                return 0;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 1;
            }
            case 68: {
                return 1;
            }
            case 69: {
                return 1;
            }
            case 70: {
                return 1;
            }
            case 71: {
                return 1;
            }
            case 72: {
                return 2;
            }
            case 73: {
                return 2;
            }
            case 74: {
                return 1;
            }
            case 75: {
                return 2;
            }
            case 76: {
                return 1;
            }
            case 77: {
                return 1;
            }
            case 78: {
                return 1;
            }
            case 79: {
                return 1;
            }
            case 80: {
                return 0;
            }
            case 81: {
                return 0;
            }
            case 82: {
                return 1;
            }
            case 83: {
                return 0;
            }
            case 84: {
                return 0;
            }
            case 85: {
                return 0;
            }
            case 86: {
                return 1;
            }
            case 87: {
                return 0;
            }
            case 88: {
                return 2;
            }
            case 89: {
                return 2;
            }
            case 90: {
                return 2;
            }
            case 91: {
                return 2;
            }
            case 92: {
                return 0;
            }
            case 93: {
                return 1;
            }
            case 94: {
                return 1;
            }
            case 95: {
                return 2;
            }
        }
        Defs.badArg();
        return 0;
    }
}

