/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CharacterAttributes;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ThePilot;
import java.awt.Point;

public class Html4DocumentAccess {
    public static final int CHARACTER_TYPE = 1;
    public static final int WORD_TYPE = 2;
    public static final int SENTENCE_TYPE = 3;
    public static final int MAX_TYPE = 3;
    public static final int ALL = 0;
    CSSLayout _layout;
    ThePilot _pilot;

    public Html4DocumentAccess(ThePilot aPilot) {
        this._pilot = aPilot;
        this._layout = aPilot.getCSSLayout();
    }

    public Html4DocumentAccess() {
    }

    public String getCurrentText(int aType) {
        return this._layout.getCurrentText(aType);
    }

    public String getTextAt(int aType, int aX, int aY, int aScrollX, int aScrollY) {
        return this._layout.getTextAt(aType, aX, aY, aScrollX, aScrollY);
    }

    public String getText(int aType, int aIndex) {
        return this._layout.getText(aType, aIndex, true);
    }

    public void positionToIndex(int aType, int aIndex) {
        this._layout.positionToIndex(aType, aIndex);
    }

    public int getCaretPosition(int aType) {
        return this._layout.getCaretPosition(aType);
    }

    public CharacterAttributes getCharAttributes(int aIndex) {
        CSSAttribs attribs = this._layout.getCharAttribs(aIndex);
        return this.getCharAttributes(attribs);
    }

    private CharacterAttributes getCharAttributes(CSSAttribs cssAttributes) {
        CharacterAttributes attributes = new CharacterAttributes();
        CharacterAttributes.background_color = cssAttributes.background_color;
        CharacterAttributes.background_image = cssAttributes.background_image;
        CharacterAttributes.border_bottom_color = cssAttributes.border_bottom_color;
        CharacterAttributes.border_bottom_style = cssAttributes.border_bottom_style;
        CharacterAttributes.border_bottom_width = cssAttributes.border_bottom_width;
        CharacterAttributes.border_left_color = cssAttributes.border_left_color;
        CharacterAttributes.border_left_style = cssAttributes.border_left_style;
        CharacterAttributes.border_left_width = cssAttributes.border_left_width;
        CharacterAttributes.border_right_color = cssAttributes.border_right_color;
        CharacterAttributes.border_right_style = cssAttributes.border_right_style;
        CharacterAttributes.border_right_width = cssAttributes.border_right_width;
        CharacterAttributes.border_top_color = cssAttributes.border_top_color;
        CharacterAttributes.border_top_style = cssAttributes.border_top_style;
        CharacterAttributes.border_top_width = cssAttributes.border_top_width;
        CharacterAttributes.font_family = cssAttributes.font_family;
        CharacterAttributes.font_size = cssAttributes.font_size;
        CharacterAttributes.font_style = cssAttributes.font_style;
        CharacterAttributes.margin_bottom = cssAttributes.margin_bottom;
        CharacterAttributes.margin_left = cssAttributes.margin_left;
        CharacterAttributes.margin_right = cssAttributes.margin_right;
        CharacterAttributes.margin_top = cssAttributes.margin_top;
        CharacterAttributes.padding_bottom = cssAttributes.padding_bottom;
        CharacterAttributes.padding_left = cssAttributes.padding_left;
        CharacterAttributes.padding_right = cssAttributes.padding_right;
        CharacterAttributes.padding_top = cssAttributes.padding_top;
        CharacterAttributes.text_align = cssAttributes.text_align;
        CharacterAttributes.text_decoration = cssAttributes.text_decoration;
        CharacterAttributes.text_indent = cssAttributes.text_indent;
        CharacterAttributes.vertical_align_type = cssAttributes.vertical_align_type;
        CharacterAttributes.color = cssAttributes.color;
        CharacterAttributes.display = cssAttributes.display;
        CharacterAttributes.outline_color = cssAttributes.outline_color;
        CharacterAttributes.height = cssAttributes.height;
        CharacterAttributes.line_height = cssAttributes.line_height;
        CharacterAttributes.listStyleType = cssAttributes.listStyleType;
        return attributes;
    }

    public int getIndexOfNode(DNode node) {
        Point thePoint = new Point();
        this._pilot.getView().findPosition(node, thePoint);
        return this.getIndexAtPoint(thePoint.x, thePoint.y, 0, 0);
    }

    public int getIndexAtPoint(int aX, int aY, int scrollX, int scrollY) {
        return this._layout.getIndexAtPoint(aX, aY, scrollX, scrollY);
    }

    public DNode getNodeByIndex(int aType, int aIndex) {
        return this._layout.getNodeByIndex(aType, aIndex);
    }

    public String getNext(int aType) {
        return this._layout.getNext(aType);
    }

    public String getPrevious(int aType) {
        return this._layout.getPrevious(aType);
    }

    public int getSelectionStart() {
        return this._layout.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this._layout.getSelectionEnd();
    }

    public String getSelectedText() {
        return this._layout.getSelectedText();
    }

    public int getCount(int aType) {
        return this._layout.getCount(aType);
    }

    public void setSelection(int x1, int y1, int x2, int y2) {
        if (!this._layout.docPane.enableTextSelection) {
            return;
        }
        this._layout.setSelection(x1, y1, x2, y2, this._pilot.getDocPane().getScrollX(), this._pilot.getDocPane().getScrollY());
    }

    public void setSelection(int type, int x, int y) {
        if (!this._layout.docPane.enableTextSelection) {
            return;
        }
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                this._layout.selectWord(x, y, this._pilot.getDocPane().getScrollX(), this._pilot.getDocPane().getScrollY());
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                this._layout.selectAll();
                break;
            }
        }
    }

    public void selectWordByIndex(int wordIndex) {
        this._layout.selectWordByIndex(wordIndex);
    }
}

