/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DAllList;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DChildrenList;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ThePilot;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;
import ice.storm.Viewport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class DNode
extends DynamicObject
implements Node,
EventTarget,
Cloneable {
    public static String DOM_LEVEL_3_ERROR = "This ICE Browser version does not support DOM Level 3";
    protected DDocument doc;
    protected DNode parent;
    protected DNode prev;
    protected DNode next;
    protected DNode first;
    protected DNode last;
    Object[] eventListeners;
    private DAttr attrListHead;
    int tagId;
    private static final int Field_all = 1;
    private static final int Field_attributes = 2;
    private static final int Field_childNodes = 3;
    private static final int Field_children = 4;
    private static final int Field_document = 5;
    private static final int Field_firstChild = 6;
    private static final int Field_innerText = 7;
    private static final int Field_lastChild = 8;
    private static final int Field_localName = 9;
    private static final int Field_namespaceURI = 10;
    private static final int Field_nextSibling = 11;
    private static final int Field_nodeName = 12;
    private static final int Field_nodeValue = 13;
    private static final int Field_nodeType = 14;
    private static final int Field_outerText = 15;
    private static final int Field_ownerDocument = 16;
    private static final int Field_parentNode = 17;
    private static final int Field_prefix = 18;
    private static final int Field_previousSibling = 19;
    private static final int Field_rootNode = 20;
    private static final int Method_addEventListener = -1;
    private static final int Method_appendChild = -2;
    private static final int Method_cloneNode = -3;
    private static final int Method_contains = -4;
    private static final int Method_dispatchEvent = -5;
    private static final int Method_getComponentVersion = -6;
    private static final int Method_hasAttributes = -7;
    private static final int Method_hasChildNodes = -8;
    private static final int Method_insertBefore = -9;
    private static final int Method_isSupported = -10;
    private static final int Method_normalize = -11;
    private static final int Method_removeChild = -12;
    private static final int Method_removeEventListener = -13;
    private static final int Method_replaceChild = -14;
    private static final int Field_parentElement = 17;

    DNode(DDocument doc, int tagId) {
        this.tagId = tagId;
        this.doc = doc;
    }

    void dispose() {
        DNode ff = this.first;
        while (ff != null) {
            DNode n = ff.next;
            ff.dispose();
            ff = n;
        }
        this.parent = null;
        this.prev = null;
        this.next = null;
        this.last = null;
        this.first = null;
    }

    protected ThePilot getPilot() {
        return this.doc.getPilot();
    }

    protected void afterClone(boolean deep) {
        DNode source_first = this.first;
        this.parent = null;
        this.prev = null;
        this.next = null;
        this.first = null;
        this.last = null;
        this.eventListeners = null;
        this.attrListHead = DAttr.cloneList(this.attrListHead, this, deep);
        if (deep) {
            DNode n = source_first;
            while (n != null) {
                DNode cloned_node = (DNode)n.clone(deep);
                if (cloned_node != null) {
                    if (this instanceof DDocument) {
                        DDocument doc = (DDocument)this;
                        doc.clearRootElement();
                    }
                    this.appendDChild(cloned_node);
                }
                n = n.next;
            }
        }
    }

    public Object clone(boolean deep) {
        try {
            DNode cloned = (DNode)super.clone();
            cloned.afterClone(deep);
            DNode dNode = cloned;
            return dNode;
        }
        catch (CloneNotSupportedException ex) {
            Object var5_5 = null;
            return var5_5;
        }
    }

    public Object clone() {
        return this.clone(false);
    }

    public final int getNameId() {
        return this.tagId;
    }

    protected void setParent(DNode parent) {
        this.parent = parent;
    }

    public DNode getParentDNode() {
        return this.parent;
    }

    public DDocument getOwnerDDocument() {
        return this.doc;
    }

    protected DNode getFirstDChild() {
        return this.first;
    }

    protected DNode getLastDChild() {
        return this.last;
    }

    protected DNode getNextDSibling() {
        return this.next;
    }

    protected DNode getPreviousDSibling() {
        return this.prev;
    }

    protected DNode appendDChild(DNode n) {
        if (n == this) {
            return null;
        }
        if (n.parent != null) {
            n.parent.removeDChild(n);
        }
        if (this.last == null) {
            this.first = this.last = n;
            n.prev = null;
        } else {
            this.last.next = n;
            n.prev = this.last;
            this.last = n;
        }
        n.next = null;
        n.setParent(this);
        DDocument doc_ref = this.doc;
        if (doc_ref != null) {
            doc_ref.mutate();
        }
        DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(26);
        evt.target = n;
        evt.relatedNode = this;
        this.doc.processEvent(evt);
        return n;
    }

    protected int attrNameToId(String name) {
        return this.doc.names.getAttrId(3, name);
    }

    protected void onDAttrValueChange(DAttr attr) {
    }

    final DAttr createDAttr(int attrNameId, DNode masterNode, DAttr next) {
        DAttr attr = this.doc.createAttribute(attrNameId);
        attr.initMasterAndLink(masterNode, next);
        return attr;
    }

    protected final DAttr getDAttrListHead() {
        return this.attrListHead;
    }

    protected int getDAttrCount() {
        int count = 0;
        DAttr cursor = this.attrListHead;
        while (cursor != null) {
            ++count;
            cursor = cursor.next;
        }
        return count;
    }

    protected Object getDAttrValueOrNull(int attrNameId) {
        DAttr cursor = this.attrListHead;
        while (cursor != null) {
            if (cursor.nameId == attrNameId) {
                return cursor.getObjectValue();
            }
            cursor = cursor.next;
        }
        return null;
    }

    protected final DAttr getDAttr(int attrNameId) {
        DAttr cursor = this.attrListHead;
        while (cursor != null && cursor.nameId != attrNameId) {
            cursor = cursor.next;
        }
        return cursor;
    }

    protected DAttr getDAttrFromIndex(int index) {
        DAttr cursor = this.attrListHead;
        while (cursor != null) {
            if (index == 0) break;
            --index;
            cursor = cursor.next;
        }
        return cursor;
    }

    protected void setDAttr(int attrNameId, Object value, boolean change_notify) {
        DAttr head;
        DAttr cursor = head = this.attrListHead;
        while (cursor != null && cursor.nameId != attrNameId) {
            cursor = cursor.next;
        }
        if (cursor == null) {
            this.attrListHead = cursor = this.createDAttr(attrNameId, this, head);
            cursor.setObjectValue(value, change_notify);
            if (change_notify) {
                DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(28);
                evt.setMutationData(null, null, cursor.getValue(), cursor.getName(), (short)2);
                this.dispatchEvent(evt);
            }
        } else {
            String oldVal = cursor.getValue();
            cursor.setObjectValue(value, change_notify);
            if (change_notify) {
                DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(28);
                evt.setMutationData(null, oldVal, cursor.getValue(), cursor.getName(), (short)1);
                this.dispatchEvent(evt);
            }
        }
    }

    protected DAttr setDAttr(DAttr new_attr, boolean change_notify) {
        DAttr head;
        if (!new_attr.setMasterNode(this)) {
            return null;
        }
        DAttr removed = this.removeDAttr(new_attr.nameId, false);
        new_attr.next = head = this.attrListHead;
        this.attrListHead = new_attr;
        new_attr.afterAddingToNode();
        if (change_notify) {
            DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(28);
            evt.setMutationData(null, removed != null ? removed.getValue() : null, new_attr.getValue(), new_attr.getName(), (short)1);
            this.dispatchEvent(evt);
        }
        return removed;
    }

    /*
     * Unable to fully structure code
     */
    protected DAttr removeDAttr(int attrNameId, boolean remove_notify) {
        block3: {
            removed = null;
            cursor = this.attrListHead;
            if (cursor == null) break block3;
            next = cursor.next;
            if (cursor.nameId != attrNameId) ** GOTO lbl15
            this.attrListHead = next;
            removed = cursor;
            break block3;
lbl-1000:
            // 1 sources

            {
                if (next.nameId == attrNameId) {
                    cursor.next = next.next;
                    removed = next;
                    break;
                }
                cursor = next;
                next = next.next;
lbl15:
                // 2 sources

                ** while (next != null)
            }
        }
        if (removed != null) {
            removed.detachFromAttrList(remove_notify);
        }
        return removed;
    }

    /*
     * Unable to fully structure code
     */
    protected DAttr removeDAttr(DAttr old_attr, boolean remove_notify) {
        block3: {
            removed = null;
            cursor = this.attrListHead;
            if (cursor == null) break block3;
            next = cursor.next;
            if (cursor != old_attr) ** GOTO lbl15
            this.attrListHead = next;
            removed = cursor;
            break block3;
lbl-1000:
            // 1 sources

            {
                if (next == old_attr) {
                    cursor.next = next.next;
                    removed = next;
                    break;
                }
                cursor = next;
                next = next.next;
lbl15:
                // 2 sources

                ** while (next != null)
            }
        }
        if (removed != null) {
            removed.detachFromAttrList(remove_notify);
        }
        return removed;
    }

    protected void removeAllDAttrs() {
        this.attrListHead = null;
    }

    public String getNodeName() {
        return null;
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String nodeValue) {
    }

    public short getNodeType() {
        return 0;
    }

    public final Node getParentNode() {
        return this.getParentDNode();
    }

    public final Node getRootNode() {
        return this.getRootDNode();
    }

    public DNode getRootDNode() {
        DNode parent;
        DNode n = this;
        while ((parent = n.parent) != null) {
            n = parent;
        }
        return n;
    }

    public NodeList getChildNodes() {
        return new DChildrenList(this);
    }

    public final Node getFirstChild() {
        return this.getFirstDChild();
    }

    public final Node getLastChild() {
        return this.getLastDChild();
    }

    public final Node getPreviousSibling() {
        return this.getPreviousDSibling();
    }

    public final Node getNextSibling() {
        return this.getNextDSibling();
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public final Document getOwnerDocument() {
        return this.getOwnerDDocument();
    }

    public final Node insertBefore(Node newChild, Node refChild) {
        if (newChild instanceof DNode && (refChild == null || refChild instanceof DNode)) {
            return this.insertDChildBefore((DNode)newChild, (DNode)refChild);
        }
        return null;
    }

    protected DNode insertDChildBefore(DNode child, DNode ref) {
        if (child.doc != this.doc) {
            return null;
        }
        if (ref != null) {
            if (ref.doc != this.doc) {
                return null;
            }
            if (ref.parent != this) {
                return null;
            }
        }
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        if (ref == null) {
            this.appendDChild(child);
        } else {
            child.next = ref;
            child.prev = ref.prev;
            if (ref.prev != null) {
                ref.prev.next = child;
            }
            ref.prev = child;
            child.parent = this;
            if (this.first == ref) {
                this.first = child;
            }
            this.doc.mutate();
            DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(26);
            evt.target = child;
            evt.relatedNode = this;
            this.doc.processEvent(evt);
        }
        return child;
    }

    public final Node replaceChild(Node newChild, Node refChild) {
        if (newChild instanceof DNode && refChild instanceof DNode) {
            return this.replaceDChild((DNode)newChild, (DNode)refChild);
        }
        return null;
    }

    protected DNode replaceDChild(DNode child, DNode ref) {
        if (child == ref) {
            return child;
        }
        if (child.doc != this.doc || ref.doc != this.doc) {
            return null;
        }
        if (ref.parent != this) {
            return null;
        }
        if (child.parent != null) {
            child.parent.removeDChild(child);
        }
        child.next = ref.next;
        child.prev = ref.prev;
        if (child.prev != null) {
            child.prev.next = child;
        }
        if (child.next != null) {
            child.next.prev = child;
        }
        if (this.first == ref) {
            this.first = child;
        }
        if (this.last == ref) {
            this.last = child;
        }
        child.parent = this;
        ref.parent = null;
        ref.next = null;
        ref.prev = null;
        DDocument doc_ref = this.doc;
        if (doc_ref != null) {
            doc_ref.mutate();
        }
        DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(26);
        evt.target = child;
        evt.relatedNode = this;
        this.doc.processEvent(evt);
        return child;
    }

    public final Node removeChild(Node oldNode) {
        if (oldNode instanceof DNode) {
            return this.removeDChild((DNode)oldNode);
        }
        return null;
    }

    protected DNode removeDChild(DNode n) {
        if (n.doc != this.doc) {
            return null;
        }
        if (n.parent != this) {
            return null;
        }
        DMutationEvent evt = (DMutationEvent)this.doc.createDOMEvent(27);
        evt.target = n;
        evt.relatedNode = this;
        this.doc.processEvent(evt);
        DNode n_next = n.next;
        DNode n_prev = n.prev;
        if (n == this.last) {
            this.last = n_prev;
        }
        if (n_prev != null) {
            n_prev.next = n_next;
        }
        if (n == this.first) {
            this.first = n_next;
        }
        if (n_next != null) {
            n_next.prev = n_prev;
        }
        n.prev = null;
        n.next = null;
        n.setParent(null);
        DDocument doc_ref = this.doc;
        if (doc_ref != null) {
            doc_ref.mutate();
        }
        return n;
    }

    public final Node appendChild(Node n) {
        return this.appendDChild((DNode)n);
    }

    public boolean hasChildNodes() {
        return this.first != null;
    }

    public Node cloneNode(boolean deep) {
        try {
            DNode cloned = (DNode)super.clone();
            cloned.afterClone(deep);
            DNode dNode = cloned;
            return dNode;
        }
        catch (CloneNotSupportedException ex) {
            Node node = null;
            return node;
        }
    }

    private int script_attrNameToId(String name) {
        int id = this.attrNameToId(name);
        if (DDocument.isEventHandlerAttr(id) && !name.equals(name.toLowerCase())) {
            return -1;
        }
        return id;
    }

    public boolean hasSlot(String name, DynEnv env) {
        int attrNameId = this.script_attrNameToId(name);
        if (attrNameId < 0) {
            return super.hasSlot(name, env);
        }
        return this.getDAttr(attrNameId) != null;
    }

    public Object getSlot(String name, DynEnv env) {
        int attrNameId = this.script_attrNameToId(name);
        if (attrNameId < 0) {
            return super.getSlot(name, env);
        }
        DAttr attr = this.getDAttr(attrNameId);
        if (attr != null) {
            Object value = attr.getObjectValue();
            if (DDocument.isEventHandlerAttr(attrNameId)) {
                value = env.wrapEventHandler(this, value);
            }
            return value;
        }
        if (DDocument.isEventHandlerAttr(attrNameId)) {
            return null;
        }
        return DynamicObject.NOT_FOUND;
    }

    public void setSlot(String name, Object value, DynEnv env) {
        int attrNameId = this.script_attrNameToId(name);
        if (attrNameId < 0) {
            super.setSlot(name, value, env);
            return;
        }
        DAttr attr = this.getDAttr(attrNameId);
        if (attr != null) {
            attr.setObjectValue(value, true);
        } else {
            attr = this.doc.createAttribute(attrNameId);
            attr.setObjectValue(value, false);
            this.setDAttr(attr, true);
        }
    }

    public void deleteSlot(String name) {
        int attrNameId = this.script_attrNameToId(name);
        if (attrNameId < 0) {
            super.deleteSlot(name);
            return;
        }
        this.removeDAttr(attrNameId, true);
    }

    public void unlinkAllSlots() {
        this.removeAllDAttrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        DNode dNode = this;
        synchronized (dNode) {
            this.eventListeners = DNodeListeners.addEventListener(this.eventListeners, type, useCapture, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        DNode dNode = this;
        synchronized (dNode) {
            this.eventListeners = DNodeListeners.removeEventListener(this.eventListeners, type, useCapture, listener);
        }
    }

    public boolean dispatchEvent(Event evt) {
        if (!(evt instanceof DOMEvent)) {
            return false;
        }
        DOMEvent de = (DOMEvent)evt;
        de.target = this;
        this.doc.processEvent(de);
        return de.isDefaultCancelled();
    }

    public boolean contains(DNode toFind) {
        DNode n = toFind;
        while (n != null) {
            if (n == this) {
                return true;
            }
            n = n.parent;
        }
        return false;
    }

    protected DNode getDParent() {
        return this.parent;
    }

    public void setInnerText(String text) {
        DTextNode tn = this.doc.createDTextNode(text);
        while (this.first != null) {
            this.removeDChild(this.first);
        }
        this.appendDChild(tn);
    }

    public void setOuterText(String text) {
        DNode n = this.parent;
        if (n != null) {
            DTextNode tn = this.doc.createDTextNode(text);
            n.replaceDChild(tn, this);
        }
    }

    public String getOuterText() {
        return this.getInnerText();
    }

    public String getInnerText() {
        StringBuffer sb = new StringBuffer();
        DNode.inner_text_r(this, sb, false);
        return sb.toString();
    }

    private static void inner_text_r(DNode n, StringBuffer sb, boolean escapeHTML) {
        if (n instanceof DTextNode) {
            String text = ((DTextNode)n).getData();
            if (escapeHTML) {
                DNode.appendEscapedHtml(text, sb, false);
            } else {
                sb.append(text);
            }
        }
        n = n.first;
        while (n != null) {
            DNode.inner_text_r(n, sb, escapeHTML);
            n = n.next;
        }
    }

    static void appendOuterHTML(DNode node, StringBuffer sb) {
        if (node instanceof DElement) {
            DElement theOne = (DElement)node;
            sb.append("<");
            sb.append(theOne.getTagName());
            DAttr attr_cursor = theOne.getDAttrListHead();
            while (attr_cursor != null) {
                String tmp = attr_cursor.getValue();
                if (tmp != null) {
                    sb.append(" ");
                    sb.append(attr_cursor.getName());
                    sb.append("=\"");
                    DNode.appendEscapedHtml(tmp, sb, true);
                    sb.append("\"");
                }
                attr_cursor = attr_cursor.next;
            }
            sb.append(">");
            DNode n = node.first;
            while (n != null) {
                DNode.appendOuterHTML(n, sb);
                n = n.next;
            }
            sb.append("</");
            sb.append(theOne.getTagName());
            sb.append(">");
        } else {
            DNode.inner_text_r(node, sb, true);
        }
    }

    private static void appendEscapedHtml(String str, StringBuffer sb, boolean escapeQuote) {
        int length = str.length();
        sb.append(str);
        boolean hasEscapes = false;
        int i = 0;
        while (i != length) {
            char c = str.charAt(i);
            String escape = null;
            switch (c) {
                case '<': {
                    escape = "&lt;";
                    break;
                }
                case '>': {
                    escape = "&gt;";
                    break;
                }
                case '&': {
                    escape = "&amp;";
                    break;
                }
                case '\"': {
                    if (!escapeQuote) break;
                    escape = "&quot;";
                    break;
                }
            }
            if (escape == null) {
                if (hasEscapes) {
                    sb.append(c);
                }
            } else {
                if (!hasEscapes) {
                    hasEscapes = true;
                    sb.setLength(sb.length() - length + i);
                }
                sb.append(escape);
            }
            ++i;
        }
    }

    public DAllList getAll() {
        return new DAllList(this);
    }

    public void normalize() {
        DNode n = this.first;
        while (n != null) {
            n.normalize();
            n = n.next;
        }
    }

    public boolean isSupported(String feature, String version) {
        return this.doc.getDom().hasFeature(feature, version);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) {
    }

    public String getLocalName() {
        return null;
    }

    public boolean hasAttributes() {
        return this.attrListHead != null;
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException(DOM_LEVEL_3_ERROR);
    }

    static boolean isNullOrEmpty(String item) {
        return item == null || item.equalsIgnoreCase("");
    }

    public Object getDynamicScopeParent() {
        return this.doc;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DNode.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DNode.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DNode.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAll();
            }
            case 2: {
                return this.getAttributes();
            }
            case 3: {
                return this.getChildNodes();
            }
            case 4: {
                return this.getChildNodes();
            }
            case 5: {
                return this.getOwnerDocument();
            }
            case 6: {
                return this.getFirstChild();
            }
            case 7: {
                return this.getInnerText();
            }
            case 8: {
                return this.getLastChild();
            }
            case 9: {
                return this.getLocalName();
            }
            case 10: {
                return this.getNamespaceURI();
            }
            case 11: {
                return this.getNextSibling();
            }
            case 12: {
                return this.getNodeName();
            }
            case 13: {
                return this.getNodeValue();
            }
            case 14: {
                return env.wrapInt(this.getNodeType());
            }
            case 15: {
                return this.getOuterText();
            }
            case 16: {
                return this.getOwnerDocument();
            }
            case 17: {
                return this.getParentNode();
            }
            case 18: {
                return this.getPrefix();
            }
            case 19: {
                return this.getPreviousSibling();
            }
            case 20: {
                return this.getRootNode();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 7: {
                this.setInnerText(env.toStr(value));
                return 1;
            }
            case 15: {
                this.setOuterText(env.toStr(value));
                return 1;
            }
            case 18: {
                this.setPrefix(env.toStr(value));
                return 1;
            }
            case 13: {
                this.setNodeValue(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                String type = env.toStr(args, 0);
                Object listenerObj = env.toNative(args, 1);
                boolean useCapture = env.toBoolean(args, 2);
                EventListener listener = listenerObj instanceof EventListener ? (EventListener)listenerObj : new ScriptEventListener(env.getScripter(), env.getRawObject(args, 1));
                this.addEventListener(type, listener, useCapture);
                break;
            }
            case -2: {
                return this.appendChild((Node)env.toNative(args, 0));
            }
            case -3: {
                boolean deep = env.toBoolean(args, 0);
                return this.cloneNode(deep);
            }
            case -4: {
                return env.wrapBoolean(this.contains((DNode)env.toNative(args, 0)));
            }
            case -5: {
                return env.wrapBoolean(this.dispatchEvent((Event)env.toNative(args, 0)));
            }
            case -6: {
                return env.wrapInt(0);
            }
            case -7: {
                return env.wrapBoolean(this.hasAttributes());
            }
            case -8: {
                return env.wrapBoolean(this.hasChildNodes());
            }
            case -9: {
                Node newChild = (Node)env.toNative(args, 0);
                Node refChild = (Node)env.toNative(args, 1);
                return this.insertBefore(newChild, refChild);
            }
            case -10: {
                String feature = env.toStr(args, 0);
                String version = env.toStr(args, 1);
                return env.wrapBoolean(this.isSupported(feature, version));
            }
            case -11: {
                this.normalize();
                break;
            }
            case -12: {
                return this.removeChild((Node)env.toNative(args, 0));
            }
            case -13: {
                String type = env.toStr(args, 0);
                Object listenerObj = env.toNative(args, 1);
                boolean useCapture = env.toBoolean(args, 2);
                EventListener listener = listenerObj instanceof EventListener ? (EventListener)listenerObj : new ScriptEventListener(env.getScripter(), env.getRawObject(args, 1));
                this.removeEventListener(type, listener, useCapture);
                break;
            }
            case -14: {
                Node newChild = (Node)env.toNative(args, 0);
                Node refChild = (Node)env.toNative(args, 1);
                return this.replaceChild(newChild, refChild);
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                X = "all";
                id = 1;
                break;
            }
            case 6: {
                X = "prefix";
                id = 18;
                break;
            }
            case 8: {
                switch (s.charAt(5)) {
                    case 'a': {
                        X = "nodeName";
                        id = 12;
                        break block0;
                    }
                    case 'e': {
                        X = "document";
                        id = 5;
                        break block0;
                    }
                    case 'i': {
                        X = "contains";
                        id = -4;
                        break block0;
                    }
                    case 'o': {
                        X = "rootNode";
                        id = 20;
                        break block0;
                    }
                    case 'r': {
                        X = "children";
                        id = 4;
                        break block0;
                    }
                    case 'y': {
                        X = "nodeType";
                        id = 14;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                switch (s.charAt(2)) {
                    case 'c': {
                        X = "localName";
                        id = 9;
                        break block0;
                    }
                    case 'd': {
                        X = "nodeValue";
                        id = 13;
                        break block0;
                    }
                    case 'n': {
                        X = "innerText";
                        id = 7;
                        break block0;
                    }
                    case 'o': {
                        X = "cloneNode";
                        id = -3;
                        break block0;
                    }
                    case 'r': {
                        X = "normalize";
                        id = -11;
                        break block0;
                    }
                    case 's': {
                        X = "lastChild";
                        id = 8;
                        break block0;
                    }
                    case 't': {
                        X = "outerText";
                        id = 15;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "attributes";
                        id = 2;
                        break block0;
                    }
                    case 'c': {
                        X = "childNodes";
                        id = 3;
                        break block0;
                    }
                    case 'f': {
                        X = "firstChild";
                        id = 6;
                        break block0;
                    }
                    case 'p': {
                        X = "parentNode";
                        id = 17;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "appendChild";
                        id = -2;
                        break block0;
                    }
                    case 'i': {
                        X = "isSupported";
                        id = -10;
                        break block0;
                    }
                    case 'n': {
                        X = "nextSibling";
                        id = 11;
                        break block0;
                    }
                    case 'r': {
                        X = "removeChild";
                        id = -12;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = s.charAt(0);
                if (c == 'i') {
                    X = "insertBefore";
                    id = -9;
                    break;
                }
                if (c == 'n') {
                    X = "namespaceURI";
                    id = 10;
                    break;
                }
                if (c != 'r') break;
                X = "replaceChild";
                id = -14;
                break;
            }
            case 13: {
                switch (s.charAt(4)) {
                    case 'a': {
                        X = "dispatchEvent";
                        id = -5;
                        break block0;
                    }
                    case 'h': {
                        X = "hasChildNodes";
                        id = -8;
                        break block0;
                    }
                    case 'n': {
                        X = "parentElement";
                        id = 17;
                        break block0;
                    }
                    case 'r': {
                        X = "ownerDocument";
                        id = 16;
                        break block0;
                    }
                    case 't': {
                        X = "hasAttributes";
                        id = -7;
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                X = "previousSibling";
                id = 19;
                break;
            }
            case 16: {
                X = "addEventListener";
                id = -1;
                break;
            }
            case 19: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getComponentVersion";
                    id = -6;
                    break;
                }
                if (c != 'r') break;
                X = "removeEventListener";
                id = -13;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    private static class ScriptEventListener
    implements EventListener {
        private final Scripter scripter;
        private final Object value;

        ScriptEventListener(Scripter scripter_arg, Object value_arg) {
            this.scripter = scripter_arg;
            this.value = value_arg;
        }

        public boolean equals(Object another) {
            if (another instanceof ScriptEventListener) {
                ScriptEventListener x = (ScriptEventListener)another;
                return this.scripter.equals(x.scripter) && this.value.equals(x.value);
            }
            return false;
        }

        public int hashCode() {
            return this.scripter.hashCode() ^ this.value.hashCode();
        }

        public void handleEvent(Event event) {
            DOMEvent devent = (DOMEvent)event;
            EventTarget tgt = event.getTarget();
            if (!(tgt instanceof DNode)) {
                return;
            }
            DNode target = (DNode)tgt;
            Viewport vp = target.doc.pilot.getPilotViewport();
            this.scripter.evalEventHandler(vp, target, this.value, devent);
        }
    }
}

