/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dom.DocumentImpl;
import ice.dom.html.TableCellElement;
import ice.dom.html.TableElement;
import ice.dom.html.TableRowElement;
import ice.pilots.html4.AccessibleContextProxy;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ScreenReaderStatusComponent;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.TheView;
import ice.util.Defs;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class AccessibleHyperPanel
extends AccessibleContextProxy
implements AccessibleHypertext,
EventListener {
    private AccessibleContext _proxyContext;
    private ScreenReaderStatusComponent _statusComponent;
    private ThePilot _pilot;
    private DDocument _document;
    private DElement _body;
    private String _fixedAccessibleName;
    private String _fixedAccessibleDescription;
    private String _documentTitle;
    private String _text;
    private Vector _lineMap;
    private Vector _linkVector;
    private Hashtable _namedAnchorTable;
    private int _caretPosition;
    private DocumentLine _currentLine;
    private static int FAKE_CHAR_WIDTH = 14;
    private static int FAKE_CHAR_HEIGHT = 14;
    private static int FAKE_LINE_LENGTH = 250;
    private String LINK_IDENTIFIER;
    private String INPUT_IDENTIFIER;
    private String IMAGE_IDENTIFIER;
    private String HYPERTEXT_ACCESSIBLE_DESCRIPTION;

    private void $init$() {
        this._proxyContext = null;
        this._statusComponent = null;
        this._pilot = null;
        this._document = null;
        this._body = null;
        this._fixedAccessibleName = null;
        this._fixedAccessibleDescription = null;
        this._documentTitle = null;
        this._text = "";
        this._lineMap = null;
        this._linkVector = null;
        this._namedAnchorTable = null;
        this._caretPosition = 0;
        this._currentLine = null;
        this.LINK_IDENTIFIER = "LINK";
        this.INPUT_IDENTIFIER = "INPUT";
        this.IMAGE_IDENTIFIER = "IMAGE";
        this.HYPERTEXT_ACCESSIBLE_DESCRIPTION = "HTML Page";
    }

    public AccessibleHyperPanel(ThePilot pilot, AccessibleContext proxyContext, ScreenReaderStatusComponent statusComponent) {
        this.$init$();
        this._proxyContext = proxyContext;
        this._pilot = pilot;
        this._statusComponent = statusComponent;
        this._pilot.addPersistentDOMEventListener("load", this, true);
        this._pilot.addPersistentDOMEventListener("unload", this, true);
        this._pilot.addPersistentDOMEventListener("keyup", this, true);
        this._pilot.addPersistentDOMEventListener("focus", this, true);
        this._pilot.addPersistentDOMEventListener("goto", this, true);
        this._lineMap = new Vector();
        this._linkVector = new Vector();
        this._namedAnchorTable = new Hashtable();
        this._buildDocumentData();
    }

    public String getAccessibleName() {
        if (this._fixedAccessibleName != null) {
            return this._fixedAccessibleName;
        }
        return this._documentTitle;
    }

    public void setAccessibleName(String s) {
        String oldName = this.getAccessibleName();
        this._fixedAccessibleName = s;
        this.firePropertyChange("AccessibleName", oldName, this.getAccessibleName());
    }

    public String getAccessibleDescription() {
        if (this._fixedAccessibleDescription != null) {
            return this._fixedAccessibleDescription;
        }
        return this.HYPERTEXT_ACCESSIBLE_DESCRIPTION;
    }

    public void setAccessibleDescription(String s) {
        String oldDescription = this.getAccessibleDescription();
        this._fixedAccessibleDescription = s;
        this.firePropertyChange("AccessibleDescription", oldDescription, this.getAccessibleDescription());
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TEXT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = super.getAccessibleStateSet();
        states.add(AccessibleState.MULTI_LINE);
        return states;
    }

    public int getLinkCount() {
        return this._linkVector.size();
    }

    public AccessibleHyperlink getLink(int linkIndex) {
        DocumentLink aLink = null;
        if (linkIndex >= 0 && linkIndex < this._linkVector.size()) {
            aLink = (DocumentLink)this._linkVector.elementAt(linkIndex);
        }
        return aLink;
    }

    public int getLinkIndex(int charIndex) {
        int linkIndex = -1;
        if (charIndex >= 0 && charIndex < this._text.length()) {
            int iter = 0;
            while (iter < this._linkVector.size()) {
                DocumentLink aLink = (DocumentLink)this._linkVector.elementAt(iter);
                if (charIndex >= aLink.getStartIndex() && charIndex < aLink.getEndIndex()) {
                    linkIndex = iter;
                    break;
                }
                ++iter;
            }
        }
        return linkIndex;
    }

    public int getIndexAtPoint(Point p) {
        int charIndex = -1;
        if (p != null && p.x >= 0 && p.y >= 0) {
            int iter = 0;
            while (iter < this._lineMap.size()) {
                DocumentLine aLine = (DocumentLine)this._lineMap.elementAt(iter);
                Rectangle lineBounds = aLine.getLineBounds();
                if (p.y < lineBounds.y + lineBounds.height) {
                    charIndex = aLine.getCharacterAtX(p.x);
                    break;
                }
                ++iter;
            }
        }
        return charIndex;
    }

    public Rectangle getCharacterBounds(int i) {
        Rectangle charBounds = new Rectangle();
        if (i >= 0 && i < this._text.length()) {
            int iter = 0;
            while (iter < this._lineMap.size()) {
                DocumentLine aLine = (DocumentLine)this._lineMap.elementAt(iter);
                if (i < aLine.getDocumentOffset() + aLine.getLength()) {
                    charBounds = aLine.getCharacterBounds(i - aLine.getDocumentOffset());
                    break;
                }
                ++iter;
            }
        }
        return charBounds;
    }

    public int getCharCount() {
        return this._text.length();
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public String getAtIndex(int part, int index) {
        if (index < 0 || index >= this._text.length()) {
            return null;
        }
        switch (part) {
            case 1: {
                return this._text.substring(index, index + 1);
            }
            case 2: 
            case 3: {
                BreakIterator iterator = this._getIterator(part);
                iterator.setText(this._text);
                int end = iterator.following(index);
                return this._text.substring(iterator.previous(), end);
            }
        }
        return null;
    }

    public String getAfterIndex(int part, int index) {
        if (part == 1) {
            return this.getAtIndex(part, index + 1);
        }
        if (index < 0 || index >= this._text.length()) {
            return null;
        }
        BreakIterator iterator = this._getIterator(part);
        iterator.setText(this._text);
        int start = iterator.following(index);
        if (start == -1 || start >= this._text.length()) {
            return null;
        }
        int end = iterator.following(start);
        if (end == -1 || end >= this._text.length()) {
            return null;
        }
        return this._text.substring(start, end);
    }

    public String getBeforeIndex(int part, int index) {
        if (part == 1) {
            return this.getAtIndex(part, index - 1);
        }
        if (index < 0 || index >= this._text.length()) {
            return null;
        }
        BreakIterator iterator = this._getIterator(part);
        iterator.setText(this._text);
        iterator.following(index);
        int end = iterator.previous();
        int start = iterator.previous();
        if (start == -1) {
            return null;
        }
        return this._text.substring(start, end);
    }

    public AttributeSet getCharacterAttribute(int i) {
        return SimpleAttributeSet.EMPTY;
    }

    public int getSelectionStart() {
        if (this._currentLine != null) {
            return this._currentLine.getDocumentOffset();
        }
        return 0;
    }

    public int getSelectionEnd() {
        if (this._currentLine != null) {
            return this._currentLine.getDocumentOffset() + this._currentLine.getLength();
        }
        return this._text.length();
    }

    public AccessibleText getAccessibleText() {
        return this;
    }

    public String getSelectedText() {
        if (this._currentLine != null) {
            return this._currentLine.getLine();
        }
        return this._text;
    }

    public void handleEvent(Event event) {
        DOMEvent dEvent = (DOMEvent)event;
        DNode eventTarget = (DNode)event.getTarget();
        switch (dEvent.getTypeId()) {
            case 13: {
                if (eventTarget == null || eventTarget.getNameId() != 13) break;
                this._buildDocumentData();
                break;
            }
            case 14: {
                if (eventTarget == null || eventTarget.getNameId() != 13) break;
                this._clearDocumentData(true);
                break;
            }
            case 10: {
                DOMUIEvent uiEvent = (DOMUIEvent)event;
                this._handleKeyUpEvent(uiEvent);
                break;
            }
            case 21: {
                if (eventTarget == null) break;
                this._handleFocusEvent(eventTarget);
                break;
            }
            case 30: {
                if (eventTarget == null) break;
                this._handleGotoEvent(eventTarget);
                break;
            }
        }
    }

    private void _handleGotoEvent(DNode target) {
        DAnchorElement anchorElement;
        String anchorName;
        Integer lineNumberObj;
        int lineNumber = 0;
        if (target instanceof DAnchorElement && (lineNumberObj = (Integer)this._namedAnchorTable.get(anchorName = (anchorElement = (DAnchorElement)target).getAttribute(63))) != null) {
            lineNumber = lineNumberObj;
        }
        if (this._lineMap.size() > 0) {
            if (lineNumber >= this._lineMap.size()) {
                lineNumber = this._lineMap.size() - 1;
            }
            DocumentLine aLine = (DocumentLine)this._lineMap.elementAt(lineNumber);
            int oldCaretPosition = this._caretPosition;
            this._caretPosition = aLine.getDocumentOffset();
            if (aLine != this._currentLine) {
                this._currentLine = aLine;
                this._statusComponent.setScreenReaderStatus(aLine.getLine());
            }
            if (this._caretPosition != oldCaretPosition) {
                this.firePropertyChange("AccessibleCaret", new Integer(oldCaretPosition), new Integer(this._caretPosition));
            }
        }
    }

    private void _handleFocusEvent(DNode target) {
        int iter = 0;
        while (iter < this._lineMap.size()) {
            DocumentLine aLine = (DocumentLine)this._lineMap.elementAt(iter);
            if (aLine.getNode() == target) {
                int oldCaretPosition = this._caretPosition;
                this._caretPosition = aLine.getDocumentOffset();
                if (aLine != this._currentLine) {
                    this._currentLine = aLine;
                    this._statusComponent.setScreenReaderStatus(aLine.getLine());
                }
                if (this._caretPosition == oldCaretPosition) break;
                this.firePropertyChange("AccessibleCaret", new Integer(oldCaretPosition), new Integer(this._caretPosition));
                break;
            }
            ++iter;
        }
    }

    private void _handleKeyUpEvent(DOMUIEvent uiEvent) {
        if (this._currentLine == null) {
            return;
        }
        int oldCaretPosition = this._caretPosition;
        if (uiEvent.getKeyCode() == (long)39) {
            if (this._caretPosition < this._text.length()) {
                ++this._caretPosition;
                if (this._caretPosition >= this._currentLine.getDocumentOffset() + this._currentLine.getLength()) {
                    this._currentLine = this._getNextLine(this._currentLine);
                }
            }
        } else if (uiEvent.getKeyCode() == (long)37) {
            if (this._caretPosition > 0) {
                --this._caretPosition;
                if (this._caretPosition < this._currentLine.getDocumentOffset()) {
                    this._currentLine = this._getPrevLine(this._currentLine);
                }
            }
        } else if (uiEvent.getKeyCode() == (long)38) {
            this._currentLine = this._getPrevLine(this._currentLine);
            this._caretPosition = this._currentLine.getDocumentOffset();
        } else if (uiEvent.getKeyCode() == (long)40) {
            if (this._currentLine.getLineNumber() < this._lineMap.size() - 1) {
                this._currentLine = this._getNextLine(this._currentLine);
                this._caretPosition = this._currentLine.getDocumentOffset();
            } else if (this._currentLine.getLineNumber() == this._lineMap.size() - 1) {
                this._caretPosition = this._text.length();
            }
        }
        if (oldCaretPosition != this._caretPosition) {
            this._currentLine.requestFocus();
            this.firePropertyChange("AccessibleCaret", new Integer(oldCaretPosition), new Integer(this._caretPosition));
        }
    }

    protected AccessibleContext getAccessibleContext() {
        return this._proxyContext;
    }

    private DocumentLine _getPrevLine(DocumentLine aLine) {
        DocumentLine newLine;
        if (aLine.getLineNumber() > 0 && (newLine = (DocumentLine)this._lineMap.elementAt(aLine.getLineNumber() - 1)) != null) {
            return newLine;
        }
        return aLine;
    }

    private DocumentLine _getNextLine(DocumentLine aLine) {
        DocumentLine newLine;
        if (aLine.getLineNumber() < this._lineMap.size() - 1 && (newLine = (DocumentLine)this._lineMap.elementAt(aLine.getLineNumber() + 1)) != null) {
            return newLine;
        }
        return aLine;
    }

    private synchronized void _buildDocumentData() {
        if (this._body != null) {
            this._clearDocumentData(false);
        }
        this._document = (DDocument)this._pilot.getDocument();
        this._body = (DElement)this._document.getBody();
        this._documentTitle = this._document.getTitle();
        Object objectCopy = this._document.clone(true);
        DDocument copyDDocument = (DDocument)objectCopy;
        ListInfo listInfo = new ListInfo();
        listInfo.setAllListInfo(copyDDocument.getDocumentDElement());
        TableLayoutHeadInfo tableLayoutHeadInfo = new TableLayoutHeadInfo(copyDDocument);
        tableLayoutHeadInfo.setTableLayoutHeadInfo(copyDDocument);
        this._body = (DElement)copyDDocument.getBody();
        if (this._body == null) {
            this._text = "";
        } else {
            StringBuffer textBuff = new StringBuffer();
            this._populateDocumentMap(this._body, textBuff, this._lineMap, this._linkVector, this._namedAnchorTable);
            this._text = textBuff.toString();
        }
        this._caretPosition = 0;
        if (this._lineMap.size() > 0) {
            this._currentLine = (DocumentLine)this._lineMap.elementAt(0);
        }
        this.firePropertyChange("AccessibleName", null, this.getAccessibleName());
        this.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
    }

    private synchronized void _clearDocumentData(boolean fireChangeEvents) {
        String oldName = this.getAccessibleName();
        this._document = (DDocument)this._pilot.getDocument();
        this._body = null;
        this._documentTitle = null;
        this._lineMap.removeAllElements();
        int linkIter = 0;
        while (linkIter < this._linkVector.size()) {
            DocumentLink aLink = (DocumentLink)this._linkVector.elementAt(linkIter);
            aLink.setValid(false);
            ++linkIter;
        }
        this._linkVector.removeAllElements();
        this._namedAnchorTable.clear();
        this._text = "";
        this._currentLine = null;
        this._caretPosition = 0;
        if (fireChangeEvents) {
            this.firePropertyChange("AccessibleName", oldName, this.getAccessibleName());
            this.firePropertyChange("AccessibleText", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private BreakIterator _getIterator(int part) {
        if (part == 2) {
            return BreakIterator.getWordInstance(this.getLocale());
        }
        return BreakIterator.getSentenceInstance(this.getLocale());
    }

    private void _populateDocumentMap(DNode currentNode, StringBuffer buff, Vector documentMap, Vector linkVector, Hashtable namedAnchorTable) {
        if (currentNode == null) {
            return;
        }
        if (currentNode instanceof DTextNode) {
            this._handleTextNode((DTextNode)currentNode, buff, documentMap);
        } else {
            if (currentNode instanceof DImageElement) {
                this._handleImageNode((DImageElement)currentNode, buff, documentMap);
                return;
            }
            if (currentNode instanceof DInputElement) {
                this._handleInputNode((DInputElement)currentNode, buff, documentMap);
                return;
            }
            if (currentNode instanceof DAnchorElement) {
                this._handleLinkNode((DAnchorElement)currentNode, buff, documentMap, linkVector, namedAnchorTable);
                return;
            }
        }
        DNode iter = (DNode)currentNode.getFirstChild();
        while (iter != null) {
            this._populateDocumentMap(iter, buff, documentMap, linkVector, namedAnchorTable);
            iter = (DNode)iter.getNextSibling();
        }
    }

    private void _handleImageNode(DImageElement imageElement, StringBuffer buff, Vector documentMap) {
        if (imageElement != null) {
            String imageSrc;
            DNode parent;
            String altInformation = imageElement.getAlt();
            if (altInformation == null && (parent = (DNode)imageElement.getParentNode()) != null && parent instanceof DAnchorElement && (imageSrc = imageElement.getSrc()) != null) {
                altInformation = imageSrc;
            }
            if (altInformation != null && altInformation.length() > 0) {
                String imageString = this.IMAGE_IDENTIFIER + " " + altInformation;
                DocumentLine newLine = new DocumentLine(imageElement, imageString, documentMap.size(), buff.length());
                documentMap.addElement(newLine);
                buff.append(newLine.getLine());
            }
        }
    }

    private void _handleInputNode(DInputElement inputElement, StringBuffer buff, Vector documentMap) {
        if (inputElement != null && !inputElement.getAttribute("type").equalsIgnoreCase("hidden")) {
            String typeInformation = inputElement.getType();
            String altInformation = inputElement.getAlt();
            String inputString = this.INPUT_IDENTIFIER + " " + typeInformation;
            if (altInformation != null) {
                inputString = inputString + " " + altInformation;
            }
            if (inputElement.getAttribute(111).equalsIgnoreCase("submit") && inputElement.getValue() != null) {
                inputString = inputString + " " + inputElement.getValue();
            }
            DocumentLine newLine = new DocumentLine(inputElement, inputString, documentMap.size(), buff.length());
            documentMap.addElement(newLine);
            buff.append(newLine.getLine());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _handleTextNode(DTextNode textNode, StringBuffer buff, Vector documentMap) {
        iterator = BreakIterator.getLineInstance(this.getLocale());
        remainingText = textNode.getData();
        if (!textNode.getParentNode().getLocalName().equalsIgnoreCase("script")) ** GOTO lbl30
        return;
lbl-1000:
        // 1 sources

        {
            beforeLine = 0;
            afterLine = remainingText.length();
            if (remainingText.length() > AccessibleHyperPanel.FAKE_LINE_LENGTH) {
                iterator.setText(remainingText);
                afterLine = iterator.following(AccessibleHyperPanel.FAKE_LINE_LENGTH);
                beforeLine = iterator.previous();
                if (beforeLine == -1) {
                    beforeLine = 0;
                }
                if (afterLine == -1) {
                    afterLine = remainingText.length();
                }
            }
            newLine = "";
            if (beforeLine == 0) {
                newLine = remainingText.substring(0, afterLine);
                remainingText = remainingText.substring(afterLine);
            } else {
                newLine = remainingText.substring(0, beforeLine);
                remainingText = remainingText.substring(beforeLine);
            }
            nbspChar = '\u00a0';
            newLine = newLine.replace(nbspChar, ' ');
            newLine = newLine.trim();
            if (newLine.length() <= 0) continue;
            documentLine = new DocumentLine(textNode, newLine, documentMap.size(), buff.length());
            documentMap.addElement(documentLine);
            buff.append(documentLine.getLine());
lbl30:
            // 3 sources

            ** while (remainingText.length() > 0)
        }
lbl31:
        // 1 sources

    }

    private void _handleLinkNode(DAnchorElement anchor, StringBuffer buff, Vector documentMap, Vector linkVector, Hashtable namedAnchorTable) {
        if (anchor != null) {
            String anchorName;
            DocumentLink aLink = new DocumentLink(anchor, buff.length());
            if (aLink.getHREF() != null) {
                linkVector.addElement(aLink);
                DocumentLine newLine = new DocumentLine(anchor, aLink.getLinkText(), documentMap.size(), buff.length());
                documentMap.addElement(newLine);
                buff.append(newLine.getLine());
            }
            if ((anchorName = aLink.getName()) != null) {
                namedAnchorTable.put(anchorName, new Integer(documentMap.size()));
            }
        }
    }

    static int ra$FAKE_CHAR_WIDTH() {
        return FAKE_CHAR_WIDTH;
    }

    static int ra$FAKE_CHAR_HEIGHT() {
        return FAKE_CHAR_HEIGHT;
    }

    static DDocument ra$_document(AccessibleHyperPanel accessibleHyperPanel) {
        return accessibleHyperPanel._document;
    }

    static void mav$_populateDocumentMap(AccessibleHyperPanel accessibleHyperPanel, DNode dNode, StringBuffer stringBuffer, Vector vector, Vector vector2, Hashtable hashtable) {
        accessibleHyperPanel._populateDocumentMap(dNode, stringBuffer, vector, vector2, hashtable);
    }

    static String ra$LINK_IDENTIFIER(AccessibleHyperPanel accessibleHyperPanel) {
        return accessibleHyperPanel.LINK_IDENTIFIER;
    }

    private class DocumentLine {
        private DNode _node;
        private String _line;
        private int _lineNumber;
        private int _documentOffset;

        public DocumentLine(DNode node, String line) {
            this.$init$();
            this._node = node;
            this._line = line;
        }

        public DocumentLine(DNode node, String line, int lineNumber, int documentOffset) {
            this.$init$();
            this._node = node;
            this._line = line.endsWith(".") || line.endsWith("?") || line.endsWith("!") ? line : line + ".";
            this._lineNumber = lineNumber;
            this._documentOffset = documentOffset;
        }

        public String getLine() {
            return this._line;
        }

        public int getLength() {
            return this._line.length();
        }

        public DNode getNode() {
            return this._node;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public int getDocumentOffset() {
            return this._documentOffset;
        }

        public void setLineNumber(int lineNumber) {
            this._lineNumber = lineNumber;
        }

        public void setDocumentOffset(int documentOffset) {
            this._documentOffset = documentOffset;
        }

        public void requestFocus() {
            TheView view = (TheView)AccessibleHyperPanel.ra$_document(AccessibleHyperPanel.this).getDefaultView();
            if (view != null) {
                if (this._node instanceof DElement) {
                    view.processFocusCall((DElement)this._node);
                } else {
                    view.processBlurCall(this._node);
                }
            }
        }

        public Rectangle getLineBounds() {
            Rectangle bounds = new Rectangle();
            bounds.setSize(AccessibleHyperPanel.ra$FAKE_CHAR_WIDTH() * this._line.length(), AccessibleHyperPanel.ra$FAKE_CHAR_HEIGHT());
            bounds.setLocation(0, this._lineNumber * AccessibleHyperPanel.ra$FAKE_CHAR_HEIGHT());
            return bounds;
        }

        public Rectangle getCharacterBounds(int charIndex) {
            Rectangle bounds = new Rectangle();
            if (charIndex >= 0 && charIndex < this._line.length()) {
                bounds.setSize(AccessibleHyperPanel.ra$FAKE_CHAR_WIDTH(), AccessibleHyperPanel.ra$FAKE_CHAR_HEIGHT());
                bounds.setLocation(charIndex * AccessibleHyperPanel.ra$FAKE_CHAR_WIDTH(), this._lineNumber * AccessibleHyperPanel.ra$FAKE_CHAR_HEIGHT());
            }
            return bounds;
        }

        public int getCharacterAtX(int xPos) {
            int charIndex = xPos / AccessibleHyperPanel.ra$FAKE_CHAR_WIDTH();
            if (charIndex > this._line.length()) {
                charIndex = -1;
            }
            return charIndex;
        }

        private void $init$() {
            this._node = null;
            this._line = null;
            this._lineNumber = 0;
            this._documentOffset = 0;
        }
    }

    public class DocumentLink
    extends AccessibleHyperlink {
        private DAnchorElement _linkElement;
        private int _documentOffset;
        private String _linkText;
        private URL _linkURL;
        private boolean _isValid;

        public DocumentLink(DAnchorElement anchor, int documentOffset) {
            this.$init$();
            this._linkElement = anchor;
            this._documentOffset = documentOffset;
            this._isValid = true;
            try {
                this._linkURL = new URL(AccessibleHyperPanel.ra$_document(AccessibleHyperPanel.this).resolveUrl(this._linkElement.getHref()));
            }
            catch (Exception e) {
                this._linkURL = null;
            }
            this._populateLinkText();
        }

        public String getLinkText() {
            return this._linkText;
        }

        public String getHREF() {
            return this._linkElement.getAttribute(46);
        }

        public String getName() {
            return this._linkElement.getAttribute(63);
        }

        public URL getLinkURL() {
            return this._linkURL;
        }

        public void setValid(boolean isValid) {
            this._isValid = isValid;
        }

        public boolean isValid() {
            return this._isValid;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int i) {
            if (i == 0 && this.isValid()) {
                this._linkElement.click();
                return true;
            }
            return false;
        }

        public String getAccessibleActionDescription(int i) {
            if (i == 0 && this.isValid()) {
                return this._linkText;
            }
            return null;
        }

        public Object getAccessibleActionObject(int i) {
            if (i == 0 && this.isValid()) {
                return this._linkURL;
            }
            return null;
        }

        public Object getAccessibleActionAnchor(int i) {
            return this.getAccessibleActionDescription(i);
        }

        public int getStartIndex() {
            return this._documentOffset;
        }

        public int getEndIndex() {
            return this._documentOffset + this._linkText.length();
        }

        private void _populateLinkText() {
            Vector tempVector = new Vector();
            StringBuffer tempBuffer = new StringBuffer("");
            Hashtable tempTable = new Hashtable();
            DNode iter = (DNode)this._linkElement.getFirstChild();
            while (iter != null) {
                AccessibleHyperPanel.mav$_populateDocumentMap(AccessibleHyperPanel.this, iter, tempBuffer, tempVector, tempVector, tempTable);
                iter = (DNode)iter.getNextSibling();
            }
            tempVector.removeAllElements();
            this._linkText = AccessibleHyperPanel.ra$LINK_IDENTIFIER(AccessibleHyperPanel.this) + " " + tempBuffer.toString();
        }

        private void $init$() {
            this._linkElement = null;
            this._documentOffset = 0;
            this._linkText = "";
            this._linkURL = null;
            this._isValid = true;
        }
    }

    protected class ListInfo {
        protected ListInfo() {
        }

        public void setAllListInfo(DElement dElement) {
            if (dElement == null) {
                return;
            }
            Node currentDNode = dElement.getFirstChild();
            while (currentDNode != null) {
                if (currentDNode instanceof DElement && this.isListTag((DElement)currentDNode)) {
                    this.printChildren((DElement)currentDNode);
                } else if (currentDNode instanceof DElement) {
                    this.setAllListInfo((DElement)currentDNode);
                }
                currentDNode = (DNode)currentDNode.getNextSibling();
            }
        }

        private int getNestedLevel(DElement dElement) {
            int count = 0;
            Node node = dElement.getParentNode();
            while (node != null && !(node instanceof DocumentImpl)) {
                if (node instanceof DElement && (((DElement)node).getNameId() == 61 || ((DElement)node).getNameId() == 90 || ((DElement)node).getNameId() == 27)) {
                    ++count;
                    break;
                }
                node = node.getParentNode();
            }
            return count;
        }

        private void printChildren(DElement currentDNode) {
            this.setListInfo(currentDNode);
            NodeList nodeList = currentDNode.getChildNodes();
            int j = 0;
            while (j < nodeList.getLength()) {
                Node cNode = nodeList.item(j);
                if (cNode != null && cNode instanceof DElement && cNode.hasChildNodes()) {
                    if (this.isChildHasListTag((DElement)cNode)) {
                        DElement cElement = this.getChildListTag((DElement)cNode);
                        this.printChildren(cElement);
                    } else if (this.isListTag((DElement)cNode)) {
                        this.printChildren((DElement)cNode);
                    }
                }
                ++j;
            }
        }

        private DElement getChildListTag(DNode pNode) {
            NodeList nodeList = pNode.getChildNodes();
            int j = 0;
            while (j < nodeList.getLength()) {
                int nameId;
                Node cNode = nodeList.item(j);
                if (cNode != null && cNode instanceof DElement && cNode.hasChildNodes() && ((nameId = ((DElement)cNode).getNameId()) == 61 || nameId == 90 || nameId == 27)) {
                    return (DElement)cNode;
                }
                ++j;
            }
            return null;
        }

        private boolean isChildHasListTag(DNode pNode) {
            NodeList nodeList = pNode.getChildNodes();
            int j = 0;
            while (j < nodeList.getLength()) {
                Node cNode = nodeList.item(j);
                if (cNode != null && cNode instanceof DElement && cNode.hasChildNodes()) {
                    return this.isListTag((DElement)cNode);
                }
                ++j;
            }
            return false;
        }

        private boolean isListTag(DNode node) {
            int nameId = node.getNameId();
            return nameId == 61 || nameId == 90 || nameId == 27;
        }

        private void setListInfo(DNode temp) {
            int count = this.getChildNodeCountByTagName(temp, new int[]{53, 22});
            int nestedCount = this.getNestedLevel((DElement)temp);
            DTextNode textNode = this.getFirstDTextNode(temp);
            if (textNode != null && count > 0) {
                String modified = "list with ";
                modified = count == 1 ? modified + count + " item " : modified + count + " items ";
                if (nestedCount > 0) {
                    modified = modified + " nesting level " + nestedCount + " ";
                }
                textNode.setData(modified + textNode.getData());
                Debug.p("set List Tag Info :" + textNode.getData());
            }
        }

        private int getChildNodeCountByTagName(DNode pNode, int[] tagName) {
            NodeList allList = pNode.getChildNodes();
            DNode[] nodes = new DNode[allList.getLength()];
            int count = 0;
            int i = 0;
            while (i < allList.getLength()) {
                nodes[i] = (DNode)allList.item(i);
                int j = 0;
                while (j < tagName.length) {
                    if (nodes[i].getNameId() == tagName[j]) {
                        ++count;
                        if (pNode.getNameId() == 61 || pNode.getNameId() == 90 || pNode.getNameId() == 27) {
                            DTextNode textNode = this.getFirstDTextNode(nodes[i]);
                            String modified = count + " ";
                            textNode.setData(modified + textNode.getData());
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return count;
        }

        private DTextNode getFirstDTextNode(DNode temp) {
            Node node = temp.getFirstChild();
            while (node != null) {
                if (node instanceof DTextNode) {
                    return (DTextNode)node;
                }
                node = node.getFirstChild();
            }
            return null;
        }
    }

    protected class TableLayoutHeadInfo {
        private DDocument _CopyDDocument;
        private String TABLE_TH_SCOPE;
        private String[] rowScopes;

        private void $init$() {
            this.TABLE_TH_SCOPE = null;
            this.rowScopes = null;
        }

        protected TableLayoutHeadInfo(DDocument copyDocument) {
            this.$init$();
            this._CopyDDocument = copyDocument;
        }

        private DTextNode getValidDTextNode(TableElement tElement) {
            HTMLTableSectionElement htmlTableSectionTable = tElement.getTHead();
            if (htmlTableSectionTable != null) {
                HTMLCollection htmlCollection = htmlTableSectionTable.getRows();
                DTextNode textNodeThead = this.getChildWithDTextNode(htmlCollection);
                if (textNodeThead != null) {
                    return textNodeThead;
                }
            } else {
                DTextNode textNode;
                HTMLCollection htmlCollection = tElement.getRows();
                if (htmlCollection.getLength() > 0 && (textNode = this.getChildWithDTextNode(htmlCollection)) != null) {
                    return textNode;
                }
            }
            return null;
        }

        private void tableTHheadWithTDid(DElement nElement) {
            DTextNode headTextNode;
            DElement element;
            DTextNode textNode;
            String headerAttr = nElement.getAttribute(44);
            if (headerAttr != null && nElement instanceof TableCellElement && (textNode = this.getFirstDTextNode(nElement)) != null && (element = (DElement)this._CopyDDocument.getElementById(nElement.getAttribute(44))) != null && (headTextNode = this.getFirstDTextNode(element)) != null) {
                textNode.setData(headTextNode.getData().trim() + " " + textNode.getData());
            }
        }

        private void tableTDScope(DElement firstTD, int colIndex) {
            String scopeAttr = firstTD.getAttribute(96);
            if (scopeAttr != null) {
                DNode pNode = firstTD.getParentDNode();
                if (firstTD.getNameId() == 81 && scopeAttr.equalsIgnoreCase("row") && pNode instanceof TableRowElement && colIndex < 1) {
                    TableRowElement tableRowElement = (TableRowElement)pNode;
                    HTMLCollection rCells = tableRowElement.getCells();
                    int k = 1;
                    while (k < rCells.getLength()) {
                        Node inCell = rCells.item(k);
                        if (inCell instanceof TableCellElement) {
                            this.setModifiedDTextNodeData((DElement)((TableCellElement)inCell), firstTD);
                        }
                        ++k;
                    }
                }
            }
        }

        private void setTableTHScopeString(DElement nElement) {
            String colgroupString = null;
            String scope = nElement.getAttribute(96);
            if (scope != null) {
                DTextNode colgroup = this.getFirstDTextNode(nElement);
                colgroupString = colgroup.getData();
            }
            this.TABLE_TH_SCOPE = colgroupString;
        }

        private void tableTHScope(TableElement tElement, DElement nElement, int rowIndex, int columnIndex) {
            String tag = nElement.getTagName();
            String scope = nElement.getAttribute(96);
            if (tag.equals("TH") && scope != null) {
                if (scope.equals("colgroup") && rowIndex == 0) {
                    this.setTableTHScopeString(nElement);
                }
                if (scope.equals("col") && rowIndex < 2) {
                    DTextNode col = this.getFirstDTextNode(nElement);
                    String headString = col.getData();
                    String abbrString = nElement.getAttribute(1);
                    if (abbrString != null) {
                        headString = abbrString;
                    }
                    if (this.TABLE_TH_SCOPE != null) {
                        headString = this.TABLE_TH_SCOPE + " " + headString;
                    }
                    HTMLCollection htmlCollection = tElement.getRows();
                    int j = rowIndex + 1;
                    while (j < htmlCollection.getLength()) {
                        TableRowElement tableRowElement;
                        Node cNode;
                        Node rowNode = tElement.getRows().item(j);
                        if (rowNode instanceof TableRowElement && (cNode = (tableRowElement = (TableRowElement)rowNode).getCells().item(columnIndex)) instanceof DElement) {
                            this.setModifiedDTextNodeData((DElement)cNode, headString);
                        }
                        ++j;
                    }
                }
            }
        }

        private void setAccessibleTheadDetails(TableElement tElement) {
            HTMLCollection htmlCollection = tElement.getRows();
            this.rowScopes = new String[this.getTableRowCounts(tElement)];
            int deep = htmlCollection.getLength();
            int i = 0;
            while (i < deep) {
                Node firstNode = htmlCollection.item(i);
                if (firstNode instanceof HTMLTableRowElement) {
                    HTMLTableRowElement rowElement = (HTMLTableRowElement)firstNode;
                    HTMLCollection insideHtml = rowElement.getCells();
                    int j = 0;
                    while (j < insideHtml.getLength()) {
                        Node node = insideHtml.item(j);
                        if (node instanceof DElement) {
                            boolean doTDWithHeaders = Defs.sysPropertyBoolean("ice.pilots.html4.swing.accessible.jaws.tableinfo.TDWithHeaders", false);
                            if (doTDWithHeaders) {
                                this.tableTHheadWithTDid((DElement)node);
                            }
                            boolean doTDWithScope = Defs.sysPropertyBoolean("ice.pilots.html4.swing.accessible.jaws.tableinfo.TDWithScope", false);
                            boolean doTHWithScope = Defs.sysPropertyBoolean("ice.pilots.html4.swing.accessible.jaws.tableinfo.THWithScope", false);
                            if (doTHWithScope && !doTDWithScope) {
                                this.tableTHScope(tElement, (DElement)node, i, j);
                            }
                            if (doTDWithScope && !doTHWithScope) {
                                this.tableTDScope((DElement)node, j);
                            }
                            if (doTDWithScope && doTHWithScope) {
                                this.tableTHTDScope(tElement, (DElement)node, i, j);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private DElement getTableTDScopeElement(DElement firstTD) {
            String scopeAttr = firstTD.getAttribute(96);
            DElement temp = null;
            DNode pNode = firstTD.getParentDNode();
            if (scopeAttr != null && firstTD.getNameId() == 81 && scopeAttr.equalsIgnoreCase("row") && pNode instanceof TableRowElement) {
                temp = firstTD;
            }
            return temp;
        }

        private void tableTHTDScope(TableElement tElement, DElement nElement, int rowIndex, int columnIndex) {
            String tag = nElement.getTagName();
            String scope = nElement.getAttribute(96);
            if (tag.equals("TH") && scope != null) {
                if (scope.equals("colgroup") && rowIndex == 0) {
                    this.setTableTHScopeString(nElement);
                }
                if (scope.equals("col") && rowIndex < 2) {
                    DTextNode col = this.getFirstDTextNode(nElement);
                    String headString = col.getData();
                    String abbrString = nElement.getAttribute(1);
                    if (abbrString != null) {
                        headString = abbrString;
                    }
                    if (this.TABLE_TH_SCOPE != null) {
                        headString = this.TABLE_TH_SCOPE + " " + headString;
                    }
                    HTMLCollection htmlCollection = tElement.getRows();
                    int j = rowIndex + 1;
                    while (j < htmlCollection.getLength()) {
                        TableRowElement tableRowElement;
                        Node cNode;
                        Node rowNode = tElement.getRows().item(j);
                        if (rowNode instanceof TableRowElement && (cNode = (tableRowElement = (TableRowElement)rowNode).getCells().item(columnIndex)) instanceof DElement) {
                            DElement testElement;
                            String scopeTemp = headString;
                            if (this.rowScopes[j] != null && this.getTableTDScopeElement((DElement)cNode) == null) {
                                headString = headString + " " + this.rowScopes[j];
                            }
                            if (columnIndex == 0 && (testElement = this.getTableTDScopeElement((DElement)cNode)) != null) {
                                this.rowScopes[j] = this.getFirstDTextNode(testElement).getData();
                            }
                            this.setModifiedDTextNodeData((DElement)cNode, headString);
                            headString = scopeTemp;
                        }
                        ++j;
                    }
                }
            }
        }

        private void setModifiedDTextNodeData(DElement oldElement, String headString) {
            DTextNode oldNode = this.getFirstDTextNode(oldElement);
            if (oldNode != null) {
                oldNode.setData(headString.trim() + " " + oldNode.getData());
            }
        }

        private void setModifiedDTextNodeData(DElement oldElement, DElement headElement) {
            DTextNode oldNode = this.getFirstDTextNode(oldElement);
            DTextNode insertNode = this.getFirstDTextNode(headElement);
            if (oldNode != null && insertNode != null) {
                oldNode.setData(insertNode.getData().trim() + " " + oldNode.getData());
            }
        }

        private int getTableColCounts(DNode node) {
            int numCols = -1;
            if (node instanceof TableElement) {
                TableElement tableElement = (TableElement)node;
                int i = 0;
                while (i < tableElement.getRows().getLength()) {
                    HTMLTableRowElement htmlTableRowElement = (HTMLTableRowElement)tableElement.getRows().item(i);
                    int temp = htmlTableRowElement.getCells().getLength();
                    if (temp > numCols) {
                        numCols = temp;
                    }
                    ++i;
                }
                return numCols;
            }
            return numCols;
        }

        private int getTableRowCounts(DNode node) {
            int rowCount = -1;
            if (node instanceof TableElement) {
                TableElement tableElement = (TableElement)node;
                rowCount = tableElement.getRows().getLength();
                return rowCount;
            }
            return rowCount;
        }

        private void setAccessibleTableDetails(TableElement tElement) {
            String summary = tElement.getSummary();
            int colCounts = this.getTableColCounts(tElement);
            int rowCounts = this.getTableRowCounts(tElement);
            String tableLayout = " this is a table with " + colCounts + " columns and " + rowCounts + " rows ";
            HTMLTableCaptionElement htmlTableCaption = tElement.getCaption();
            if (htmlTableCaption != null) {
                DTextNode textNodeCaption = this.getFirstDTextNode((DNode)((Object)htmlTableCaption));
                if (textNodeCaption != null && (colCounts > 1 || rowCounts > 1)) {
                    String modified = "caption " + textNodeCaption.getData();
                    modified = summary != null ? modified + " summary " + summary + tableLayout : modified + tableLayout;
                    textNodeCaption.setData(modified);
                }
            } else {
                DTextNode textNode = this.getValidDTextNode(tElement);
                if (textNode != null && (colCounts > 1 || rowCounts > 1)) {
                    String modified = "";
                    if (summary != null) {
                        modified = summary + tableLayout;
                    }
                    modified = tableLayout + textNode.getData();
                    textNode.setData(modified);
                }
            }
        }

        private DTextNode getChildWithDTextNode(HTMLCollection htmlCollection) {
            Node firstNode;
            if (htmlCollection.getLength() > 0 && (firstNode = htmlCollection.item(0)) instanceof HTMLTableRowElement) {
                HTMLTableRowElement rowElement = (HTMLTableRowElement)firstNode;
                HTMLCollection insideHtml = rowElement.getCells();
                int j = 0;
                while (j < insideHtml.getLength()) {
                    Node node = insideHtml.item(j);
                    DTextNode textNode = this.getFirstDTextNode((DNode)node);
                    if (textNode != null) {
                        return textNode;
                    }
                    ++j;
                }
            }
            return null;
        }

        public void setTableLayoutHeadInfo(DDocument dDocument) {
            NodeList nodeList = dDocument.getElementsByTagName("TABLE");
            DNode[] nodes = new DNode[nodeList.getLength()];
            int i = 0;
            while (i < nodeList.getLength()) {
                DNode node;
                nodes[i] = node = (DNode)nodeList.item(i);
                if (node instanceof TableElement) {
                    this.setAccessibleTheadDetails((TableElement)node);
                    boolean doTableLayout = Defs.sysPropertyBoolean("ice.pilots.html4.swing.accessible.jaws.tableinfo.tableLayout", true);
                    if (doTableLayout) {
                        this.setAccessibleTableDetails((TableElement)node);
                    }
                }
                ++i;
            }
        }

        private DTextNode getFirstDTextNode(DNode temp) {
            Node node = temp.getFirstChild();
            while (node != null) {
                if (node instanceof DTextNode) {
                    return (DTextNode)node;
                }
                node = node.getFirstChild();
            }
            return null;
        }
    }
}

