/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.domviewer;

import ice.pilots.domviewer.JavaPilot;
import ice.pilots.domviewer.MyNodeInfo;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;

public class DOMWindow
extends JPanel
implements TreeSelectionListener {
    JavaPilot the_pilot;
    JTree my_tree;
    JEditorPane view_area;
    URL loc;
    DefaultMutableTreeNode top;

    private void $init$() {
        this.the_pilot = null;
        this.my_tree = null;
        this.view_area = null;
        this.loc = null;
        this.top = null;
    }

    public DOMWindow(JavaPilot pilotobj) {
        super(new BorderLayout());
        this.$init$();
        this.the_pilot = pilotobj;
        this.top = new DefaultMutableTreeNode("The DOM Tree");
        this.my_tree = new JTree(this.top);
        this.my_tree.getSelectionModel().setSelectionMode(1);
        this.my_tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.my_tree);
        this.view_area = new JEditorPane();
        this.view_area.setEditable(false);
        this.view_area.setContentType("text/html");
        JScrollPane htmlView = new JScrollPane(this.view_area);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(htmlView);
        Dimension minimumSize = new Dimension(100, 50);
        htmlView.setMinimumSize(minimumSize);
        treeView.setMinimumSize(minimumSize);
        splitPane.setDividerLocation(200);
        splitPane.setPreferredSize(new Dimension(600, 400));
        this.add((Component)splitPane, "Center");
    }

    public void valueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.my_tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node == this.top) {
            Viewport v = this.the_pilot.get_other_view();
            String loc = null;
            String base = null;
            if (v != null) {
                loc = v.getLocation();
                base = v.getBaseUrl();
            }
            this.view_area.setText("<b>Location:</b> " + loc + "<br>" + "<b>Base:</b> " + base + "<br>");
        } else {
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof MyNodeInfo) {
                MyNodeInfo n = (MyNodeInfo)nodeInfo;
                if (n.node instanceof Node) {
                    this.displayNode((Node)n.node);
                }
            }
        }
    }

    String getAttrInfo(Node node) {
        DElement elem;
        String style;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        int len = attrs.getLength();
        if (len == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<b>Attributes:</b><br>");
        int i = 0;
        while (i < len) {
            String the_name;
            Node subnode = attrs.item(i);
            if (subnode != null && (the_name = subnode.getNodeName()) != null) {
                sb.append("&nbsp;&nbsp;&nbsp; ");
                sb.append(the_name);
                sb.append(" = ");
                sb.append("\"" + subnode.getNodeValue() + "\"");
                sb.append(" {" + subnode.getNamespaceURI() + "}");
                sb.append("<br>");
            }
            ++i;
        }
        if (node instanceof DElement && (style = (elem = (DElement)node).getStyle().getCssText()) != null && style.length() != 0) {
            sb.append("<b>Style:</b><br><pre>");
            sb.append(elem.getStyle().getCssText());
            sb.append("</pre>");
        }
        return sb.toString();
    }

    String getTypeAsText(int type) {
        String s = "";
        switch (type) {
            case 1: {
                s = "ELEMENT_NODE";
                break;
            }
            case 2: {
                s = "ATTRIBUTE_NODE";
                break;
            }
            case 3: {
                s = "TEXT_NODE";
                break;
            }
            case 4: {
                s = "CDATA_SECTION_NODE";
                break;
            }
            case 5: {
                s = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 6: {
                s = "ENTITY_NODE";
                break;
            }
            case 7: {
                s = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 8: {
                s = "COMMENT_NODE";
                break;
            }
            case 9: {
                s = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                s = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 11: {
                s = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 12: {
                s = "NOTATION_NODE";
                break;
            }
        }
        return s;
    }

    String getNameOfNode(Node node) {
        String the_name = "";
        if (node instanceof DElement && ((DElement)node).getSynthetic()) {
            the_name = "[*] ";
        }
        the_name = the_name + node.getNodeName();
        return the_name;
    }

    String getDispLine(String name, Object val) {
        return "<b>" + name + ":</b> " + val + "<br>\n";
    }

    void displayNode(Node info) {
        String its_name = this.getNameOfNode(info);
        String ns = info.getNamespaceURI();
        short its_type = info.getNodeType();
        String its_val = info.getNodeValue();
        String its_attrs = this.getAttrInfo(info);
        String total = "";
        if (its_name != null) {
            total = total + this.getDispLine("Name", its_name);
        }
        total = total + this.getDispLine("nsURI", ns);
        if (its_type > 0) {
            total = total + this.getDispLine("Type", this.getTypeAsText(its_type));
        }
        if (its_val != null) {
            total = total + this.getDispLine("Value", its_val);
        }
        if (its_attrs != null) {
            total = total + its_attrs;
        }
        this.view_area.setText(total);
    }

    void addNodes(Node from_node, DefaultMutableTreeNode where_add) {
        if (from_node.hasChildNodes()) {
            NodeList children = from_node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node a_node = children.item(i);
                DefaultMutableTreeNode where_we_are = new DefaultMutableTreeNode(new MyNodeInfo(a_node, this.getNameOfNode(a_node)));
                where_add.add(where_we_are);
                this.addNodes(a_node, where_we_are);
                ++i;
            }
        }
    }

    void addImages(Node rootnode) {
        HTMLCollection im_elms;
        DefaultMutableTreeNode image_elm = new DefaultMutableTreeNode("Images");
        Document the_doc = rootnode.getOwnerDocument();
        if (the_doc instanceof DDocument && (im_elms = ((DDocument)the_doc).getImages()) != null) {
            int i = 0;
            while (i < im_elms.getLength()) {
                Node a_node = im_elms.item(i);
                image_elm.add(new DefaultMutableTreeNode(new MyNodeInfo(a_node, this.getNameOfNode(a_node))));
                this.top.add(image_elm);
                ++i;
            }
        }
    }

    void addForms(Node rootnode) {
        HTMLCollection im_elms;
        DefaultMutableTreeNode image_elm = new DefaultMutableTreeNode("Forms");
        boolean empty = true;
        Document the_doc = rootnode.getOwnerDocument();
        if (the_doc instanceof DDocument && (im_elms = ((DDocument)the_doc).getForms()) != null) {
            int i = 0;
            while (i < im_elms.getLength()) {
                Node a_node = im_elms.item(i);
                DefaultMutableTreeNode addable = new DefaultMutableTreeNode(new MyNodeInfo(a_node, this.getNameOfNode(a_node)));
                image_elm.add(addable);
                empty = false;
                this.addNodes(a_node, addable);
                ++i;
            }
        }
        if (!empty) {
            this.top.add(image_elm);
        }
    }

    void addTags(Node rootnode, String tagName) {
        DefaultMutableTreeNode tag_elm = new DefaultMutableTreeNode(tagName + "s");
        boolean empty = true;
        Document a_doc = rootnode.getOwnerDocument();
        if (a_doc instanceof DDocument) {
            DDocument doc = (DDocument)a_doc;
            NodeList list = doc.getElementsByTagName(tagName);
            int i = 0;
            while (i < list.getLength()) {
                Node a_node = list.item(i);
                DefaultMutableTreeNode addable = new DefaultMutableTreeNode(new MyNodeInfo(a_node, this.getNameOfNode(a_node)));
                tag_elm.add(addable);
                empty = false;
                this.addNodes(a_node, addable);
                ++i;
            }
        }
        if (!empty) {
            this.top.add(tag_elm);
        }
    }

    void createNodes() {
        Element rootnode;
        if (this.the_pilot != null && this.the_pilot instanceof JavaPilot && (rootnode = this.the_pilot.getRootNode()) != null) {
            DefaultMutableTreeNode root_elm = new DefaultMutableTreeNode(new MyNodeInfo(rootnode, this.getNameOfNode(rootnode)));
            this.addNodes(rootnode, root_elm);
            this.top.add(root_elm);
            this.addImages(rootnode);
            this.addForms(rootnode);
            this.addTags(rootnode, "IFRAME");
            this.addTags(rootnode, "SCRIPT");
            this.repaint();
        }
    }
}

