/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.LineBuffer;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import java.io.IOException;
import java.io.Reader;

public class TokenStream {
    static final int TSF_NEWLINES = 1;
    static final int TSF_FUNCTION = 2;
    static final int TSF_RETURN_EXPR = 4;
    static final int TSF_RETURN_VOID = 8;
    static final int TSF_REGEXP = 16;
    static final int TSF_DIRTYLINE = 32;
    private static final int EOF_CHAR = -1;
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int POPV = 2;
    public static final int ENTERWITH = 3;
    public static final int LEAVEWITH = 4;
    public static final int RETURN = 5;
    public static final int GOTO = 6;
    public static final int IFEQ = 7;
    public static final int IFNE = 8;
    public static final int DUP = 9;
    public static final int SETNAME = 10;
    public static final int BITOR = 11;
    public static final int BITXOR = 12;
    public static final int BITAND = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int LSH = 20;
    public static final int RSH = 21;
    public static final int URSH = 22;
    public static final int ADD = 23;
    public static final int SUB = 24;
    public static final int MUL = 25;
    public static final int DIV = 26;
    public static final int MOD = 27;
    public static final int BITNOT = 28;
    public static final int NEG = 29;
    public static final int NEW = 30;
    public static final int DELPROP = 31;
    public static final int TYPEOF = 32;
    public static final int NAMEINC = 33;
    public static final int PROPINC = 34;
    public static final int ELEMINC = 35;
    public static final int NAMEDEC = 36;
    public static final int PROPDEC = 37;
    public static final int ELEMDEC = 38;
    public static final int GETPROP = 39;
    public static final int SETPROP = 40;
    public static final int GETELEM = 41;
    public static final int SETELEM = 42;
    public static final int CALL = 43;
    public static final int NAME = 44;
    public static final int NUMBER = 45;
    public static final int STRING = 46;
    public static final int ZERO = 47;
    public static final int ONE = 48;
    public static final int NULL = 49;
    public static final int THIS = 50;
    public static final int FALSE = 51;
    public static final int TRUE = 52;
    public static final int SHEQ = 53;
    public static final int SHNE = 54;
    public static final int CLOSURE = 55;
    public static final int REGEXP = 56;
    public static final int POP = 57;
    public static final int POS = 58;
    public static final int VARINC = 59;
    public static final int VARDEC = 60;
    public static final int BINDNAME = 61;
    public static final int THROW = 62;
    public static final int IN = 63;
    public static final int INSTANCEOF = 64;
    public static final int GOSUB = 65;
    public static final int RETSUB = 66;
    public static final int CALLSPECIAL = 67;
    public static final int GETTHIS = 68;
    public static final int NEWTEMP = 69;
    public static final int USETEMP = 70;
    public static final int GETBASE = 71;
    public static final int GETVAR = 72;
    public static final int SETVAR = 73;
    public static final int UNDEFINED = 74;
    public static final int TRY = 75;
    public static final int ENDTRY = 76;
    public static final int NEWSCOPE = 77;
    public static final int TYPEOFNAME = 78;
    public static final int ENUMINIT = 79;
    public static final int ENUMNEXT = 80;
    public static final int GETPROTO = 81;
    public static final int GETPARENT = 82;
    public static final int SETPROTO = 83;
    public static final int SETPARENT = 84;
    public static final int SCOPE = 85;
    public static final int GETSCOPEPARENT = 86;
    public static final int THISFN = 87;
    public static final int JTHROW = 88;
    public static final int SEMI = 89;
    public static final int LB = 90;
    public static final int RB = 91;
    public static final int LC = 92;
    public static final int RC = 93;
    public static final int LP = 94;
    public static final int RP = 95;
    public static final int COMMA = 96;
    public static final int ASSIGN = 97;
    public static final int HOOK = 98;
    public static final int COLON = 99;
    public static final int OR = 100;
    public static final int AND = 101;
    public static final int EQOP = 102;
    public static final int RELOP = 103;
    public static final int SHOP = 104;
    public static final int UNARYOP = 105;
    public static final int INC = 106;
    public static final int DEC = 107;
    public static final int DOT = 108;
    public static final int PRIMARY = 109;
    public static final int FUNCTION = 110;
    public static final int EXPORT = 111;
    public static final int IMPORT = 112;
    public static final int IF = 113;
    public static final int ELSE = 114;
    public static final int SWITCH = 115;
    public static final int CASE = 116;
    public static final int DEFAULT = 117;
    public static final int WHILE = 118;
    public static final int DO = 119;
    public static final int FOR = 120;
    public static final int BREAK = 121;
    public static final int CONTINUE = 122;
    public static final int VAR = 123;
    public static final int WITH = 124;
    public static final int CATCH = 125;
    public static final int FINALLY = 126;
    public static final int RESERVED = 127;
    public static final int NOP = 128;
    public static final int NOT = 129;
    public static final int PRE = 130;
    public static final int POST = 131;
    public static final int VOID = 132;
    public static final int BLOCK = 133;
    public static final int ARRAYLIT = 134;
    public static final int OBJLIT = 135;
    public static final int LABEL = 136;
    public static final int TARGET = 137;
    public static final int LOOP = 138;
    public static final int ENUMDONE = 139;
    public static final int EXPRSTMT = 140;
    public static final int PARENT = 141;
    public static final int CONVERT = 142;
    public static final int JSR = 143;
    public static final int NEWLOCAL = 144;
    public static final int USELOCAL = 145;
    public static final int SCRIPT = 146;
    public static final int LAST_TOKEN = 146;
    private LineBuffer in;
    int flags;
    String regExpFlags;
    private String sourceName;
    private String line;
    private Scriptable scope;
    private int pushbackToken;
    private int tokenno;
    private int op;
    private String string;
    private double number;
    private char[] stringBuffer;
    private int stringBufferTop;

    public static String tokenToName(int token) {
        return "";
    }

    public String tokenToString(int token) {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private int stringToKeyword(String name) {
        int id;
        block86: {
            int Id_break = 121;
            int Id_case = 116;
            int Id_continue = 122;
            int Id_default = 117;
            int Id_delete = 31;
            int Id_do = 119;
            int Id_else = 114;
            int Id_export = 111;
            int Id_false = 13165;
            int Id_for = 120;
            int Id_function = 110;
            int Id_if = 113;
            int Id_in = 16231;
            int Id_new = 30;
            int Id_null = 12653;
            int Id_return = 5;
            int Id_switch = 115;
            int Id_this = 12909;
            int Id_true = 13421;
            int Id_typeof = 8297;
            int Id_var = 123;
            int Id_void = 33897;
            int Id_while = 118;
            int Id_with = 124;
            int Id_abstract = 127;
            int Id_boolean = 127;
            int Id_byte = 127;
            int Id_catch = 125;
            int Id_char = 127;
            int Id_class = 127;
            int Id_const = 127;
            int Id_debugger = 127;
            int Id_double = 127;
            int Id_enum = 127;
            int Id_extends = 127;
            int Id_final = 127;
            int Id_finally = 126;
            int Id_float = 127;
            int Id_goto = 127;
            int Id_implements = 127;
            int Id_import = 112;
            int Id_instanceof = 16487;
            int Id_int = 127;
            int Id_interface = 127;
            int Id_long = 127;
            int Id_native = 127;
            int Id_package = 127;
            int Id_private = 127;
            int Id_protected = 127;
            int Id_public = 127;
            int Id_short = 127;
            int Id_static = 127;
            int Id_super = 127;
            int Id_synchronized = 127;
            int Id_throw = 62;
            int Id_throws = 127;
            int Id_transient = 127;
            int Id_try = 75;
            int Id_volatile = 127;
            String s = name;
            id = 0;
            String X = null;
            block0 : switch (s.length()) {
                case 2: {
                    char c = s.charAt(1);
                    if (c == 'f') {
                        if (s.charAt(0) != 'i') break;
                        id = 113;
                        break block86;
                    } else if (c == 'n') {
                        if (s.charAt(0) != 'i') break;
                        id = 16231;
                        break block86;
                    } else {
                        if (c != 'o' || s.charAt(0) != 'd') break;
                        id = 119;
                    }
                    break block86;
                }
                case 3: {
                    switch (s.charAt(0)) {
                        case 'f': {
                            if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                            id = 120;
                            break block86;
                        }
                        case 'i': {
                            if (s.charAt(2) != 't' || s.charAt(1) != 'n') break;
                            id = 127;
                            break block86;
                        }
                        case 'n': {
                            if (s.charAt(2) != 'w' || s.charAt(1) != 'e') break;
                            id = 30;
                            break block86;
                        }
                        case 't': {
                            if (s.charAt(2) != 'y' || s.charAt(1) != 'r') break;
                            id = 75;
                            break block86;
                        }
                        case 'v': {
                            if (s.charAt(2) != 'r' || s.charAt(1) != 'a') break;
                            id = 123;
                            break block86;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (s.charAt(0)) {
                        case 'b': {
                            X = "byte";
                            id = 127;
                            break;
                        }
                        case 'c': {
                            char c = s.charAt(3);
                            if (c == 'e') {
                                if (s.charAt(2) != 's' || s.charAt(1) != 'a') break;
                                id = 116;
                                break block86;
                            } else {
                                if (c != 'r' || s.charAt(2) != 'a' || s.charAt(1) != 'h') break;
                                id = 127;
                            }
                            break block86;
                        }
                        case 'e': {
                            char c = s.charAt(3);
                            if (c == 'e') {
                                if (s.charAt(2) != 's' || s.charAt(1) != 'l') break;
                                id = 114;
                                break block86;
                            } else {
                                if (c != 'm' || s.charAt(2) != 'u' || s.charAt(1) != 'n') break;
                                id = 127;
                            }
                            break block86;
                        }
                        case 'g': {
                            X = "goto";
                            id = 127;
                            break;
                        }
                        case 'l': {
                            X = "long";
                            id = 127;
                            break;
                        }
                        case 'n': {
                            X = "null";
                            id = 12653;
                            break;
                        }
                        case 't': {
                            char c = s.charAt(3);
                            if (c == 'e') {
                                if (s.charAt(2) != 'u' || s.charAt(1) != 'r') break;
                                id = 13421;
                                break block86;
                            } else {
                                if (c != 's' || s.charAt(2) != 'i' || s.charAt(1) != 'h') break;
                                id = 12909;
                            }
                            break block86;
                        }
                        case 'v': {
                            X = "void";
                            id = 33897;
                            break;
                        }
                        case 'w': {
                            X = "with";
                            id = 124;
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (s.charAt(2)) {
                        case 'a': {
                            X = "class";
                            id = 127;
                            break;
                        }
                        case 'e': {
                            X = "break";
                            id = 121;
                            break;
                        }
                        case 'i': {
                            X = "while";
                            id = 118;
                            break;
                        }
                        case 'l': {
                            X = "false";
                            id = 13165;
                            break;
                        }
                        case 'n': {
                            char c = s.charAt(0);
                            if (c == 'c') {
                                X = "const";
                                id = 127;
                                break;
                            }
                            if (c != 'f') break;
                            X = "final";
                            id = 127;
                            break;
                        }
                        case 'o': {
                            char c = s.charAt(0);
                            if (c == 'f') {
                                X = "float";
                                id = 127;
                                break;
                            }
                            if (c != 's') break;
                            X = "short";
                            id = 127;
                            break;
                        }
                        case 'p': {
                            X = "super";
                            id = 127;
                            break;
                        }
                        case 'r': {
                            X = "throw";
                            id = 62;
                            break;
                        }
                        case 't': {
                            X = "catch";
                            id = 125;
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (s.charAt(1)) {
                        case 'a': {
                            X = "native";
                            id = 127;
                            break;
                        }
                        case 'e': {
                            char c = s.charAt(0);
                            if (c == 'd') {
                                X = "delete";
                                id = 31;
                                break;
                            }
                            if (c != 'r') break;
                            X = "return";
                            id = 5;
                            break;
                        }
                        case 'h': {
                            X = "throws";
                            id = 127;
                            break;
                        }
                        case 'm': {
                            X = "import";
                            id = 112;
                            break;
                        }
                        case 'o': {
                            X = "double";
                            id = 127;
                            break;
                        }
                        case 't': {
                            X = "static";
                            id = 127;
                            break;
                        }
                        case 'u': {
                            X = "public";
                            id = 127;
                            break;
                        }
                        case 'w': {
                            X = "switch";
                            id = 115;
                            break;
                        }
                        case 'x': {
                            X = "export";
                            id = 111;
                            break;
                        }
                        case 'y': {
                            X = "typeof";
                            id = 8297;
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (s.charAt(1)) {
                        case 'a': {
                            X = "package";
                            id = 127;
                            break block0;
                        }
                        case 'e': {
                            X = "default";
                            id = 117;
                            break block0;
                        }
                        case 'i': {
                            X = "finally";
                            id = 126;
                            break block0;
                        }
                        case 'o': {
                            X = "boolean";
                            id = 127;
                            break block0;
                        }
                        case 'r': {
                            X = "private";
                            id = 127;
                            break block0;
                        }
                        case 'x': {
                            X = "extends";
                            id = 127;
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (s.charAt(0)) {
                        case 'a': {
                            X = "abstract";
                            id = 127;
                            break block0;
                        }
                        case 'c': {
                            X = "continue";
                            id = 122;
                            break block0;
                        }
                        case 'd': {
                            X = "debugger";
                            id = 127;
                            break block0;
                        }
                        case 'f': {
                            X = "function";
                            id = 110;
                            break block0;
                        }
                        case 'v': {
                            X = "volatile";
                            id = 127;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    char c = s.charAt(0);
                    if (c == 'i') {
                        X = "interface";
                        id = 127;
                        break;
                    }
                    if (c == 'p') {
                        X = "protected";
                        id = 127;
                        break;
                    }
                    if (c != 't') break;
                    X = "transient";
                    id = 127;
                    break;
                }
                case 10: {
                    char c = s.charAt(1);
                    if (c == 'm') {
                        X = "implements";
                        id = 127;
                        break;
                    }
                    if (c != 'n') break;
                    X = "instanceof";
                    id = 16487;
                    break;
                }
                case 12: {
                    X = "synchronized";
                    id = 127;
                }
            }
            if (X != null && X != s && !X.equals(s)) {
                return 0;
            }
        }
        if (id == 0) {
            return 0;
        }
        this.op = id >> 8;
        return id & 0xFF;
    }

    public TokenStream(Reader in, Scriptable scope, String sourceName, int lineno) {
        this.$init$();
        this.in = new LineBuffer(in, lineno);
        this.scope = scope;
        this.pushbackToken = 0;
        this.sourceName = sourceName;
        this.flags = 0;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public boolean matchToken(int toMatch) throws IOException {
        int token = this.getToken();
        if (token == toMatch) {
            return true;
        }
        --this.tokenno;
        this.pushbackToken = token;
        return false;
    }

    public void clearPushback() {
        this.pushbackToken = 0;
    }

    public void ungetToken(int tt) {
        if (this.pushbackToken != 0 && tt != -1) {
            String message = Context.getMessage2("msg.token.replaces.pushback", this.tokenToString(tt), this.tokenToString(this.pushbackToken));
            throw new RuntimeException(message);
        }
        this.pushbackToken = tt;
        --this.tokenno;
    }

    public int peekToken() throws IOException {
        int result;
        this.pushbackToken = result = this.getToken();
        --this.tokenno;
        return result;
    }

    public int peekTokenSameLine() throws IOException {
        this.flags |= 1;
        int result = this.peekToken();
        this.flags &= 0xFFFFFFFE;
        if (this.pushbackToken == 1) {
            this.pushbackToken = 0;
        }
        return result;
    }

    protected static boolean isJSIdentifier(String s) {
        int length = s.length();
        if (length == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < length) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c == '\\' && i + 5 >= length && s.charAt(i + 1) == 'u' && 0 <= TokenStream.xDigitToInt(s.charAt(i + 2)) && 0 <= TokenStream.xDigitToInt(s.charAt(i + 3)) && 0 <= TokenStream.xDigitToInt(s.charAt(i + 4)) && 0 <= TokenStream.xDigitToInt(s.charAt(i + 5))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    static int xDigitToInt(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 87;
        }
        if (65 <= c && c <= 70) {
            return c - 55;
        }
        return -1;
    }

    public static boolean isJSSpace(int c) {
        return c == 32 || c == 9 || c == 12 || c == 11 || c == 160 || Character.getType((char)c) == 12;
    }

    public static boolean isJSLineTerminator(int c) {
        return c == 10 || c == 13 || c == 8232 || c == 8233;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.in.read()) != -1 && c != 10) {
        }
        this.in.unread();
    }

    /*
     * Unable to fully structure code
     */
    public int getToken() throws IOException {
        block124: {
            block125: {
                ++this.tokenno;
                if (this.pushbackToken != 0) {
                    result = this.pushbackToken;
                    this.pushbackToken = 0;
                    return result;
                }
                do {
                    if ((c = this.in.read()) != 10) continue;
                    this.flags &= -33;
                    if ((this.flags & 1) != 0) break;
                } while (TokenStream.isJSSpace(c) || c == 10);
                if (c == -1) {
                    return 0;
                }
                if (c != 45 && c != 10) {
                    this.flags |= 32;
                }
                isUnicodeEscapeStart = false;
                if (c == 92) {
                    c = this.in.read();
                    if (c == 117) {
                        identifierStart = true;
                        isUnicodeEscapeStart = true;
                        this.stringBufferTop = 0;
                    } else {
                        identifierStart = false;
                        c = 92;
                        this.in.unread();
                    }
                } else {
                    identifierStart = Character.isJavaIdentifierStart((char)c);
                    if (identifierStart) {
                        this.stringBufferTop = 0;
                        this.addToString(c);
                    }
                }
                if (identifierStart) {
                    containsEscape = isUnicodeEscapeStart;
                    while (true) {
                        if (isUnicodeEscapeStart) {
                            escapeVal = 0;
                            i = 0;
                            while (i != 4) {
                                c = this.in.read();
                                if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) break;
                                ++i;
                            }
                            if (escapeVal < 0) {
                                this.reportSyntaxError("msg.invalid.escape", null);
                                return -1;
                            }
                            this.addToString(escapeVal);
                            isUnicodeEscapeStart = false;
                            continue;
                        }
                        c = this.in.read();
                        if (c == 92) {
                            c = this.in.read();
                            if (c == 117) {
                                isUnicodeEscapeStart = true;
                                containsEscape = true;
                                continue;
                            }
                            this.reportSyntaxError("msg.illegal.character", null);
                            return -1;
                        }
                        if (!Character.isJavaIdentifierPart((char)c)) break;
                        this.addToString(c);
                    }
                    this.in.unread();
                    str = this.getStringFromBuffer();
                    if (!containsEscape && (result = this.stringToKeyword(str)) != 0) {
                        if (result != 127) {
                            return result;
                        }
                        if (!Context.getContext().hasFeature(3)) {
                            return result;
                        }
                        errArgs = new Object[]{str};
                        this.reportSyntaxWarning("msg.reserved.keyword", errArgs);
                    }
                    this.string = str;
                    return 44;
                }
                if (!TokenStream.isDigit(c) && (c != 46 || !TokenStream.isDigit(this.in.peek()))) break block124;
                this.stringBufferTop = 0;
                base = 10;
                if (c == 48) {
                    c = this.in.read();
                    if (c == 120 || c == 88) {
                        base = 16;
                        c = this.in.read();
                    } else if (TokenStream.isDigit(c)) {
                        base = 8;
                    } else {
                        this.addToString(48);
                    }
                }
                if (base != 16) ** GOTO lbl96
                while (0 <= TokenStream.xDigitToInt(c)) {
                    this.addToString(c);
                    c = this.in.read();
                }
                break block125;
lbl-1000:
                // 1 sources

                {
                    if (base == 8 && c >= 56) {
                        errArgs = new Object[]{c == 56 ? "8" : "9"};
                        this.reportSyntaxWarning("msg.bad.octal.literal", errArgs);
                        base = 10;
                    }
                    this.addToString(c);
                    c = this.in.read();
lbl96:
                    // 2 sources

                    ** while (48 <= c && c <= 57)
                }
            }
            isInteger = true;
            if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                isInteger = false;
                if (c == 46) {
                    do {
                        this.addToString(c);
                    } while (TokenStream.isDigit(c = this.in.read()));
                }
                if (c == 101 || c == 69) {
                    this.addToString(c);
                    c = this.in.read();
                    if (c == 43 || c == 45) {
                        this.addToString(c);
                        c = this.in.read();
                    }
                    if (!TokenStream.isDigit(c)) {
                        this.reportSyntaxError("msg.missing.exponent", null);
                        return -1;
                    }
                    do {
                        this.addToString(c);
                    } while (TokenStream.isDigit(c = this.in.read()));
                }
            }
            this.in.unread();
            numString = this.getStringFromBuffer();
            if (base == 10 && !isInteger) {
                try {
                    dval = Double.valueOf(numString);
                }
                catch (NumberFormatException ex) {
                    errArgs = new Object[]{ex.getMessage()};
                    this.reportSyntaxError("msg.caught.nfe", errArgs);
                    var27_18 = -1;
                    return var27_18;
                }
            } else {
                dval = ScriptRuntime.stringToNumber(numString, 0, base);
            }
            this.number = dval;
            return 45;
        }
        if (c == 34 || c == 39) {
            quoteChar = c;
            val = 0;
            this.stringBufferTop = 0;
            c = this.in.read();
            block46: while (c != quoteChar) {
                if (c == 10 || c == -1) {
                    this.in.unread();
                    this.reportSyntaxError("msg.unterminated.string.lit", null);
                    return -1;
                }
                if (c == 92) {
                    c = this.in.read();
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 117: {
                            escapeStart = this.stringBufferTop;
                            this.addToString(117);
                            escapeVal = 0;
                            i = 0;
                            while (i != 4) {
                                c = this.in.read();
                                if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) continue block46;
                                this.addToString(c);
                                ++i;
                            }
                            this.stringBufferTop = escapeStart;
                            c = escapeVal;
                            break;
                        }
                        case 120: {
                            c = this.in.read();
                            escapeVal = TokenStream.xDigitToInt(c);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                continue block46;
                            }
                            c1 = c;
                            c = this.in.read();
                            if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) {
                                this.addToString(120);
                                this.addToString(c1);
                                continue block46;
                            }
                            c = escapeVal;
                            break;
                        }
                        default: {
                            if (48 > c || c >= 56) break;
                            val = c - 48;
                            c = this.in.read();
                            if (48 <= c && c < 56) {
                                val = 8 * val + c - 48;
                                c = this.in.read();
                                if (48 <= c && c < 56 && val <= 31) {
                                    val = 8 * val + c - 48;
                                    c = this.in.read();
                                }
                            }
                            this.in.unread();
                            c = val;
                        }
                    }
                }
                this.addToString(c);
                c = this.in.read();
            }
            this.string = this.getStringFromBuffer();
            return 46;
        }
        switch (c) {
            case 10: {
                return 1;
            }
            case 59: {
                return 89;
            }
            case 91: {
                return 90;
            }
            case 93: {
                return 91;
            }
            case 123: {
                return 92;
            }
            case 125: {
                return 93;
            }
            case 40: {
                return 94;
            }
            case 41: {
                return 95;
            }
            case 44: {
                return 96;
            }
            case 63: {
                return 98;
            }
            case 58: {
                return 99;
            }
            case 46: {
                return 108;
            }
            case 124: {
                if (this.in.match(124)) {
                    return 100;
                }
                if (this.in.match(61)) {
                    this.op = 11;
                    return 97;
                }
                return 11;
            }
            case 94: {
                if (this.in.match(61)) {
                    this.op = 12;
                    return 97;
                }
                return 12;
            }
            case 38: {
                if (this.in.match(38)) {
                    return 101;
                }
                if (this.in.match(61)) {
                    this.op = 13;
                    return 97;
                }
                return 13;
            }
            case 61: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) != false ? 53 : 14;
                    return 102;
                }
                this.op = 128;
                return 97;
            }
            case 33: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) != false ? 54 : 15;
                    return 102;
                }
                this.op = 129;
                return 105;
            }
            case 60: {
                if (this.in.match(33)) {
                    if (this.in.match(45)) {
                        if (this.in.match(45)) {
                            this.skipLine();
                            return this.getToken();
                        }
                        this.in.unread();
                    }
                    this.in.unread();
                }
                if (this.in.match(60)) {
                    if (this.in.match(61)) {
                        this.op = 20;
                        return 97;
                    }
                    this.op = 20;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 17;
                    return 103;
                }
                this.op = 16;
                return 103;
            }
            case 62: {
                if (this.in.match(62)) {
                    if (this.in.match(62)) {
                        if (this.in.match(61)) {
                            this.op = 22;
                            return 97;
                        }
                        this.op = 22;
                        return 104;
                    }
                    if (this.in.match(61)) {
                        this.op = 21;
                        return 97;
                    }
                    this.op = 21;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 19;
                    return 103;
                }
                this.op = 18;
                return 103;
            }
            case 42: {
                if (this.in.match(61)) {
                    this.op = 25;
                    return 97;
                }
                return 25;
            }
            case 47: {
                if (this.in.match(47)) {
                    this.skipLine();
                    return this.getToken();
                }
                if (this.in.match(42)) {
                    while (!((c = this.in.read()) == -1 || c == 42 && this.in.match(47))) {
                    }
                    if (c == -1) {
                        this.reportSyntaxError("msg.unterminated.comment", null);
                        return -1;
                    }
                    return this.getToken();
                }
                if ((this.flags & 16) != 0) {
                    this.stringBufferTop = 0;
                    while ((c = this.in.read()) != 47) {
                        if (c == 10 || c == -1) {
                            this.in.unread();
                            this.reportSyntaxError("msg.unterminated.re.lit", null);
                            return -1;
                        }
                        if (c == 92) {
                            this.addToString(c);
                            c = this.in.read();
                        }
                        this.addToString(c);
                    }
                    reEnd = this.stringBufferTop;
                    while (true) {
                        if (this.in.match(103)) {
                            this.addToString(103);
                            continue;
                        }
                        if (this.in.match(105)) {
                            this.addToString(105);
                            continue;
                        }
                        if (!this.in.match(109)) break;
                        this.addToString(109);
                    }
                    if (TokenStream.isAlpha(this.in.peek())) {
                        this.reportSyntaxError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.string = new String(this.stringBuffer, 0, reEnd);
                    this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
                    return 56;
                }
                if (this.in.match(61)) {
                    this.op = 26;
                    return 97;
                }
                return 26;
            }
            case 37: {
                this.op = 27;
                if (this.in.match(61)) {
                    return 97;
                }
                return 27;
            }
            case 126: {
                this.op = 28;
                return 105;
            }
            case 43: {
                if (this.in.match(61)) {
                    this.op = 23;
                    return 97;
                }
                if (this.in.match(43)) {
                    return 106;
                }
                return 23;
            }
            case 45: {
                if (this.in.match(61)) {
                    this.op = 24;
                    c = 97;
                } else if (this.in.match(45)) {
                    if ((this.flags & 32) == 0 && this.in.match(62)) {
                        this.skipLine();
                        return this.getToken();
                    }
                    c = 107;
                } else {
                    c = 24;
                }
                this.flags |= 32;
                return c;
            }
        }
        this.reportSyntaxError("msg.illegal.character", null);
        return -1;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        if (this.stringBufferTop == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, this.stringBufferTop);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[this.stringBufferTop++] = (char)c;
    }

    public void reportSyntaxError(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        if (this.scope != null) {
            throw NativeGlobal.constructError(Context.getContext(), "SyntaxError", message, this.scope, this.getSourceName(), this.getLineno(), this.getOffset(), this.getLine());
        }
        Context.reportError(message, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    private void reportSyntaxWarning(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportWarning(message, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineno() {
        return this.in.getLineno();
    }

    public int getOp() {
        return this.op;
    }

    public String getString() {
        return this.string;
    }

    public double getNumber() {
        return this.number;
    }

    public String getLine() {
        return this.in.getLine();
    }

    public int getOffset() {
        return this.in.getOffset();
    }

    public int getTokenno() {
        return this.tokenno;
    }

    public boolean eof() {
        return this.in.eof();
    }

    private void $init$() {
        this.string = "";
        this.stringBuffer = new char[128];
    }
}

