/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.RegExpProxy;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;

final class NativeString
extends IdScriptable {
    private static final int ConstructorId_fromCharCode = -1;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int MAX_PROTOTYPE_ID = 33;
    private static final String defaultValue = "";
    private String string;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeString obj = new NativeString(defaultValue);
        obj.prototypeFlag = true;
        obj.addAsPrototype(33, cx, scope, sealed);
    }

    private NativeString(String s) {
        this.$init$();
        this.string = s;
    }

    public String getClassName() {
        return "String";
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
        this.addIdFunctionProperty(ctor, -1, sealed);
        super.fillConstructorProperties(cx, ctor, sealed);
    }

    protected int getIdDefaultAttributes(int id) {
        if (id == 1) {
            return 7;
        }
        return super.getIdDefaultAttributes(id);
    }

    protected Object getIdValue(int id) {
        if (id == 1) {
            return this.wrap_int(this.string.length());
        }
        return super.getIdValue(id);
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case -1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 2;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    return 0;
                }
                case 13: {
                    return 2;
                }
                case 14: {
                    return 1;
                }
                case 15: {
                    return 2;
                }
                case 16: {
                    return 0;
                }
                case 17: {
                    return 0;
                }
                case 18: {
                    return 0;
                }
                case 19: {
                    return 0;
                }
                case 20: {
                    return 0;
                }
                case 21: {
                    return 0;
                }
                case 22: {
                    return 0;
                }
                case 23: {
                    return 0;
                }
                case 24: {
                    return 0;
                }
                case 25: {
                    return 0;
                }
                case 26: {
                    return 0;
                }
                case 27: {
                    return 0;
                }
                case 28: {
                    return 0;
                }
                case 29: {
                    return 1;
                }
                case 30: {
                    return 1;
                }
                case 31: {
                    return 1;
                }
                case 32: {
                    return 1;
                }
                case 33: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case -1: {
                    return NativeString.jsStaticFunction_fromCharCode(args);
                }
                case 2: {
                    return NativeString.jsConstructor(args, thisObj == null);
                }
                case 3: {
                    return this.realThis(thisObj, f).js_toString();
                }
                case 4: {
                    return this.realThis(thisObj, f).js_valueOf();
                }
                case 5: {
                    return NativeString.js_charAt(ScriptRuntime.toString(thisObj), args);
                }
                case 6: {
                    return this.wrap_double(NativeString.js_charCodeAt(ScriptRuntime.toString(thisObj), args));
                }
                case 7: {
                    return this.wrap_int(NativeString.js_indexOf(ScriptRuntime.toString(thisObj), args));
                }
                case 8: {
                    return this.wrap_int(NativeString.js_lastIndexOf(ScriptRuntime.toString(thisObj), args));
                }
                case 9: {
                    return NativeString.js_split(cx, scope, ScriptRuntime.toString(thisObj), args);
                }
                case 10: {
                    return NativeString.js_substring(cx, ScriptRuntime.toString(thisObj), args);
                }
                case 11: {
                    return NativeString.js_toLowerCase(ScriptRuntime.toString(thisObj));
                }
                case 12: {
                    return NativeString.js_toUpperCase(ScriptRuntime.toString(thisObj));
                }
                case 13: {
                    return NativeString.js_substr(ScriptRuntime.toString(thisObj), args);
                }
                case 14: {
                    return NativeString.js_concat(ScriptRuntime.toString(thisObj), args);
                }
                case 15: {
                    return NativeString.js_slice(ScriptRuntime.toString(thisObj), args);
                }
                case 16: {
                    return NativeString.tagify(thisObj, "b", null, null);
                }
                case 17: {
                    return NativeString.tagify(thisObj, "i", null, null);
                }
                case 18: {
                    return NativeString.tagify(thisObj, "tt", null, null);
                }
                case 19: {
                    return NativeString.tagify(thisObj, "strike", null, null);
                }
                case 20: {
                    return NativeString.tagify(thisObj, "small", null, null);
                }
                case 21: {
                    return NativeString.tagify(thisObj, "big", null, null);
                }
                case 22: {
                    return NativeString.tagify(thisObj, "blink", null, null);
                }
                case 23: {
                    return NativeString.tagify(thisObj, "sup", null, null);
                }
                case 24: {
                    return NativeString.tagify(thisObj, "sub", null, null);
                }
                case 25: {
                    return NativeString.tagify(thisObj, "font", "size", args);
                }
                case 26: {
                    return NativeString.tagify(thisObj, "font", "color", args);
                }
                case 27: {
                    return NativeString.tagify(thisObj, "a", "href", args);
                }
                case 28: {
                    return NativeString.tagify(thisObj, "a", "name", args);
                }
                case 29: {
                    return this.wrap_boolean(NativeString.js_equals(ScriptRuntime.toString(thisObj), ScriptRuntime.toString(args, 0)));
                }
                case 30: {
                    return this.wrap_boolean(NativeString.js_equalsIgnoreCase(ScriptRuntime.toString(thisObj), ScriptRuntime.toString(args, 0)));
                }
                case 31: {
                    return NativeString.checkReProxy(cx).match(cx, scope, thisObj, args);
                }
                case 32: {
                    return NativeString.checkReProxy(cx).search(cx, scope, thisObj, args);
                }
                case 33: {
                    return NativeString.checkReProxy(cx).replace(cx, scope, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private NativeString realThis(Scriptable thisObj, IdFunction f) {
        while (!(thisObj instanceof NativeString)) {
            thisObj = this.nextInstanceCheck(thisObj, f, true);
        }
        return (NativeString)thisObj;
    }

    private static RegExpProxy checkReProxy(Context cx) {
        RegExpProxy result = cx.getRegExpProxy();
        if (result == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        return result;
    }

    private static String tagify(Object thisObj, String tag, String attribute, Object[] args) {
        String str = ScriptRuntime.toString(thisObj);
        StringBuffer result = new StringBuffer();
        result.append('<');
        result.append(tag);
        if (attribute != null) {
            result.append(' ');
            result.append(attribute);
            result.append("=\"");
            result.append(ScriptRuntime.toString(args, 0));
            result.append('\"');
        }
        result.append('>');
        result.append(str);
        result.append("</");
        result.append(tag);
        result.append('>');
        return result.toString();
    }

    private static String jsStaticFunction_fromCharCode(Object[] args) {
        int N = args.length;
        if (N < 1) {
            return defaultValue;
        }
        StringBuffer s = new StringBuffer(N);
        int i = 0;
        while (i < N) {
            s.append(ScriptRuntime.toUint16(args[i]));
            ++i;
        }
        return s.toString();
    }

    private static Object jsConstructor(Object[] args, boolean inNewExpr) {
        String s;
        String string = s = args.length >= 1 ? ScriptRuntime.toString(args[0]) : defaultValue;
        if (inNewExpr) {
            return new NativeString(s);
        }
        return s;
    }

    public String toString() {
        return this.string;
    }

    private String js_toString() {
        return this.string;
    }

    private String js_valueOf() {
        return this.string;
    }

    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.string.length()) {
            return this.string.substring(index, index + 1);
        }
        return super.get(index, start);
    }

    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.string.length()) {
            return;
        }
        super.put(index, start, value);
    }

    private static String js_charAt(String target, Object[] args) {
        double pos = ScriptRuntime.toInteger(args, 0);
        if (pos < 0.0 || pos >= (double)target.length()) {
            return defaultValue;
        }
        return target.substring((int)pos, (int)pos + 1);
    }

    private static double js_charCodeAt(String target, Object[] args) {
        double pos = ScriptRuntime.toInteger(args, 0);
        if (pos < 0.0 || pos >= (double)target.length()) {
            return ScriptRuntime.NaN;
        }
        return target.charAt((int)pos);
    }

    private static int js_indexOf(String target, Object[] args) {
        String search = ScriptRuntime.toString(args, 0);
        double begin = ScriptRuntime.toInteger(args, 1);
        if (begin > (double)target.length()) {
            return -1;
        }
        if (begin < 0.0) {
            begin = 0.0;
        }
        return target.indexOf(search, (int)begin);
    }

    private static int js_lastIndexOf(String target, Object[] args) {
        String search = ScriptRuntime.toString(args, 0);
        double end = ScriptRuntime.toNumber(args, 1);
        if (end != end || end > (double)target.length()) {
            end = target.length();
        } else if (end < 0.0) {
            end = 0.0;
        }
        return target.lastIndexOf(search, (int)end);
    }

    /*
     * Unable to fully structure code
     */
    private static int find_split(Scriptable scope, String target, String separator, Object re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        block11: {
            i = ip[0];
            length = target.length();
            cx = Context.getContext();
            version = cx.getLanguageVersion();
            if (version != 120 || re != null || separator.length() != 1 || separator.charAt(0) != ' ') break block11;
            if (i == 0) {
                while (i < length && Character.isWhitespace(target.charAt(i))) {
                    ++i;
                }
                ip[0] = i;
            }
            if (i != length) ** GOTO lbl14
            return -1;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl14:
                // 2 sources

                ** while (i < length && !Character.isWhitespace((char)target.charAt((int)i)))
            }
lbl15:
            // 1 sources

            j = i;
            while (j < length && Character.isWhitespace(target.charAt(j))) {
                ++j;
            }
            matchlen[0] = j - i;
            return i;
        }
        if (i > length) {
            return -1;
        }
        if (re != null) {
            return cx.getRegExpProxy().find_split(scope, target, separator, re, ip, matchlen, matched, parensp);
        }
        if (version != 0 && version < 130 && length == 0) {
            return -1;
        }
        if (separator.length() == 0) {
            if (version == 120) {
                if (i == length) {
                    matchlen[0] = 1;
                    return i;
                }
                return i + 1;
            }
            return i == length ? -1 : i + 1;
        }
        if (ip[0] >= length) {
            return length;
        }
        i = target.indexOf(separator, ip[0]);
        return i != -1 ? i : length;
    }

    private static Object js_split(Context cx, Scriptable scope, String target, Object[] args) {
        int match;
        Scriptable top = NativeString.getTopLevelScope(scope);
        Scriptable result = ScriptRuntime.newObject(cx, top, "Array", null);
        if (args.length < 1) {
            result.put(0, result, (Object)target);
            return result;
        }
        boolean limited = args.length > 1 && args[1] != Undefined.instance;
        long limit = 0L;
        if (limited && (limit = ScriptRuntime.toUint32(args[1])) > (long)target.length()) {
            limit = 1 + target.length();
        }
        String separator = null;
        int[] matchlen = new int[]{0};
        Object re = null;
        RegExpProxy reProxy = cx.getRegExpProxy();
        if (reProxy != null && reProxy.isRegExp(args[0])) {
            re = args[0];
        } else {
            separator = ScriptRuntime.toString(args[0]);
            matchlen[0] = separator.length();
        }
        int[] ip = new int[]{0};
        int len = 0;
        boolean[] matched = new boolean[]{false};
        String[][] parens = new String[][]{null};
        while ((match = NativeString.find_split(scope, target, separator, re, ip, matchlen, matched, parens)) >= 0) {
            if (limited && (long)len >= limit || match > target.length()) break;
            String substr = target.length() == 0 ? target : target.substring(ip[0], match);
            result.put(len, result, (Object)substr);
            ++len;
            if (re != null && matched[0]) {
                int size = parens[0].length;
                int num = 0;
                while (num < size) {
                    if (limited && (long)len >= limit) break;
                    result.put(len, result, (Object)parens[0][num]);
                    ++len;
                    ++num;
                }
                matched[0] = false;
            }
            ip[0] = match + matchlen[0];
            if (cx.getLanguageVersion() < 130 && cx.getLanguageVersion() != 0 && !limited && ip[0] == target.length()) break;
        }
        return result;
    }

    private static String js_substring(Context cx, String target, Object[] args) {
        double end;
        int length = target.length();
        double start = ScriptRuntime.toInteger(args, 0);
        if (start < 0.0) {
            start = 0.0;
        } else if (start > (double)length) {
            start = length;
        }
        if (args.length <= 1 || args[1] == Undefined.instance) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            } else if (end > (double)length) {
                end = length;
            }
            if (end < start) {
                if (cx.getLanguageVersion() != 120) {
                    double temp = start;
                    start = end;
                    end = temp;
                } else {
                    end = start;
                }
            }
        }
        return target.substring((int)start, (int)end);
    }

    private static String js_toLowerCase(String target) {
        return target.toLowerCase();
    }

    private static String js_toUpperCase(String target) {
        return target.toUpperCase();
    }

    int getLength() {
        return this.string.length();
    }

    private static String js_substr(String target, Object[] args) {
        double end;
        if (args.length < 1) {
            return target;
        }
        double begin = ScriptRuntime.toInteger(args[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        if (args.length == 1) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            }
            if ((end += begin) > (double)length) {
                end = length;
            }
        }
        return target.substring((int)begin, (int)end);
    }

    private static String js_concat(String target, Object[] args) {
        int N = args.length;
        if (N == 0) {
            return target;
        }
        int size = target.length();
        String[] argsAsStrings = new String[N];
        int i = 0;
        while (i != N) {
            String s;
            argsAsStrings[i] = s = ScriptRuntime.toString(args[i]);
            size += s.length();
            ++i;
        }
        StringBuffer result = new StringBuffer(size);
        result.append(target);
        int i2 = 0;
        while (i2 != N) {
            result.append(argsAsStrings[i2]);
            ++i2;
        }
        return result.toString();
    }

    private static String js_slice(String target, Object[] args) {
        if (args.length != 0) {
            double end;
            double begin = ScriptRuntime.toInteger(args[0]);
            int length = target.length();
            if (begin < 0.0) {
                if ((begin += (double)length) < 0.0) {
                    begin = 0.0;
                }
            } else if (begin > (double)length) {
                begin = length;
            }
            if (args.length == 1) {
                end = length;
            } else {
                end = ScriptRuntime.toInteger(args[1]);
                if (end < 0.0) {
                    if ((end += (double)length) < 0.0) {
                        end = 0.0;
                    }
                } else if (end > (double)length) {
                    end = length;
                }
                if (end < begin) {
                    end = begin;
                }
            }
            return target.substring((int)begin, (int)end);
        }
        return target;
    }

    private static boolean js_equals(String target, String strOther) {
        return target.equals(strOther);
    }

    private static boolean js_equalsIgnoreCase(String target, String strOther) {
        return target.equalsIgnoreCase(strOther);
    }

    protected String getIdName(int id) {
        if (id == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (id) {
                case -1: {
                    return "fromCharCode";
                }
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "charAt";
                }
                case 6: {
                    return "charCodeAt";
                }
                case 7: {
                    return "indexOf";
                }
                case 8: {
                    return "lastIndexOf";
                }
                case 9: {
                    return "split";
                }
                case 10: {
                    return "substring";
                }
                case 11: {
                    return "toLowerCase";
                }
                case 12: {
                    return "toUpperCase";
                }
                case 13: {
                    return "substr";
                }
                case 14: {
                    return "concat";
                }
                case 15: {
                    return "slice";
                }
                case 16: {
                    return "bold";
                }
                case 17: {
                    return "italics";
                }
                case 18: {
                    return "fixed";
                }
                case 19: {
                    return "strike";
                }
                case 20: {
                    return "small";
                }
                case 21: {
                    return "big";
                }
                case 22: {
                    return "blink";
                }
                case 23: {
                    return "sup";
                }
                case 24: {
                    return "sub";
                }
                case 25: {
                    return "fontsize";
                }
                case 26: {
                    return "fontcolor";
                }
                case 27: {
                    return "link";
                }
                case 28: {
                    return "anchor";
                }
                case 29: {
                    return "equals";
                }
                case 30: {
                    return "equalsIgnoreCase";
                }
                case 31: {
                    return "match";
                }
                case 32: {
                    return "search";
                }
                case 33: {
                    return "replace";
                }
            }
        }
        return null;
    }

    private void $init$() {
        this.setMaxId(1);
    }

    protected int mapNameToId(String s) {
        if (s.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeString.toPrototypeId(s);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(2);
                if (c == 'b') {
                    if (s.charAt(0) != 's' || s.charAt(1) != 'u') break;
                    return 24;
                }
                if (c == 'g') {
                    if (s.charAt(0) != 'b' || s.charAt(1) != 'i') break;
                    return 21;
                }
                if (c != 'p' || s.charAt(0) != 's' || s.charAt(1) != 'u') break;
                return 23;
            }
            case 4: {
                char c = s.charAt(0);
                if (c == 'b') {
                    X = "bold";
                    id = 16;
                    break;
                }
                if (c != 'l') break;
                X = "link";
                id = 27;
                break;
            }
            case 5: {
                switch (s.charAt(4)) {
                    case 'd': {
                        X = "fixed";
                        id = 18;
                        break block0;
                    }
                    case 'e': {
                        X = "slice";
                        id = 15;
                        break block0;
                    }
                    case 'h': {
                        X = "match";
                        id = 31;
                        break block0;
                    }
                    case 'k': {
                        X = "blink";
                        id = 22;
                        break block0;
                    }
                    case 'l': {
                        X = "small";
                        id = 20;
                        break block0;
                    }
                    case 't': {
                        X = "split";
                        id = 9;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(1)) {
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'l') {
                            X = "length";
                            id = 1;
                            break;
                        }
                        if (c != 's') break;
                        X = "search";
                        id = 32;
                        break;
                    }
                    case 'h': {
                        X = "charAt";
                        id = 5;
                        break;
                    }
                    case 'n': {
                        X = "anchor";
                        id = 28;
                        break;
                    }
                    case 'o': {
                        X = "concat";
                        id = 14;
                        break;
                    }
                    case 'q': {
                        X = "equals";
                        id = 29;
                        break;
                    }
                    case 't': {
                        X = "strike";
                        id = 19;
                        break;
                    }
                    case 'u': {
                        X = "substr";
                        id = 13;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(1)) {
                    case 'a': {
                        X = "valueOf";
                        id = 4;
                        break block0;
                    }
                    case 'e': {
                        X = "replace";
                        id = 33;
                        break block0;
                    }
                    case 'n': {
                        X = "indexOf";
                        id = 7;
                        break block0;
                    }
                    case 't': {
                        X = "italics";
                        id = 17;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'f') {
                    X = "fontsize";
                    id = 25;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 3;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'f') {
                    X = "fontcolor";
                    id = 26;
                    break;
                }
                if (c != 's') break;
                X = "substring";
                id = 10;
                break;
            }
            case 10: {
                X = "charCodeAt";
                id = 6;
                break;
            }
            case 11: {
                switch (s.charAt(2)) {
                    case 'L': {
                        X = "toLowerCase";
                        id = 11;
                        break block0;
                    }
                    case 'U': {
                        X = "toUpperCase";
                        id = 12;
                        break block0;
                    }
                    case 'n': {
                        X = "constructor";
                        id = 2;
                        break block0;
                    }
                    case 's': {
                        X = "lastIndexOf";
                        id = 8;
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                X = "equalsIgnoreCase";
                id = 30;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }
}

