/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.EcmaError;
import ice.mozilla.javascript.EvaluatorException;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdFunctionMaster;
import ice.mozilla.javascript.InterpretedScript;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeError;
import ice.mozilla.javascript.NotAFunctionException;
import ice.mozilla.javascript.PropertyException;
import ice.mozilla.javascript.Script;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.TokenStream;
import ice.mozilla.javascript.Undefined;
import java.io.IOException;
import java.io.StringReader;

public class NativeGlobal
implements IdFunctionMaster {
    private static final int Id_decodeURI = 1;
    private static final int Id_decodeURIComponent = 2;
    private static final int Id_encodeURI = 3;
    private static final int Id_encodeURIComponent = 4;
    private static final int Id_escape = 5;
    private static final int Id_eval = 6;
    private static final int Id_isFinite = 7;
    private static final int Id_isNaN = 8;
    private static final int Id_parseFloat = 9;
    private static final int Id_parseInt = 10;
    private static final int Id_unescape = 11;
    private static final int LAST_SCOPE_FUNCTION_ID = 11;
    private static final int Id_new_CommonError = 12;
    private boolean scopeSlaveFlag;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeGlobal obj = new NativeGlobal();
        obj.scopeSlaveFlag = true;
        int id = 1;
        while (id <= 11) {
            String name = NativeGlobal.getMethodName(id);
            IdFunction f = new IdFunction(obj, name, id);
            f.setParentScope(scope);
            if (sealed) {
                f.sealObject();
            }
            ScriptableObject.defineProperty(scope, name, f, 2);
            ++id;
        }
        ScriptableObject.defineProperty(scope, "NaN", ScriptRuntime.NaNobj, 2);
        ScriptableObject.defineProperty(scope, "Infinity", new Double(Double.POSITIVE_INFINITY), 2);
        ScriptableObject.defineProperty(scope, "undefined", Undefined.instance, 2);
        String[] errorMethods = new String[]{"ConversionError", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError"};
        int i = 0;
        while (i < errorMethods.length) {
            String name = errorMethods[i];
            IdFunction ctor = new IdFunction(obj, name, 12);
            ctor.setFunctionType(2);
            ctor.setParentScope(scope);
            ScriptableObject.defineProperty(scope, name, ctor, 2);
            Scriptable errorProto = ScriptRuntime.newObject(cx, scope, "Error", ScriptRuntime.emptyArgs);
            errorProto.put("name", errorProto, (Object)name);
            ctor.put("prototype", (Scriptable)ctor, (Object)errorProto);
            if (sealed) {
                ctor.sealObject();
                if (errorProto instanceof ScriptableObject) {
                    ((ScriptableObject)errorProto).sealObject();
                }
            }
            ++i;
        }
    }

    public Object execMethod(int methodId, IdFunction function, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.scopeSlaveFlag) {
            switch (methodId) {
                case 1: {
                    return this.js_decodeURI(cx, args);
                }
                case 2: {
                    return this.js_decodeURIComponent(cx, args);
                }
                case 3: {
                    return this.js_encodeURI(cx, args);
                }
                case 4: {
                    return this.js_encodeURIComponent(cx, args);
                }
                case 5: {
                    return this.js_escape(cx, args);
                }
                case 6: {
                    return this.js_eval(cx, scope, args);
                }
                case 7: {
                    return this.js_isFinite(cx, args);
                }
                case 8: {
                    return this.js_isNaN(cx, args);
                }
                case 9: {
                    return this.js_parseFloat(cx, args);
                }
                case 10: {
                    return this.js_parseInt(cx, args);
                }
                case 11: {
                    return this.js_unescape(cx, args);
                }
                case 12: {
                    return this.new_CommonError(function, cx, scope, args);
                }
            }
        }
        throw IdFunction.onBadMethodId(this, methodId);
    }

    public int methodArity(int methodId) {
        if (this.scopeSlaveFlag) {
            switch (methodId) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
            }
        }
        return -1;
    }

    private static String getMethodName(int methodId) {
        switch (methodId) {
            case 1: {
                return "decodeURI";
            }
            case 2: {
                return "decodeURIComponent";
            }
            case 3: {
                return "encodeURI";
            }
            case 4: {
                return "encodeURIComponent";
            }
            case 5: {
                return "escape";
            }
            case 6: {
                return "eval";
            }
            case 7: {
                return "isFinite";
            }
            case 8: {
                return "isNaN";
            }
            case 9: {
                return "parseFloat";
            }
            case 10: {
                return "parseInt";
            }
            case 11: {
                return "unescape";
            }
        }
        return null;
    }

    private Object js_parseInt(Context cx, Object[] args) {
        char c;
        String s = ScriptRuntime.toString(args, 0);
        int radix = ScriptRuntime.toInt32(args, 1);
        int len = s.length();
        if (len == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean negative = false;
        int start = 0;
        while (Character.isWhitespace(c = s.charAt(start)) && ++start < len) {
        }
        if (c == '+' || (negative = c == '-')) {
            ++start;
        }
        int NO_RADIX = -1;
        if (radix == 0) {
            radix = -1;
        } else {
            if (radix < 2 || radix > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (radix == 16 && len - start > 1 && s.charAt(start) == '0' && ((c = s.charAt(start + 1)) == 'x' || c == 'X')) {
                start += 2;
            }
        }
        if (radix == -1) {
            radix = 10;
            if (len - start > 1 && s.charAt(start) == '0') {
                c = s.charAt(start + 1);
                if (c == 'x' || c == 'X') {
                    radix = 16;
                    start += 2;
                } else if ('0' <= c && c <= '9') {
                    radix = 8;
                    ++start;
                }
            }
        }
        double d = ScriptRuntime.stringToNumber(s, start, radix);
        return new Double(negative ? -d : d);
    }

    private Object js_parseFloat(Context cx, Object[] args) {
        char c;
        if (args.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String s = ScriptRuntime.toString(args[0]);
        int len = s.length();
        if (len == 0) {
            return ScriptRuntime.NaNobj;
        }
        int i = 0;
        while (TokenStream.isJSSpace(c = s.charAt(i)) && i + 1 < len) {
            ++i;
        }
        int start = i;
        if (c == '+' || c == '-') {
            c = s.charAt(++i);
        }
        if (c == 'I') {
            if (i + 8 > len || !s.substring(i, i + 8).equals("Infinity")) {
                return ScriptRuntime.NaNobj;
            }
            double d = s.charAt(start) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return new Double(d);
        }
        int decimal = -1;
        int exponent = -1;
        block9: while (i < len) {
            switch (s.charAt(i)) {
                case '.': {
                    if (decimal != -1) break block9;
                    decimal = i;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (exponent != -1) break block9;
                    exponent = i;
                    break;
                }
                case '+': 
                case '-': {
                    if (exponent == i - 1) break;
                    break block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    break block9;
                }
            }
            ++i;
        }
        s = s.substring(start, i);
        try {
            Double d = Double.valueOf(s);
            return d;
        }
        catch (NumberFormatException ex) {
            Double d = ScriptRuntime.NaNobj;
            return d;
        }
    }

    private Object js_escape(Context cx, Object[] args) {
        double d;
        boolean URL_XALPHAS = true;
        int URL_XPALPHAS = 2;
        int URL_PATH = 4;
        String s = ScriptRuntime.toString(args, 0);
        int mask = 7;
        if (args.length > 1 && ((d = ScriptRuntime.toNumber(args[1])) != d || (double)(mask = (int)d) != d || (mask & 0xFFFFFFF8) != 0)) {
            String message = Context.getMessage0("msg.bad.esc.mask");
            Context.reportError(message);
            mask = 7;
        }
        StringBuffer sb = null;
        int k = 0;
        int L = s.length();
        while (k != L) {
            block6: {
                int hexSize;
                char c;
                block9: {
                    block7: {
                        block8: {
                            block5: {
                                c = s.charAt(k);
                                if (mask == 0 || !(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.') && ((mask & 4) == 0 || c != '/' && c != '+')) break block5;
                                if (sb != null) {
                                    sb.append(c);
                                }
                                break block6;
                            }
                            if (sb == null) {
                                sb = new StringBuffer(L + 3);
                                sb.append(s);
                                sb.setLength(k);
                            }
                            if (c >= '\u0100') break block7;
                            if (c != ' ' || mask != 2) break block8;
                            sb.append('+');
                            break block6;
                        }
                        sb.append('%');
                        hexSize = 2;
                        break block9;
                    }
                    sb.append('%');
                    sb.append('u');
                    hexSize = 4;
                }
                int shift = (hexSize - 1) * 4;
                while (shift >= 0) {
                    int digit = 0xF & c >> shift;
                    int hc = digit < 10 ? 48 + digit : 55 + digit;
                    sb.append((char)hc);
                    shift -= 4;
                }
            }
            ++k;
        }
        return sb == null ? s : sb.toString();
    }

    private Object js_unescape(Context cx, Object[] args) {
        String s = ScriptRuntime.toString(args, 0);
        int firstEscapePos = s.indexOf(37);
        if (firstEscapePos >= 0) {
            int L = s.length();
            char[] buf = s.toCharArray();
            int destination = firstEscapePos;
            int k = firstEscapePos;
            while (k != L) {
                char c = buf[k];
                if (c == '%' && ++k != L) {
                    int end;
                    int start;
                    if (buf[k] == 'u') {
                        start = k + 1;
                        end = k + 5;
                    } else {
                        start = k;
                        end = k + 2;
                    }
                    if (end <= L) {
                        int x = 0;
                        int i = start;
                        while (i != end) {
                            x = x << 4 | TokenStream.xDigitToInt(buf[i]);
                            ++i;
                        }
                        if (x >= 0) {
                            c = (char)x;
                            k = end;
                        }
                    }
                }
                buf[destination] = c;
                ++destination;
            }
            s = new String(buf, 0, destination);
        }
        return s;
    }

    private Object js_isNaN(Context cx, Object[] args) {
        if (args.length < 1) {
            return Boolean.TRUE;
        }
        double d = ScriptRuntime.toNumber(args[0]);
        return d != d ? Boolean.TRUE : Boolean.FALSE;
    }

    private Object js_isFinite(Context cx, Object[] args) {
        if (args.length < 1) {
            return Boolean.FALSE;
        }
        double d = ScriptRuntime.toNumber(args[0]);
        return d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY ? Boolean.FALSE : Boolean.TRUE;
    }

    private Object js_eval(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        String m = ScriptRuntime.getMessage1("msg.cant.call.indirect", "eval");
        throw NativeGlobal.constructError(cx, "EvalError", m, scope);
    }

    public static Object evalSpecial(Context cx, Scriptable scope, Object thisArg, Object[] args, String filename, int lineNumber) throws JavaScriptException {
        if (args.length < 1) {
            return Undefined.instance;
        }
        Object x = args[0];
        if (!(x instanceof String)) {
            String message = Context.getMessage0("msg.eval.nonstring");
            Context.reportWarning(message);
            return x;
        }
        if (filename == null) {
            int[] linep = new int[1];
            filename = Context.getSourcePositionFromStack(linep);
            if (filename != null) {
                lineNumber = linep[0];
            } else {
                filename = "";
            }
        }
        String sourceName = ScriptRuntime.makeUrlForGeneratedScript(true, filename, lineNumber);
        try {
            Object result;
            Script script;
            StringReader in = new StringReader((String)x);
            int oldOptLevel = cx.getOptimizationLevel();
            cx.setOptimizationLevel(-1);
            try {
                script = cx.compileReader(scope, in, sourceName, 1, null);
            }
            finally {
                cx.setOptimizationLevel(oldOptLevel);
            }
            if (script == null) {
                String message = Context.getMessage0("msg.syntax");
                throw new EvaluatorException(message);
            }
            InterpretedScript is = (InterpretedScript)script;
            is.itsData.itsFromEvalCode = true;
            Object object = result = is.call(cx, scope, (Scriptable)thisArg, ScriptRuntime.emptyArgs);
            return object;
        }
        catch (IOException ioe) {
            throw new RuntimeException("unexpected io exception");
        }
    }

    public static EcmaError constructError(Context cx, String error, String message, Object scope) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        return NativeGlobal.constructError(cx, error, message, scope, filename, linep[0], 0, null);
    }

    static EcmaError typeError0(String messageId, Object scope) {
        return NativeGlobal.constructError(Context.getContext(), "TypeError", ScriptRuntime.getMessage0(messageId), scope);
    }

    static EcmaError typeError1(String messageId, Object arg1, Object scope) {
        return NativeGlobal.constructError(Context.getContext(), "TypeError", ScriptRuntime.getMessage1(messageId, arg1), scope);
    }

    public static EcmaError constructError(Context cx, String error, String message, Object scope, String sourceName, int lineNumber, int columnNumber, String lineSource) {
        Scriptable scopeObject;
        try {
            scopeObject = (Scriptable)scope;
        }
        catch (ClassCastException x) {
            throw new RuntimeException(x.toString());
        }
        Object[] args = new Object[]{message};
        try {
            Scriptable errorObject = cx.newObject(scopeObject, error, args);
            errorObject.put("name", errorObject, (Object)error);
            EcmaError ecmaError = new EcmaError((NativeError)errorObject, sourceName, lineNumber, columnNumber, lineSource);
            return ecmaError;
        }
        catch (PropertyException x) {
            throw new RuntimeException(x.toString());
        }
        catch (JavaScriptException x) {
            throw new RuntimeException(x.toString());
        }
        catch (NotAFunctionException x) {
            throw new RuntimeException(x.toString());
        }
    }

    private Object new_CommonError(IdFunction ctorObj, Context cx, Scriptable scope, Object[] args) {
        NativeError newInstance = new NativeError();
        newInstance.setPrototype((Scriptable)ctorObj.get("prototype", (Scriptable)ctorObj));
        newInstance.setParentScope(scope);
        if (args.length > 0) {
            newInstance.put("message", (Scriptable)newInstance, args[0]);
        }
        return newInstance;
    }

    private static String encode(Context cx, String str, boolean fullUri) {
        byte[] utf8buf = null;
        StringBuffer sb = null;
        int k = 0;
        int length = str.length();
        while (k != length) {
            int C = str.charAt(k);
            if (NativeGlobal.encodeUnescaped((char)C, fullUri)) {
                if (sb != null) {
                    sb.append((char)C);
                }
            } else {
                int V;
                if (56320 <= C && C <= 57343) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if (C < 55296 || 56319 < C) {
                    V = C;
                } else {
                    if (++k == length) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    char C2 = str.charAt(k);
                    if ('\udc00' > C2 || C2 > '\udfff') {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    V = (C - 55296 << 10) + (C2 - 56320) + 65536;
                }
                if (utf8buf == null) {
                    utf8buf = new byte[6];
                    sb = new StringBuffer(length + 3);
                    sb.append(str);
                    sb.setLength(k);
                }
                int L = NativeGlobal.oneUcs4ToUtf8Char(utf8buf, V);
                int j = 0;
                while (j < L) {
                    int d = 0xFF & utf8buf[j];
                    sb.append('%');
                    sb.append(NativeGlobal.toHexChar(d >>> 4));
                    sb.append(NativeGlobal.toHexChar(d & 0xF));
                    ++j;
                }
            }
            ++k;
        }
        return sb == null ? str : sb.toString();
    }

    private static char toHexChar(int i) {
        if (i >> 4 != 0) {
            Context.codeBug();
        }
        return (char)(i < 10 ? i + 48 : i - 10 + 97);
    }

    private static int unHex(char c) {
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static int unHex(char c1, char c2) {
        int i1 = NativeGlobal.unHex(c1);
        int i2 = NativeGlobal.unHex(c2);
        if (i1 >= 0 && i2 >= 0) {
            return i1 << 4 | i2;
        }
        return -1;
    }

    private static String decode(Context cx, String str, boolean fullUri) {
        char[] buf = null;
        int bufTop = 0;
        int k = 0;
        int length = str.length();
        while (k != length) {
            char C = str.charAt(k);
            if (C != '%') {
                if (buf != null) {
                    buf[bufTop++] = C;
                }
                ++k;
                continue;
            }
            if (buf == null) {
                buf = new char[length];
                bufTop = k;
                str.getChars(0, bufTop, buf, 0);
            }
            int start = k;
            if (k + 3 > length) {
                throw Context.reportRuntimeError0("msg.bad.uri");
            }
            int B = NativeGlobal.unHex(str.charAt(k + 1), str.charAt(k + 2));
            if (B < 0) {
                throw Context.reportRuntimeError0("msg.bad.uri");
            }
            k += 3;
            if ((B & 0x80) == 0) {
                C = (char)B;
            } else {
                int minUcs4Char;
                int ucs4Char;
                int utf8Tail;
                if ((B & 0xC0) == 128) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if ((B & 0x20) == 0) {
                    utf8Tail = 1;
                    ucs4Char = B & 0x1F;
                    minUcs4Char = 128;
                } else if ((B & 0x10) == 0) {
                    utf8Tail = 2;
                    ucs4Char = B & 0xF;
                    minUcs4Char = 2048;
                } else if ((B & 8) == 0) {
                    utf8Tail = 3;
                    ucs4Char = B & 7;
                    minUcs4Char = 65536;
                } else if ((B & 4) == 0) {
                    utf8Tail = 4;
                    ucs4Char = B & 3;
                    minUcs4Char = 0x200000;
                } else if ((B & 2) == 0) {
                    utf8Tail = 5;
                    ucs4Char = B & 1;
                    minUcs4Char = 0x4000000;
                } else {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if (k + 3 * utf8Tail > length) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                int j = 0;
                while (j != utf8Tail) {
                    if (str.charAt(k) != '%') {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    B = NativeGlobal.unHex(str.charAt(k + 1), str.charAt(k + 2));
                    if (B < 0 || (B & 0xC0) != 128) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    ucs4Char = ucs4Char << 6 | B & 0x3F;
                    k += 3;
                    ++j;
                }
                if (ucs4Char < minUcs4Char || ucs4Char == 65534 || ucs4Char == 65535) {
                    ucs4Char = 65533;
                }
                if (ucs4Char >= 65536) {
                    if ((ucs4Char -= 65536) > 1048575) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    char H = (char)((ucs4Char >>> 10) + 55296);
                    C = (char)((ucs4Char & 0x3FF) + 56320);
                    buf[bufTop++] = H;
                } else {
                    C = (char)ucs4Char;
                }
            }
            if (fullUri && NativeGlobal.fullUriDecodeReserved(C)) {
                int x = start;
                while (x != k) {
                    buf[bufTop++] = str.charAt(x);
                    ++x;
                }
                continue;
            }
            buf[bufTop++] = C;
        }
        return buf == null ? str : new String(buf, 0, bufTop);
    }

    private static boolean encodeUnescaped(char c, boolean fullUri) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return true;
        }
        switch (c) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        if (fullUri) {
            return NativeGlobal.fullUriDecodeReserved(c);
        }
        return false;
    }

    private static boolean fullUriDecodeReserved(char c) {
        switch (c) {
            case '#': 
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    private String js_decodeURI(Context cx, Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.decode(cx, str, true);
    }

    private String js_decodeURIComponent(Context cx, Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.decode(cx, str, false);
    }

    private Object js_encodeURI(Context cx, Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.encode(cx, str, true);
    }

    private String js_encodeURIComponent(Context cx, Object[] args) {
        String str = ScriptRuntime.toString(args, 0);
        return NativeGlobal.encode(cx, str, false);
    }

    private static int oneUcs4ToUtf8Char(byte[] utf8Buffer, int ucs4Char) {
        int utf8Length = 1;
        if ((ucs4Char & 0xFFFFFF80) == 0) {
            utf8Buffer[0] = (byte)ucs4Char;
        } else {
            int a = ucs4Char >>> 11;
            utf8Length = 2;
            while (a != 0) {
                a >>>= 5;
                ++utf8Length;
            }
            int i = utf8Length;
            while (--i > 0) {
                utf8Buffer[i] = (byte)(ucs4Char & 0x3F | 0x80);
                ucs4Char >>>= 6;
            }
            utf8Buffer[0] = (byte)(256 - (1 << 8 - utf8Length) + ucs4Char);
        }
        return utf8Length;
    }
}

