/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Arguments;
import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.NativeFunction;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeCall caller;
    NativeFunction funObj;
    Scriptable thisObj;
    private Object[] originalArgs;
    public int debugPC;
    private boolean prototypeFlag;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeCall obj = new NativeCall();
        obj.prototypeFlag = true;
        obj.addAsPrototype(1, cx, scope, sealed);
    }

    NativeCall(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, Object[] args) {
        this.funObj = funObj;
        this.thisObj = thisObj;
        this.setParentScope(scope);
        this.caller = cx.currentActivation;
        cx.currentActivation = this;
        this.originalArgs = args == null ? ScriptRuntime.emptyArgs : args;
        String[] argNames = funObj.argNames;
        if (argNames != null) {
            int i = 0;
            while (i < funObj.argCount) {
                Scriptable val = i < args.length ? args[i] : Undefined.instance;
                super.put(argNames[i], (Scriptable)this, (Object)val);
                ++i;
            }
        }
        super.put("arguments", (Scriptable)this, (Object)new Arguments(this));
        if (argNames != null) {
            int i = funObj.argCount;
            while (i != argNames.length) {
                super.put(argNames[i], (Scriptable)this, (Object)Undefined.instance);
                ++i;
            }
        }
    }

    private NativeCall() {
    }

    public String getClassName() {
        return "Call";
    }

    private static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            throw Context.reportRuntimeError1("msg.only.from.new", "Call");
        }
        ScriptRuntime.checkDeprecated(cx, "Call");
        NativeCall result = new NativeCall();
        result.setPrototype(NativeCall.getObjectPrototype(ctorObj));
        return result;
    }

    NativeCall getActivation(Function f) {
        NativeCall x = this;
        do {
            if (x.funObj != f) continue;
            return x;
        } while ((x = x.caller) != null);
        return null;
    }

    public Function getFunctionObject() {
        return this.funObj;
    }

    public Object[] getOriginalArguments() {
        return this.originalArgs;
    }

    public NativeCall getCaller() {
        return this.caller;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag && methodId == 1) {
            return 1;
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag && methodId == 1) {
            return NativeCall.jsConstructor(cx, args, f, thisObj == null);
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag && id == 1) {
            return "constructor";
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        return s.equals("constructor") ? 1 : 0;
    }
}

