/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

public class LabelTable {
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private long[] itsFixupTable;
    private int itsFixupTableTop;

    public int acquireLabel() {
        int top = this.itsLabelTableTop;
        if (this.itsLabelTable == null || top == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] tmp = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, tmp, 0, top);
                this.itsLabelTable = tmp;
            }
        }
        this.itsLabelTableTop = top + 1;
        this.itsLabelTable[top] = -1;
        return top;
    }

    public int getLabelPC(int label) {
        if (label > this.itsLabelTableTop) {
            throw new RuntimeException();
        }
        return this.itsLabelTable[label];
    }

    public void markLabel(int label, int pc) {
        if (label > this.itsLabelTableTop || pc < 0) {
            throw new RuntimeException();
        }
        if (this.itsLabelTable[label] != -1) {
            throw new RuntimeException();
        }
        this.itsLabelTable[label] = pc;
    }

    public void addLabelFixup(int label, int fixupSite) {
        if (label > this.itsLabelTableTop || fixupSite < 0) {
            throw new RuntimeException();
        }
        int top = this.itsFixupTableTop;
        if (this.itsFixupTable == null || top == this.itsFixupTable.length) {
            if (this.itsFixupTable == null) {
                this.itsFixupTable = new long[40];
            } else {
                long[] tmp = new long[this.itsFixupTable.length * 2];
                System.arraycopy(this.itsFixupTable, 0, tmp, 0, top);
                this.itsFixupTable = tmp;
            }
        }
        this.itsFixupTableTop = top + 1;
        this.itsFixupTable[top] = (long)label << 32 | (long)fixupSite;
    }

    public void fixLabelGotos(byte[] codeBuffer) {
        int i = 0;
        while (i < this.itsFixupTableTop) {
            long fixup = this.itsFixupTable[i];
            int label = (int)(fixup >> 32);
            int fixupSite = (int)fixup;
            int pc = this.itsLabelTable[label];
            if (pc == -1) {
                throw new RuntimeException();
            }
            int offset = pc - (fixupSite - 1);
            if ((short)offset != offset) {
                throw new RuntimeException("Program too complex: too big jump offset");
            }
            codeBuffer[fixupSite] = (byte)(offset >> 8);
            codeBuffer[fixupSite + 1] = (byte)offset;
            ++i;
        }
        this.itsFixupTableTop = 0;
    }

    public void clearLabels() {
        this.itsLabelTableTop = 0;
        this.itsFixupTableTop = 0;
    }
}

