/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.html;

import ice.dom.html.DefaultHTMLElement;
import ice.pilots.html4.DDocument;
import ice.storm.DynEnv;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class TableCellElement
extends DefaultHTMLElement
implements HTMLTableCellElement {
    private static final int Field_abbr = 1;
    private static final int Field_axis = 2;
    private static final int Field_cellIndex = 3;
    private static final int Field_colSpan = 4;
    private static final int Field_headers = 5;
    private static final int Field_noWrap = 6;
    private static final int Field_rowSpan = 7;
    private static final int Field_scope = 8;

    public TableCellElement(DDocument doc, int id) {
        super(doc, id);
    }

    public String getAbbr() {
        return this.getAttribute(1);
    }

    public void setAbbr(String value) {
        this.setAttribute(1, value);
    }

    public String getAxis() {
        return this.getAttribute(10);
    }

    public void setAxis(String value) {
        this.setAttribute(10, value);
    }

    public int getColSpan() {
        return TableCellElement.parseAttribute(this, 29, 1, 1, Integer.MAX_VALUE);
    }

    public void setColSpan(int value) {
        this.setAttribute(29, Integer.toString(value));
    }

    public int getRowSpan() {
        return TableCellElement.parseAttribute(this, 93, 1, 1, Integer.MAX_VALUE);
    }

    public void setRowSpan(int value) {
        this.setAttribute(93, Integer.toString(value));
    }

    public String getHeaders() {
        return this.getAttribute(44);
    }

    public void setHeaders(String value) {
        this.setAttribute(44, value);
    }

    public boolean getNoWrap() {
        return this.getAttribute(67) != null;
    }

    public void setNoWrap(boolean value) {
        this.setAttribute(67, value ? "noWrap" : null);
    }

    public String getScope() {
        return this.getAttribute(96);
    }

    public void setScope(String value) {
        this.setAttribute(96, value);
    }

    public int getCellIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableRowElement) {
            HTMLCollection cells = ((HTMLTableRowElement)parent).getCells();
            int i = 0;
            while (i < cells.getLength()) {
                if (cells.item(i) == this) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = TableCellElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = TableCellElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAbbr();
            }
            case 2: {
                return this.getAxis();
            }
            case 3: {
                return env.wrapInt(this.getCellIndex());
            }
            case 4: {
                return env.wrapInt(this.getColSpan());
            }
            case 5: {
                return this.getHeaders();
            }
            case 6: {
                return env.wrapBoolean(this.getNoWrap());
            }
            case 7: {
                return env.wrapInt(this.getRowSpan());
            }
            case 8: {
                return this.getScope();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setAbbr(env.toStr(value));
                return 1;
            }
            case 2: {
                this.setAxis(env.toStr(value));
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                this.setColSpan(env.toInt(value));
                return 1;
            }
            case 5: {
                this.setHeaders(env.toStr(value));
                return 1;
            }
            case 6: {
                this.setNoWrap(env.toBoolean(value));
                return 1;
            }
            case 7: {
                this.setRowSpan(env.toInt(value));
                return 1;
            }
            case 8: {
                this.setScope(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 4: {
                char c = s.charAt(1);
                if (c == 'b') {
                    guess = "abbr";
                    id = 1;
                    break;
                }
                if (c != 'x') break;
                guess = "axis";
                id = 2;
                break;
            }
            case 5: {
                guess = "scope";
                id = 8;
                break;
            }
            case 6: {
                guess = "noWrap";
                id = 6;
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "colSpan";
                    id = 4;
                    break;
                }
                if (c == 'h') {
                    guess = "headers";
                    id = 5;
                    break;
                }
                if (c != 'r') break;
                guess = "rowSpan";
                id = 7;
                break;
            }
            case 9: {
                guess = "cellIndex";
                id = 3;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

