/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.geom.Point2D;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;

public class WorldMercatorUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static double[] mercParams = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
    private static double[] geodParams = new double[]{6378137.0, 298.257223563};
    private static double mdFE = mercParams[3];
    private static double mdFN = mercParams[4];
    private static double k0 = mercParams[2];
    private static double lon0 = mercParams[1];
    private static double a = geodParams[0];
    private static double f = 1.0 / geodParams[1];
    private static double e = Math.sqrt(2.0 * f - f * f);
    private static double pow4 = Math.pow(e, 4.0);
    private static double pow6 = Math.pow(e, 6.0);
    private static double pow8 = Math.pow(e, 8.0);
    private static double p1 = e * e / 2.0;
    private static double p2 = 5.0 * pow4 / 24.0;
    private static double p3 = pow6 / 12.0;
    private static double p4 = 13.0 * pow8 / 360.0;

    public static Point2D geodeticToMercator(double d, double d2, Point2D point2D) {
        Point2D point2D2 = WorldMercatorUtil.toRadian(d, d2, point2D);
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        double d5 = mdFE + a * k0 * (d3 - lon0);
        double d6 = Math.sin(d4);
        double d7 = Math.tan(0.7853981633974483 + d4 / 2.0);
        double d8 = (1.0 - e * d6) / (1.0 + e * d6);
        double d9 = e / 2.0;
        double d10 = Math.pow(d8, d9);
        double d11 = mdFN + a * k0 * Math.log(d7 * d10);
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        point2D.setLocation(d5, d11);
        return point2D;
    }

    public static Point2D mercatorToGeodetic(double d, double d2, Point2D point2D) {
        double d3 = d;
        double d4 = d2;
        double d5 = Math.E;
        double d6 = Math.pow(d5, (mdFN - d3) / (a * k0));
        double d7 = 1.5707963267948966 - 2.0 * Math.atan2(d6, 1.0);
        double d8 = Math.sin(2.0 * d7);
        double d9 = 7.0 * pow4 / 48.0;
        double d10 = 29.0 * pow6 / 240.0;
        double d11 = 811.0 * pow8 / 11520.0;
        double d12 = Math.sin(2.0 * d7);
        double d13 = 7.0 * pow6 / 120.0;
        double d14 = 81.0 * pow8 / 1120.0;
        double d15 = Math.sin(6.0 * d7);
        double d16 = 4279.0 * pow8 / 161280.0;
        double d17 = Math.sin(8.0 * d7);
        double d18 = d7 + (p1 + p2 + p3 + p4) * d8 + (d9 + d10 + d11) * d12 + (d13 + d14) * d15 + d16 * d17;
        double d19 = (d4 - mdFE) / (a * k0) + lon0;
        Point2D point2D2 = WorldMercatorUtil.toLatLong(d19, d18, point2D);
        return point2D2;
    }

    private static Point2D toRadian(double d, double d2, Point2D point2D) {
        while (d < -180.0) {
            d += 360.0;
        }
        while (d > 180.0) {
            d -= 360.0;
        }
        d = d * Math.PI / 180.0;
        d2 = d2 * Math.PI / 180.0;
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        point2D.setLocation(d, d2);
        return point2D;
    }

    private static Point2D toLatLong(double d, double d2, Point2D point2D) {
        double d3 = d2 * 180.0 / Math.PI;
        double d4 = d * 180.0 / Math.PI;
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        point2D.setLocation(d4, d3);
        return point2D;
    }

    public static final JSDOGeometry geodeticToMercator(JSDOGeometry jSDOGeometry) {
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        Point2D.Double double_ = new Point2D.Double();
        if (dArray != null) {
            double[] dArray2 = new double[dArray.length];
            int n = jSDOGeometry.getDimensions();
            for (int i = 0; i < dArray.length; i += n) {
                double d = dArray[i];
                double d2 = dArray[i + 1];
                WorldMercatorUtil.geodeticToMercator(d, d2, double_);
                dArray2[i] = ((Point2D)double_).getX();
                dArray2[i + 1] = ((Point2D)double_).getY();
            }
            return new JSDOGeometry(jSDOGeometry.getType(), 54004, jSDOGeometry.getElemInfo(), dArray2);
        }
        dArray = jSDOGeometry.getPoint();
        if (dArray == null) {
            log.severe("Invalid input geometry.");
            return jSDOGeometry;
        }
        WorldMercatorUtil.geodeticToMercator(dArray[0], dArray[1], double_);
        if (dArray.length > 2 && !Double.isNaN(dArray[2])) {
            return new JSDOGeometry(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[2], 54004);
        }
        return new JSDOGeometry(((Point2D)double_).getX(), ((Point2D)double_).getY(), 54004);
    }

    public static final JSDOGeometry mercatorToGeodetic(JSDOGeometry jSDOGeometry) {
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        Point2D.Double double_ = new Point2D.Double();
        if (dArray != null) {
            double[] dArray2 = new double[dArray.length];
            int n = jSDOGeometry.getDimensions();
            for (int i = 0; i < dArray.length; i += n) {
                double d = dArray[i];
                double d2 = dArray[i + 1];
                WorldMercatorUtil.mercatorToGeodetic(d, d2, double_);
                dArray2[i] = ((Point2D)double_).getX();
                dArray2[i + 1] = ((Point2D)double_).getY();
            }
            return new JSDOGeometry(jSDOGeometry.getType(), 8307, jSDOGeometry.getElemInfo(), dArray2);
        }
        dArray = jSDOGeometry.getPoint();
        if (dArray == null) {
            log.severe("Invalid input geometry.");
            return jSDOGeometry;
        }
        WorldMercatorUtil.mercatorToGeodetic(dArray[0], dArray[1], double_);
        if (dArray.length > 2 && !Double.isNaN(dArray[2])) {
            return new JSDOGeometry(((Point2D)double_).getX(), ((Point2D)double_).getY(), dArray[2], 8307);
        }
        return new JSDOGeometry(((Point2D)double_).getX(), ((Point2D)double_).getY(), 8307);
    }
}

