/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.ComparisonOperator;
import oracle.sdovis.util.LogicalOperator;

public class WhereClause {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private Object rootOperator = null;

    public Object getRootOperator() {
        return this.rootOperator;
    }

    public String getAsWFSxml(int n, String string, String string2) {
        if (string == null) {
            return "";
        }
        if (this.rootOperator == null) {
            return "";
        }
        String string3 = "";
        Object object = this.rootOperator;
        if (object instanceof LogicalOperator) {
            LogicalOperator logicalOperator = (LogicalOperator)object;
            string3 = string3 + logicalOperator.getAsWFSxml(n + 2, string, string2);
        } else if (object instanceof ComparisonOperator) {
            ComparisonOperator comparisonOperator = (ComparisonOperator)object;
            string3 = string3 + comparisonOperator.getAsWFSxml(n + 2, string, string2);
        }
        return string3;
    }

    public String getAsWFSstring() {
        if (this.rootOperator == null) {
            return "";
        }
        String string = "";
        Object object = this.rootOperator;
        if (object instanceof LogicalOperator) {
            LogicalOperator logicalOperator = (LogicalOperator)object;
            string = string + logicalOperator.getAsWFSstring();
        } else if (object instanceof ComparisonOperator) {
            ComparisonOperator comparisonOperator = (ComparisonOperator)object;
            string = string + comparisonOperator.getAsWFSstring();
        }
        return string;
    }

    public Object parse(String string) {
        this.rootOperator = null;
        if (string == null) {
            log.warning("Query condition is null.");
            return null;
        }
        String[] stringArray = this.getExpressions(string);
        if (stringArray == null || stringArray.length == 0) {
            log.warning("Unable to get query condition fragments.");
            return null;
        }
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.parseFragment(stringArray[i], bl);
            if (object == null) {
                this.rootOperator = null;
                log.warning("Unable to parse fragment: " + stringArray[i]);
                return null;
            }
            if (object instanceof LogicalOperator) {
                LogicalOperator logicalOperator = (LogicalOperator)object;
                if (this.rootOperator == null) {
                    bl = !stringArray[i].trim().toLowerCase().endsWith(" " + logicalOperator.getLogicalOperator().toLowerCase());
                    this.rootOperator = object;
                    continue;
                }
                bl = logicalOperator.getElements().size() != 0;
                if (this.rootOperator instanceof ComparisonOperator) {
                    logicalOperator.addElement(this.rootOperator);
                    this.rootOperator = logicalOperator;
                    continue;
                }
                if (bl2) {
                    logicalOperator.addElement(this.rootOperator);
                    this.rootOperator = logicalOperator;
                    bl2 = false;
                    continue;
                }
                int n = logicalOperator.getElements().size();
                for (int j = 0; j < n; ++j) {
                    ((LogicalOperator)this.rootOperator).addElement(logicalOperator.getElements().get(j));
                }
                continue;
            }
            if (this.rootOperator == null) {
                this.rootOperator = object;
            } else {
                ((LogicalOperator)this.rootOperator).addElement(object);
            }
            bl = true;
        }
        return this.rootOperator;
    }

    private Object parseFragment(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("(") > -1 || string.indexOf(")") > -1) {
            log.info("Fragment expression can not have parenthesis.");
            return null;
        }
        String[] stringArray = string.split("\\s");
        stringArray = this.cleanStringArray(stringArray);
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl) {
            bl2 = false;
            bl5 = true;
        }
        String string2 = null;
        ComparisonOperator comparisonOperator = null;
        LogicalOperator logicalOperator = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl2) {
                comparisonOperator = new ComparisonOperator();
                comparisonOperator.setVariable(stringArray[i]);
                bl2 = false;
                bl4 = true;
                if (logicalOperator == null) continue;
                logicalOperator.addElement(comparisonOperator);
                continue;
            }
            if (bl4) {
                if (!ComparisonOperator.isOperator(stringArray[i])) {
                    log.info("Expecting comparison operator, not: " + stringArray[i]);
                    return null;
                }
                comparisonOperator.setOperator(stringArray[i]);
                bl4 = false;
                bl3 = true;
                continue;
            }
            if (bl3) {
                if (stringArray[i].startsWith("'") && stringArray[i].endsWith("'")) {
                    comparisonOperator.setValue(stringArray[i].substring(1, stringArray[i].length() - 1));
                } else {
                    comparisonOperator.setValue(stringArray[i]);
                }
                bl3 = false;
                bl5 = true;
                continue;
            }
            if (!bl5) continue;
            if (string2 == null) {
                if (logicalOperator == null) {
                    logicalOperator = new LogicalOperator(stringArray[i]);
                    logicalOperator.addElement(comparisonOperator);
                }
                string2 = stringArray[i];
            } else if (!string2.equalsIgnoreCase(stringArray[i])) {
                log.info("Use parenthesis to separate different logic operators.");
                return null;
            }
            bl5 = false;
            bl2 = true;
        }
        if (logicalOperator == null && comparisonOperator == null) {
            return null;
        }
        if (logicalOperator != null) {
            return logicalOperator;
        }
        return comparisonOperator;
    }

    private String[] getExpressions(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.lastIndexOf("(");
        if (n == -1) {
            arrayList.add(string.trim());
        } else {
            boolean bl = false;
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '(') {
                    if (!bl) continue;
                    arrayList.add(string2);
                    string2 = "";
                    bl = false;
                    continue;
                }
                if (c == ')') {
                    if (!bl) continue;
                    arrayList.add(string2);
                    string2 = "";
                    bl = false;
                    continue;
                }
                if (!bl) {
                    string2 = string2 + c;
                    bl = true;
                    continue;
                }
                string2 = string2 + c;
            }
            if (string2.trim().length() > 0) {
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] cleanStringArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].trim().length() == 0) {
                ++n;
                continue;
            }
            String string = stringArray[n].trim();
            if (string.equalsIgnoreCase("is")) {
                if (stringArray[n + 1].trim().equalsIgnoreCase("null")) {
                    string = string + " null";
                    vector.add(string);
                    ++n;
                    continue;
                }
                if (!stringArray[n + 1].trim().equalsIgnoreCase("not") || !stringArray[n + 2].trim().equalsIgnoreCase("null")) continue;
                string = string + " not null";
                vector.add(string);
                n += 2;
                continue;
            }
            if (string.startsWith("'") && !string.endsWith("'")) {
                string = string + " ";
                if (++n == stringArray.length) break;
                String string2 = stringArray[n];
                while (!string2.endsWith("'") && n < stringArray.length) {
                    string = string2.length() == 0 ? string + " " : string + string2;
                    string2 = stringArray[++n];
                }
                string = string + string2;
                vector.add(string);
                ++n;
                continue;
            }
            vector.add(string);
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }
}

